/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.data.convert.IDisplayConverter;
import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.ContentDescription;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFormatter;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;

public class RDataFormatterConverter
implements IDisplayConverter {
    private final AbstractRDataProvider<?> fDataProvider;
    RDataFormatter fFallbackFormatter;

    public RDataFormatterConverter(AbstractRDataProvider<?> dataProvider) {
        this.fDataProvider = dataProvider;
    }

    private RDataFormatter getFormatter(LayerCell cell) {
        RDataFormatter formatter;
        ContentDescription description = this.fDataProvider.getDescription();
        if (description != null && (formatter = this.getFormatter(description, cell)) != null) {
            return formatter;
        }
        if (this.fFallbackFormatter == null) {
            this.fFallbackFormatter = new RDataFormatter();
        }
        return this.fFallbackFormatter;
    }

    protected @Nullable RDataFormatter getFormatter(ContentDescription description, LayerCell cell) {
        if ((cell.getDim(Orientation.HORIZONTAL).getId() & 0x7FF0000000000000L) == 0x10000000000000L && (cell.getDim(Orientation.VERTICAL).getId() & 0x7FF0000000000000L) == 0x10000000000000L) {
            ImList<RDataTableColumn> columns = description.getDataColumns();
            long index = this.getColumnIndex(cell);
            if (index >= 0L && index < (long)columns.size()) {
                return ((RDataTableColumn)columns.get((int)index)).getDefaultFormat();
            }
            return description.getDefaultDataFormat();
        }
        return null;
    }

    protected long getColumnIndex(LayerCell cell) {
        return cell.getDim(Orientation.HORIZONTAL).getId() & 0xFFFFFFFFFFFFFL;
    }

    public Object canonicalToDisplayValue(LayerCell cell, ConfigRegistry configRegistry, Object canonicalValue) {
        return this.getFormatter(cell).modelToDisplayValue(canonicalValue);
    }

    public Object displayToCanonicalValue(LayerCell cell, ConfigRegistry configRegistry, Object displayValue) {
        throw new UnsupportedOperationException();
    }

    public static class RowHeader
    extends RDataFormatterConverter {
        public RowHeader(AbstractRDataProvider<?> dataProvider) {
            super(dataProvider);
        }

        @Override
        protected RDataFormatter getFormatter(ContentDescription description, LayerCell cell) {
            if ((cell.getDim(Orientation.VERTICAL).getId() & 0x7FF0000000000000L) == 0x10000000000000L) {
                ImList<RDataTableColumn> columns = description.getRowHeaderColumns();
                long index = this.getColumnIndex(cell);
                if (columns != null && index >= 0L && index < (long)columns.size()) {
                    return ((RDataTableColumn)columns.get((int)index)).getDefaultFormat();
                }
            }
            return null;
        }
    }
}

