/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.base.ui.StatetImages;
import org.eclipse.statet.ecommons.debug.ui.ECommonsDebugUIResources;
import org.eclipse.statet.ecommons.models.core.util.ElementPartition;
import org.eclipse.statet.jcommons.collections.IntIntervalArrays;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.CombinedRList;
import org.eclipse.statet.r.core.rmodel.Parameters;
import org.eclipse.statet.r.core.rmodel.RElement;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.rmodel.RFrame;
import org.eclipse.statet.r.core.rmodel.RLangClass;
import org.eclipse.statet.r.core.rmodel.RLangClassExtension;
import org.eclipse.statet.r.core.rmodel.RLangMethod;
import org.eclipse.statet.r.core.rmodel.RLangSlot;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.REnvironment;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.swt.graphics.Image;

public class RLabelProvider
extends StyledCellLabelProvider
implements ElementLabelProvider,
ILabelProvider,
Disposable {
    public static final int NAMESPACE = 1;
    public static final int HEADER = 2;
    public static final int LONG = 4;
    public static final int COUNT = 8;
    public static final int ASSIST = 16;
    public static final int NO_STORE_TYPE = 32;
    public static final int RESOURCE_PATH = 256;
    private final StringBuilder textBuilder = new StringBuilder(100);
    private final StyledString.Styler defaultStyler;
    private int style;

    public RLabelProvider() {
        this(0);
    }

    public RLabelProvider(int style) {
        if ((this.style & 4) != 0) {
            this.style |= 8;
        }
        this.style = style;
        this.defaultStyler = (this.style & 2) != 0 ? ElementLabelProvider.TITLE_STYLER : null;
    }

    protected final StringBuilder getTextBuilder() {
        this.textBuilder.setLength(0);
        return this.textBuilder;
    }

    public Image getImage(LtkModelElement element) {
        switch ((element.getElementType() & 0xF00) >> 8) {
            case 2: {
                return RUI.getImage("org.eclipse.statet.r.ui/images/obj/r_script");
            }
            case 3: {
                return StatetImages.getImage((String)"org.eclipse.statet.ide.ui/image/obj/import");
            }
            case 5: {
                switch (element.getElementType() & 0xFF0) {
                    case 1312: {
                        return RUI.getImage("org.eclipse.statet.r.ui/images/obj/function.generic");
                    }
                    case 1408: {
                        return RUI.getImage("org.eclipse.statet.r.ui/images/obj/method");
                    }
                }
                return RUI.getImage((element.getElementType() & 0xF) != 1 ? "org.eclipse.statet.r.ui/images/obj/function.common" : "org.eclipse.statet.r.ui/images/obj/function.common.local");
            }
            case 4: {
                switch (element.getElementType() & 0xFF0) {
                    case 1152: {
                        return StatetImages.getImage((String)"org.eclipse.statet.ide.ui/image/obj/class");
                    }
                    case 1168: {
                        return StatetImages.getImage((String)"org.eclipse.statet.ide.ui/image/obj/class_ext");
                    }
                }
                return null;
            }
            case 6: {
                if (element instanceof CombinedRElement) {
                    return this.getImage((CombinedRElement)element);
                }
                switch (element.getElementType() & 0xFF0) {
                    case 1664: {
                        return RUI.getImage("org.eclipse.statet.r.ui/images/obj/variable.slot");
                    }
                }
                return RUI.getImage((element.getElementType() & 0xF) != 1 ? "org.eclipse.statet.r.ui/images/obj/variable.common" : "org.eclipse.statet.r.ui/images/obj/variable.common.local");
            }
        }
        return null;
    }

    private Image getImage(CombinedRElement element) {
        CombinedRElement rObject;
        int rObjectType;
        if (element.getRObjectType() == 14) {
            RReference ref = (RReference)element;
            rObjectType = ref.getReferencedRObjectType();
            rObject = ref.getResolvedRObject();
            if (rObjectType == 0) {
                rObjectType = rObject != null ? (int)rObject.getRObjectType() : 14;
            }
        } else {
            rObjectType = element.getRObjectType();
            rObject = element;
        }
        switch (rObjectType) {
            case 1: {
                return RUI.getImage("org.eclipse.statet.r.ui/images/obj/null");
            }
            case 13: {
                throw new IllegalArgumentException();
            }
            case 7: {
                return RUI.getImage("org.eclipse.statet.r.ui/images/obj/list");
            }
            case 6: {
                return RUI.getImage("org.eclipse.statet.r.ui/images/obj/dataframe");
            }
            case 2: {
                return element.getModelParent() != null && element.getModelParent().getRObjectType() == 6 ? RUI.getImage("org.eclipse.statet.r.ui/images/obj/datastore") : RUI.getImage("org.eclipse.statet.r.ui/images/obj/vector");
            }
            case 3: {
                return RUI.getImage("org.eclipse.statet.r.ui/images/obj/array");
            }
            case 10: {
                if (element.getData() != null) {
                    return element.getModelParent() != null && element.getModelParent().getRObjectType() == 6 ? RUI.getImage("org.eclipse.statet.r.ui/images/obj/s4obj.dataframe_col") : RUI.getImage("org.eclipse.statet.r.ui/images/obj/s4obj.vector");
                }
                return RUI.getImage("org.eclipse.statet.r.ui/images/obj/s4obj");
            }
            case 8: {
                if (rObject instanceof REnvironment) {
                    REnvironment renv = (REnvironment)element;
                    switch (renv.getSpecialType()) {
                        case 7: {
                            return RUI.getImage("org.eclipse.statet.r.ui/images/obj/globalenv");
                        }
                        case 1: 
                        case 5: {
                            return RUI.getImage("org.eclipse.statet.r.ui/images/obj/packageenv");
                        }
                        case 9: {
                            return RUI.getImage("org.eclipse.statet.r.ui/images/obj/emptyenv");
                        }
                    }
                }
                return RUI.getImage("org.eclipse.statet.r.ui/images/obj/otherenv");
            }
            case 17: {
                return RUI.getImage("org.eclipse.statet.r.ui/images/obj/missing");
            }
            case 18: {
                return RUI.getImage("org.eclipse.statet.r.ui/images/obj/promise");
            }
        }
        return RUI.getImage("org.eclipse.statet.r.ui/images/obj/variable.common");
    }

    public String getText(LtkModelElement element) {
        String name = element.getElementName().getDisplayName();
        switch ((element.getElementType() & 0xF00) >> 8) {
            case 5: {
                StringBuilder text = name != null ? new StringBuilder(name) : new StringBuilder();
                this.appendMethodDetail(text, (RLangMethod)element);
                return text.toString();
            }
            case 4: {
                switch (element.getElementType() & 0xFF0) {
                    case 1168: {
                        StringBuilder text = name != null ? new StringBuilder(name) : new StringBuilder();
                        this.appendClassExtDetail(text, (RLangClassExtension)element);
                        return text.toString();
                    }
                }
                break;
            }
            case 6: {
                switch (element.getElementType() & 0xFF0) {
                    case 1664: {
                        StringBuilder text = name != null ? new StringBuilder(name) : new StringBuilder();
                        this.appendSlotDetail(text, (RLangSlot)element);
                        return text.toString();
                    }
                }
            }
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    public StyledString getStyledText(LtkModelElement element) {
        LtkModelElement ltkModelElement = element;
        if (ltkModelElement instanceof RElement) {
            void rElement;
            RElement rElement2 = (RElement)ltkModelElement;
            RElement cfr_ignored_0 = (RElement)ltkModelElement;
            return this.getStyledText((RElement)rElement, rElement.getElementName(), null);
        }
        if (element instanceof RSourceUnit) {
            return this.getStyledText((RSourceUnit)element);
        }
        ElementName elementName = element.getElementName();
        return new StyledString(elementName.getDisplayName(), this.defaultStyler);
    }

    /*
     * WARNING - void declaration
     */
    public int @Nullable [] getStyledTextRegions(LtkModelElement element, int flags, int[] regions) {
        ElementName elementName;
        LtkModelElement ltkModelElement = element;
        if (ltkModelElement instanceof RElement) {
            void rElement;
            RElement rElement2 = (RElement)ltkModelElement;
            RElement cfr_ignored_0 = (RElement)ltkModelElement;
            return this.getStyledTextRegions((RElement)rElement, rElement.getElementName(), flags, regions);
        }
        if (element instanceof RSourceUnit) {
            return this.getStyledTextRegions((RSourceUnit)element, flags, regions);
        }
        if (flags == 0 && (elementName = element.getElementName()).getDisplayName().startsWith(elementName.getSegmentName())) {
            return regions;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public StyledString getStyledText(RElement element, RElementName elementName, RList elementAttr) {
        RElementName elementName0 = elementName != null ? elementName : element.getElementName();
        StyledString text = new StyledString();
        switch ((element.getElementType() & 0xF00) >> 8) {
            case 5: {
                int length;
                String segmentName;
                if (this.style != 0 && elementName0.getNextSegment() == null && (segmentName = elementName0.getSegmentName()) != null && (length = segmentName.length()) > 2 && segmentName.charAt(length - 2) == '<' && segmentName.charAt(length - 1) == '-') {
                    text.append(RElementName.create((int)17, (String)segmentName.substring(0, length - 2)).getDisplayName(), this.defaultStyler);
                    this.appendMethodDetailAssignmentSpecial(text, (RLangMethod)element);
                    text.append(" <- value");
                    break;
                }
                String name = elementName0.getDisplayName();
                if (name != null) {
                    text.append(name, this.defaultStyler);
                }
                this.appendMethodDetail(text, (RLangMethod)element);
                break;
            }
            case 4: {
                String name = elementName0.getDisplayName();
                if (name != null) {
                    text.append(name, this.defaultStyler);
                }
                switch (element.getElementType() & 0xFF0) {
                    case 1168: {
                        this.appendClassExtDetail(text, (RLangClassExtension)element);
                    }
                }
                break;
            }
            case 6: {
                String segmentName;
                RElement rElement = element;
                if (rElement instanceof CombinedRElement) {
                    void cElement;
                    segmentName = (CombinedRElement)rElement;
                    CombinedRElement cfr_ignored_0 = (CombinedRElement)rElement;
                    if (cElement.getRObjectType() == 8 && elementName == null) {
                        text.append(elementName0.getSegmentName(), this.defaultStyler);
                    } else {
                        String name = elementName0.getDisplayName();
                        if (name != null) {
                            text.append(name, this.defaultStyler);
                        }
                    }
                    this.decorateStyledText(text, (CombinedRElement)cElement, (ElementName)elementName0, elementAttr);
                    break;
                }
                String name = elementName0.getDisplayName();
                if (name != null) {
                    text.append(name, this.defaultStyler);
                }
                switch (element.getElementType() & 0xFF0) {
                    case 1664: {
                        this.appendSlotDetail(text, (RLangSlot)element);
                    }
                }
                break;
            }
            default: {
                String name = elementName0.getDisplayName();
                if (name == null) break;
                text.append(name, this.defaultStyler);
            }
        }
        if ((this.style & 1) != 0) {
            RFrame frame;
            RElement parent;
            RElementName scope = elementName0.getScope();
            if (scope == null && (parent = element.getModelParent()) != null && (frame = (RFrame)parent.getAdapter(RFrame.class)) != null) {
                scope = frame.getElementName();
            }
            if (scope != null) {
                StringBuilder textBuilder = this.getTextBuilder();
                textBuilder.append(" - ");
                textBuilder.append(scope.getDisplayName());
                text.append(textBuilder.toString(), StyledString.QUALIFIER_STYLER);
            }
        }
        return text;
    }

    public int[] getStyledTextRegions(RElement element, RElementName elementName, int flags, int[] regions) {
        RElementName elementName0 = elementName != null ? elementName : element.getElementName();
        switch ((element.getElementType() & 0xF00) >> 8) {
            case 5: {
                int length;
                String segmentName;
                if (this.style != 0 && elementName0.getNextSegment() == null && (segmentName = elementName0.getSegmentName()) != null && (length = segmentName.length()) > 2 && segmentName.charAt(length - 2) == '<' && segmentName.charAt(length - 1) == '-') {
                    regions = IntIntervalArrays.removeTail((int[])regions, (int)(length - 2));
                    regions = RElementName.create((int)17, (String)segmentName.substring(0, length - 2)).correctDisplayNameRegions(regions, 0);
                    break;
                }
                regions = elementName0.correctDisplayNameRegions(regions, 0);
                break;
            }
            default: {
                regions = elementName0.correctDisplayNameRegions(regions, 0);
            }
        }
        return regions;
    }

    private StyledString decorateStyledText(StyledString text, CombinedRElement element, ElementName elementName, RList elementAttr) {
        switch (element.getRObjectType()) {
            case 1: {
                break;
            }
            case 13: {
                throw new IllegalArgumentException();
            }
            case 2: {
                this.appendVectorDetail(text, element, elementAttr);
                break;
            }
            case 3: {
                this.appendArrayDetail(text, element, elementAttr);
                break;
            }
            case 6: {
                this.appendDataframeDetail(text, element, elementAttr);
                break;
            }
            case 7: {
                this.appendListDetail(text, element, elementAttr);
                break;
            }
            case 8: {
                this.appendEnvDetail(text, element, elementAttr);
                break;
            }
            case 10: {
                this.appendS4ObjectDetail(text, element, elementAttr);
                break;
            }
            default: {
                if ((this.style & 4) != 0) {
                    this.appendLongClassInfo(text, element, elementAttr);
                    break;
                }
                StringBuilder textBuilder = this.getTextBuilder();
                textBuilder.append(" : ");
                textBuilder.append(element.getRClassName());
                text.append(textBuilder.toString(), StyledString.DECORATIONS_STYLER);
            }
        }
        return text;
    }

    public StyledString getStyledText(RSourceUnit sourceUnit) {
        Object resource;
        ElementName elementName = sourceUnit.getElementName();
        StyledString text = new StyledString(elementName.getDisplayName(), this.defaultStyler);
        if ((this.style & 0x100) != 0 && (resource = sourceUnit.getResource()) instanceof IResource) {
            this.appendPath(text, (IResource)((IResource)resource).getParent());
        }
        return text;
    }

    public int[] getStyledTextRegions(RSourceUnit sourceUnit, int flags, int[] regions) {
        return regions;
    }

    public String getText(ElementPartition partition) {
        StringBuilder text = new StringBuilder();
        text.append("[");
        text.append(Long.toString(partition.getPartitionStart() + 1L));
        text.append(" ... ");
        text.append(Long.toString(partition.getPartitionStart() + partition.getPartitionLength()));
        text.append("]");
        return text.toString();
    }

    public Image getImage(Object element) {
        LtkModelElement modelElement = LtkModelUtils.getModelElement((Object)element);
        if (modelElement != null) {
            if (modelElement instanceof CombinedRElement) {
                return this.getImage((CombinedRElement)modelElement);
            }
            return this.getImage(modelElement);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ElementPartition) {
            return this.getText((ElementPartition)element);
        }
        LtkModelElement modelElement = LtkModelUtils.getModelElement((Object)element);
        if (modelElement != null) {
            return this.getText(modelElement);
        }
        return null;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        LtkModelElement modelElement = LtkModelUtils.getModelElement((Object)element);
        if (element instanceof ElementPartition) {
            this.update(cell, (ElementPartition)element, modelElement);
            super.update(cell);
        } else if (modelElement != null) {
            this.update(cell, modelElement);
            super.update(cell);
        } else {
            cell.setImage(null);
            cell.setText(element.toString());
            cell.setStyleRanges(null);
            super.update(cell);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void update(ViewerCell cell, LtkModelElement element) {
        Image image = null;
        StyledString styledText = null;
        LtkModelElement ltkModelElement = element;
        if (ltkModelElement instanceof CombinedRElement) {
            RObject realObject;
            void combined;
            CombinedRElement combinedRElement = (CombinedRElement)ltkModelElement;
            CombinedRElement cfr_ignored_0 = (CombinedRElement)ltkModelElement;
            if (combined.getRObjectType() == 14 && (realObject = ((RReference)element).getResolvedRObject()) instanceof CombinedRElement) {
                image = this.getImage((CombinedRElement)realObject);
                styledText = this.getStyledText((RElement)((CombinedRElement)realObject), combined.getElementName(), null);
            }
        }
        if (image == null) {
            image = this.getImage(element);
        }
        cell.setImage(image);
        if (styledText == null) {
            styledText = this.getStyledText(element);
        }
        if (styledText != null) {
            cell.setText(styledText.getString());
            cell.setStyleRanges(styledText.getStyleRanges());
        } else {
            cell.setText(this.getText(element));
            cell.setStyleRanges(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void update(ViewerCell cell, ElementPartition partition, LtkModelElement element) {
        cell.setImage(ECommonsDebugUIResources.INSTANCE.getImage("org.eclipse.statet.ecommons.debugimage/obj/VariablePartition"));
        StyledString text = new StyledString();
        text.append("[");
        text.append(Long.toString(partition.getPartitionStart() + 1L));
        text.append(" ... ");
        text.append(Long.toString(partition.getPartitionStart() + partition.getPartitionLength()));
        text.append("]");
        LtkModelElement ltkModelElement = element;
        if (ltkModelElement instanceof RList) {
            void rList;
            RList rList2 = (RList)ltkModelElement;
            RList cfr_ignored_0 = (RList)ltkModelElement;
            String label = rList.getName(partition.getPartitionStart());
            if (label != null) {
                text.append("  ");
                text.append(label, StyledString.QUALIFIER_STYLER);
                text.append(" ... ", StyledString.QUALIFIER_STYLER);
                label = rList.getName(partition.getPartitionStart() + (partition.getPartitionLength() - 1L));
                if (label != null) {
                    text.append(label, StyledString.QUALIFIER_STYLER);
                }
            }
        }
        cell.setText(text.getString());
        cell.setStyleRanges(text.getStyleRanges());
    }

    public String getToolTipText(Object element) {
        LtkModelElement modelElement = LtkModelUtils.getModelElement((Object)element);
        if (modelElement != null) {
            switch ((modelElement.getElementType() & 0xF00) >> 8) {
                case 5: {
                    StringBuilder text = new StringBuilder();
                    this.appendMethodMLText(text, (RLangMethod)modelElement);
                    return text.toString();
                }
                case 4: {
                    switch (modelElement.getElementType() & 0xFF0) {
                        case 1152: {
                            StringBuilder text = new StringBuilder();
                            this.appendClassMLText(text, (RLangClass)modelElement);
                            return text.toString();
                        }
                        case 1168: {
                            StringBuilder text = new StringBuilder();
                            this.appendClassExtMLText(text, (RLangClassExtension)modelElement);
                            return text.toString();
                        }
                    }
                    return null;
                }
            }
        }
        return null;
    }

    protected void appendMethodDetail(StringBuilder text, RLangMethod method) {
        Parameters parameters = method.getParameters();
        boolean showTypes = method.getElementType() == 1408;
        text.append('(');
        if (parameters == null) {
            text.append("<unknown>");
        } else if (parameters.size() > 0) {
            int last = parameters.size() - 1;
            if (showTypes) {
                int i = 0;
                while (i < last) {
                    this.appendParameterWithType(text, parameters.get(i));
                    text.append(", ");
                    ++i;
                }
                this.appendParameterWithType(text, parameters.get(last));
            } else {
                int i = 0;
                while (i < last) {
                    this.appendParameter(text, parameters.get(i));
                    text.append(", ");
                    ++i;
                }
                this.appendParameter(text, parameters.get(last));
            }
        }
        text.append(')');
    }

    public void appendArgumentInformation(StringBuilder text, IntList idxs, Parameters parameters) {
        if (parameters != null) {
            if (parameters.size() == 0) {
                text.append("<no arguments>");
            } else {
                int last = parameters.size() - 1;
                idxs.add(text.length());
                int i = 0;
                while (i < last) {
                    this.appendParameter(text, parameters.get(i));
                    text.append(", ");
                    idxs.add(text.length() - 1);
                    ++i;
                }
                this.appendParameter(text, parameters.get(last));
            }
        } else {
            text.append("<unkown>");
        }
    }

    protected void appendMethodDetail(StyledString text, RLangMethod method) {
        Parameters parameters = method.getParameters();
        boolean showTypes = method.getElementType() == 1408;
        text.append("(", this.defaultStyler);
        if (parameters == null) {
            text.append("<unknown>", this.defaultStyler);
        } else if (parameters.size() > 0) {
            int last = parameters.size() - 1;
            if (showTypes) {
                int i = 0;
                while (i < last) {
                    this.appendParameterWithType(text, parameters.get(i));
                    text.append(", ", this.defaultStyler);
                    ++i;
                }
                this.appendParameterWithType(text, parameters.get(last));
            } else {
                int i = 0;
                while (i < last) {
                    this.appendParameter(text, parameters.get(i));
                    text.append(", ", this.defaultStyler);
                    ++i;
                }
                this.appendParameter(text, parameters.get(last));
            }
        }
        text.append(")", this.defaultStyler);
    }

    protected void appendMethodDetailAssignmentSpecial(StyledString text, RLangMethod method) {
        Parameters parameters = method.getParameters();
        boolean showTypes = method.getElementType() == 1408;
        text.append("(", this.defaultStyler);
        if (parameters == null) {
            text.append("<unknown>", this.defaultStyler);
        } else if (parameters.size() > 0) {
            int last = parameters.size() - 1;
            if (showTypes) {
                int i = 0;
                while (i < last) {
                    this.appendParameterWithType(text, parameters.get(i));
                    text.append(", ", this.defaultStyler);
                    ++i;
                }
                this.appendParameterWithType(text, parameters.get(last));
            } else {
                int i = 0;
                while (i < last) {
                    this.appendParameter(text, parameters.get(i));
                    text.append(", ", this.defaultStyler);
                    ++i;
                }
                this.appendParameter(text, parameters.get(last));
            }
        }
        text.append(")", this.defaultStyler);
    }

    private void appendParameter(StyledString text, Parameters.Parameter parameter) {
        String name = parameter.getName();
        if (name != null) {
            text.append(name, this.defaultStyler);
        }
    }

    private void appendParameter(StringBuilder text, Parameters.Parameter parameter) {
        String name = parameter.getName();
        if (name != null) {
            text.append(name);
        }
    }

    private void appendParameterWithType(StyledString text, Parameters.Parameter parameter) {
        String className;
        String name = parameter.getName();
        if (name != null) {
            text.append(name, this.defaultStyler);
        }
        if ((className = parameter.getClassName()) != null) {
            text.append(" : ", StyledString.DECORATIONS_STYLER);
            text.append(className, StyledString.DECORATIONS_STYLER);
        }
    }

    private void appendParameterWithType(StringBuilder text, Parameters.Parameter parameter) {
        String className;
        String name = parameter.getName();
        if (name != null) {
            text.append(name);
        }
        if ((className = parameter.getClassName()) != null) {
            text.append(" : ");
            text.append(className);
        }
    }

    protected void appendMethodMLText(StringBuilder sb, RLangMethod method) {
        Parameters parameters = method.getParameters();
        String name = method.getElementName().getDisplayName();
        if (name != null) {
            sb.append(name);
        }
        if (parameters != null && parameters.size() > 0) {
            sb.ensureCapacity(sb.length() + 5 + parameters.size() * 20);
            sb.append("( \n");
            int last = parameters.size() - 1;
            sb.append("  ");
            int i = 0;
            while (i < last) {
                this.appendParameterLong(sb, parameters.get(i));
                sb.append(",\n  ");
                ++i;
            }
            this.appendParameterLong(sb, parameters.get(last));
            sb.append("\n)");
        } else {
            sb.append("()");
        }
    }

    private void appendParameterLong(StringBuilder sb, Parameters.Parameter parameter) {
        String className;
        String name = parameter.getName();
        if (name != null) {
            sb.append(name);
        }
        if ((className = parameter.getClassName()) != null) {
            sb.append(" : ");
            sb.append(className);
        }
    }

    protected void appendClassMLText(StringBuilder sb, RLangClass clazz) {
        List extendedClassNames = clazz.getExtendedClassNames();
        String name = clazz.getElementName().getDisplayName();
        if (name != null) {
            sb.append(name);
        }
        if (extendedClassNames != null && !extendedClassNames.isEmpty()) {
            sb.ensureCapacity(sb.length() + 15 + extendedClassNames.size() * 16);
            sb.append("\n  extends ");
            int last = extendedClassNames.size() - 1;
            int i = 0;
            while (i < last) {
                sb.append((String)extendedClassNames.get(i));
                sb.append(", ");
                ++i;
            }
            sb.append((String)extendedClassNames.get(last));
        }
    }

    protected void appendClassExtDetail(StyledString text, RLangClassExtension ext) {
        String command = ext.getExtCommand();
        if (command != null) {
            if (!command.equals("setIs")) {
                return;
            }
            text.append("\u200a->\u200a");
            String type = ext.getExtTypeName();
            if (type != null) {
                text.append(type);
            }
        }
    }

    protected void appendClassExtDetail(StringBuilder sb, RLangClassExtension ext) {
        String command = ext.getExtCommand();
        if (command != null) {
            if (!command.equals("setIs")) {
                return;
            }
            sb.append("\u200a->\u200a");
            String type = ext.getExtTypeName();
            if (type != null) {
                sb.append(type);
            }
        }
    }

    protected void appendClassExtMLText(StringBuilder text, RLangClassExtension ext) {
        String command;
        String name = ext.getElementName().getDisplayName();
        if (name != null) {
            text.append(name);
        }
        if ((command = ext.getExtCommand()) != null) {
            text.append("\n  ");
            text.append(command);
            String type = ext.getExtTypeName();
            if (type != null) {
                text.append(' ');
                text.append(type);
            }
            text.append(' ');
        }
    }

    protected void appendSlotDetail(StyledString text, RLangSlot slot) {
        String type = slot.getTypeName();
        if (type != null) {
            text.append(" : ", StyledString.DECORATIONS_STYLER);
            text.append(type, StyledString.DECORATIONS_STYLER);
        }
    }

    protected void appendSlotDetail(StringBuilder text, RLangSlot slot) {
    }

    protected void appendLongClassInfo(StyledString text, CombinedRElement element, RList elementAttr) {
        RObject object;
        StringBuilder textBuilder = this.getTextBuilder();
        textBuilder.append(" : ");
        RStore classData = null;
        if (elementAttr != null && (object = elementAttr.get("class")) != null && object.getRObjectType() == 2 && object.getData().getStoreType() == 5 && (classData = object.getData()).getLength() > 0L) {
            int last = (int)classData.getLength() - 1;
            int i = 0;
            while (i < last) {
                if (!classData.isNA(i)) {
                    textBuilder.append(classData.getChar(i));
                    textBuilder.append(", ");
                }
                ++i;
            }
            textBuilder.append(classData.getChar(last));
        }
        if (textBuilder.length() == 3) {
            textBuilder.append(element.getRClassName());
        }
        if (element.getData() != null && element.getData().getStoreType() > 0 && (classData != null ? !classData.contains(RDataUtils.getStoreClass((RStore)element.getData())) : !element.getRClassName().equals(RDataUtils.getStoreClass((RStore)element.getData())))) {
            textBuilder.append(" (");
            textBuilder.append(RDataUtils.getStoreAbbr((RStore)element.getData()));
            textBuilder.append(')');
        }
        text.append(textBuilder.toString(), StyledString.DECORATIONS_STYLER);
    }

    protected void appendVectorDetail(StyledString text, CombinedRElement element, RList elementAttr) {
        StringBuilder sb;
        byte datatype = element.getData().getStoreType();
        if ((this.style & 4) != 0) {
            this.appendLongClassInfo(text, element, elementAttr);
            sb = this.getTextBuilder();
        } else {
            sb = this.getTextBuilder();
            sb.append(" : ");
            if (element.getRClassName().equals(element.getData().getBaseVectorRClassName())) {
                if ((this.style & 0x20) == 0) {
                    sb.append(RDataUtils.getStoreAbbr((RStore)element.getData()));
                }
            } else {
                sb.append(element.getRClassName());
                if ((this.style & 0x20) == 0) {
                    sb.append(" (");
                    sb.append(RDataUtils.getStoreAbbr((RStore)element.getData()));
                    sb.append(')');
                }
            }
        }
        sb.append(" [");
        sb.append(element.getLength());
        sb.append(']');
        if ((this.style & 0x20) == 0 && datatype == 10) {
            sb.append(" (");
            sb.append(((RFactorStore)element.getData()).getLevelCount());
            sb.append(' ');
            sb.append("levels");
            sb.append(')');
        }
        text.append(sb.toString(), StyledString.DECORATIONS_STYLER);
    }

    protected void appendArrayDetail(StyledString text, CombinedRElement element, RList elementAttr) {
        StringBuilder sb;
        if ((this.style & 4) != 0) {
            this.appendLongClassInfo(text, element, elementAttr);
            sb = this.getTextBuilder();
        } else {
            sb = this.getTextBuilder();
            sb.append(" : ");
            if (element.getRClassName().equals("array") || element.getRClassName().equals("matrix")) {
                if ((this.style & 0x20) == 0) {
                    sb.append(RDataUtils.getStoreAbbr((RStore)element.getData()));
                }
            } else {
                sb.append(element.getRClassName());
                if ((this.style & 0x20) == 0) {
                    sb.append(" (");
                    sb.append(RDataUtils.getStoreAbbr((RStore)element.getData()));
                    sb.append(')');
                }
            }
        }
        sb.append(" [");
        RIntegerStore dim = ((RArray)element).getDim();
        int dimLength = (int)dim.getLength();
        if (dimLength > 0) {
            sb.append(dim.getInt(0));
            int i = 1;
            while (i < dimLength) {
                sb.append('\u00d7');
                sb.append(dim.getInt(i));
                ++i;
            }
        }
        sb.append(']');
        text.append(sb.toString(), StyledString.DECORATIONS_STYLER);
    }

    protected void appendListDetail(StyledString text, CombinedRElement element, RList elementAttr) {
        StringBuilder sb;
        if ((this.style & 8) != 0) {
            sb = this.getTextBuilder();
            sb.append(" (");
            sb.append(element.getLength());
            sb.append(' ');
            sb.append("items");
            sb.append(')');
            text.append(sb.toString(), StyledString.COUNTER_STYLER);
        }
        if ((this.style & 4) != 0) {
            this.appendLongClassInfo(text, element, elementAttr);
        } else if (!element.getRClassName().equals("list")) {
            sb = this.getTextBuilder();
            sb.setLength(0);
            sb.append(" : ");
            sb.append(element.getRClassName());
            text.append(sb.toString(), StyledString.DECORATIONS_STYLER);
        }
    }

    protected void appendEnvDetail(StyledString text, CombinedRElement element, RList elementAttr) {
        CombinedRList env = (CombinedRList)element;
        if ((this.style & 8) != 0) {
            String countInfo = this.getEnvCountInfo(env);
            text.append(countInfo, StyledString.COUNTER_STYLER);
        }
        if ((this.style & 4) != 0) {
            this.appendLongClassInfo(text, element, elementAttr);
        }
    }

    protected String getEnvCountInfo(CombinedRList envir) {
        StringBuilder textBuilder = this.getTextBuilder();
        textBuilder.append(" (");
        textBuilder.append(envir.getLength());
        textBuilder.append(')');
        return textBuilder.toString();
    }

    protected void appendDataframeDetail(StyledString text, CombinedRElement element, RList elementAttr) {
        StringBuilder sb;
        RDataFrame dataframe = (RDataFrame)element;
        if ((this.style & 8) != 0) {
            sb = this.getTextBuilder();
            sb.append(" (");
            sb.append(dataframe.getColumnCount());
            sb.append(' ');
            sb.append("var.");
            sb.append(')');
            text.append(sb.toString(), StyledString.COUNTER_STYLER);
        }
        if ((this.style & 4) != 0) {
            this.appendLongClassInfo(text, element, elementAttr);
            sb = this.getTextBuilder();
        } else {
            sb = this.getTextBuilder();
            if (!element.getRClassName().equals("data.frame")) {
                sb.append(" : ");
                sb.append(dataframe.getRClassName());
            }
        }
        sb.append(" [");
        sb.append(dataframe.getRowCount());
        sb.append(']');
        text.append(sb.toString(), StyledString.DECORATIONS_STYLER);
    }

    protected void appendS4ObjectDetail(StyledString text, CombinedRElement element, RList elementAttr) {
        if ((this.style & 4) != 0) {
            this.appendLongClassInfo(text, element, elementAttr);
        } else {
            StringBuilder textBuilder = this.getTextBuilder();
            textBuilder.append(" : ");
            textBuilder.append(element.getRClassName());
            text.append(textBuilder.toString(), StyledString.DECORATIONS_STYLER);
        }
    }

    protected void appendPath(StyledString text, IResource resource) {
        if (resource != null) {
            text.append(" - ", StyledString.QUALIFIER_STYLER);
            text.append(resource.getFullPath().makeRelative().toString(), StyledString.QUALIFIER_STYLER);
        }
    }
}

