/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.HtmlEntity;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class HtmlEntitySpan
extends SourceSpan {
    private static final Pattern PATTERN = Pattern.compile("&(#[Xx]\\p{XDigit}{1,6}|#\\p{Digit}{1,7}|\\p{Alpha}\\p{Alnum}{1,31});.*", 32);
    private @Nullable Matcher matcher;

    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        Matcher matcher;
        char c = cursor.getChar();
        if (c == '&' && (matcher = cursor.setup(this.getMatcher())).matches()) {
            String entity = matcher.group(1);
            return new HtmlEntity(cursor.getLineAtOffset(), cursor.getOffset(), entity.length() + 2, entity);
        }
        return null;
    }

    private Matcher getMatcher() {
        if (this.matcher == null) {
            this.matcher = PATTERN.matcher("");
        }
        return this.matcher;
    }
}

