/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupConfig;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguageManager1;
import org.eclipse.statet.internal.docmlet.wikitext.core.MarkupConfigTextFileBufferUpdater;
import org.eclipse.statet.internal.docmlet.wikitext.core.MarkupLanguageManager;
import org.eclipse.statet.internal.docmlet.wikitext.core.WikitextCorePlugin;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class MarkupLanguageManager1
extends MarkupLanguageManager
implements WikitextMarkupLanguageManager1,
IResourceChangeListener {
    public static final WikitextMarkupLanguageManager1 INSTANCE;
    private static final String PREF_QUALIFIER = "org.eclipse.statet.docmlet.wikitext.core/markup/Wikitext";
    private static final String KEY = "MarkupConfig";
    private static final QualifiedName PROPERTY_NAME;
    private static final String PREFIX = "MarkupConfig!";
    private final CopyOnWriteIdentityListSet<WikitextMarkupLanguageManager1.MarkupConfigChangedListener> configChangedListeners = new CopyOnWriteIdentityListSet();
    private final Map<IProject, ProjectEntry> projectEntries = new HashMap<IProject, ProjectEntry>();
    private final BackgroundJob backgroundJob = new BackgroundJob();

    static {
        MarkupLanguageManager1 instance = new MarkupLanguageManager1();
        instance.addConfigChangedListener(new MarkupConfigTextFileBufferUpdater(instance));
        INSTANCE = instance;
        PROPERTY_NAME = new QualifiedName("org.eclipse.statet.docmlet.wikitext.core", "Wikitext.MarkupConfig");
    }

    private static String getPrefKey(IFile file) {
        return PREFIX + file.getProjectRelativePath().toPortableString();
    }

    public MarkupLanguageManager1() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 6);
    }

    private @Nullable String getLanguageName(IFile file, boolean required) throws CoreException {
        CoreException cause = null;
        try {
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription != null) {
                return this.getLanguageName(contentDescription.getContentType());
            }
        }
        catch (CoreException e) {
            cause = e;
        }
        if (required) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", NLS.bind((String)"Failed to detect markup language for file ''{0}''.", (Object)file.getFullPath()), (Throwable)cause));
        }
        return null;
    }

    private String getLanguageName(IFile file) throws CoreException {
        return this.getLanguageName(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectEntry getProjectEntry(IProject project) {
        Map<IProject, ProjectEntry> map = this.projectEntries;
        synchronized (map) {
            ProjectEntry entry = this.projectEntries.get(project);
            if (entry == null) {
                entry = new ProjectEntry(project);
                this.projectEntries.put(project, entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        IResource resource = event.getResource();
        if (resource instanceof IProject) {
            BackgroundJob backgroundJob = this.backgroundJob;
            synchronized (backgroundJob) {
                this.backgroundJob.addProjectToDispose((IProject)resource);
                this.backgroundJob.schedule(100L);
            }
        }
    }

    @Override
    public void addConfigChangedListener(WikitextMarkupLanguageManager1.MarkupConfigChangedListener listener) {
        this.configChangedListeners.add((Object)listener);
    }

    @Override
    public void removeConfigChangedListern(WikitextMarkupLanguageManager1.MarkupConfigChangedListener listener) {
        this.configChangedListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable WikitextMarkupLanguage getLanguage(IFile file, @Nullable String languageName, boolean inherit) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try {
            boolean exists = file.exists();
            Property property = null;
            String configString = null;
            if (exists) {
                property = (Property)file.getSessionProperty(PROPERTY_NAME);
            }
            if (property == null || languageName != null && property.languageName != languageName) {
                ProjectEntry projectEntry = this.getProjectEntry(file.getProject());
                IEclipsePreferences prefNode = projectEntry.getPrefNode();
                configString = prefNode.get(MarkupLanguageManager1.getPrefKey(file), null);
                if (property == null) {
                    String fileLanguageName = this.getLanguageName(file, languageName == null);
                    if (exists && fileLanguageName != null) {
                        property = new Property(fileLanguageName, configString != null ? this.getLanguage(fileLanguageName, configString) : null);
                        ProjectEntry projectEntry2 = projectEntry;
                        synchronized (projectEntry2) {
                            if (prefNode.get(MarkupLanguageManager1.getPrefKey(file), null) == configString) {
                                file.setSessionProperty(PROPERTY_NAME, (Object)property);
                            }
                        }
                    }
                    if (languageName == null) {
                        languageName = fileLanguageName;
                    }
                }
                if (property == null || property.languageName != languageName) {
                    return configString != null || inherit ? this.getLanguage(languageName, configString) : null;
                }
            }
            return property.language != null || !inherit ? property.language : this.getLanguage(file.getProject(), property.languageName, true);
        }
        catch (Exception e) {
            WikitextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", NLS.bind((String)"An error occurred when occurred when reading markup configuration for ''{0}''.", (Object)file.getFullPath()), (Throwable)e));
            return null;
        }
    }

    private @Nullable WikitextMarkupLanguage getLanguage(String name, String configString) {
        MarkupConfig config;
        if (configString != null && (config = this.createNewConfig(name)) != null && config.load(configString)) {
            return this.createLanguage(name, config);
        }
        return this.getLanguage(name);
    }

    private @Nullable WikitextMarkupLanguage createLanguage(String name, MarkupConfig config) {
        WikitextMarkupLanguage language = this.getLanguage(name);
        if (language == null) {
            return null;
        }
        language = language.clone();
        language.setMarkupConfig(config);
        return language;
    }

    @Override
    public @Nullable MarkupConfig getConfig(String languageName) {
        WikitextMarkupLanguage language = this.getLanguage(languageName);
        if (language == null) {
            throw new IllegalStateException("Language is missing: " + languageName);
        }
        return language.getMarkupConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configChanged(String languageName) {
        super.configChanged(languageName);
        BackgroundJob backgroundJob = this.backgroundJob;
        synchronized (backgroundJob) {
            this.backgroundJob.addChangedConfig(languageName);
            this.backgroundJob.schedule(100L);
        }
    }

    public @Nullable WikitextMarkupLanguage getLanguage(IProject project, String languageName, boolean inherit) {
        return inherit ? this.getLanguage(languageName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfig(IFile file, @Nullable MarkupConfig config) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try {
            ProjectEntry projectEntry = this.getProjectEntry(file.getProject());
            IEclipsePreferences prefNode = projectEntry.getPrefNode();
            if (config == null) {
                ProjectEntry projectEntry2 = projectEntry;
                synchronized (projectEntry2) {
                    projectEntry.setTmpFileProperty(file, null);
                    prefNode.remove(MarkupLanguageManager1.getPrefKey(file));
                }
            }
            String languageName = this.getLanguageName(file);
            Property property = new Property(languageName, this.createLanguage(languageName, config));
            String value = config.getString();
            ProjectEntry projectEntry3 = projectEntry;
            synchronized (projectEntry3) {
                projectEntry.setTmpFileProperty(file, property);
                prefNode.put(MarkupLanguageManager1.getPrefKey(file), value);
            }
            prefNode.flush();
        }
        catch (Exception e) {
            WikitextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", NLS.bind((String)"An error occurred when occurred when saving markup configuration for ''{0}''.", (Object)file.getFullPath().toFile()), (Throwable)e));
        }
    }

    @Override
    public @Nullable MarkupConfig getConfig(IFile file, String languageName) {
        WikitextMarkupLanguage language = this.getLanguage(file, languageName, false);
        return language != null ? language.getMarkupConfig() : null;
    }

    private class BackgroundJob
    extends Job {
        private final List<IProject> projectsToDispose;
        private final List<IFile> changedFiles;
        private Map<String, List<IProject>> changedLanguages;

        public BackgroundJob() {
            super("Markup Config Worker");
            this.projectsToDispose = new ArrayList<IProject>();
            this.changedFiles = new ArrayList<IFile>();
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(20);
        }

        public void addProjectToDispose(IProject project) {
            this.projectsToDispose.add(project);
        }

        public void addChangedConfig(String languageName) {
            if (this.changedLanguages == null) {
                this.changedLanguages = new IdentityHashMap<String, List<IProject>>();
            }
            this.changedLanguages.put(languageName, (List<IProject>)ImCollections.newList());
        }

        public void addChangedConfig(IProject project, String languageName) {
            List<IProject> projects;
            if (this.changedLanguages == null) {
                this.changedLanguages = new IdentityHashMap<String, List<IProject>>();
            }
            if ((projects = this.changedLanguages.get(languageName)) == null) {
                projects = new ArrayList<IProject>();
                this.changedLanguages.put(languageName, projects);
            } else if (projects.isEmpty()) {
                return;
            }
            if (!projects.contains(project)) {
                projects.add(project);
            }
        }

        public void addChangedConfig(IFile file) {
            this.changedFiles.add(file);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
            this.execDispose();
            this.execNotify(m);
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execDispose() {
            while (true) {
                ImList projects;
                Object object = this;
                synchronized (object) {
                    projects = ImCollections.clearToList(this.projectsToDispose);
                }
                if (projects.isEmpty()) {
                    return;
                }
                object = MarkupLanguageManager1.this.projectEntries;
                synchronized (object) {
                    for (IProject project : projects) {
                        ProjectEntry entry = MarkupLanguageManager1.this.projectEntries.remove(project);
                        if (entry == null) continue;
                        entry.dispose();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execNotify(SubMonitor m) {
            Map<String, List<IProject>> changedLanguages;
            ImList files;
            BackgroundJob backgroundJob = this;
            synchronized (backgroundJob) {
                files = ImCollections.clearToList(this.changedFiles);
                changedLanguages = this.changedLanguages;
                this.changedLanguages = null;
            }
            m.setWorkRemaining((changedLanguages != null ? changedLanguages.size() * 10 : 0) + files.size());
            if (changedLanguages != null) {
                SubMonitor m1 = m.newChild(changedLanguages.size() * 10);
                ImIdentityList listeners = MarkupLanguageManager1.this.configChangedListeners.toList();
                m1.setWorkRemaining(listeners.size());
                for (WikitextMarkupLanguageManager1.MarkupConfigChangedListener listener : listeners) {
                    try {
                        listener.configChanged(changedLanguages, (IProgressMonitor)m1.newChild(1));
                    }
                    catch (CoreException e) {
                        WikitextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", "An error occurred while handling a markup configuration changes.", (Throwable)e));
                    }
                }
            }
            for (IFile file : files) {
                SubMonitor m1 = m.newChild(1);
                if (!file.exists()) continue;
                ImIdentityList listeners = MarkupLanguageManager1.this.configChangedListeners.toList();
                m1.setWorkRemaining(listeners.size());
                for (WikitextMarkupLanguageManager1.MarkupConfigChangedListener listener : listeners) {
                    try {
                        listener.configChanged(file, (IProgressMonitor)m1.newChild(1));
                    }
                    catch (CoreException e) {
                        WikitextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", NLS.bind((String)"An error occurred while handling a markup configuration change for file ''{0}''.", (Object)file.getFullPath()), (Throwable)e));
                    }
                }
            }
        }
    }

    private class ProjectEntry
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final IProject project;
        private final IEclipsePreferences prefNode;
        private @Nullable IFile tmpFile;
        private @Nullable Property tmpFileProperty;

        public ProjectEntry(IProject project) {
            this.project = project;
            ProjectScope projectScope = new ProjectScope(project);
            this.prefNode = projectScope.getNode(MarkupLanguageManager1.PREF_QUALIFIER);
            this.prefNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }

        public IProject getProject() {
            return this.project;
        }

        public IEclipsePreferences getPrefNode() {
            return this.prefNode;
        }

        public void dispose() {
            try {
                this.prefNode.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        public void setTmpFileProperty(IFile file, Property property) {
            this.tmpFile = file;
            this.tmpFileProperty = property;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().startsWith(MarkupLanguageManager1.PREFIX) && this.project.isOpen()) {
                IPath path = Path.fromPortableString((String)event.getKey().substring(MarkupLanguageManager1.PREFIX.length()));
                IFile file = null;
                Object object = this;
                synchronized (object) {
                    Property property = null;
                    if (this.tmpFile != null && this.tmpFile.getFullPath().equals((Object)path)) {
                        file = this.tmpFile;
                        property = this.tmpFileProperty;
                        this.tmpFile = null;
                        this.tmpFileProperty = null;
                    } else {
                        file = this.project.getFile(path);
                    }
                    try {
                        file.setSessionProperty(PROPERTY_NAME, property);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                object = MarkupLanguageManager1.this.backgroundJob;
                synchronized (object) {
                    MarkupLanguageManager1.this.backgroundJob.addChangedConfig(file);
                    MarkupLanguageManager1.this.backgroundJob.schedule();
                }
            }
        }
    }

    private static class Property {
        final String languageName;
        final @Nullable WikitextMarkupLanguage language;

        public Property(String languageName, @Nullable WikitextMarkupLanguage language) {
            this.languageName = languageName;
            this.language = language;
        }
    }
}

