/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.util;

import java.util.IdentityHashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.jface.resource.ImageImageDescriptor;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.Asts;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.element.EmbeddingForeignElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceContainerElement;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceIssueEditorAnnotation;
import org.eclipse.statet.ltk.ui.util.DecoratedElementImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.IDocumentProvider;

@NonNullByDefault
public class ExtModelLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
ElementLabelProvider,
Disposable {
    protected static final ElementLabelProvider NO_PROVIDER = new ElementLabelProvider(){};
    private final IdentityHashMap<String, ElementLabelProvider> providers = new IdentityHashMap(4);
    private @Nullable String modelTypeId;
    private @Nullable String documentProviderModelTypeId;
    private @Nullable IDocumentProvider documentProvider;
    private final SharedUIResources sharedResources = SharedUIResources.getInstance();

    public ExtModelLabelProvider(String modelTypeId) {
        this.modelTypeId = modelTypeId;
    }

    public ExtModelLabelProvider() {
    }

    public void dispose() {
        for (ElementLabelProvider provider : this.providers.values()) {
            if (!(provider instanceof Disposable)) continue;
            ((Disposable)provider).dispose();
        }
        this.providers.clear();
        super.dispose();
    }

    protected @Nullable ElementLabelProvider getElementLabelProvider(@Nullable String modelId) {
        if (modelId == null) {
            return null;
        }
        ElementLabelProvider provider = this.providers.get(modelId);
        if (provider == null) {
            provider = (ElementLabelProvider)LtkModels.getModelAdapter((String)modelId, ElementLabelProvider.class);
            if (provider == null) {
                provider = NO_PROVIDER;
            }
            this.providers.put(modelId, provider);
        }
        return provider != NO_PROVIDER ? provider : null;
    }

    protected void addProvider(String modelId, ElementLabelProvider provider) {
        this.providers.put(modelId, provider);
    }

    public @Nullable Image getImage(@Nullable Object element) {
        if (element instanceof LtkModelElement) {
            return this.getImage((LtkModelElement)element);
        }
        return null;
    }

    public @Nullable String getText(@Nullable Object element) {
        if (element instanceof LtkModelElement) {
            return this.getText((LtkModelElement)element);
        }
        return null;
    }

    @Override
    public @Nullable Image getImage(LtkModelElement<?> element) {
        int adornmentFlags;
        SourceStructElement embeddedElement;
        ElementLabelProvider provider;
        boolean embedding = (element.getElementType() & 0xF00) == 2048;
        Image image = null;
        if (image == null && embedding && this.modelTypeId != element.getModelTypeId() && (provider = this.getElementLabelProvider(this.modelTypeId)) != null) {
            image = provider.getImage(element);
        }
        if (image == null && (provider = this.getElementLabelProvider(element.getModelTypeId())) != null) {
            image = provider.getImage(element);
        }
        if (image == null && embedding && (embeddedElement = ((EmbeddingForeignElement)element).getForeignElement()) != null && (provider = this.getElementLabelProvider(embeddedElement.getModelTypeId())) != null) {
            image = provider.getImage((LtkModelElement<?>)embeddedElement);
        }
        if (image != null && (adornmentFlags = this.computeAdornmentFlags(element)) != 0) {
            DecoratedElementImageDescriptor imageDescriptor = new DecoratedElementImageDescriptor((ImageDescriptor)new ImageImageDescriptor(image), adornmentFlags);
            return this.sharedResources.getImageDescriptorRegistry().get((ImageDescriptor)imageDescriptor);
        }
        return image;
    }

    @Override
    public String getText(LtkModelElement<?> element) {
        SourceStructElement embeddedElement;
        ElementLabelProvider provider;
        boolean embedding = (element.getElementType() & 0xF00) == 2048;
        String text = null;
        if (text == null && embedding && this.modelTypeId != element.getModelTypeId() && (provider = this.getElementLabelProvider(this.modelTypeId)) != null) {
            text = provider.getText(element);
        }
        if (text == null && (provider = this.getElementLabelProvider(element.getModelTypeId())) != null) {
            text = provider.getText(element);
        }
        if (text == null && embedding && (embeddedElement = ((EmbeddingForeignElement)element).getForeignElement()) != null && (provider = this.getElementLabelProvider(embeddedElement.getModelTypeId())) != null) {
            text = provider.getText((LtkModelElement<?>)embeddedElement);
        }
        if (text == null) {
            text = element.getElementName().getDisplayName();
        }
        return text;
    }

    @Override
    public StyledString getStyledText(LtkModelElement<?> element) {
        SourceStructElement embeddedElement;
        ElementLabelProvider provider;
        boolean embedding = (element.getElementType() & 0xF00) == 2048;
        StyledString text = null;
        if (text == null && embedding && this.modelTypeId != element.getModelTypeId() && (provider = this.getElementLabelProvider(this.modelTypeId)) != null) {
            text = provider.getStyledText(element);
        }
        if (text == null && (provider = this.getElementLabelProvider(element.getModelTypeId())) != null) {
            text = provider.getStyledText(element);
        }
        if (text == null && embedding && (embeddedElement = ((EmbeddingForeignElement)element).getForeignElement()) != null && (provider = this.getElementLabelProvider(embeddedElement.getModelTypeId())) != null) {
            text = provider.getStyledText((LtkModelElement<?>)embeddedElement);
        }
        if (text == null) {
            text = new StyledString(element.getElementName().getDisplayName());
        }
        return text;
    }

    protected int computeAdornmentFlags(LtkModelElement<?> element) {
        SourceElement sourceElement;
        SourceUnit sourceUnit;
        int flags = 0;
        if (element instanceof SourceElement && (sourceUnit = (sourceElement = (SourceElement)element).getSourceUnit()) != null && sourceUnit.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
            IAnnotationModel annotationModel;
            if (this.hasAstError(sourceElement)) {
                flags |= 4;
            } else if (this.isUpToDate(sourceElement) && (annotationModel = this.getAnnotationModel(sourceUnit)) != null) {
                flags |= this.getProblemFlag(annotationModel, sourceElement);
            }
        }
        return flags;
    }

    private @Nullable IAnnotationModel getAnnotationModel(SourceUnit sourceUnit) {
        IDocumentProvider documentProvider;
        String modelTypeId = (String)ObjectUtils.nonNullElse((Object)this.modelTypeId, (Object)sourceUnit.getModelTypeId());
        if (modelTypeId == this.documentProviderModelTypeId) {
            documentProvider = this.documentProvider;
        } else {
            documentProvider = (IDocumentProvider)LtkModels.getModelAdapter((String)modelTypeId, IDocumentProvider.class);
            this.documentProviderModelTypeId = modelTypeId;
            this.documentProvider = documentProvider;
        }
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getAnnotationModel((Object)sourceUnit);
    }

    private boolean isUpToDate(SourceElement<?> element) {
        SourceContainerElement containerElement;
        if (element instanceof SourceStructElement && (containerElement = LtkModelUtils.getSourceContainerElement((SourceStructElement)((SourceStructElement)element))) != null) {
            SourceUnit sourceUnit = element.getSourceUnit();
            return containerElement.getStamp().getContentStamp() == sourceUnit.getContentStamp(null);
        }
        return true;
    }

    private boolean hasAstError(SourceElement<?> element) {
        SourceStructElement embeddedElement;
        boolean embedding = (element.getElementType() & 0xF00) == 2048;
        AstNode astNode = (AstNode)element.getAdapter(AstNode.class);
        if (astNode != null && Asts.hasErrors((AstNode)astNode)) {
            return true;
        }
        return embedding && (embeddedElement = ((EmbeddingForeignElement)element).getForeignElement()) != null && (astNode = (AstNode)embeddedElement.getAdapter(AstNode.class)) != null && Asts.hasErrors((AstNode)astNode);
    }

    /*
     * WARNING - void declaration
     */
    private int getProblemFlag(IAnnotationModel model, SourceElement<?> sourceElement) {
        int severity = -1;
        Iterator iter = model.getAnnotationIterator();
        while (severity != 2 && iter.hasNext()) {
            Problem issue;
            void issueAnnotation;
            Annotation annotation = (Annotation)iter.next();
            Annotation annotation2 = annotation;
            if (!(annotation2 instanceof SourceIssueEditorAnnotation)) continue;
            SourceIssueEditorAnnotation cfr_ignored_0 = (SourceIssueEditorAnnotation)annotation2;
            SourceIssueEditorAnnotation cfr_ignored_1 = (SourceIssueEditorAnnotation)annotation2;
            if (issueAnnotation.isMarkedDeleted() || !((issue = issueAnnotation.getIssue()) instanceof Problem) || !this.isInside(model.getPosition(annotation), sourceElement)) continue;
            severity = Math.max(severity, issue.getSeverity());
        }
        switch (severity) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        return 0;
    }

    private boolean isInside(@Nullable Position position, SourceElement<?> sourceElement) {
        return position != null && (this.isInside(position, sourceElement.getSourceRange()) || this.isInside(position, sourceElement.getDocumentationRange()));
    }

    private boolean isInside(Position position, @Nullable TextRegion region) {
        return region != null && region.contains(position.getOffset());
    }

    public void update(ViewerCell cell) {
        Object cellElement = cell.getElement();
        if (cellElement instanceof LtkModelElement) {
            LtkModelElement element = (LtkModelElement)cellElement;
            cell.setImage(this.getImage(element));
            StyledString styledText = this.getStyledText(element);
            cell.setText(styledText.getString());
            cell.setStyleRanges(styledText.getStyleRanges());
        } else {
            cell.setImage(null);
            cell.setText(cellElement.toString());
            cell.setStyleRanges(null);
        }
        super.update(cell);
    }
}

