/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.util.ServerUtils;

@NonNullByDefault
public class RJContext {
    public static final String RJ_SERVER_CLASS_PATH_PROPERTY_KEY = "org.eclipse.statet.rj.server.ClassPath.urls";
    public static final String RJ_PATH_SEPARATOR = ":,:";
    private static final Pattern RJ_PATH_SEPARATOR_PATTERN = Pattern.compile(":,:", 16);
    @Deprecated
    protected static final String LOCALHOST_POLICY_FILENAME = "localhost.policy";

    public List<BundleEntry> resolveBundles(List<BundleSpec> bundleSpecs) throws StatusException {
        return CommonsRuntime.getEnvironment().resolveBundles(bundleSpecs);
    }

    @Deprecated
    public String getServerPolicyFilePath() throws RjInvalidConfigurationException {
        try {
            List<BundleEntry> bundles = this.resolveBundles((List<BundleSpec>)ImCollections.newList((Object)ServerUtils.RJ_SERVER_SPEC));
            for (BundleEntry bundle : bundles) {
                Path policyPath;
                if (!(bundle instanceof BundleEntry.Dir) || (policyPath = bundle.getResourcePath(LOCALHOST_POLICY_FILENAME)) == null || !Files.isRegularFile(policyPath, new LinkOption[0])) continue;
                return policyPath.toUri().toString();
            }
            for (BundleEntry bundle : bundles) {
                String s = bundle.getResourceUrlString(LOCALHOST_POLICY_FILENAME);
                if (s == null) continue;
                return s;
            }
            throw new UnsupportedOperationException("bundleEntries=" + (!bundles.isEmpty() ? "n\t" + CollectionUtils.toString(bundles, (String)"\n\t") : "<none>"));
        }
        catch (Exception e) {
            throw new RjInvalidConfigurationException("Failed find server policy file.", e);
        }
    }

    protected String getPropertiesDirPath() {
        return System.getProperty("user.dir");
    }

    protected @Nullable InputStream getInputStream(String path) throws IOException {
        Path file = Path.of(path, new String[0]);
        if (Files.notExists(file, new LinkOption[0])) {
            return null;
        }
        return Files.newInputStream(file, new OpenOption[0]);
    }

    protected OutputStream getOutputStream(String path) throws IOException {
        Path file = Path.of(path, new String[0]);
        return Files.newOutputStream(file, new OpenOption[0]);
    }

    public @Nullable Properties loadProperties(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String path = String.valueOf(this.getPropertiesDirPath()) + '/' + name + ".properties";
        InputStream in = this.getInputStream(path);
        if (in == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public void saveProperties(String name, Properties properties) throws IOException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        String path = String.valueOf(this.getPropertiesDirPath()) + '/' + name + ".properties";
        OutputStream out = this.getOutputStream(path);
        try {
            properties.store(out, null);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

