/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.nostart;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.statet.ecommons.io.TextContentDescriber;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class RdTextContentDescriber
extends TextContentDescriber {
    private static final @NonNull QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private static final String ENCODING_COMMAND_NAME = "encoding";
    private static final Pattern BRACKET_CONTENT_PATTERN = Pattern.compile("\\s*\\{\\s*(\\S*)\\s*\\}.*");

    public @NonNull QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public int describe(Reader contents, @Nullable IContentDescription description) throws IOException {
        if (description != null && description.isRequested(IContentDescription.CHARSET)) {
            BufferedReader reader = new BufferedReader(contents);
            String encoding = this.searchEncoding(reader);
            if (encoding == null) {
                return 1;
            }
            description.setProperty(IContentDescription.CHARSET, (Object)encoding);
        }
        return 2;
    }

    public int describe(InputStream contents, @Nullable IContentDescription description) throws IOException {
        BufferedReader reader;
        String encoding;
        byte[] bom = this.getByteOrderMark(contents);
        String baseEncoding = "ISO-8859-1";
        if (bom != null) {
            if (bom == IContentDescription.BOM_UTF_16BE) {
                baseEncoding = "UTF-16BE";
            } else if (bom == IContentDescription.BOM_UTF_16LE) {
                baseEncoding = "UTF-16LE";
            } else if (bom == IContentDescription.BOM_UTF_8) {
                baseEncoding = "UTF-8";
            }
            if (description != null && description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
                description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)bom);
            }
        }
        if (description != null && description.isRequested(IContentDescription.CHARSET) && (encoding = this.searchEncoding(reader = new BufferedReader(new InputStreamReader(contents, baseEncoding)))) != null) {
            description.setProperty(IContentDescription.CHARSET, (Object)encoding);
        }
        return 2;
    }

    private @Nullable String searchEncoding(BufferedReader reader) throws IOException {
        String line;
        block5: while ((line = reader.readLine()) != null) {
            int idx = 0;
            while (idx < line.length()) {
                switch (line.charAt(idx)) {
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    case '%': {
                        continue block5;
                    }
                    case '\\': {
                        Matcher matcher;
                        if (!line.regionMatches(idx + 1, ENCODING_COMMAND_NAME, 0, ENCODING_COMMAND_NAME.length()) || !(matcher = BRACKET_CONTENT_PATTERN.matcher(line.substring(idx + 1 + ENCODING_COMMAND_NAME.length()))).matches()) break block5;
                        return matcher.group(1);
                    }
                    default: {
                        break block5;
                    }
                }
                ++idx;
            }
        }
        return null;
    }
}

