/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.pkgmanager;

import java.net.URL;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.renv.core.RPkgType;

@NonNullByDefault
public class RRepo {
    public static final String CUSTOM_PREFIX = "custom-";
    public static final String SPECIAL_PREFIX = "special-";
    public static final String R_PREFIX = "r-";
    public static final String CRAN_ID = "r-CRAN";
    public static final String BIOC_ID_PREFIX = "r-BioC";
    public static final String WS_CACHE_PREFIX = "special-ws-cache-";
    public static final String WS_CACHE_SOURCE_ID = "special-ws-cache-source";
    public static final String WS_CACHE_BINARY_ID = "special-ws-cache-binary";
    public static final RRepo WS_CACHE_SOURCE_REPO = new RRepo("special-ws-cache-source", "Local Packages", null, RPkgType.SOURCE);
    public static final RRepo WS_CACHE_BINARY_REPO = new RRepo("special-ws-cache-binary", "Local Packages", null, RPkgType.BINARY);
    private final String id;
    private String name;
    private String url;
    private @Nullable RPkgType pkgType;

    public static String checkRepoURL(String url) {
        if (url.length() > 0 && url.charAt(url.length() - 1) != '/') {
            return String.valueOf(url) + '/';
        }
        return url;
    }

    public static @Nullable String hintName(RRepo repo) {
        try {
            URL url = new URL(repo.getURL());
            if (url.getHost() != null) {
                return url.getHost();
            }
            if (url.getPath() != null) {
                return url.getPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public RRepo(String id, @Nullable String name, @Nullable String url, @Nullable RPkgType pkgType) {
        this.id = id.intern();
        this.setName(name);
        this.setURL(url);
        this.pkgType = pkgType;
    }

    public RRepo(String id) {
        this(id, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public void set(RRepo template) {
        this.name = template.name;
        this.url = template.url;
        this.pkgType = template.pkgType;
    }

    public void setName(@Nullable String name) {
        this.name = name != null ? name : "";
    }

    public String getName() {
        return this.name;
    }

    public void setURL(@Nullable String url) {
        this.url = url != null ? RRepo.checkRepoURL(url) : "";
    }

    public String getURL() {
        return this.url;
    }

    public @Nullable RPkgType getPkgType() {
        return this.pkgType;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj) break block2;
                Object object = obj;
                if (!(object instanceof RRepo)) break block3;
                RRepo rRepo = (RRepo)object;
                RRepo cfr_ignored_0 = (RRepo)object;
                if (this.id.equals(other.id)) break block2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " (" + this.getURL() + ")";
    }
}

