/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rmodel;

import java.io.Serializable;
import org.eclipse.statet.jcommons.lang.Immutable;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class Parameters
implements Immutable,
Serializable {
    private static final long serialVersionUID = -3536570586490553543L;
    public static final int UNKNOWN = 0;
    private static final int OBJ_SHIFT = 0;
    private static final int NAME_SHIFT = 8;
    private static final int OTHER_SHIFT = 16;
    private static final int FLAGS_SHIFT = 24;
    public static final int UNSPECIFIC_OBJ = 1;
    public static final int UNSPECIFIC_NAME = 256;
    public static final int PACKAGE_NAME = 512;
    public static final int HELP_TOPIC_NAME = 4096;
    public static final int CLASS_OBJ = 32;
    public static final int CLASS_NAME = 8192;
    public static final int METHOD_OBJ = 64;
    public static final int METHOD_NAME = 16384;
    public static final int FILE_NAME = 131072;
    public static final int NAME_AS_SYMBOL = 0x2000000;
    public static final int NAME_AS_STRING = 0x4000000;
    protected final @NonNull Parameter[] parameters;

    public Parameters(String ... names) {
        this.parameters = new Parameter[names.length];
        int i = 0;
        while (i < names.length) {
            this.parameters[i] = new Parameter(i, names[i], 0, null);
            ++i;
        }
    }

    Parameters(@NonNull Parameter[] parameters) {
        this.parameters = parameters;
    }

    public int size() {
        return this.parameters.length;
    }

    public boolean contains(@Nullable String name) {
        if (name != null) {
            int i = 0;
            while (i < this.parameters.length) {
                Parameter parameter = this.parameters[i];
                if (parameter.name != null && parameter.name.equals(name)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public @Nullable Parameter get(@Nullable String name) {
        if (name != null) {
            int i = 0;
            while (i < this.parameters.length) {
                Parameter parameter = this.parameters[i];
                if (parameter.name != null && parameter.name.equals(name)) {
                    return parameter;
                }
                ++i;
            }
        }
        return null;
    }

    public Parameter get(int index) {
        return this.parameters[index];
    }

    public int indexOf(@Nullable String name) {
        if (name != null) {
            int i = 0;
            while (i < this.parameters.length) {
                Parameter parameter = this.parameters[i];
                if (parameter.name != null && parameter.name.equals(name)) {
                    return parameter.index;
                }
                ++i;
            }
        }
        return -1;
    }

    public static final class Parameter
    implements Serializable {
        private static final long serialVersionUID = 5880323434513504465L;
        public final int index;
        private final @Nullable String name;
        private final int type;
        private final @Nullable String className;

        Parameter(int index, @Nullable String name, int type, @Nullable String className) {
            this.index = index;
            this.name = name;
            this.type = type;
            this.className = className;
        }

        public @Nullable String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public @Nullable String getClassName() {
            return this.className;
        }
    }
}

