/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.docmlet.tex.core.TexBuildParticipant;
import org.eclipse.statet.docmlet.tex.core.model.TexWorkspaceSourceUnit;
import org.eclipse.statet.docmlet.tex.core.model.build.LtxSourceUnitModelContainer;
import org.eclipse.statet.docmlet.tex.core.project.TexProject;
import org.eclipse.statet.internal.redocs.tex.r.model.LtxRweaveSuModelContainer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.project.RProjects;
import org.eclipse.statet.r.core.rmodel.RModel;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.build.RModelIndexUpdate;
import org.eclipse.statet.redocs.tex.r.core.model.LtxRweaveSourceUnit;

@NonNullByDefault
public class TexRweaveBuildParticipant
extends TexBuildParticipant {
    private static final ImList<String> TEX_R_MODEL_TYPES = ImCollections.newList((Object)"LtxRweave");
    private RModelIndexUpdate rIndexUpdate = (RModelIndexUpdate)ObjectUtils.nonNullLateInit();

    public void init() {
        super.init();
        RProject rProject = RProjects.getRProject((IProject)((TexProject)this.getLtkProject()).getProject());
        if (rProject != null) {
            this.setEnabled(true);
            this.rIndexUpdate = new RModelIndexUpdate(rProject, TEX_R_MODEL_TYPES, this.getBuildType() == 6);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleSourceUnitUpdated(TexWorkspaceSourceUnit sourceUnit, SubMonitor m) throws CoreException {
        TexWorkspaceSourceUnit texWorkspaceSourceUnit = sourceUnit;
        if (texWorkspaceSourceUnit instanceof LtxRweaveSourceUnit) {
            void unit;
            LtxRweaveSourceUnit ltxRweaveSourceUnit = (LtxRweaveSourceUnit)texWorkspaceSourceUnit;
            LtxRweaveSourceUnit cfr_ignored_0 = (LtxRweaveSourceUnit)texWorkspaceSourceUnit;
            LtxRweaveSuModelContainer modelContainer = (LtxRweaveSuModelContainer)((Object)unit.getAdapter(LtxSourceUnitModelContainer.class));
            if (modelContainer != null) {
                this.rIndexUpdate.update((RSourceUnit)unit, RModel.getRModelInfo((SourceUnitModelInfo)modelContainer.getCurrentModel()));
            } else {
                this.rIndexUpdate.remove((RSourceUnit)unit);
            }
        }
    }

    public void handleSourceUnitRemoved(IFile file, SubMonitor m) throws CoreException {
        this.rIndexUpdate.remove(file);
    }

    public void finish(SubMonitor m) throws CoreException {
        this.rIndexUpdate.submit((IProgressMonitor)m);
    }
}

