/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.freeze;

import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.core.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeCellPositionCommand;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeColumnStrategy;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeDimPositionCommand;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeHelper;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeLayer;
import org.eclipse.statet.ecommons.waltable.freeze.FreezePositionStrategy;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeRowStrategy;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeSelectionCommand;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeSelectionStrategy;
import org.eclipse.statet.ecommons.waltable.freeze.IFreezeCommand;
import org.eclipse.statet.ecommons.waltable.freeze.IFreezeCoordinatesProvider;
import org.eclipse.statet.ecommons.waltable.freeze.UnFreezeGridCommand;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayer;

public class FreezeCommandHandler
extends AbstractLayerCommandHandler<IFreezeCommand> {
    protected final FreezeLayer freezeLayer;
    protected final ViewportLayer viewportLayer;
    protected final SelectionLayer selectionLayer;

    public FreezeCommandHandler(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<IFreezeCommand> getCommandClass() {
        return IFreezeCommand.class;
    }

    @Override
    public boolean doCommand(IFreezeCommand command) {
        if (command instanceof FreezeDimPositionCommand) {
            FreezeDimPositionCommand dimPositionCommand = (FreezeDimPositionCommand)command;
            IFreezeCoordinatesProvider coordinatesProvider = dimPositionCommand.getOrientation() == Orientation.HORIZONTAL ? new FreezeColumnStrategy(this.freezeLayer, dimPositionCommand.getPosition()) : new FreezeRowStrategy(this.freezeLayer, dimPositionCommand.getPosition());
            this.handleFreezeCommand(coordinatesProvider, dimPositionCommand.isToggle(), command.isOverrideFreeze());
            return true;
        }
        if (command instanceof FreezeCellPositionCommand) {
            FreezeCellPositionCommand freezeCellPositionCommand = (FreezeCellPositionCommand)command;
            FreezePositionStrategy coordinatesProvider = new FreezePositionStrategy(this.freezeLayer, freezeCellPositionCommand.getColumnPosition(), freezeCellPositionCommand.getRowPosition());
            this.handleFreezeCommand(coordinatesProvider, freezeCellPositionCommand.isToggle(), command.isOverrideFreeze());
            return true;
        }
        if (command instanceof FreezeSelectionCommand) {
            FreezeSelectionStrategy coordinatesProvider = new FreezeSelectionStrategy(this.freezeLayer, this.viewportLayer, this.selectionLayer);
            this.handleFreezeCommand(coordinatesProvider, command.isToggle(), command.isOverrideFreeze());
            return true;
        }
        if (command instanceof UnFreezeGridCommand) {
            this.handleUnfreeze();
            return true;
        }
        return false;
    }

    protected void handleFreezeCommand(IFreezeCoordinatesProvider coordinatesProvider, boolean toggle, boolean override) {
        if (!this.freezeLayer.isFrozen() || override) {
            if (this.freezeLayer.isFrozen() && override) {
                FreezeHelper.resetViewport(this.freezeLayer, this.viewportLayer);
            }
            PositionCoordinate topLeftPosition = coordinatesProvider.getTopLeftPosition();
            PositionCoordinate bottomRightPosition = coordinatesProvider.getBottomRightPosition();
            FreezeHelper.freeze(this.freezeLayer, this.viewportLayer, topLeftPosition, bottomRightPosition);
        } else if (toggle) {
            this.handleUnfreeze();
        }
    }

    protected void handleUnfreeze() {
        FreezeHelper.unfreeze(this.freezeLayer, this.viewportLayer);
    }
}

