/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell.decorator;

import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellPainter;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.ui.util.CellEdgeEnum;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class CellPainterDecorator
implements LayerCellPainter {
    private final LayerCellPainter baseCellPainter;
    private final CellEdgeEnum cellEdge;
    private final LayerCellPainter decoratorCellPainter;
    private final long spacing;
    private boolean paintDecorationDependent;

    public CellPainterDecorator(LayerCellPainter baseCellPainter, CellEdgeEnum cellEdge, LayerCellPainter decoratorCellPainter) {
        this(baseCellPainter, cellEdge, 2L, decoratorCellPainter);
    }

    public CellPainterDecorator(LayerCellPainter baseCellPainter, CellEdgeEnum cellEdge, LayerCellPainter decoratorCellPainter, boolean paintDecorationDependent) {
        this(baseCellPainter, cellEdge, 2L, decoratorCellPainter, paintDecorationDependent);
    }

    public CellPainterDecorator(LayerCellPainter baseCellPainter, CellEdgeEnum cellEdge, long spacing, LayerCellPainter decoratorCellPainter) {
        this(baseCellPainter, cellEdge, spacing, decoratorCellPainter, true);
    }

    public CellPainterDecorator(LayerCellPainter baseCellPainter, CellEdgeEnum cellEdge, long spacing, LayerCellPainter decoratorCellPainter, boolean paintDecorationDependent) {
        this.baseCellPainter = baseCellPainter;
        this.cellEdge = cellEdge;
        this.spacing = spacing;
        this.decoratorCellPainter = decoratorCellPainter;
        this.paintDecorationDependent = paintDecorationDependent;
    }

    public void setPaintDecorationDependent(boolean paintDecorationDependent) {
        this.paintDecorationDependent = paintDecorationDependent;
    }

    @Override
    public long getPreferredWidth(LayerCell cell, GC gc, ConfigRegistry configRegistry) {
        switch (this.cellEdge) {
            case TOP: 
            case BOTTOM: 
            case TOP_LEFT: 
            case TOP_RIGHT: 
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                return this.spacing + Math.max(this.baseCellPainter.getPreferredWidth(cell, gc, configRegistry), this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry));
            }
        }
        return this.baseCellPainter.getPreferredWidth(cell, gc, configRegistry) + this.spacing + this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry);
    }

    @Override
    public long getPreferredHeight(LayerCell cell, GC gc, ConfigRegistry configRegistry) {
        switch (this.cellEdge) {
            case LEFT: 
            case RIGHT: 
            case TOP_LEFT: 
            case TOP_RIGHT: 
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                return this.spacing + Math.max(this.baseCellPainter.getPreferredHeight(cell, gc, configRegistry), this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry));
            }
        }
        return this.baseCellPainter.getPreferredHeight(cell, gc, configRegistry) + this.spacing + this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry);
    }

    @Override
    public void paintCell(LayerCell cell, GC gc, LRectangle adjustedCellBounds, ConfigRegistry configRegistry) {
        LRectangle baseCellPainterBounds = this.paintDecorationDependent ? this.getBaseCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry) : adjustedCellBounds;
        LRectangle decoratorCellPainterBounds = this.getDecoratorCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry);
        Color originalBg = gc.getBackground();
        gc.setBackground(CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyling.BACKGROUND_COLOR));
        gc.fillRectangle(GraphicsUtils.safe(adjustedCellBounds));
        gc.setBackground(originalBg);
        this.baseCellPainter.paintCell(cell, gc, baseCellPainterBounds, configRegistry);
        this.decoratorCellPainter.paintCell(cell, gc, decoratorCellPainterBounds, configRegistry);
    }

    public LRectangle getBaseCellPainterBounds(LayerCell cell, GC gc, LRectangle adjustedCellBounds, ConfigRegistry configRegistry) {
        long preferredDecoratorWidth = this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry);
        long preferredDecoratorHeight = this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry);
        long grabbedPreferredWidth = adjustedCellBounds.width - preferredDecoratorWidth - this.spacing;
        long grabbedPreferredHeight = adjustedCellBounds.height - preferredDecoratorHeight - this.spacing;
        switch (this.cellEdge) {
            case LEFT: {
                return new LRectangle(adjustedCellBounds.x + preferredDecoratorWidth + this.spacing, adjustedCellBounds.y, grabbedPreferredWidth, adjustedCellBounds.height).intersection(adjustedCellBounds);
            }
            case RIGHT: {
                return new LRectangle(adjustedCellBounds.x, adjustedCellBounds.y, grabbedPreferredWidth, adjustedCellBounds.height).intersection(adjustedCellBounds);
            }
            case TOP: {
                return new LRectangle(adjustedCellBounds.x, adjustedCellBounds.y + preferredDecoratorHeight + this.spacing, adjustedCellBounds.width, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
            case BOTTOM: {
                return new LRectangle(adjustedCellBounds.x, adjustedCellBounds.y, adjustedCellBounds.width, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
            case TOP_LEFT: {
                return new LRectangle(adjustedCellBounds.x + preferredDecoratorWidth + this.spacing, adjustedCellBounds.y + preferredDecoratorHeight + this.spacing, grabbedPreferredWidth, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
            case TOP_RIGHT: {
                return new LRectangle(adjustedCellBounds.x, adjustedCellBounds.y + preferredDecoratorHeight + this.spacing, grabbedPreferredWidth, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
            case BOTTOM_LEFT: {
                return new LRectangle(adjustedCellBounds.x + preferredDecoratorWidth + this.spacing, adjustedCellBounds.y, grabbedPreferredWidth, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
            case BOTTOM_RIGHT: {
                return new LRectangle(adjustedCellBounds.x, adjustedCellBounds.y, grabbedPreferredWidth, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
        }
        return null;
    }

    public LRectangle getDecoratorCellPainterBounds(LayerCell cell, GC gc, LRectangle adjustedCellBounds, ConfigRegistry configRegistry) {
        long preferredDecoratorWidth = this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry);
        long preferredDecoratorHeight = this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry);
        switch (this.cellEdge) {
            case LEFT: {
                return new LRectangle(adjustedCellBounds.x, adjustedCellBounds.y + (adjustedCellBounds.height - preferredDecoratorHeight) / 2L, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case RIGHT: {
                return new LRectangle(adjustedCellBounds.x + adjustedCellBounds.width - preferredDecoratorWidth, adjustedCellBounds.y + (adjustedCellBounds.height - preferredDecoratorHeight) / 2L, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case TOP: {
                return new LRectangle(adjustedCellBounds.x + (adjustedCellBounds.width - preferredDecoratorWidth) / 2L, adjustedCellBounds.y, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case BOTTOM: {
                return new LRectangle(adjustedCellBounds.x + (adjustedCellBounds.width - preferredDecoratorWidth) / 2L, adjustedCellBounds.y + adjustedCellBounds.height - preferredDecoratorHeight, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case TOP_LEFT: {
                return new LRectangle(adjustedCellBounds.x, adjustedCellBounds.y, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case TOP_RIGHT: {
                return new LRectangle(adjustedCellBounds.x + adjustedCellBounds.width - preferredDecoratorWidth, adjustedCellBounds.y, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case BOTTOM_LEFT: {
                return new LRectangle(adjustedCellBounds.x, adjustedCellBounds.y + adjustedCellBounds.height - preferredDecoratorHeight, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case BOTTOM_RIGHT: {
                return new LRectangle(adjustedCellBounds.x + adjustedCellBounds.width - preferredDecoratorWidth, adjustedCellBounds.y + adjustedCellBounds.height - preferredDecoratorHeight, preferredDecoratorWidth, preferredDecoratorHeight);
            }
        }
        return null;
    }

    @Override
    public LayerCellPainter getCellPainterAt(long x, long y, LayerCell cell, GC gc, LRectangle adjustedCellBounds, ConfigRegistry configRegistry) {
        LRectangle baseCellPainterBounds;
        LRectangle decoratorCellPainterBounds = this.getDecoratorCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry);
        if (decoratorCellPainterBounds.contains(x, y)) {
            return this.decoratorCellPainter.getCellPainterAt(x, y, cell, gc, decoratorCellPainterBounds, configRegistry);
        }
        LRectangle lRectangle = baseCellPainterBounds = this.paintDecorationDependent ? this.getBaseCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry) : adjustedCellBounds;
        if (baseCellPainterBounds.contains(x, y)) {
            return this.baseCellPainter.getCellPainterAt(x, y, cell, gc, baseCellPainterBounds, configRegistry);
        }
        return this;
    }
}

