/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui.matcher;

import org.eclipse.statet.ecommons.waltable.ui.matcher.IKeyEventMatcher;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.KeyEvent;

public class KeyEventMatcher
implements IKeyEventMatcher {
    private final int stateMask;
    private final int keyCode;

    public KeyEventMatcher(int keyCode) {
        this(0, keyCode);
    }

    public KeyEventMatcher(int stateMask, int keyCode) {
        this.stateMask = stateMask;
        this.keyCode = keyCode;
    }

    public int getStateMask() {
        return this.stateMask;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    @Override
    public boolean matches(KeyEvent event) {
        boolean keyCodeMatches;
        boolean stateMaskMatches = this.stateMask == event.stateMask;
        boolean bl = keyCodeMatches = this.keyCode == event.keyCode;
        return stateMaskMatches && keyCodeMatches;
    }

    public int hashCode() {
        return this.stateMask * 17 + this.keyCode * 119;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyEventMatcher)) {
            return false;
        }
        KeyEventMatcher other = (KeyEventMatcher)obj;
        return this.stateMask == other.stateMask && this.keyCode == other.keyCode;
    }
}

