/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyList;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public final class ImEmptySet<E>
extends AbstractImList<E>
implements ImSet<E>,
RandomAccess {
    public static final ImEmptySet INSTANCE = new ImEmptySet();
    private final ListIterator<E> iterator = new AbstractImList.AbstractImListIter<E>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public E previous() {
            throw new NoSuchElementException();
        }
    };

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.isEmpty();
    }

    @Override
    public E get(int index) {
        throw new IndexOutOfBoundsException("index= " + index);
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.emptySpliterator();
    }

    @Override
    public Object[] toArray() {
        return ArrayUtils.EMPTY_OBJ;
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        if (dest.length > 0) {
            dest[0] = null;
        }
        return dest;
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return generator.apply(0);
    }

    @Override
    public void copyTo(Object[] dest, int destPos) {
    }

    @Override
    public void copyTo(int srcPos, Object[] dest, int destPos, int length) {
        assert (false);
    }

    @Override
    public ImList<E> toList() {
        return ImEmptyList.INSTANCE;
    }

    @Override
    public ImIdentityList<E> toIdentityList() {
        return ImEmptyIdentityList.INSTANCE;
    }

    @Override
    public <R> ImCollection.MappingResult<R> map(Function<E, R> mapper) {
        ObjectUtils.nonNullAssert(mapper);
        return ImEmptyList.INSTANCE;
    }

    @Override
    public @Nullable E findFirst(Predicate<E> predicate) {
        ObjectUtils.nonNullAssert(predicate);
        return null;
    }

    @Override
    public boolean anyMatch(Predicate<? super E> predicate) {
        ObjectUtils.nonNullAssert(predicate);
        return false;
    }

    @Override
    public boolean allMatch(Predicate<? super E> predicate) {
        ObjectUtils.nonNullAssert(predicate);
        return true;
    }

    @Override
    public boolean noneMatch(Predicate<? super E> predicate) {
        ObjectUtils.nonNullAssert(predicate);
        return true;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Set) {
            Set other = (Set)obj;
            return other.isEmpty();
        }
        return false;
    }

    public String toString() {
        return "[]";
    }
}

