/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.r.apps.ui.launching.AppControlManager;
import org.eclipse.statet.internal.r.apps.ui.launching.AppType;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

@NonNullByDefault
public class RAppUIPlugin
extends AbstractUIPlugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.r.apps";
    private static RAppUIPlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private @Nullable AppControlManager launchConfigManager;

    public static RAppUIPlugin getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        RAppUIPlugin plugin = RAppUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static void logError(String message, Throwable e) {
        RAppUIPlugin.log((IStatus)new Status(4, BUNDLE_ID, message, e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            RAppUIPlugin rAppUIPlugin = this;
            synchronized (rAppUIPlugin) {
                this.started = false;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    RAppUIPlugin.log((IStatus)new Status(4, BUNDLE_ID, "Error occured while dispose module", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.r.apps/image/tool/View", "tool_16", "view-app.png");
    }

    public synchronized AppControlManager getRunAppConfigManager(AppType appType) {
        if (this.launchConfigManager == null) {
            this.launchConfigManager = new AppControlManager(appType);
            this.disposables.add((Disposable)this.launchConfigManager);
        }
        return this.launchConfigManager;
    }
}

