/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pager;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

@NonNullByDefault
public class RPagerEditorInput
implements IEditorInput {
    private final String name;
    private final RTool source;
    private final ImList<TextFile> files;

    public RPagerEditorInput(String name, RTool source, ImList<TextFile> files) {
        this.name = name;
        this.source = source;
        this.files = files;
    }

    public boolean exists() {
        return true;
    }

    public @Nullable ImageDescriptor getImageDescriptor() {
        return RUI.getImageDescriptor("org.eclipse.statet.r.editors.Rd");
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return String.valueOf(this.name) + '\n' + this.source.getLabel(1);
    }

    public ImList<TextFile> getFiles() {
        return this.files;
    }

    public @Nullable IPersistableElement getPersistable() {
        return null;
    }

    public <T> @Nullable T getAdapter(Class<T> adapter) {
        return null;
    }

    public static class TextFile {
        private final String name;
        private final String content;

        public TextFile(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public String getContent() {
            return this.content;
        }
    }
}

