/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.doc;

import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public interface RDocumentConstants {
    public static final String R_PARTITIONING = "org.eclipse.statet.R";
    public static final String R_DEFAULT_CONTENT_TYPE = "R.Default";
    public static final String R_QUOTED_SYMBOL_CONTENT_TYPE = "R.QuotedSymbol";
    public static final String R_INFIX_OPERATOR_CONTENT_TYPE = "R.Op.Infix";
    public static final String R_STRING_CONTENT_TYPE = "R.String";
    public static final String R_COMMENT_CONTENT_TYPE = "R.Comment";
    public static final String R_ROXYGEN_CONTENT_TYPE = "R.Roxygen";
    public static final ImList<String> R_CONTENT_TYPES = ImCollections.newList((Object[])new String[]{"R.Default", "R.QuotedSymbol", "R.Op.Infix", "R.String", "R.Comment", "R.Roxygen"});
    public static final PartitionConstraint R_DEFAULT_CONTENT_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String contentType) {
            return contentType == RDocumentConstants.R_DEFAULT_CONTENT_TYPE;
        }
    };
    public static final PartitionConstraint R_CODE_CONTENT_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String contentType) {
            return contentType == RDocumentConstants.R_DEFAULT_CONTENT_TYPE || contentType == RDocumentConstants.R_STRING_CONTENT_TYPE || contentType == RDocumentConstants.R_QUOTED_SYMBOL_CONTENT_TYPE || contentType == RDocumentConstants.R_INFIX_OPERATOR_CONTENT_TYPE;
        }
    };
    public static final PartitionConstraint R_ANY_CONTENT_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String contentType) {
            return contentType == RDocumentConstants.R_DEFAULT_CONTENT_TYPE || contentType == RDocumentConstants.R_STRING_CONTENT_TYPE || contentType == RDocumentConstants.R_COMMENT_CONTENT_TYPE || contentType == RDocumentConstants.R_ROXYGEN_CONTENT_TYPE || contentType == RDocumentConstants.R_INFIX_OPERATOR_CONTENT_TYPE || contentType == RDocumentConstants.R_QUOTED_SYMBOL_CONTENT_TYPE;
        }
    };
    public static final PartitionConstraint R_NO_COMMENT_CONTENT_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String contentType) {
            return contentType != RDocumentConstants.R_COMMENT_CONTENT_TYPE;
        }
    };
    public static final String RDOC_PARTITIONING = "org.eclipse.statet.Rd";
    public static final String RDOC_DEFAULT_CONTENT_TYPE = "__dftl_partition_content_type";
    public static final String RDOC_COMMENT_CONTENT_TYPE = "Rd.Comment";
    public static final String RDOC_PLATFORM_SPECIF = "__rd_platform";
    public static final ImList<String> RDOC_CONTENT_TYPES = ImCollections.newList((Object[])new String[]{"__dftl_partition_content_type", "Rd.Comment", "__rd_platform"});
    public static final PartitionConstraint RDOC_DEFAULT_CONTENT_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String contentType) {
            return contentType == RDocumentConstants.RDOC_DEFAULT_CONTENT_TYPE;
        }
    };
    public static final String RPKG_DESCR_PARTITIONING = "org.eclipse.statet.RPkgDescription";
    public static final String RPKG_DESCR_DEFAULT_CONTENT_TYPE = "RPkgDescr.Default";
    public static final String RPKG_DESCR_FIELD_NAME_CONTENT_TYPE = "RPkgDescr.FieldName";
    public static final ImList<String> RPKG_DESCR_CONTENT_TYPES = ImCollections.newList((Object[])new String[]{"RPkgDescr.Default", "RPkgDescr.FieldName", "R.Default", "R.QuotedSymbol", "R.Op.Infix", "R.String", "R.Comment"});
    public static final PartitionConstraint RPKG_DESCR_DEFAULT_CONTENT_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String contentType) {
            return contentType == RDocumentConstants.RPKG_DESCR_DEFAULT_CONTENT_TYPE;
        }
    };
    public static final PartitionConstraint RPKG_DESCR_ANY_CONTENT_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String contentType) {
            return contentType == RDocumentConstants.RPKG_DESCR_DEFAULT_CONTENT_TYPE || contentType == RDocumentConstants.RPKG_DESCR_FIELD_NAME_CONTENT_TYPE;
        }
    };
}

