/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.project.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.issues.core.impl.ResourceMarkerIssueRequestor;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.project.core.LtkProject;
import org.eclipse.statet.ltk.project.core.builder.ProjectBuildParticipant;
import org.eclipse.statet.ltk.project.core.builder.ProjectTaskBuilder;

@NonNullByDefault
public abstract class ProjectTask<TProject extends LtkProject, TSourceUnit extends WorkspaceSourceUnit, TParticipant extends ProjectBuildParticipant<TProject, TSourceUnit>> {
    private static final ProjectBuildParticipant NO_PARTICIPANT = new ProjectBuildParticipant();
    private final Map<String, TParticipant> participants = new HashMap<String, TParticipant>();
    private final ProjectTaskBuilder<TProject, TSourceUnit, TParticipant> projectBuilder;
    private final IProject project;
    private int buildType;
    protected final MultiStatus status;

    public ProjectTask(ProjectTaskBuilder<TProject, TSourceUnit, TParticipant> projectBuilder) {
        this.projectBuilder = projectBuilder;
        this.project = projectBuilder.getProject();
        this.status = new MultiStatus(this.getBuilderDefinition().getBundleId(), 0, String.format("%1$s build status for '%2$s'", this.getBuilderDefinition().getProjectTypeLabel(), this.getProject().getName()), null);
    }

    protected final ProjectTaskBuilder<TProject, TSourceUnit, TParticipant> getBuilder() {
        return this.projectBuilder;
    }

    protected final ProjectTaskBuilder.BuilderDefinition<TProject, TSourceUnit, TParticipant> getBuilderDefinition() {
        return this.projectBuilder.getBuilderDefinition();
    }

    public final IProject getProject() {
        return this.project;
    }

    public void setBuildType(int buildType) {
        this.buildType = buildType;
    }

    protected final Collection<TParticipant> getParticipants() {
        Collection<TParticipant> values = this.participants.values();
        ArrayList<ProjectBuildParticipant> list = new ArrayList<ProjectBuildParticipant>(values.size());
        for (ProjectBuildParticipant participant : values) {
            if (participant == null) continue;
            list.add(participant);
        }
        return list;
    }

    protected final @Nullable TParticipant getParticipant(String modelTypeId) {
        if (modelTypeId == null) {
            return null;
        }
        @Nullable ProjectBuildParticipant<TProject, TSourceUnit> participant = (ProjectBuildParticipant)this.participants.get(modelTypeId);
        if (participant == null) {
            participant = this.loadParticipant(modelTypeId);
            this.participants.put(modelTypeId, participant);
        }
        return (TParticipant)(participant != NO_PARTICIPANT ? participant : null);
    }

    private TParticipant loadParticipant(String modelTypeId) {
        @Nullable ProjectBuildParticipant participant = (ProjectBuildParticipant)LtkModels.getModelAdapter(modelTypeId, this.getBuilderDefinition().getParticipantType());
        if (participant == null) {
            return (TParticipant)NO_PARTICIPANT;
        }
        participant.ltkProject = this.getBuilder().getLtkProject();
        participant.buildType = this.buildType;
        participant.enabled = false;
        participant.init();
        return (TParticipant)participant;
    }

    protected void clear(IFile file) {
        try {
            ResourceMarkerIssueRequestor.clear((Object)file, this.getBuilder().getIssueTypeSets());
        }
        catch (CoreException e) {
            this.status.add((IStatus)new Status(4, this.getBuilderDefinition().getBundleId(), String.format("An error occurred when clearing issue(s) of file '%1$s'.", file.getProjectRelativePath()), (Throwable)e));
        }
    }

    protected void clear(IProject project) {
        try {
            ResourceMarkerIssueRequestor.clear((Object)project, this.getBuilder().getIssueTypeSets());
        }
        catch (CoreException e) {
            this.status.add((IStatus)new Status(4, this.getBuilderDefinition().getBundleId(), "An error occurred when clearing issue(s) of the project.", (Throwable)e));
        }
    }

    protected void finish() {
        if (!this.status.isOK()) {
            this.getBuilder().log((IStatus)this.status);
        }
    }
}

