/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.text.core;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.ecommons.text.core.TextTokenScanner;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.string.CharPair;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.jcommons.text.core.CharPairSet;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public class HeuristicTokenScanner
implements TextTokenScanner {
    protected static final PartitionConstraint ALL_PARTITIONS_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String contentType) {
            return true;
        }
    };
    protected static final CharPairSet COMMON_BRACKETS = new CharPairSet(ImCollections.newIdentityList((Object[])new CharPair[]{Chars.CURLY_BRACKETS, Chars.SQUARE_BRACKETS, Chars.ROUND_BRACKETS}));
    private final String partitioning;
    private final PartitionConstraint defaultPartitionConstraint;
    private IDocument document;
    private PartitionConstraint partitionConstraint;
    protected char ch;
    protected int pos;
    private @Nullable StopCondition nonWSCondition;
    private @Nullable StopCondition nonWSorLRCondition;

    public HeuristicTokenScanner(DocContentSections documentContentInfo, PartitionConstraint defaultContentConstraint) {
        this.partitioning = documentContentInfo.getPartitioning();
        this.defaultPartitionConstraint = defaultContentConstraint;
    }

    public CharPairSet getDefaultBrackets() {
        return COMMON_BRACKETS;
    }

    public final IDocument getDocument() {
        return this.document;
    }

    public final String getDocumentPartitioning() {
        return this.partitioning;
    }

    public final PartitionConstraint getDefaultPartitionConstraint() {
        return this.defaultPartitionConstraint;
    }

    protected final PartitionConstraint getPartitionConstraint() {
        return this.partitionConstraint;
    }

    public final char getChar() {
        return this.ch;
    }

    protected boolean isWhitespace(char c) {
        return Character.getType(c) == 12 || c == '\t';
    }

    protected final StopCondition getAnyNonWSCondition() {
        StopCondition nonWSCondition = this.nonWSCondition;
        if (nonWSCondition == null) {
            this.nonWSCondition = nonWSCondition = new StopCondition(this){

                @Override
                public boolean stop() {
                    char c = ch;
                    return !this.isWhitespace(c);
                }
            };
        }
        return nonWSCondition;
    }

    protected final StopCondition getAnyNonWSorLRCondition() {
        StopCondition nonWSorLRCondition = this.nonWSorLRCondition;
        if (nonWSorLRCondition == null) {
            this.nonWSorLRCondition = nonWSorLRCondition = new StopCondition(this){

                @Override
                public boolean stop() {
                    char c = ch;
                    return !this.isWhitespace(c) && c != '\r' && c != '\n';
                }
            };
        }
        return nonWSorLRCondition;
    }

    protected final StopCondition getNonWSCondition() {
        StopCondition nonWSCondition = this.nonWSCondition;
        if (nonWSCondition == null) {
            this.nonWSCondition = nonWSCondition = new PartitionBasedCondition(this){

                @Override
                protected boolean matchesChar(char c) {
                    return !this.isWhitespace(c);
                }
            };
        }
        return nonWSCondition;
    }

    protected final StopCondition getNonWSorLRCondition() {
        StopCondition nonWSorLRCondition = this.nonWSorLRCondition;
        if (nonWSorLRCondition == null) {
            this.nonWSorLRCondition = nonWSorLRCondition = new PartitionBasedCondition(this){

                @Override
                protected boolean matchesChar(char c) {
                    return !this.isWhitespace(c) && c != '\r' && c != '\n';
                }
            };
        }
        return nonWSorLRCondition;
    }

    public void configure(IDocument document, final String partitionType) {
        assert (document != null && partitionType != null);
        this.document = document;
        this.partitionConstraint = new PartitionConstraint(){

            public boolean matches(String partitionTypeToTest) {
                return partitionType == partitionTypeToTest;
            }
        };
    }

    public void configure(IDocument document) {
        assert (document != null);
        this.document = document;
        this.partitionConstraint = ALL_PARTITIONS_CONSTRAINT;
    }

    public void configureDefaultPartitions(IDocument document) {
        assert (document != null);
        this.document = document;
        this.partitionConstraint = this.getDefaultPartitionConstraint();
    }

    public void configure(IDocument document, PartitionConstraint partitionConstraint) {
        assert (document != null && partitionConstraint != null);
        this.document = document;
        this.partitionConstraint = partitionConstraint;
    }

    protected int createForwardBound(int start) throws BadLocationException {
        return this.document.getLength();
    }

    protected int createBackwardBound(int start) throws BadLocationException {
        return 0;
    }

    protected final int checkForwardBound(int start, int bound) throws BadLocationException {
        if (bound == -2) {
            bound = this.createForwardBound(start);
        }
        assert (bound >= start && bound <= this.document.getLength());
        return bound;
    }

    protected final int checkBackwardBound(int start, int bound) throws BadLocationException {
        if (bound == -2) {
            bound = this.createBackwardBound(start);
        }
        assert (bound <= start && bound >= 0);
        return bound - 1;
    }

    protected final int scanForward(int start, int bound, StopCondition condition, char escapeChar) {
        if (bound == -2) {
            bound = this.document.getLength();
        }
        assert (start >= 0);
        try {
            int offset = start;
            while (offset < bound) {
                this.ch = this.document.getChar(offset);
                this.pos = offset;
                if (condition.stop()) {
                    if (escapeChar != '\u0000') {
                        while (--offset >= start && this.document.getChar(offset) == escapeChar) {
                        }
                        if ((this.pos - offset) % 2 == 1) {
                            return this.pos;
                        }
                    } else {
                        return this.pos;
                    }
                }
                offset = condition.nextPositionForward();
            }
            this.pos = bound;
            this.ch = (char)(this.pos >= 0 && this.pos < this.document.getLength() ? (int)this.document.getChar(this.pos) : 65535);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    protected final int scanBackward(int start, int bound, StopCondition condition, char escapeChar) {
        if (bound == -2) {
            bound = -1;
        }
        try {
            int offset = start;
            while (offset > bound) {
                this.ch = this.document.getChar(offset);
                this.pos = offset;
                if (condition.stop()) {
                    if (escapeChar != '\u0000') {
                        while (--offset > bound && this.document.getChar(offset) == escapeChar) {
                        }
                        if ((this.pos - offset) % 2 == 1) {
                            return this.pos;
                        }
                    } else {
                        return this.pos;
                    }
                }
                offset = condition.nextPositionBackward();
            }
            this.pos = bound;
            this.ch = (char)(this.pos >= 0 && this.pos < this.document.getLength() ? (int)this.document.getChar(this.pos) : 65535);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    protected final @Nullable IRegion findRegion(int offset, StopCondition condition, boolean allowClosing) {
        int start = offset;
        int end = this.scanForward(offset, -2, condition, '\u0000');
        if (end == -1) {
            end = this.pos;
        }
        if (allowClosing || end > offset) {
            --start;
            if ((start = this.scanBackward(start, -2, condition, '\u0000')) == -1) {
                start = this.pos;
            }
            ++start;
        }
        if (start < end) {
            return new Region(start, end - start);
        }
        return null;
    }

    public final int scanForward(int offset, int bound, char ch) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound, new SingleCharacterMatchCondition(ch), '\u0000');
    }

    public final int scanBackward(int offset, int bound, char ch) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        return this.scanBackward(offset, bound, new SingleCharacterMatchCondition(ch), '\u0000');
    }

    public final int scanForward(int offset, int bound, char[] chars) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound, new CharacterMatchCondition(chars), '\u0000');
    }

    public final int scanBackward(int offset, int bound, char[] chars) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        return this.scanBackward(offset, bound, new CharacterMatchCondition(chars), '\u0000');
    }

    public final int scanForward(int offset, int bound, String s) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound -= s.length(), new StringMatchCondition(new String[]{s}), '\u0000');
    }

    public final int scanForward(int offset, int bound, String[] s) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound -= s[0].length(), new StringMatchCondition(s), '\u0000');
    }

    public int findClosingPeer(int offset, CharPair pair, char escapeChar) throws BadLocationException {
        if (offset < 0) {
            throw new BadLocationException();
        }
        CharacterMatchCondition condition = new CharacterMatchCondition(pair.toArray());
        int depth = 1;
        int bound = this.checkForwardBound(offset, -2);
        --offset;
        do {
            if ((offset = this.scanForward(offset + 1, bound, condition, escapeChar)) == -1) {
                return -1;
            }
            if (this.ch == pair.opening) {
                ++depth;
                continue;
            }
            --depth;
        } while (depth != 0);
        return offset;
    }

    public int findOpeningPeer(int offset, CharPair pair, char escapeChar) throws BadLocationException {
        if (offset > this.document.getLength()) {
            throw new BadLocationException();
        }
        CharacterMatchCondition condition = new CharacterMatchCondition(pair.toArray());
        int depth = 1;
        int bound = this.checkBackwardBound(offset, -2);
        do {
            if ((offset = this.scanBackward(offset - 1, bound, condition, escapeChar)) == -1) {
                return -1;
            }
            if (this.ch == pair.closing) {
                ++depth;
                continue;
            }
            --depth;
        } while (depth != 0);
        return offset;
    }

    public int[] computePairBalance(int backwardOffset, int forwardOffset, @Nullable TextRegion region, CharPairSet brackets, int[] initial, int searchPairIndex) throws BadLocationException {
        CharPairSet.CharMatch match;
        int[] balance = new int[brackets.getPairCount()];
        class BracketBalanceCondition
        extends PartitionBasedCondition {
            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable CharPairSet.CharMatch match;
            private final /* synthetic */ CharPairSet val$brackets;

            BracketBalanceCondition(CharPairSet charPairSet) {
                this.val$brackets = charPairSet;
            }

            @Override
            protected boolean matchesChar(char c) {
                this.match = this.val$brackets.getMatch((int)c);
                return this.match != null;
            }
        }
        BracketBalanceCondition condition = new BracketBalanceCondition(brackets);
        int breakPairIndex = -1;
        int bound = this.checkBackwardBound(backwardOffset, region != null ? region.getStartOffset() : -2);
        while (--backwardOffset > bound) {
            if ((backwardOffset = this.scanBackward(backwardOffset, bound, condition, brackets.getEscapeChar())) == -1) break;
            match = (CharPairSet.CharMatch)ObjectUtils.nonNullAssert((Object)condition.match);
            if (match.isOpening()) {
                int n = match.getPairIndex();
                balance[n] = balance[n] + 1;
                if (match.getPairIndex() == searchPairIndex || balance[match.getPairIndex()] <= 0) continue;
                breakPairIndex = match.getPairIndex();
                break;
            }
            int n = match.getPairIndex();
            balance[n] = balance[n] - 1;
        }
        int i = 0;
        while (i < balance.length) {
            balance[i] = (balance[i] > 0 ? balance[i] : 0) + initial[i];
            ++i;
        }
        bound = this.checkForwardBound(forwardOffset, region != null ? region.getEndOffset() : -2);
        while (forwardOffset < bound) {
            if ((forwardOffset = this.scanForward(forwardOffset, bound, condition, brackets.getEscapeChar())) == -1) break;
            match = (CharPairSet.CharMatch)ObjectUtils.nonNullAssert((Object)condition.match);
            if (match.isOpening()) {
                int n = match.getPairIndex();
                balance[n] = balance[n] + 1;
            } else {
                int n = match.getPairIndex();
                balance[n] = balance[n] - 1;
            }
            if (breakPairIndex >= 0 && balance[breakPairIndex] == 0) break;
            ++forwardOffset;
        }
        return balance;
    }

    public int computePairBalance(int backwardOffset, int forwardOffset, @Nullable TextRegion region, CharPair pair, char escapeChar, int initial) throws BadLocationException {
        int balance = 0;
        CharacterMatchCondition condition = new CharacterMatchCondition(pair.toArray());
        int bound = this.checkBackwardBound(backwardOffset, region != null ? region.getStartOffset() : -2);
        while (--backwardOffset > bound) {
            if ((backwardOffset = this.scanBackward(backwardOffset, bound, condition, escapeChar)) == -1) break;
            if (this.ch == pair.opening) {
                ++balance;
                continue;
            }
            --balance;
        }
        balance = (balance > 0 ? balance : 0) + initial;
        bound = this.checkForwardBound(forwardOffset, region != null ? region.getEndOffset() : -2);
        while (forwardOffset < bound) {
            if ((forwardOffset = this.scanForward(forwardOffset, bound, condition, escapeChar)) == -1) break;
            balance = this.ch == pair.opening ? ++balance : --balance;
            if (balance == 0) break;
            ++forwardOffset;
        }
        return balance;
    }

    public final int findAnyNonBlankForward(int offset, int bound, boolean linebreakIsBlank) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound, linebreakIsBlank ? this.getAnyNonWSorLRCondition() : this.getAnyNonWSCondition(), '\u0000');
    }

    public final int findAnyNonBlankBackward(int offset, int bound, boolean linebreakIsBlank) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        return this.scanBackward(offset - 1, bound, linebreakIsBlank ? this.getAnyNonWSorLRCondition() : this.getAnyNonWSCondition(), '\u0000');
    }

    public final int findNonBlankForward(int offset, int bound, boolean linebreakIsBlank) throws BadLocationException {
        bound = this.checkForwardBound(offset, bound);
        return this.scanForward(offset, bound, linebreakIsBlank ? this.getNonWSorLRCondition() : this.getNonWSCondition(), '\u0000');
    }

    public final int findNonBlankBackward(int offset, int bound, boolean linebreakIsBlank) throws BadLocationException {
        bound = this.checkBackwardBound(offset, bound);
        return this.scanBackward(offset - 1, bound, linebreakIsBlank ? this.getNonWSorLRCondition() : this.getNonWSCondition(), '\u0000');
    }

    public @Nullable IRegion findBlankRegion(int offset, boolean linebreakIsBlank) {
        return this.findRegion(offset, linebreakIsBlank ? this.getAnyNonWSorLRCondition() : this.getAnyNonWSCondition(), false);
    }

    public boolean isBlankLine(int offset) throws BadLocationException {
        IRegion line = this.document.getLineInformationOfOffset(offset);
        if (line.getLength() > 0) {
            int nonWhitespace = this.findAnyNonBlankForward(line.getOffset(), line.getOffset() + line.getLength(), false);
            return nonWhitespace == -1;
        }
        return true;
    }

    public final @Nullable IRegion findCommonWord(int offset) {
        return this.findRegion(offset, new StopCondition(this){

            @Override
            public boolean stop() {
                return !Character.isLetterOrDigit(ch);
            }
        }, false);
    }

    public final int getFirstLineOfRegion(IRegion region) throws BadLocationException {
        return this.document.getLineOfOffset(region.getOffset());
    }

    public final int getLastLineOfRegion(IRegion region) throws BadLocationException {
        if (region.getLength() == 0) {
            return this.document.getLineOfOffset(region.getOffset());
        }
        return this.document.getLineOfOffset(region.getOffset() + region.getLength() - 1);
    }

    public final int count(int start, int stop, char c) {
        int count = 0;
        SingleCharacterMatchCondition condition = new SingleCharacterMatchCondition(c);
        while (start < stop && (start = this.scanForward(start, stop, condition, '\u0000')) != -1) {
            ++count;
            ++start;
        }
        return count;
    }

    protected final @Nullable String getContentType() {
        try {
            return TextUtilities.getContentType((IDocument)this.document, (String)this.partitioning, (int)this.pos, (boolean)false);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    protected final ITypedRegion getPartition() throws BadLocationException {
        return TextUtilities.getPartition((IDocument)this.document, (String)this.partitioning, (int)this.pos, (boolean)false);
    }

    public final ITypedRegion getPartition(int offset) {
        try {
            return TextUtilities.getPartition((IDocument)this.document, (String)this.partitioning, (int)offset, (boolean)false);
        }
        catch (BadLocationException e) {
            return new TypedRegion(this.pos, 0, "__no_partition_at_all");
        }
    }

    protected class CharacterMatchCondition
    extends PartitionBasedCondition {
        protected final char[] chars;

        public CharacterMatchCondition(char[] chars) {
            assert (chars != null);
            this.chars = chars;
        }

        @Override
        protected boolean matchesChar(char c) {
            int i = 0;
            while (i < this.chars.length) {
                if (c == this.chars[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    protected abstract class PartitionBasedCondition
    extends StopCondition {
        private @Nullable ITypedRegion currentPartition;
        private boolean currentPartitionMatched;
        private int currentPartitionStart;
        private int currentPartitionEnd;

        public PartitionBasedCondition() {
            this.currentPartitionMatched = false;
        }

        private boolean updatePartition() throws BadLocationException {
            ITypedRegion partition;
            this.currentPartition = partition = HeuristicTokenScanner.this.getPartition();
            this.currentPartitionStart = partition.getOffset();
            this.currentPartitionEnd = this.currentPartitionStart + partition.getLength();
            this.currentPartitionMatched = HeuristicTokenScanner.this.partitionConstraint.matches(partition.getType());
            return this.currentPartitionMatched;
        }

        @Override
        public boolean stop() throws BadLocationException {
            int offset = HeuristicTokenScanner.this.pos;
            return (this.currentPartitionMatched && offset >= this.currentPartitionStart && offset < this.currentPartitionEnd || this.updatePartition()) && this.matchesChar(HeuristicTokenScanner.this.ch);
        }

        protected abstract boolean matchesChar(char var1);

        @Override
        public int nextPositionForward() {
            int offset = HeuristicTokenScanner.this.pos;
            if (this.currentPartitionMatched) {
                return offset + 1;
            }
            if (offset < this.currentPartitionEnd) {
                return this.currentPartitionEnd;
            }
            return offset + 1;
        }

        @Override
        public int nextPositionBackward() {
            if (this.currentPartitionMatched) {
                return HeuristicTokenScanner.this.pos - 1;
            }
            if (HeuristicTokenScanner.this.pos >= this.currentPartitionStart) {
                return this.currentPartitionStart - 1;
            }
            return HeuristicTokenScanner.this.pos - 1;
        }
    }

    protected class SingleCharacterMatchCondition
    extends PartitionBasedCondition {
        protected final int singleChar;

        public SingleCharacterMatchCondition(char ch) {
            this.singleChar = ch;
        }

        @Override
        protected boolean matchesChar(char c) {
            return c == this.singleChar;
        }
    }

    protected abstract class StopCondition {
        protected StopCondition() {
        }

        public abstract boolean stop() throws BadLocationException;

        public int nextPositionForward() {
            return HeuristicTokenScanner.this.pos + 1;
        }

        public int nextPositionBackward() {
            return HeuristicTokenScanner.this.pos - 1;
        }
    }

    protected class StringMatchCondition
    extends PartitionBasedCondition {
        protected final String[] strings;

        public StringMatchCondition(String[] s) {
            this.strings = s;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean matchesChar(char c) {
            try {
                String[] stringArray = this.strings;
                int n = this.strings.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    String string = stringArray[n2];
                    if (c == string.charAt(0) && string.regionMatches(1, HeuristicTokenScanner.this.document.get(HeuristicTokenScanner.this.pos + 1, string.length() - 1), 0, string.length() - 1)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }
    }
}

