/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.dcf.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.dcf.core.source.ast.Value;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;

@NonNullByDefault
public abstract class EmbeddingValue
extends Value
implements EmbeddingAstNode {
    private final String foreignType;
    private @Nullable AstNode foreignNode;

    EmbeddingValue(int statusCode, DslAstNode parent, String foreignType) {
        super(statusCode, parent);
        this.foreignType = foreignType;
    }

    EmbeddingValue(DslAstNode parent, String foreignType) {
        super(parent);
        this.foreignType = foreignType;
    }

    public String getForeignTypeId() {
        return this.foreignType;
    }

    public int getEmbedDescr() {
        return 1;
    }

    public void setForeignNode(@Nullable AstNode node) {
        this.foreignNode = node;
        if (node != null) {
            this.doSetStatusSeverityOfChild(node.getStatusCode());
        }
    }

    public @Nullable AstNode getForeignNode() {
        return this.foreignNode;
    }

    @Override
    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        if (this.foreignNode != null) {
            this.foreignNode.accept(visitor);
        }
    }

    static class Empty
    extends EmbeddingValue {
        private static final ImList<TextRegion> FRAGMENTS = ImCollections.emptyList();

        Empty(DslAstNode parent, int endOffset, String foreignType) {
            super(parent, foreignType);
            this.doSetStartEndOffset(parent.getEndOffset(), endOffset);
            this.doSetText("");
        }

        @Override
        public ImList<TextRegion> getTextRegions() {
            return FRAGMENTS;
        }
    }

    static class Multiline
    extends EmbeddingValue {
        private final ImList<TextRegion> fragments;

        Multiline(DslAstNode parent, int endOffset, String foreignType, ImList<TextRegion> fragments, @Nullable String text) {
            super(parent, foreignType);
            this.doSetStartEndOffset(parent.getEndOffset(), endOffset);
            this.doSetText(text);
            this.fragments = fragments;
        }

        @Override
        public ImList<TextRegion> getTextRegions() {
            return this.fragments;
        }
    }

    static class Simple
    extends EmbeddingValue {
        private final ImList<TextRegion> fragments;

        Simple(DslAstNode parent, int endOffset, String foreignType, TextRegion region, @Nullable String text) {
            super(parent, foreignType);
            this.doSetStartEndOffset(parent.getEndOffset(), endOffset);
            this.doSetText(text);
            this.fragments = ImCollections.newList((Object)region);
        }

        @Override
        public ImList<TextRegion> getTextRegions() {
            return this.fragments;
        }

        public @Nullable TextRegion getTextRegion() {
            return (TextRegion)this.fragments.get(0);
        }
    }
}

