/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.dialogs;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.IEnumLabel;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.dialogs.AbstractSeriesSettingsDialog;

public class BarSeriesSettingsDialog
extends AbstractSeriesSettingsDialog<IBarSeriesSettings> {
    private AtomicReference<Text> barColorControl = new AtomicReference();
    private AtomicReference<Spinner> barPaddingControl = new AtomicReference();
    private AtomicReference<Spinner> barWidthControl = new AtomicReference();
    private AtomicReference<Button> barOverlayControl = new AtomicReference();
    private AtomicReference<ComboViewer> barWidthStyleControl = new AtomicReference();
    private AtomicReference<Button> enableStackControl = new AtomicReference();

    public BarSeriesSettingsDialog(Shell parentShell, IBarSeriesSettings settings) {
        super(parentShell, settings);
    }

    @Override
    protected void createInputSection(Composite parent) {
        super.createInputSection(parent);
        this.createBarColorSection(parent);
        this.createBarOverlaySection(parent);
        this.createBarPaddingSection(parent);
        this.createBarWidthSection(parent);
        this.createBarWidthStyleSection(parent);
        this.createEnableStackSection(parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        IBarSeriesSettings settings = (IBarSeriesSettings)this.getSettings();
        if (settings != null) {
            this.barColorControl.get().setBackground(settings.getBarColor());
            this.barOverlayControl.get().setSelection(settings.isBarOverlay());
            this.barPaddingControl.get().setSelection(settings.getBarPadding());
            this.barWidthControl.get().setSelection(settings.getBarWidth());
            this.barWidthStyleControl.get().setSelection((ISelection)new StructuredSelection((Object)settings.getBarWidthStyle()));
            this.enableStackControl.get().setSelection(settings.isEnableStack());
        }
    }

    private void createBarColorSection(Composite parent) {
        String title = "Bar Color";
        this.createSectionLabel(parent, title);
        Text text = this.createColorChoser(parent, title, this.getGridData(768, 1), color -> {
            IBarSeriesSettings settings = (IBarSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setBarColor((Color)color);
            }
        });
        this.barColorControl.set(text);
    }

    private void createBarOverlaySection(Composite parent) {
        this.createSectionLabel(parent, "");
        Button button = this.createCheckBox(parent, "Bar Overlay", "Enable or disable to display the bar overlay.", this.getGridData(768, 2), selection -> {
            IBarSeriesSettings settings = (IBarSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setBarOverlay((boolean)selection);
            }
        });
        this.barOverlayControl.set(button);
    }

    private void createBarPaddingSection(Composite parent) {
        String title = "Bar Padding";
        this.createSectionLabel(parent, title);
        Spinner spinner = this.createSpinner(parent, title, 1, 50, 1, this.getGridData(768, 2), selection -> {
            IBarSeriesSettings settings = (IBarSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setBarPadding((int)selection);
            }
        });
        this.barPaddingControl.set(spinner);
    }

    private void createBarWidthSection(Composite parent) {
        String title = "Bar Width";
        this.createSectionLabel(parent, title);
        Spinner spinner = this.createSpinner(parent, title, 1, 50, 1, this.getGridData(768, 2), selection -> {
            IBarSeriesSettings settings = (IBarSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setBarWidth((int)selection);
            }
        });
        this.barWidthControl.set(spinner);
    }

    private void createBarWidthStyleSection(Composite parent) {
        String title = "Bar Width Style";
        this.createSectionLabel(parent, title);
        ComboViewer comboViewer = this.createComboViewer(parent, title, (IEnumLabel[])IBarSeries.BarWidthStyle.values(), IBarSeries.BarWidthStyle.STRETCHED, this.getGridData(768, 2), object -> {
            IBarSeriesSettings settings = (IBarSeriesSettings)this.getSettings();
            if (settings != null && object instanceof IBarSeries.BarWidthStyle) {
                settings.setBarWidthStyle((IBarSeries.BarWidthStyle)object);
            }
        });
        this.barWidthStyleControl.set(comboViewer);
    }

    private void createEnableStackSection(Composite parent) {
        this.createSectionLabel(parent, "");
        Button button = this.createCheckBox(parent, "Enable Stack", "Enable or disable the stack modus.", this.getGridData(768, 2), selection -> {
            IBarSeriesSettings settings = (IBarSeriesSettings)this.getSettings();
            if (settings != null) {
                settings.setEnableStack((boolean)selection);
            }
        });
        this.enableStackControl.set(button);
    }
}

