/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.vectorgraphics2d.pdf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.eclipse.swtchart.vectorgraphics2d.core.SizedDocument;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.CommandSequence;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.AffineTransformCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.Command;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.DrawShapeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.DrawStringCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.FillShapeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetColorCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetFontCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetStrokeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetTransformCommand;
import org.eclipse.swtchart.vectorgraphics2d.util.PageSize;

class PDFDocument
extends SizedDocument {
    private static final float POINTS_PER_INCH = 72.0f;
    private static final float POINTS_PER_MM = 2.8346457f;
    private static final float BEZIER_CONSTANT = 0.5522848f;
    private PDDocument document = null;

    public PDFDocument(CommandSequence commands, PageSize pageSize, boolean compressed) throws IOException {
        super(pageSize, compressed);
        this.document = this.createDocument(commands, pageSize);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.document != null) {
            this.document.save(outputStream);
            this.document.close();
            this.document = null;
        }
    }

    private PDDocument createDocument(CommandSequence commands, PageSize pageSize) {
        Scale scale = this.getScale(pageSize, commands);
        PDDocument document = new PDDocument();
        PDRectangle rectangle = this.getRectangle(pageSize, scale);
        PDPage page = new PDPage(rectangle);
        document.addPage(page);
        float height = rectangle.getHeight();
        Matrix matrixScale = Matrix.getScaleInstance((float)1.0f, (float)-1.0f);
        Matrix matrixTranslate = Matrix.getTranslateInstance((float)0.0f, (float)(-height));
        Matrix matrixFlip = Matrix.concatenate((Matrix)matrixScale, (Matrix)matrixTranslate);
        AffineTransform affineTransform = null;
        boolean useAffineTransform = false;
        Color colorBackground = Color.WHITE;
        Color colorForeground = Color.BLACK;
        PDType1Font font = PDType1Font.HELVETICA;
        float fontSize = 8.0f;
        HashMap<Integer, PDExtendedGraphicsState> opacityMap = new HashMap<Integer, PDExtendedGraphicsState>();
        try {
            Throwable throwable = null;
            Object var19_21 = null;
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                for (Command command : commands) {
                    if (command instanceof AffineTransformCommand) {
                        AffineTransformCommand c = (AffineTransformCommand)command;
                        affineTransform = (AffineTransform)c.getValue();
                        continue;
                    }
                    if (command instanceof SetColorCommand) {
                        SetColorCommand c = (SetColorCommand)command;
                        colorBackground = (Color)c.getValue();
                        colorForeground = (Color)c.getValue();
                        int alpha = ((Color)c.getValue()).getAlpha();
                        PDExtendedGraphicsState graphicsState = (PDExtendedGraphicsState)opacityMap.get(alpha);
                        if (graphicsState == null) {
                            graphicsState = new PDExtendedGraphicsState();
                            graphicsState.setNonStrokingAlphaConstant(Float.valueOf(0.003921569f * (float)alpha));
                            opacityMap.putIfAbsent(alpha, graphicsState);
                        }
                        contentStream.setGraphicsStateParameters(graphicsState);
                        continue;
                    }
                    if (command instanceof SetStrokeCommand) {
                        SetStrokeCommand c = (SetStrokeCommand)command;
                        Stroke stroke = (Stroke)c.getValue();
                        if (!(stroke instanceof BasicStroke)) continue;
                        BasicStroke basicStroke = (BasicStroke)stroke;
                        contentStream.setLineCapStyle(basicStroke.getEndCap());
                        if (basicStroke.getDashArray() != null) {
                            float[] dashArray = basicStroke.getDashArray();
                            float[] dashArrayAdjusted = new float[dashArray.length];
                            int i = 0;
                            while (i < dashArray.length) {
                                dashArrayAdjusted[i] = dashArray[i];
                                ++i;
                            }
                            contentStream.setLineDashPattern(dashArrayAdjusted, basicStroke.getDashPhase());
                        }
                        contentStream.setLineJoinStyle(basicStroke.getLineJoin());
                        contentStream.setLineWidth(basicStroke.getLineWidth());
                        continue;
                    }
                    if (command instanceof SetFontCommand) {
                        SetFontCommand c = (SetFontCommand)command;
                        Font fontx = (Font)c.getValue();
                        fontSize = fontx.getSize2D();
                        continue;
                    }
                    if (command instanceof SetTransformCommand) {
                        SetTransformCommand c = (SetTransformCommand)command;
                        affineTransform = (AffineTransform)c.getValue();
                        double[] matrixFromAffineTransform = new double[6];
                        affineTransform.getMatrix(matrixFromAffineTransform);
                        if (matrixFromAffineTransform[0] != 0.0) continue;
                        useAffineTransform = true;
                        continue;
                    }
                    if (command instanceof DrawShapeCommand || command instanceof FillShapeCommand) {
                        boolean fillShape = command instanceof FillShapeCommand;
                        Object object = command.getValue();
                        if (!(object instanceof Shape)) continue;
                        Shape shape = (Shape)object;
                        if (shape instanceof Line2D || shape instanceof Path2D || shape instanceof Polygon || shape instanceof Rectangle) {
                            contentStream.setNonStrokingColor(colorBackground);
                            contentStream.setStrokingColor(colorForeground);
                            PathIterator iterator = shape.getPathIterator(null);
                            double[] coordsCur = new double[6];
                            while (!iterator.isDone()) {
                                int segmentType = iterator.currentSegment(coordsCur);
                                switch (segmentType) {
                                    case 0: {
                                        Point2D.Float pointMoveTo = matrixFlip.transformPoint((float)coordsCur[0], (float)coordsCur[1]);
                                        contentStream.moveTo(pointMoveTo.x, pointMoveTo.y);
                                        break;
                                    }
                                    case 1: {
                                        Point2D.Float pointLineTo = matrixFlip.transformPoint((float)coordsCur[0], (float)coordsCur[1]);
                                        contentStream.lineTo(pointLineTo.x, pointLineTo.y);
                                        break;
                                    }
                                    case 4: {
                                        contentStream.closePath();
                                        break;
                                    }
                                }
                                iterator.next();
                            }
                            if (fillShape) {
                                contentStream.fill();
                                continue;
                            }
                            contentStream.stroke();
                            continue;
                        }
                        if (!(object instanceof Ellipse2D)) continue;
                        Ellipse2D ellipse2D = (Ellipse2D)object;
                        contentStream.setNonStrokingColor(colorBackground);
                        contentStream.setStrokingColor(colorForeground);
                        float positionX = (float)ellipse2D.getCenterX();
                        float positionY = height - (float)ellipse2D.getCenterY();
                        float radius = (float)(ellipse2D.getWidth() / 2.0);
                        this.drawCircle(contentStream, positionX, positionY, radius);
                        continue;
                    }
                    if (!(command instanceof DrawStringCommand)) continue;
                    DrawStringCommand c = (DrawStringCommand)command;
                    String label = (String)c.getValue();
                    Point2D.Float point = new Point2D.Float((float)c.getX(), (float)c.getY());
                    point = matrixFlip.transformPoint(point.x, point.y);
                    contentStream.setFont((PDFont)font, fontSize);
                    contentStream.setNonStrokingColor(colorForeground);
                    contentStream.beginText();
                    if (useAffineTransform) {
                        double rotationDegree = this.getRotationDegree(affineTransform);
                        contentStream.setTextMatrix(Matrix.getRotateInstance((double)Math.toRadians(rotationDegree), (float)point.x, (float)point.y));
                        useAffineTransform = false;
                    } else {
                        contentStream.newLineAtOffset(point.x, point.y);
                    }
                    contentStream.showText(label);
                    contentStream.endText();
                }
                contentStream.close();
                this.scaleToTargetSize(pageSize, document, page);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return document;
    }

    private void drawCircle(PDPageContentStream contentStream, float positionX, float positionY, float radius) throws IOException {
        float constant = radius * 0.5522848f;
        contentStream.moveTo(positionX + radius, positionY);
        contentStream.curveTo(positionX + radius, positionY + constant, positionX + constant, positionY + radius, positionX, positionY + radius);
        contentStream.curveTo(positionX - constant, positionY + radius, positionX - radius, positionY + constant, positionX - radius, positionY);
        contentStream.curveTo(positionX - radius, positionY - constant, positionX - constant, positionY - radius, positionX, positionY - radius);
        contentStream.curveTo(positionX + constant, positionY - radius, positionX + radius, positionY - constant, positionX + radius, positionY);
        contentStream.fill();
        contentStream.closePath();
        contentStream.stroke();
    }

    private double getRotationDegree(AffineTransform affineTransform) {
        double scaleX = affineTransform.getScaleX();
        double shearY = affineTransform.getShearY();
        double theta = Math.atan2(shearY, scaleX);
        return Math.toDegrees(theta) - 180.0;
    }

    private void scaleToTargetSize(PageSize pageSize, PDDocument document, PDPage page) throws IOException {
        float width = (float)(pageSize.getWidth() * 2.8346457481384277);
        float height = (float)(pageSize.getHeight() * 2.8346457481384277);
        PDRectangle targetSize = new PDRectangle(width, height);
        PDRectangle originalSize = page.getMediaBox();
        float scaleX = targetSize.getWidth() / originalSize.getWidth();
        float scaleY = targetSize.getHeight() / originalSize.getHeight();
        PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.PREPEND, false);
        Matrix matrix = Matrix.getScaleInstance((float)scaleX, (float)scaleY);
        contentStream.transform(matrix);
        contentStream.close();
        page.setMediaBox(targetSize);
    }

    private PDRectangle getRectangle(PageSize pageSize, Scale scale) {
        float width = (float)(pageSize.getWidth() * scale.getX());
        float height = (float)(pageSize.getHeight() * scale.getY());
        return new PDRectangle(width, height);
    }

    private Scale getScale(PageSize pageSize, CommandSequence commands) {
        double scaleX = 1.0;
        double scaleY = 1.0;
        for (Command command : commands) {
            if (!(command instanceof AffineTransformCommand)) continue;
            AffineTransformCommand affineTransformCommand = (AffineTransformCommand)command;
            AffineTransform affineTransform = (AffineTransform)affineTransformCommand.getValue();
            scaleX = affineTransform.getScaleX();
            scaleY = affineTransform.getScaleY();
        }
        double x = scaleX != 0.0 ? 1.0 / scaleX : 1.0;
        double y = scaleY != 0.0 ? 1.0 / scaleY : 1.0;
        return new Scale(x, y);
    }

    private class Scale {
        private double x = 1.0;
        private double y = 1.0;

        public Scale(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

