/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelQueryService;
import org.eclipse.tcf.te.tcf.locator.services.AbstractPeerModelService;

public class PeerModelQueryService
extends AbstractPeerModelService
implements IPeerModelQueryService {
    public PeerModelQueryService(IPeerModel parentModel) {
        super(parentModel);
    }

    @Override
    public String[] queryLocalServices(final IPeerNode node) {
        Assert.isNotNull((Object)node);
        final AtomicReference services = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                services.set(node.getStringProperty("LocalServices"));
            }
        });
        if (services.get() != null) {
            String[] local = ((String)services.get()).split(",\\s*");
            return local;
        }
        return null;
    }

    @Override
    public String[] queryRemoteServices(final IPeerNode node) {
        Assert.isNotNull((Object)node);
        final AtomicReference services = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                services.set(node.getStringProperty("RemoteServices"));
            }
        });
        if (services.get() != null) {
            String[] remote = ((String)services.get()).split(",\\s*");
            return remote;
        }
        return null;
    }

    @Override
    public String[] queryOfflineServices(final IPeerNode node) {
        Assert.isNotNull((Object)node);
        final AtomicReference services = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                services.set((String)node.getPeer().getAttributes().get("OfflineServices"));
            }
        });
        if (services.get() != null) {
            String[] offline = ((String)services.get()).split(",\\s*");
            return offline;
        }
        return null;
    }

    @Override
    public boolean hasLocalService(IPeerNode node, String ... service) {
        String[] localServices = this.queryLocalServices(node);
        if (localServices == null || localServices.length == 0) {
            return false;
        }
        List<String> local = Arrays.asList(localServices);
        String[] stringArray = service;
        int n = service.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!local.contains(s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean hasRemoteService(IPeerNode node, String ... service) {
        String[] remoteServices = this.queryRemoteServices(node);
        if (remoteServices == null || remoteServices.length == 0) {
            return false;
        }
        List<String> remote = Arrays.asList(remoteServices);
        if (remote == null || remote.isEmpty()) {
            return false;
        }
        String[] stringArray = service;
        int n = service.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!remote.contains(s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean hasOfflineService(IPeerNode node, String ... service) {
        String[] services = this.queryRemoteServices(node);
        if (services == null) {
            services = this.queryOfflineServices(node);
        }
        if (services == null || services.length == 0) {
            return false;
        }
        List<String> remoteOrOfflineServices = Arrays.asList(services);
        String[] stringArray = service;
        int n = service.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!remoteOrOfflineServices.contains(s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

