/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor.sections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.core.util.persistence.PeerDataHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.net.RemoteHostAddressControl;
import org.eclipse.tcf.te.ui.controls.net.RemoteHostPortControl;
import org.eclipse.tcf.te.ui.controls.validator.NameOrIPValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.controls.wire.network.NetworkAddressControl;
import org.eclipse.tcf.te.ui.controls.wire.network.NetworkCablePanel;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TcpTransportSection
extends AbstractSection
implements IDataExchangeNode {
    private BaseEditBrowseTextControl proxyControl = null;
    private MyRemoteHostAddressControl addressControl = null;
    private MyRemoteHostPortControl portControl = null;
    private boolean isAutoPort = false;
    private String proxies = null;
    protected IPeerNode od;
    final IPropertiesContainer odc = new PropertiesContainer();
    final IPropertiesContainer wc = new PropertiesContainer();

    public TcpTransportSection(IManagedForm form, Composite parent) {
        super(form, parent, 64);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public TcpTransportSection(IManagedForm form, Composite parent, boolean showTitleBar) {
        super(form, parent, showTitleBar ? 64 : 4096, showTitleBar);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public void dispose() {
        if (this.proxyControl != null) {
            this.proxyControl.dispose();
            this.proxyControl = null;
        }
        if (this.addressControl != null) {
            this.addressControl.dispose();
            this.addressControl = null;
        }
        if (this.portControl != null) {
            this.portControl.dispose();
            this.portControl = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (MyRemoteHostAddressControl.class.equals((Object)adapter)) {
            return this.addressControl;
        }
        if (MyRemoteHostPortControl.class.equals((Object)adapter)) {
            return this.portControl;
        }
        return super.getAdapter(adapter);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.TcpTransportSection_title);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Composite client = this.createClientContainer((Composite)section, 2, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        this.proxyControl = new BaseEditBrowseTextControl(null);
        this.proxyControl.setParentControlIsInnerPanel(true);
        this.proxyControl.setEditFieldLabel(Messages.TcpTransportSection_proxies_label);
        this.proxyControl.setReadOnly(true);
        this.proxyControl.setHasHistory(false);
        this.proxyControl.setHideBrowseButton(true);
        this.proxyControl.setupPanel(client);
        SWTControlUtil.setEnabled((Control)this.proxyControl.getEditFieldControl(), (boolean)false);
        this.addressControl = new MyRemoteHostAddressControl();
        this.addressControl.setupPanel(client);
        this.addressControl.getEditFieldControl().setFocus();
        this.portControl = new MyRemoteHostPortControl();
        this.portControl.setParentControlIsInnerPanel(true);
        this.portControl.setupPanel(this.addressControl.getInnerPanelComposite());
        this.portControl.setEditFieldControlText(this.getDefaultPort());
    }

    protected String getDefaultPort() {
        return "1534";
    }

    protected final void setIsAutoPort(boolean value) {
        this.isAutoPort = value;
        if (this.portControl != null) {
            this.portControl.setEnabled(!this.isAutoPort);
        }
    }

    protected final boolean isAutoPort() {
        return this.isAutoPort;
    }

    public void setActive(boolean active) {
        if (active) {
            Object node;
            if (this.getManagedForm().getContainer() instanceof AbstractEditorPage && !((AbstractEditorPage)this.getManagedForm().getContainer()).isDirty() && (node = ((AbstractEditorPage)this.getManagedForm().getContainer()).getEditorInputNode()) instanceof IPeerNode) {
                this.setupData((IPeerNode)node);
            }
        } else {
            this.dataChanged(null);
        }
    }

    public void setupData(IPropertiesContainer data) {
        String port;
        String ip;
        Assert.isNotNull((Object)data);
        this.setIsUpdating(true);
        boolean isAutoPort = data.getBooleanProperty("autoPort");
        if (this.proxyControl != null) {
            this.proxies = data.getStringProperty("Proxies");
            IPeer[] proxyPeers = PeerDataHelper.decodePeerList((String)this.proxies);
            String proxyInfo = "";
            IPeer[] iPeerArray = proxyPeers;
            int n = proxyPeers.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                final IPeer proxy = iPeerArray[n2];
                final AtomicReference locatorNode = new AtomicReference();
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ILocatorModelLookupService lkup = (ILocatorModelLookupService)ModelManager.getLocatorModel().getService(ILocatorModelLookupService.class);
                        locatorNode.set(lkup.lkupLocatorNode(proxy));
                    }
                });
                if (proxyInfo.length() > 0) {
                    proxyInfo = String.valueOf(proxyInfo) + " / ";
                }
                String string = name = locatorNode.get() != null ? ((ILocatorNode)locatorNode.get()).getPeer().getName() : proxy.getID();
                if (name == null || name.trim().length() == 0) {
                    name = locatorNode.get() != null ? ((ILocatorNode)locatorNode.get()).getPeer().getID() : proxy.getID();
                } else if (locatorNode.get() != null) {
                    name = String.valueOf(name) + "  (" + (String)((ILocatorNode)locatorNode.get()).getPeer().getAttributes().get("Host") + ")";
                }
                proxyInfo = String.valueOf(proxyInfo) + name.trim();
                ++n2;
            }
            this.proxyControl.setEditFieldControlText(proxyInfo);
        }
        if (this.addressControl != null && (ip = data.getStringProperty("Host")) != null) {
            this.addressControl.setEditFieldControlText(ip);
        }
        if (this.portControl != null && (port = data.getStringProperty("Port")) != null) {
            this.portControl.setEditFieldControlText(port);
        }
        this.setIsAutoPort(isAutoPort);
        this.setIsUpdating(false);
        this.dataChanged(null);
        this.updateEnablement();
    }

    public void setupData(final IPeerNode node) {
        if (this.isDirty()) {
            return;
        }
        boolean updateWidgets = true;
        if (node == null && this.od == null || node != null && node.equals(this.od)) {
            updateWidgets = false;
        }
        PropertiesContainer previousOdc = new PropertiesContainer();
        previousOdc.setProperties(this.odc.getProperties());
        this.od = node;
        this.odc.clearProperties();
        this.wc.clearProperties();
        if (node == null) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                TcpTransportSection.this.odc.setProperty("TransportName", (Object)node.getPeer().getTransportName());
                TcpTransportSection.this.odc.setProperty("Host", node.getPeer().getAttributes().get("Host"));
                TcpTransportSection.this.odc.setProperty("Port", node.getPeer().getAttributes().get("Port"));
                TcpTransportSection.this.odc.setProperty("autoPort", node.getPeer().getAttributes().get("autoPort"));
                TcpTransportSection.this.odc.setProperty("Proxies", node.getPeer().getAttributes().get("Proxies"));
                TcpTransportSection.this.wc.setProperties(TcpTransportSection.this.odc.getProperties());
            }
        });
        if (!previousOdc.getProperties().equals(this.odc.getProperties())) {
            updateWidgets = true;
        }
        if (updateWidgets) {
            this.setupData(this.wc);
        } else {
            this.dataChanged(null);
        }
    }

    public void extractData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        boolean isAutoPort = this.isAutoPort();
        data.setProperty("Proxies", (Object)this.proxies);
        if (this.addressControl != null) {
            String host = this.addressControl.getEditFieldControlText();
            data.setProperty("Host", (Object)(!"".equals(host) ? host : null));
        }
        if (this.portControl != null) {
            String port = this.portControl.getEditFieldControlText();
            if (isAutoPort) {
                data.setProperty("Port", null);
            } else {
                data.setProperty("Port", (Object)(!"".equals(port) ? port : null));
            }
        }
        if (isAutoPort) {
            data.setProperty("autoPort", (Object)Boolean.TRUE.toString());
        } else {
            data.setProperty("autoPort", null);
        }
        data.setProperty("TransportName", (Object)"TCP");
    }

    public void extractData(final IPeerNode node) {
        if (node == null) {
            return;
        }
        final ArrayList<String> removed = new ArrayList<String>();
        Set currentKeySet = this.wc.getProperties().keySet();
        this.extractData(this.wc);
        if (this.odc.equals(this.wc)) {
            return;
        }
        Set newKeySet = this.wc.getProperties().keySet();
        for (String key : currentKeySet) {
            if (newKeySet.contains(key)) continue;
            removed.add(key);
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IPeer oldPeer = node.getPeer();
                HashMap<String, String> attributes = new HashMap<String, String>(oldPeer.getAttributes());
                for (String key : removed) {
                    attributes.remove(key);
                }
                for (String key : TcpTransportSection.this.wc.getProperties().keySet()) {
                    String value = TcpTransportSection.this.wc.getStringProperty(key);
                    if (value != null) {
                        attributes.put(key, value);
                        continue;
                    }
                    attributes.remove(key);
                }
                IChannel channel = Tcf.getChannelManager().getChannel(oldPeer);
                if (channel != null) {
                    channel.close();
                }
                Peer newPeer = new Peer(attributes);
                boolean changed = node.setChangeEventsEnabled(false);
                node.setProperty("PeerInstance", (Object)newPeer);
                node.setProperty("dns.name.transient", null);
                node.setProperty("dns.lastIP.transient", null);
                node.setProperty("dns.skip.transient", null);
                if (changed) {
                    node.setChangeEventsEnabled(true);
                }
            }
        });
    }

    public boolean isValid() {
        if (this.isUpdating()) {
            return true;
        }
        boolean valid = super.isValid();
        if (this.addressControl != null) {
            valid &= this.addressControl.isValid();
            if (this.addressControl.getMessageType() > this.getMessageType()) {
                this.setMessage(this.addressControl.getMessage(), this.addressControl.getMessageType());
            }
        }
        if (this.portControl != null) {
            valid &= this.portControl.isValid();
            if (this.portControl.getMessageType() > this.getMessageType()) {
                this.setMessage(this.portControl.getMessage(), this.portControl.getMessageType());
            }
        }
        return valid;
    }

    public void commit(boolean onSave) {
        boolean needsSaving = this.isDirty();
        super.commit(onSave);
        if (!onSave || !needsSaving) {
            return;
        }
        this.extractData(this.od);
    }

    public void dataChanged(TypedEvent e) {
        boolean autoPort;
        String address;
        String value;
        if (this.isUpdating()) {
            return;
        }
        boolean isDirty = false;
        String transportType = this.wc.getStringProperty("TransportName");
        isDirty = "".equals(transportType) ? (isDirty |= (value = this.odc.getStringProperty("TransportName")) != null && !"".equals(value.trim())) : (isDirty |= !this.odc.isProperty("TransportName", (Object)transportType));
        if (this.addressControl != null && (address = this.addressControl.getEditFieldControlText()) != null) {
            isDirty = "".equals(address) ? (isDirty |= this.odc.getStringProperty("Host") != null && !address.equals(this.odc.getStringProperty("Host"))) : (isDirty |= !address.equals(this.odc.getStringProperty("Host")));
        }
        if (!(autoPort = this.odc.getBooleanProperty("autoPort")) && this.portControl != null) {
            String port = this.portControl.getEditFieldControlText();
            String oldPort = this.odc.getStringProperty("Port");
            isDirty |= !port.equals(oldPort != null ? oldPort : "");
        }
        isDirty |= this.isAutoPort() ^ autoPort;
        String newProxies = this.odc.getStringProperty("Proxies");
        isDirty = this.proxies == null || this.proxies.trim().length() == 0 ? (isDirty |= newProxies != null && newProxies.trim().length() > 0) : (isDirty |= newProxies == null || newProxies.trim().length() == 0);
        this.markDirty(isDirty);
        this.updateEnablement();
    }

    public void updateAttributes(IPropertiesContainer attributes) {
        Assert.isNotNull((Object)attributes);
        attributes.setProperty("Proxies", null);
        attributes.setProperty("Host", null);
        attributes.setProperty("Port", null);
        attributes.setProperty("autoPort", null);
        this.extractData(attributes);
    }

    protected void updateEnablement() {
        boolean enabled;
        IPeerNode input = this.od;
        boolean bl = enabled = !this.isReadOnly() && (!(input instanceof IPeerNode) || input.getConnectState() == 1);
        if (this.proxyControl != null) {
            this.proxyControl.setEnabled(enabled);
            if (enabled) {
                SWTControlUtil.setEnabled((Control)this.proxyControl.getEditFieldControl(), (boolean)false);
            }
        }
        if (this.addressControl != null) {
            this.addressControl.setEnabled(enabled);
        }
        if (this.portControl != null) {
            this.portControl.setEnabled(enabled && !this.isAutoPort);
        }
    }

    public void saveWidgetValues(IDialogSettings settings) {
        super.saveWidgetValues(settings);
        if (settings != null) {
            if (this.addressControl != null) {
                this.addressControl.saveWidgetValues(settings, TcpTransportSection.class.getSimpleName());
            }
            if (this.portControl != null && !this.portControl.getEditFieldControlText().equals(this.getDefaultPort())) {
                this.portControl.saveWidgetValues(settings, TcpTransportSection.class.getSimpleName());
            }
        }
    }

    public void restoreWidgetValues(IDialogSettings settings) {
        super.restoreWidgetValues(settings);
        if (settings != null) {
            if (this.addressControl != null) {
                this.addressControl.restoreWidgetValues(settings, TcpTransportSection.class.getSimpleName());
            }
            if (this.portControl != null) {
                this.portControl.restoreWidgetValues(settings, TcpTransportSection.class.getSimpleName());
            }
        }
    }

    protected class MyNetworkAddressControl
    extends NetworkAddressControl {
        public MyNetworkAddressControl(NetworkCablePanel networkPanel) {
            super(networkPanel);
            this.setEditFieldLabel(Messages.MyNetworkAddressControl_label);
        }

        protected void configureEditFieldValidator(Validator validator) {
            if (validator instanceof NameOrIPValidator) {
                validator.setMessageText("NameOrIPValidator_Information_MissingNameOrIP", Messages.MyNetworkAddressControl_information_missingTargetNameAddress);
                validator.setMessageText("NameOrIPValidator_Error.InvalidNameOrIP", Messages.MyNetworkAddressControl_error_invalidTargetNameAddress);
                validator.setMessageText("NameOrIPValidator_Error_InvalidName", Messages.MyNetworkAddressControl_error_invalidTargetNameAddress);
                validator.setMessageText("NameOrIPValidator_Error_InvalidIP", Messages.MyNetworkAddressControl_error_invalidTargetIpAddress);
                validator.setMessageText("NameOrIPValidator_Information_CheckName", this.getUserInformationTextCheckNameAddress());
            }
        }

        protected String getUserInformationTextCheckNameAddress() {
            return Messages.MyNetworkAddressControl_information_checkNameAddressUserInformation;
        }

        public IValidatingContainer getValidatingContainer() {
            Object container = TcpTransportSection.this.getManagedForm().getContainer();
            return container instanceof IValidatingContainer ? (IValidatingContainer)container : null;
        }

        public void modifyText(ModifyEvent e) {
            super.modifyText(e);
            TcpTransportSection.this.dataChanged((TypedEvent)e);
        }
    }

    protected class MyRemoteHostAddressControl
    extends RemoteHostAddressControl {
        public MyRemoteHostAddressControl() {
            super(null);
            this.setEditFieldLabel(Messages.MyRemoteHostAddressControl_label);
        }

        public IValidatingContainer getValidatingContainer() {
            Object container = TcpTransportSection.this.getManagedForm().getContainer();
            return container instanceof IValidatingContainer ? (IValidatingContainer)container : null;
        }

        public void modifyText(ModifyEvent e) {
            super.modifyText(e);
            TcpTransportSection.this.dataChanged((TypedEvent)e);
        }

        protected void onButtonControlSelected() {
            super.onButtonControlSelected();
            this.getValidatingContainer().setMessage(this.getMessage(), this.getMessageType());
        }
    }

    public class MyRemoteHostPortControl
    extends RemoteHostPortControl {
        public MyRemoteHostPortControl() {
            super(null);
        }

        public IValidatingContainer getValidatingContainer() {
            Object container = TcpTransportSection.this.getManagedForm().getContainer();
            return container instanceof IValidatingContainer ? (IValidatingContainer)container : null;
        }

        public void modifyText(ModifyEvent e) {
            super.modifyText(e);
            TcpTransportSection.this.dataChanged((TypedEvent)e);
        }
    }
}

