/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.sections;

import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.persistence.PersistenceManager;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractContextSelectorSection
extends org.eclipse.tcf.te.ui.views.sections.AbstractContextSelectorSection {
    private IPropertiesContainer odc = null;
    private boolean disposed = false;
    final IPeerModelListener modelListener = new IPeerModelListener(){

        public void modelDisposed(IPeerModel model) {
            AbstractContextSelectorSection.this.refreshSelectorControl();
        }

        public void modelChanged(IPeerModel model, IPeerNode peerNode, boolean added) {
            AbstractContextSelectorSection.this.refreshSelectorControl();
        }
    };
    final IEventListener eventListener = new IEventListener(){

        public void eventFired(EventObject event) {
            if (event.getSource() instanceof IPeer || event.getSource() instanceof IPeerNode) {
                AbstractContextSelectorSection.this.refreshSelectorControl();
            }
        }
    };

    public AbstractContextSelectorSection(IManagedForm form, Composite parent) {
        super(form, parent);
        this.addListener();
    }

    public AbstractContextSelectorSection(IManagedForm form, Composite parent, int style) {
        super(form, parent, style);
        this.addListener();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        super.createClient(section, toolkit);
    }

    public void dispose() {
        this.disposed = true;
        super.dispose();
        if (this.modelListener != null) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    ModelManager.getPeerModel().removeListener(AbstractContextSelectorSection.this.modelListener);
                }
            });
        }
        if (this.eventListener != null) {
            EventManager.getInstance().removeEventListener(this.eventListener);
        }
    }

    protected void addListener() {
        if (this.disposed) {
            return;
        }
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ModelManager.getPeerModel().addListener(AbstractContextSelectorSection.this.modelListener);
            }
        });
        EventManager.getInstance().addEventListener(this.eventListener, ChangeEvent.class);
    }

    protected void refreshSelectorControl() {
        if (this.disposed) {
            return;
        }
        if (this.getSelectorControl() != null) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (AbstractContextSelectorSection.this.getSelectorControl() != null) {
                                AbstractContextSelectorSection.this.getSelectorControl().refresh();
                            }
                            AbstractContextSelectorSection.this.getManagedForm().dirtyStateChanged();
                        }
                    });
                }
            });
        }
    }

    public static final String encode(IModelNode[] contexts) {
        try {
            if (contexts != null && contexts.length > 0) {
                IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate(IPeer.class, String.class);
                return (String)delegate.writeList((Object[])contexts, String.class);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static final IModelNode[] decode(String encoded) {
        try {
            if (encoded != null && encoded.trim().length() > 0) {
                IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate(IPeer.class, String.class);
                Object[] input = delegate.readList(IPeerNode.class, (Object)encoded);
                ArrayList<IModelNode> peers = new ArrayList<IModelNode>();
                Object[] objectArray = input;
                int n = input.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IModelNode) {
                        peers.add((IModelNode)object);
                    }
                    ++n2;
                }
                return (IModelNode[])peers.toArray(new IPeerNode[peers.size()]);
            }
        }
        catch (Exception exception) {}
        return new IModelNode[0];
    }

    protected abstract String getContextListDataKey();

    public void setupData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        this.odc = new PropertiesContainer();
        this.odc.setProperties(data.getProperties());
        this.setIsUpdating(true);
        String encoded = data.getStringProperty(this.getContextListDataKey());
        IModelNode[] list = AbstractContextSelectorSection.decode(encoded);
        if (this.selector != null) {
            this.selector.setCheckedModelContexts(list);
            if (this.selector.getViewer() != null) {
                this.selector.getViewer().refresh();
            }
        }
        this.setIsUpdating(false);
        this.dataChanged();
    }

    public void extractData(IPropertiesContainer data) {
        if (this.selector != null) {
            data.setProperty(this.getContextListDataKey(), (Object)AbstractContextSelectorSection.encode(this.selector.getCheckedModelContexts()));
        }
    }

    public void dataChanged() {
        if (this.odc == null || this.isUpdating()) {
            return;
        }
        boolean isDirty = false;
        if (this.selector != null) {
            String oldValue;
            String newValue = AbstractContextSelectorSection.encode(this.selector.getCheckedModelContexts());
            isDirty = "".equals(newValue) ? (isDirty |= (oldValue = this.odc.getStringProperty(this.getContextListDataKey())) != null && !"".equals(oldValue.trim())) : (isDirty |= !this.odc.isProperty(this.getContextListDataKey(), (Object)newValue));
        }
        this.markDirty(isDirty);
    }
}

