/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.nls.Messages;

public abstract class AbstractDecoratedDialogPageControl
extends BaseDialogPageControl {
    private ControlDecoration controlDecoration;

    public AbstractDecoratedDialogPageControl() {
    }

    public AbstractDecoratedDialogPageControl(IDialogPage parentPage) {
        super(parentPage);
    }

    public ControlDecoration doCreateControlDecoration(Control control) {
        Assert.isNotNull((Object)control);
        this.controlDecoration = new ControlDecoration(control, this.doGetControlDecorationPosition());
        return this.controlDecoration;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.controlDecoration = null;
    }

    protected int doGetControlDecorationPosition() {
        return 16512;
    }

    protected void configureControlDecoration(ControlDecoration decoration) {
        Assert.isNotNull((Object)decoration);
        decoration.setShowOnlyOnFocus(false);
    }

    public void updateControlDecoration(String message, int messageType) {
        if (this.getControlDecoration() != null) {
            this.getControlDecoration().setDescriptionText(message);
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            String decorationId = "DEC_INFORMATION";
            if (messageType == 3) {
                decorationId = "DEC_ERROR";
            } else if (messageType == 2) {
                decorationId = "DEC_WARNING";
            }
            FieldDecoration fieldDeco = registry.getFieldDecoration(decorationId);
            if (fieldDeco != null) {
                this.getControlDecoration().setImage(fieldDeco.getImage());
            }
            if (message == null || messageType == 0) {
                if (!this.hasContentAssist()) {
                    this.getControlDecoration().hide();
                } else {
                    fieldDeco = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
                    if (fieldDeco != null) {
                        this.getControlDecoration().setDescriptionText(Messages.AbstractDecoratedDialogPageControl_contentAssist_message);
                        this.getControlDecoration().setImage(fieldDeco.getImage());
                        this.getControlDecoration().show();
                    }
                }
            } else {
                this.getControlDecoration().show();
            }
        }
    }

    public final ControlDecoration getControlDecoration() {
        return this.controlDecoration;
    }

    protected boolean hasContentAssist() {
        return false;
    }
}

