/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.launcher;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IProcessesV1;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.core.channelmanager.OpenChannelException;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.streams.StreamsDataProvider;
import org.eclipse.tcf.te.tcf.core.streams.StreamsDataReceiver;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.launcher.IProcessContextAwareListener;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.launcher.IProcessLauncher;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.launcher.IProcessStreamsProxy;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessLauncherTerminalTabListener;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessProcessesListener;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessStateChangeEvent;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessStreamsListener;
import org.eclipse.tcf.te.tcf.processes.core.nls.Messages;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalTabListener;
import org.osgi.framework.Bundle;

public class ProcessLauncher
extends PlatformObject
implements IProcessLauncher {
    IChannel channel = null;
    boolean closeChannelOnDispose = false;
    boolean sharedChannel = false;
    IPropertiesContainer properties;
    IProcesses svcProcesses;
    IStreams svcStreams;
    IProcesses.ProcessContext processContext;
    private ICallback callback;
    private IChannelManager.IStreamsListener streamsListener = null;
    private IProcesses.ProcessesListener processesListener = null;
    private ITerminalTabListener terminalTabListener = null;
    private IProcessStreamsProxy streamsProxy = null;
    IToken activeToken = null;
    public static final String PROCESS_LAUNCH_FAILED_MESSAGE = "processLaunchFailedMessage";

    public ProcessLauncher() {
    }

    public ProcessLauncher(IProcessStreamsProxy streamsProxy) {
        this.streamsProxy = streamsProxy;
    }

    @Override
    public void dispose() {
        this.processContext = null;
        final IChannel finChannel = this.channel;
        if (this.terminalTabListener != null) {
            TerminalServiceFactory.getService().removeTerminalTabListener(this.terminalTabListener);
            this.terminalTabListener = null;
        }
        AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                if (finChannel != null && ProcessLauncher.this.closeChannelOnDispose) {
                    Tcf.getChannelManager().closeChannel(finChannel);
                }
            }
        }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
        if (this.streamsListener != null) {
            if (this.streamsListener instanceof ProcessStreamsListener) {
                ((ProcessStreamsListener)this.streamsListener).dispose((ICallback)new AsyncCallbackCollector.SimpleCollectorCallback(collector));
            }
            this.streamsListener = null;
        }
        if (this.processesListener != null) {
            this.getSvcProcesses().removeListener(this.processesListener);
            if (this.processesListener instanceof ProcessProcessesListener) {
                ((ProcessProcessesListener)this.processesListener).dispose((ICallback)new AsyncCallbackCollector.SimpleCollectorCallback(collector));
            }
            this.processesListener = null;
        }
        if (this.streamsProxy != null) {
            this.streamsProxy.dispose((ICallback)new AsyncCallbackCollector.SimpleCollectorCallback(collector));
            this.streamsProxy = null;
        }
        collector.initDone();
        this.channel = null;
    }

    @Override
    public void terminate() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ProcessLauncher.this.channel != null && ProcessLauncher.this.channel.getState() == 1 && ProcessLauncher.this.processContext != null && ProcessLauncher.this.processContext.canTerminate()) {
                    ProcessLauncher.this.processContext.terminate(new IProcesses.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            ProcessLauncher.this.onTerminateDone((this).ProcessLauncher.this.processContext, error);
                        }
                    });
                }
            }
        };
        Protocol.invokeLater((Runnable)runnable);
    }

    @Override
    public void cancel() {
        if (!(this.activeToken == null || this.callback != null && this.callback.isDone())) {
            final IToken token = this.activeToken;
            this.activeToken = null;
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    token.cancel();
                }
            });
        }
    }

    protected void onTerminateDone(IProcesses.ProcessContext context, Exception error) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)context);
        if (error != null) {
            String message = NLS.bind((String)Messages.ProcessLauncher_error_processTerminateFailed, (Object)context.getName());
            message = String.valueOf(message) + NLS.bind((String)Messages.ProcessLauncher_error_possibleCause, (Object)StatusHelper.unwrapErrorReport((String)error.getLocalizedMessage()));
            Status status = new Status(2, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)error);
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
            this.dispose();
        } else {
            final IProcesses.ProcessContext finContext = context;
            this.getSvcProcesses().getContext(context.getID(), new IProcesses.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                    if (error == null && context != null && context.getID().equals(finContext.getID())) {
                        ProcessLauncher.this.getSvcProcesses().signal(context.getID(), 15L, new IProcesses.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                ProcessLauncher.this.onSignalSIGHUPDone(finContext, error);
                            }
                        });
                    }
                }
            });
        }
    }

    protected void onSignalSIGHUPDone(IProcesses.ProcessContext context, Exception error) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)context);
        if (error != null) {
            String message = NLS.bind((String)Messages.ProcessLauncher_error_processSendSignalFailed, (Object)"SIGHUP(15)", (Object)context.getName());
            message = String.valueOf(message) + NLS.bind((String)Messages.ProcessLauncher_error_possibleCause, (Object)StatusHelper.unwrapErrorReport((String)error.getLocalizedMessage()));
            Status status = new Status(2, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)error);
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
            this.dispose();
        } else {
            final IProcesses.ProcessContext finContext = context;
            this.getSvcProcesses().getContext(context.getID(), new IProcesses.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                    if (error == null && context != null && context.getID().equals(finContext.getID())) {
                        ProcessLauncher.this.getSvcProcesses().signal(context.getID(), 9L, new IProcesses.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                if (error != null) {
                                    String message = NLS.bind((String)Messages.ProcessLauncher_error_processSendSignalFailed, (Object)"SIGKILL(15)", (Object)finContext.getName());
                                    message = String.valueOf(message) + NLS.bind((String)Messages.ProcessLauncher_error_possibleCause, (Object)StatusHelper.unwrapErrorReport((String)error.getLocalizedMessage()));
                                    Status status = new Status(2, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)error);
                                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                                    ProcessLauncher.this.dispose();
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public void launch(final IPeer peer, IPropertiesContainer properties, ICallback callback) {
        IChannel c;
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)properties);
        this.callback = callback == null ? new Callback(){

            public void internalDone(Object caller, IStatus status) {
            }
        } : callback;
        this.properties = properties;
        if (properties.containsKey("process.channel") && (c = (IChannel)properties.getProperty("process.channel")) != null && c.getState() == 1) {
            this.channel = c;
            this.closeChannelOnDispose = false;
            this.sharedChannel = true;
        }
        final HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        flags.put("channel.forceNew", properties.containsKey("channel.forceNew") ? Boolean.valueOf(properties.getBooleanProperty("channel.forceNew")) : Boolean.TRUE);
        if (this.channel != null && this.channel.getState() == 1) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProcessLauncher.this.onChannelOpenDone(peer);
                }
            });
        } else {
            Tcf.getChannelManager().openChannel(peer, flags, new IChannelManager.DoneOpenChannel(){

                public void doneOpenChannel(Throwable error, IChannel channel) {
                    if (error == null) {
                        ProcessLauncher.this.channel = channel;
                        ProcessLauncher.this.closeChannelOnDispose = true;
                        ProcessLauncher.this.sharedChannel = (Boolean)flags.get("channel.forceNew") == false;
                        ProcessLauncher.this.onChannelOpenDone(peer);
                    } else {
                        String detail = error.getLocalizedMessage();
                        if (detail == null && error instanceof OpenChannelException) {
                            Throwable inner = ((OpenChannelException)error).getError();
                            detail = inner instanceof IErrorReport ? Command.toErrorString((Object)((IErrorReport)inner).getAttributes()) : inner.getLocalizedMessage();
                        }
                        if (detail == null) {
                            detail = "N/A";
                        }
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessLauncher_error_channelConnectFailed, (Object)peer.getName(), (Object)detail), error);
                        ProcessLauncher.this.invokeCallback((IStatus)status, null);
                    }
                }
            });
        }
    }

    protected void onChannelOpenDone(final IPeer peer) {
        boolean forceIProcesses;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        this.channel.addChannelListener(new IChannel.IChannelListener(){

            public void onChannelOpened() {
            }

            public void onChannelClosed(Throwable error) {
                if (error != null) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessLauncher_error_channelConnectFailed, (Object)peer.getID(), (Object)error.getLocalizedMessage()), error);
                    ProcessLauncher.this.invokeCallback((IStatus)status, null);
                }
            }

            public void congestionLevel(int level) {
            }
        });
        if (this.channel.getState() != 1) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.ProcessLauncher_error_channelNotConnected, (Throwable)new IllegalStateException());
            this.invokeCallback((IStatus)status, null);
            return;
        }
        if (this.properties.getStringProperty("process.path") == null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.ProcessLauncher_error_missingProcessPath, (Throwable)new IllegalArgumentException("process.path"));
            this.invokeCallback((IStatus)status, null);
            return;
        }
        String property = System.getProperty("processLauncher.force.IProcesses");
        boolean bl = forceIProcesses = property != null ? Boolean.parseBoolean(property) : false;
        if (!forceIProcesses) {
            this.svcProcesses = (IProcesses)this.channel.getRemoteService(IProcessesV1.class);
        }
        if (this.svcProcesses == null) {
            this.svcProcesses = (IProcesses)this.channel.getRemoteService(IProcesses.class);
        }
        if (this.svcProcesses == null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessLauncher_error_missingRequiredService, (Object)IProcesses.class.getName()), null);
            this.invokeCallback((IStatus)status, null);
            return;
        }
        this.svcStreams = (IStreams)this.channel.getRemoteService(IStreams.class);
        if (this.svcStreams == null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessLauncher_error_missingRequiredService, (Object)IStreams.class.getName()), null);
            this.invokeCallback((IStatus)status, null);
            return;
        }
        this.executeLaunch();
    }

    protected void executeLaunch() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        final IPropertiesContainer properties = this.getProperties();
        if (properties == null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessLauncher_error_illegalNullArgument, (Object)"properties"), (Throwable)new IllegalArgumentException());
            this.invokeCallback((IStatus)status, null);
            return;
        }
        if (this.streamsProxy != null || properties.getBooleanProperty("process.associateConsole") || properties.getStringProperty("process.redirectToFile") != null) {
            this.streamsListener = this.createStreamsListener();
            if (this.streamsListener != null) {
                Tcf.getChannelManager().subscribeStream(this.channel, this.getSvcProcesses() instanceof IProcessesV1 ? "ProcessesV1" : "Processes", this.streamsListener, new IChannelManager.DoneSubscribeStream(){

                    public void doneSubscribeStream(Throwable error) {
                        if (error != null) {
                            String message = NLS.bind((String)ProcessLauncher.this.getProcessLaunchFailedMessageTemplate(), (Object)properties.getStringProperty("process.path"), (Object)ProcessLauncher.this.makeString((String[])properties.getProperty("process.args")));
                            message = String.valueOf(message) + NLS.bind((String)Messages.ProcessLauncher_error_possibleCause, (Object)Messages.ProcessLauncher_cause_subscribeFailed);
                            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), message, error);
                            ProcessLauncher.this.invokeCallback((IStatus)status, null);
                        } else {
                            ProcessLauncher.this.onSubscribeStreamsDone();
                        }
                    }
                });
            } else {
                this.onAttachStreamsDone();
            }
        } else {
            this.onAttachStreamsDone();
        }
    }

    protected void onSubscribeStreamsDone() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPropertiesContainer properties = this.getProperties();
        if (properties == null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessLauncher_error_illegalNullArgument, (Object)"properties"), (Throwable)new IllegalArgumentException());
            this.invokeCallback((IStatus)status, null);
            return;
        }
        if (this.streamsProxy != null) {
            this.streamsProxy.connectInputStreamMonitor(this.connectRemoteOutputStream(this.getStreamsListener(), new String[]{"StdInID"}));
            this.streamsProxy.connectOutputStreamMonitor(this.connectRemoteInputStream(this.getStreamsListener(), new String[]{"StdOutID"}, null));
            this.streamsProxy.connectErrorStreamMonitor(this.connectRemoteInputStream(this.getStreamsListener(), new String[]{"StdErrID"}, null));
            this.onAttachStreamsDone();
        } else if (properties.getBooleanProperty("process.associateConsole")) {
            ITerminalService terminal = TerminalServiceFactory.getService();
            if (terminal != null) {
                Object value;
                this.terminalTabListener = new ProcessLauncherTerminalTabListener(this);
                terminal.addTerminalTabListener(this.terminalTabListener);
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("delegateId", "org.eclipse.tm.terminal.connector.streams.launcher.streams");
                props.put("id", "org.eclipse.tm.terminal.view.ui.TerminalsView");
                String terminalTitle = properties.getStringProperty("title");
                if (terminalTitle == null) {
                    terminalTitle = this.getTerminalTitle();
                }
                if (terminalTitle != null) {
                    props.put("title", terminalTitle);
                }
                StreamsDataReceiver.Listener[] listeners = (value = properties.getProperty("process.listener.output")) instanceof StreamsDataReceiver.Listener[] ? (StreamsDataReceiver.Listener[])value : null;
                props.put("streams.stdin", this.connectRemoteOutputStream(this.getStreamsListener(), new String[]{"StdInID"}));
                props.put("streams.stdout", this.connectRemoteInputStream(this.getStreamsListener(), new String[]{"StdOutID"}, listeners));
                props.put("streams.stderr", this.connectRemoteInputStream(this.getStreamsListener(), new String[]{"StdErrID"}, null));
                props.put("localEcho", properties.getBooleanProperty("localEcho"));
                props.put("lineSeparator", properties.getStringProperty("lineSeparator"));
                props.put("terminal.forceNew", properties.getBooleanProperty("terminal.forceNew"));
                boolean noReconnect = true;
                if (properties.containsKey("data.noReconnect")) {
                    noReconnect = properties.getBooleanProperty("data.noReconnect");
                }
                props.put("data.noReconnect", noReconnect);
                props.put("data", this);
                props.put("TabFolderManager_state_connected", Messages.ProcessLauncher_state_connected);
                props.put("TabFolderManager_state_connecting", Messages.ProcessLauncher_state_connecting);
                props.put("TabFolderManager_state_closed", Messages.ProcessLauncher_state_closed);
                terminal.openConsole(props, new ITerminalService.Done(){

                    public void done(IStatus status) {
                        if (status.getSeverity() == 4) {
                            ProcessLauncher.this.invokeCallback(status, null);
                            return;
                        }
                        Protocol.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ProcessLauncher.this.onAttachStreamsDone();
                            }
                        });
                    }
                });
            } else {
                this.onAttachStreamsDone();
            }
        } else if (properties.getStringProperty("process.redirectToFile") != null) {
            String filename = properties.getStringProperty("process.redirectToFile");
            try {
                StreamsDataReceiver receiver = new StreamsDataReceiver((Writer)new BufferedWriter(new FileWriter(filename)), new String[]{"StdOutID", "StdErrID"});
                if (this.getStreamsListener() instanceof ProcessStreamsListener) {
                    ((ProcessStreamsListener)this.getStreamsListener()).registerDataReceiver(receiver);
                }
                this.onAttachStreamsDone();
            }
            catch (IOException e) {
                String message = NLS.bind((String)this.getProcessLaunchFailedMessageTemplate(), (Object)properties.getStringProperty("process.path"), (Object)this.makeString((String[])properties.getProperty("process.args")));
                message = String.valueOf(message) + NLS.bind((String)Messages.ProcessLauncher_error_possibleCause, (Object)(e.getLocalizedMessage() != null ? StatusHelper.unwrapErrorReport((String)e.getLocalizedMessage()) : Messages.ProcessLauncher_cause_ioexception));
                Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)e);
                this.invokeCallback((IStatus)status, null);
                return;
            }
        }
    }

    protected String getProcessLaunchFailedMessageTemplate() {
        if (this.properties != null && this.properties.containsKey(PROCESS_LAUNCH_FAILED_MESSAGE)) {
            return this.properties.getStringProperty(PROCESS_LAUNCH_FAILED_MESSAGE);
        }
        return Messages.ProcessLauncher_error_processLaunchFailed;
    }

    protected String getTerminalTitle() {
        if (this.properties == null) {
            return null;
        }
        StringBuilder title = new StringBuilder();
        Path processPath = new Path(this.properties.getStringProperty("process.path"));
        Path monitoredProcessPath = null;
        if (this.properties.getStringProperty("process.monitored.path") != null) {
            monitoredProcessPath = new Path(this.properties.getStringProperty("process.monitored.path"));
        }
        if (monitoredProcessPath != null) {
            title.append(processPath.lastSegment());
            title.append(": ");
            processPath = monitoredProcessPath;
        }
        if (processPath.segmentCount() > 3) {
            title.append(".../");
            title.append(processPath.lastSegment());
        } else {
            title.append(processPath.toString());
        }
        final AtomicReference<String> peerName = new AtomicReference<String>(this.getProperties().getStringProperty("connection.name"));
        if (peerName.get() == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (ProcessLauncher.this.channel != null) {
                        peerName.set(ProcessLauncher.this.channel.getRemotePeer().getName());
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        if (peerName.get() != null) {
            title.append(" [").append(peerName.get()).append("]");
        }
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        String date = format.format(new Date(System.currentTimeMillis()));
        title.append(" (").append(date).append(")");
        return title.toString();
    }

    protected InputStream connectRemoteInputStream(IStreams.StreamsListener streamsListener, String[] streamIds, StreamsDataReceiver.Listener[] listeners) {
        Assert.isNotNull((Object)streamsListener);
        Assert.isNotNull((Object)streamIds);
        PipedInputStream stream = null;
        PipedOutputStream remoteStreamDataReceiverStream = new PipedOutputStream();
        try {
            stream = new PipedInputStream(remoteStreamDataReceiverStream);
        }
        catch (IOException iOException) {}
        if (stream != null) {
            StreamsDataReceiver receiver = new StreamsDataReceiver((Writer)new OutputStreamWriter(remoteStreamDataReceiverStream), streamIds);
            if (listeners != null && listeners.length > 0) {
                StreamsDataReceiver.Listener[] listenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    StreamsDataReceiver.Listener listener = listenerArray[n2];
                    receiver.addListener(listener);
                    ++n2;
                }
            }
            if (this.getStreamsListener() instanceof ProcessStreamsListener) {
                ((ProcessStreamsListener)this.getStreamsListener()).registerDataReceiver(receiver);
            }
        }
        return stream;
    }

    protected OutputStream connectRemoteOutputStream(IStreams.StreamsListener streamsListener, String[] streamIds) {
        Assert.isNotNull((Object)streamsListener);
        Assert.isNotNull((Object)streamIds);
        PipedInputStream inStream = null;
        PipedOutputStream stream = new PipedOutputStream();
        try {
            inStream = new PipedInputStream(stream);
        }
        catch (IOException iOException) {
            stream = null;
        }
        if (stream != null && inStream != null) {
            StreamsDataProvider provider = new StreamsDataProvider((Reader)new InputStreamReader(inStream), streamIds);
            if (this.getStreamsListener() instanceof ProcessStreamsListener) {
                ((ProcessStreamsListener)this.getStreamsListener()).setDataProvider(provider);
            }
        }
        return stream;
    }

    protected void onAttachStreamsDone() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        this.getSvcProcesses().getEnvironment(new IProcesses.DoneGetEnvironment(){

            public void doneGetEnvironment(IToken token, Exception error, Map<String, String> environment) {
                if (error != null) {
                    String message = Messages.ProcessLauncher_error_getEnvironmentFailed;
                    message = String.valueOf(message) + NLS.bind((String)Messages.ProcessLauncher_error_possibleCause, (Object)(error.getLocalizedMessage() != null ? StatusHelper.unwrapErrorReport((String)error.getLocalizedMessage()) : Messages.ProcessLauncher_cause_startFailed));
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)error);
                    ProcessLauncher.this.invokeCallback((IStatus)status, null);
                } else {
                    ProcessLauncher.this.onGetEnvironmentDone(environment);
                }
            }
        });
    }

    protected void onGetEnvironmentDone(Map<String, String> environment) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        final IPropertiesContainer properties = this.getProperties();
        if (properties == null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessLauncher_error_illegalNullArgument, (Object)"properties"), (Throwable)new IllegalArgumentException());
            this.invokeCallback((IStatus)status, null);
            return;
        }
        this.processesListener = this.createProcessesListener();
        if (this.processesListener != null) {
            this.getSvcProcesses().addListener(this.processesListener);
        }
        String processPath = properties.getStringProperty("process.path");
        Boolean processArgsAsIs = (Boolean)properties.getProperty("use.process.args.as.is");
        String[] processArgs = (String[])properties.getProperty("process.args");
        if (processArgs == null || processArgs.length <= 0 || !processPath.equals(processArgs[0])) {
            ArrayList<String> args;
            ArrayList<String> arrayList = args = processArgs != null ? new ArrayList<String>(Arrays.asList(processArgs)) : new ArrayList();
            if (processArgsAsIs == null || !processArgsAsIs.booleanValue()) {
                args.add(0, processPath);
            }
            processArgs = args.toArray(new String[args.size()]);
        }
        Boolean processCWDAsIs = (Boolean)properties.getProperty("use.process.cwd.as.is");
        String processCWD = properties.getStringProperty("process.cwd");
        if (processCWD == null || "".equals(processCWD.trim())) {
            processCWD = processCWDAsIs == null || processCWDAsIs == false ? new Path(processPath).removeLastSegments(1).toString() : "";
        }
        HashMap<String, String> processEnv = new HashMap<String, String>(environment);
        Map processEnvDiff = (Map)properties.getProperty("process.env");
        this.mergeEnvironment(processEnv, processEnvDiff);
        boolean processConsole = properties.getBooleanProperty("process.associateConsole");
        if (processConsole) {
            processEnv.put("TERM", "xterm");
        }
        boolean attach = properties.getBooleanProperty("process.attach");
        if (this.getSvcProcesses() instanceof IProcessesV1) {
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("Attach", Boolean.FALSE);
            params.put("AttachChildren", Boolean.FALSE);
            params.put("StopAtEntry", Boolean.FALSE);
            params.put("StopAtMain", Boolean.FALSE);
            params.put("UseTerminal", Boolean.FALSE);
            if (properties.getProperty("processesV1.params") != null) {
                Map addParams = (Map)properties.getProperty("processesV1.params");
                for (Map.Entry entry : addParams.entrySet()) {
                    params.put((String)entry.getKey(), (Boolean)entry.getValue());
                }
            } else {
                params.put("Attach", attach);
                params.put("AttachChildren", properties.getBooleanProperty("AttachChildren"));
                params.put("StopAtEntry", properties.getBooleanProperty("StopAtEntry"));
                params.put("StopAtMain", properties.getBooleanProperty("StopAtMain"));
                params.put("UseTerminal", processConsole);
            }
            this.activeToken = ((IProcessesV1)this.getSvcProcesses()).start(processCWD, processPath, processArgs, processEnv, params, new IProcesses.DoneStart(){

                public void doneStart(IToken token, Exception error, IProcesses.ProcessContext process) {
                    ProcessLauncher.this.activeToken = null;
                    if (error != null) {
                        String message = NLS.bind((String)ProcessLauncher.this.getProcessLaunchFailedMessageTemplate(), (Object)properties.getStringProperty("process.path"), (Object)ProcessLauncher.this.makeString((String[])properties.getProperty("process.args")));
                        message = String.valueOf(message) + NLS.bind((String)Messages.ProcessLauncher_error_possibleCause, (Object)(error.getLocalizedMessage() != null ? StatusHelper.unwrapErrorReport((String)error.getLocalizedMessage()) : Messages.ProcessLauncher_cause_startFailed));
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)error);
                        ProcessLauncher.this.invokeCallback((IStatus)status, null);
                    } else {
                        ProcessLauncher.this.onProcessLaunchDone(process);
                    }
                }
            });
        } else {
            this.activeToken = this.getSvcProcesses().start(processCWD, processPath, processArgs, processEnv, attach, new IProcesses.DoneStart(){

                public void doneStart(IToken token, Exception error, IProcesses.ProcessContext process) {
                    ProcessLauncher.this.activeToken = null;
                    if (error != null) {
                        String message = NLS.bind((String)ProcessLauncher.this.getProcessLaunchFailedMessageTemplate(), (Object)properties.getStringProperty("process.path"), (Object)ProcessLauncher.this.makeString((String[])properties.getProperty("process.args")));
                        message = String.valueOf(message) + NLS.bind((String)Messages.ProcessLauncher_error_possibleCause, (Object)(error.getLocalizedMessage() != null ? StatusHelper.unwrapErrorReport((String)error.getLocalizedMessage()) : Messages.ProcessLauncher_cause_startFailed));
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)error);
                        ProcessLauncher.this.invokeCallback((IStatus)status, null);
                    } else {
                        ProcessLauncher.this.onProcessLaunchDone(process);
                    }
                }
            });
        }
    }

    protected void mergeEnvironment(Map<String, String> processEnv, Map<String, String> processEnvDiff) {
        if (processEnv != null && processEnvDiff != null && !processEnvDiff.isEmpty()) {
            processEnv.putAll(processEnvDiff);
        }
    }

    protected void onProcessLaunchDone(IProcesses.ProcessContext process) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (process != null) {
            ProcessStateChangeEvent event;
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launcher/processLauncher")) {
                CoreBundleActivator.getTraceHandler().trace("Process context created: id='" + process.getID() + "', name='" + process.getName() + "'", 0, "trace/launcher/processLauncher", 1, this.getClass());
            }
            this.processContext = process;
            if (this.getStreamsListener() instanceof IProcessContextAwareListener) {
                ((IProcessContextAwareListener)this.getStreamsListener()).setProcessContext(process);
            }
            if (this.getProcessesListener() instanceof IProcessContextAwareListener) {
                ((IProcessContextAwareListener)this.getProcessesListener()).setProcessContext(process);
            }
            if ((event = this.createRemoteProcessStateChangeEvent(process)) != null) {
                EventManager.getInstance().fireEvent((EventObject)((Object)event));
            }
        }
        this.invokeCallback(Status.OK_STATUS, process);
    }

    protected ProcessStateChangeEvent createRemoteProcessStateChangeEvent(IProcesses.ProcessContext context) {
        Assert.isNotNull((Object)context);
        return new ProcessStateChangeEvent(context, "created", Boolean.FALSE, Boolean.TRUE, -1);
    }

    protected void invokeCallback(IStatus status, Object result) {
        ICallback callback;
        if (status.getSeverity() == 4) {
            this.dispose();
        }
        if ((callback = this.getCallback()) != null) {
            callback.setResult(result);
            callback.done((Object)this, status);
        }
    }

    public final IChannel getChannel() {
        return this.channel;
    }

    public final boolean isSharedChannel() {
        return this.sharedChannel;
    }

    public final IPropertiesContainer getProperties() {
        return this.properties;
    }

    public final IProcesses getSvcProcesses() {
        return this.svcProcesses;
    }

    public final IStreams getSvcStreams() {
        return this.svcStreams;
    }

    protected final ICallback getCallback() {
        return this.callback;
    }

    protected IChannelManager.IStreamsListener createStreamsListener() {
        return new ProcessStreamsListener(this);
    }

    protected final IStreams.StreamsListener getStreamsListener() {
        return this.streamsListener;
    }

    protected IProcesses.ProcessesListener createProcessesListener() {
        return new ProcessProcessesListener(this);
    }

    protected final IProcesses.ProcessesListener getProcessesListener() {
        return this.processesListener;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IProcesses.ProcessesListener.class)) {
            return this.processesListener;
        }
        if (adapter.isAssignableFrom(IStreams.StreamsListener.class)) {
            return this.streamsListener;
        }
        if (adapter.isAssignableFrom(IStreams.class)) {
            return this.svcStreams;
        }
        if (adapter.isAssignableFrom(IProcesses.class)) {
            return this.svcProcesses;
        }
        if (adapter.isAssignableFrom(IChannel.class)) {
            return this.channel;
        }
        if (adapter.isAssignableFrom(IPropertiesContainer.class)) {
            return this.properties;
        }
        if (adapter.isAssignableFrom(IProcesses.ProcessContext.class)) {
            return this.processContext;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    String makeString(String[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(element);
            ++n2;
        }
        return result.toString();
    }
}

