/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpMove
extends AbstractOperation {
    IConfirmCallback fConfirmCallback;
    LinkedList<WorkItem> fWork = new LinkedList();
    private long fStartTime;

    public OpMove(List<? extends IFSTreeNode> nodes, FSTreeNode dest, IConfirmCallback confirmCallback) {
        this.fConfirmCallback = confirmCallback;
        for (FSTreeNode node : this.dropNestedNodes(nodes)) {
            this.fWork.add(new WorkItem(node, dest));
        }
    }

    @Override
    public String getName() {
        return Messages.OpMove_MovingFile;
    }

    @Override
    public IStatus doRun(IProgressMonitor monitor) {
        if (this.fWork.isEmpty()) {
            return Status.OK_STATUS;
        }
        this.fStartTime = System.currentTimeMillis();
        monitor.beginTask(this.getName(), -1);
        ArrayList<FSTreeNode> notify = new ArrayList<FSTreeNode>();
        notify.add(this.fWork.peek().fDestination);
        for (WorkItem item : this.fWork) {
            notify.add(item.fSource.getParent());
        }
        IStatus status = Status.OK_STATUS;
        while (!this.fWork.isEmpty()) {
            WorkItem item = this.fWork.remove();
            status = this.runWorkItem(item, monitor);
            if (!status.isOK()) break;
        }
        for (FSTreeNode node : this.dropNestedNodes(notify)) {
            node.notifyChange();
        }
        return status;
    }

    protected IStatus runWorkItem(WorkItem item, IProgressMonitor monitor) {
        if (item.fContentLeftOK) {
            return Status.OK_STATUS;
        }
        if (item.fContentCleared) {
            return this.deleteEmptyFolder(item.fSource, monitor);
        }
        return this.move(item, monitor);
    }

    private IStatus move(WorkItem item, IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)Messages.OpMove_Moving, (Object)item.fSource.getLocation()));
        final FSTreeNode source = item.fSource;
        final FSTreeNode destination = item.fDestination;
        IStatus status = this.refresh(destination, this.fStartTime, monitor);
        if (!status.isOK()) {
            return status;
        }
        status = this.refresh(source, this.fStartTime, monitor);
        if (!status.isOK()) {
            return status;
        }
        final FSTreeNode existing = destination.findChild(source.getName());
        if (existing != null) {
            if (source == existing) {
                return Status.OK_STATUS;
            }
            if (source.isDirectory()) {
                if (!existing.isDirectory()) {
                    return StatusHelper.createStatus(MessageFormat.format(Messages.OpCopy_error_noDirectory, existing.getLocation()), null);
                }
                int replace = this.confirmCallback(existing, this.fConfirmCallback);
                if (replace == 2) {
                    item.setContentLeftOK();
                    return Status.OK_STATUS;
                }
                if (replace != 0) {
                    return Status.CANCEL_STATUS;
                }
                item.fContentCleared = true;
                this.fWork.addFirst(item);
                FSTreeNode[] fSTreeNodeArray = source.getChildren();
                int n = fSTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FSTreeNode child = fSTreeNodeArray[n2];
                    this.fWork.addFirst(new WorkItem(item, child, existing));
                    ++n2;
                }
                return Status.OK_STATUS;
            }
            if (source.isFile()) {
                if (!existing.isFile()) {
                    return StatusHelper.createStatus(MessageFormat.format(Messages.OpCopy_error_noFile, existing.getLocation()), null);
                }
                int replace = this.confirmCallback(existing, this.fConfirmCallback);
                if (replace == 2) {
                    item.setContentLeftOK();
                    return Status.OK_STATUS;
                }
                if (replace != 0) {
                    return Status.CANCEL_STATUS;
                }
            } else {
                return Status.OK_STATUS;
            }
        }
        CacheManager.clearCache(existing);
        CacheManager.clearCache(source);
        final TCFOperationMonitor result = new TCFOperationMonitor();
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (existing != null) {
                    OpMove.this.tcfMoveReplace(source, destination, existing, result);
                } else {
                    OpMove.this.tcfMove(source, destination, result);
                }
            }
        });
        return result.waitDone(monitor);
    }

    protected void tcfMoveReplace(final FSTreeNode source, final FSTreeNode destination, final FSTreeNode existing, final TCFOperationMonitor<?> result) {
        if (result.checkCancelled()) {
            return;
        }
        IFileSystem fileSystem = destination.getRuntimeModel().getFileSystem();
        if (fileSystem == null) {
            result.setCancelled();
            return;
        }
        fileSystem.remove(existing.getLocation(true), new IFileSystem.DoneRemove(){

            public void doneRemove(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    result.setError(MessageFormat.format(Messages.OpMove_CannotMove, source.getLocation()), (Throwable)error);
                } else if (!result.checkCancelled()) {
                    existing.getParent().removeNode(existing, false);
                    OpMove.this.tcfMove(source, destination, result);
                }
            }
        });
    }

    protected void tcfMove(final FSTreeNode source, final FSTreeNode dest, final TCFOperationMonitor<?> result) {
        IFileSystem fileSystem = dest.getRuntimeModel().getFileSystem();
        if (fileSystem == null) {
            result.setCancelled();
            return;
        }
        final String sourcePath = source.getLocation(true);
        String destPath = this.getPath(dest, source.getName());
        fileSystem.rename(sourcePath, destPath, new IFileSystem.DoneRename(){

            public void doneRename(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    result.setError(MessageFormat.format(Messages.OpMove_CannotMove, sourcePath), (Throwable)error);
                } else {
                    source.getParent().removeNode(source, false);
                    source.changeParent(dest);
                    dest.addNode(source, false);
                    result.setDone(null);
                }
            }
        });
    }

    private IStatus deleteEmptyFolder(final FSTreeNode source, IProgressMonitor monitor) {
        CacheManager.clearCache(source);
        final TCFOperationMonitor result = new TCFOperationMonitor();
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OpMove.this.tcfDeleteEmptyFolder(source, result);
            }
        });
        return result.waitDone(monitor);
    }

    protected void tcfDeleteEmptyFolder(final FSTreeNode source, final TCFOperationMonitor<?> result) {
        IFileSystem fs = source.getRuntimeModel().getFileSystem();
        if (fs == null) {
            result.setCancelled();
            return;
        }
        fs.rmdir(source.getLocation(true), new IFileSystem.DoneRemove(){

            public void doneRemove(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    result.setError(MessageFormat.format(Messages.OpDelete_error_delete, source.getLocation()), (Throwable)error);
                } else if (!result.checkCancelled()) {
                    source.getParent().removeNode(source, false);
                    result.setDone(null);
                }
            }
        });
    }

    private static class WorkItem {
        final WorkItem fParent;
        final FSTreeNode fDestination;
        final FSTreeNode fSource;
        boolean fContentCleared = false;
        boolean fContentLeftOK = false;

        WorkItem(FSTreeNode source, FSTreeNode destination) {
            this(null, source, destination);
        }

        WorkItem(WorkItem parent, FSTreeNode source, FSTreeNode destination) {
            this.fParent = parent;
            this.fSource = source;
            this.fDestination = destination;
        }

        void setContentLeftOK() {
            this.fContentLeftOK = true;
            if (this.fParent != null) {
                this.fParent.setContentLeftOK();
            }
        }
    }
}

