/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointExtension;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tcf.internal.cdt.ui.Activator;

public class TCFBreakpointScopeExtension
implements ICBreakpointExtension {
    private ICBreakpoint fBreakpoint;
    private IPreferenceStore fPreferenceStore;

    public void initialize(IPreferenceStore prefStore) {
        this.fPreferenceStore = prefStore;
    }

    public void initialize(ICBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
    }

    public void setThreadFilter(String[] threadIds) {
        String attr;
        if (threadIds == null) {
            attr = "";
        } else if (threadIds.length == 0) {
            attr = " ";
        } else {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < threadIds.length - 1) {
                buf.append(threadIds[i]).append(',');
                ++i;
            }
            buf.append(threadIds[threadIds.length - 1]);
            attr = buf.toString();
        }
        this.setRawContextIds(attr);
    }

    String getRawContextIds() {
        IMarker marker;
        if (this.fPreferenceStore != null) {
            return this.fPreferenceStore.getString("org.eclipse.tcf.debug.ContextIds");
        }
        if (this.fBreakpoint != null && (marker = this.fBreakpoint.getMarker()) != null) {
            return marker.getAttribute("org.eclipse.tcf.debug.ContextIds", "");
        }
        return "";
    }

    void setRawContextIds(final String contextIDs) {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.setValue("org.eclipse.tcf.debug.ContextIds", contextIDs);
        } else if (this.fBreakpoint != null) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IMarker m = TCFBreakpointScopeExtension.this.fBreakpoint.getMarker();
                        if (m == null || !m.exists()) {
                            return;
                        }
                        m.setAttribute("org.eclipse.tcf.debug.ContextIds", (Object)contextIDs);
                    }
                }, null);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public void setPropertiesFilter(String properties) {
        String _properties;
        String string = _properties = properties != null ? properties : "";
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.setValue("org.eclipse.tcf.debug.ContextQuery", _properties);
        } else if (this.fBreakpoint != null) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IMarker m = TCFBreakpointScopeExtension.this.fBreakpoint.getMarker();
                        if (m == null || !m.exists()) {
                            return;
                        }
                        m.setAttribute("org.eclipse.tcf.debug.ContextQuery", (Object)_properties);
                    }
                }, null);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public String getPropertiesFilter() {
        IMarker marker;
        if (this.fPreferenceStore != null) {
            return this.fPreferenceStore.getString("org.eclipse.tcf.debug.ContextQuery");
        }
        if (this.fBreakpoint != null && (marker = this.fBreakpoint.getMarker()) != null) {
            return marker.getAttribute("org.eclipse.tcf.debug.ContextQuery", "");
        }
        return "";
    }

    public String[] getThreadFilters() {
        String contextIds = this.getRawContextIds();
        if (contextIds.length() != 0) {
            return contextIds.split(",\\s*");
        }
        return null;
    }
}

