/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.swt.listener;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractCellPaintListener
implements Listener {
    private final int[] columns;

    public AbstractCellPaintListener(Widget widget, int ... columns) {
        this.columns = columns;
        this.register(widget);
    }

    protected void register(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            widget.addListener(41, (Listener)this);
            widget.addListener(42, (Listener)this);
            widget.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AbstractCellPaintListener.this.deregister(e.widget);
                }
            });
        }
    }

    protected void deregister(Widget widget) {
        if (widget != null) {
            widget.removeListener(41, (Listener)this);
            widget.removeListener(42, (Listener)this);
        }
    }

    public void handleEvent(Event event) {
        if (!this.isHandledEventType(event.type)) {
            return;
        }
        if (event.item instanceof Item && this.isValid(event)) {
            switch (event.type) {
                case 41: {
                    this.doHandleMeasureItemEvent(event);
                    break;
                }
                case 42: {
                    this.doHandlePaintItemEvent(event);
                }
            }
        }
    }

    protected boolean isHandledEventType(int type) {
        return 41 == type || 42 == type;
    }

    protected void doHandleMeasureItemEvent(Event event) {
        Assert.isNotNull((Object)event);
        Image image = this.getImageToDraw((Item)event.item, event.index);
        if (image != null) {
            event.width = Math.max(event.width, image.getImageData().width + 2);
            event.height = Math.max(event.height, image.getImageData().height + 2);
        }
    }

    protected void doHandlePaintItemEvent(Event event) {
        Assert.isNotNull((Object)event);
        Image image = this.getImageToDraw((Item)event.item, event.index);
        if (image != null) {
            Point point = this.getPaintOrigin(event, image);
            event.gc.drawImage(image, point.x, point.y);
        }
    }

    protected abstract Point getPaintOrigin(Event var1, Image var2);

    protected int getWidgetWidth(Event event) {
        if (event.widget instanceof Table) {
            TableColumn column = ((Table)event.widget).getColumn(event.index);
            return column.getWidth();
        }
        if (event.widget instanceof Tree) {
            TreeColumn column = ((Tree)event.widget).getColumn(event.index);
            return column.getWidth();
        }
        return event.width;
    }

    protected abstract Image getImageToDraw(Item var1, int var2);

    protected boolean isValid(Event event) {
        return event.item != null && this.isPaintImageInColumn(event.index) && (event.widget instanceof Table && event.item instanceof TableItem || event.widget instanceof Tree && event.item instanceof TreeItem);
    }

    protected boolean isPaintImageInColumn(int columnIndex) {
        int[] nArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            int col = nArray[n2];
            if (col == columnIndex) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

