/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.jar;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.tea.library.build.jar.BaseZipExec;
import org.eclipse.tea.library.build.jar.ZipExecPart;
import org.eclipse.tea.library.build.util.FileUtils;

public class ExternalZipExec
extends BaseZipExec {
    final File zipExe;

    public ExternalZipExec(File zipExe) {
        this.zipExe = zipExe;
    }

    @Override
    protected void doCreateZip() {
        for (ZipExecPart part : this.parts) {
            this.addZip(part);
        }
    }

    private void addZip(ZipExecPart part) {
        Object[] cmdArray;
        File directory;
        ArrayList<String> cmdTokens = new ArrayList<String>();
        cmdTokens.add(this.zipExe.getAbsolutePath());
        cmdTokens.add("-rqX");
        cmdTokens.add(this.zipFile.getAbsolutePath());
        List<String> elements = part.relativePaths;
        if (elements.isEmpty()) {
            throw new IllegalStateException("no ZIP elements set");
        }
        for (String element : elements) {
            cmdTokens.add(element);
        }
        if (part.excludeGit) {
            cmdTokens.add("-x");
            cmdTokens.add("*/.gitignore");
        }
        if (this.execCmd(directory = part.sourceDirectory, (String[])(cmdArray = cmdTokens.toArray(new String[cmdTokens.size()]))) != 0) {
            throw new IllegalStateException("command failed, dir=" + String.valueOf(directory) + ", cmd=" + Arrays.toString(cmdArray));
        }
    }

    private int execCmd(File directory, String ... cmdArray) {
        Process proc = Runtime.getRuntime().exec(cmdArray, null, directory);
        try {
            int n = proc.waitFor();
            proc.destroy();
            return n;
        }
        catch (Throwable throwable) {
            try {
                proc.destroy();
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalStateException("command failed, dir=" + String.valueOf(directory) + ", cmd=" + Arrays.toString(cmdArray), ex);
            }
        }
    }

    @Override
    public void unzip(File zip, File destDir) throws IOException {
        FileUtils.mkdirs(destDir);
        File unzip = new File(this.zipExe.getParentFile(), "unzip");
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(unzip.getAbsolutePath());
        cmds.add("-q");
        cmds.add(zip.getAbsolutePath());
        Object[] cmdArray = cmds.toArray(new String[cmds.size()]);
        if (this.execCmd(destDir, (String[])cmdArray) != 0) {
            throw new IllegalStateException("command failed, dir=" + String.valueOf(destDir) + ", cmd=" + Arrays.toString(cmdArray));
        }
    }
}

