/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.maven;

import java.io.PrintStream;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;

public class ConsoleRepositoryListener
extends AbstractRepositoryListener {
    private final PrintStream out;

    public ConsoleRepositoryListener(PrintStream out) {
        this.out = out != null ? out : System.out;
    }

    public void artifactDeployed(RepositoryEvent event) {
        this.out.println("Deployed " + String.valueOf(event.getArtifact()) + " to " + String.valueOf(event.getRepository()));
    }

    public void artifactDeploying(RepositoryEvent event) {
        this.out.println("Deploying " + String.valueOf(event.getArtifact()) + " to " + String.valueOf(event.getRepository()));
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        this.out.println("Invalid artifact descriptor for " + String.valueOf(event.getArtifact()) + ": " + event.getException().getMessage());
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.out.println("Missing artifact descriptor for " + String.valueOf(event.getArtifact()));
    }

    public void artifactInstalled(RepositoryEvent event) {
        this.out.println("Installed " + String.valueOf(event.getArtifact()) + " to " + String.valueOf(event.getFile()));
    }

    public void artifactInstalling(RepositoryEvent event) {
        this.out.println("Installing " + String.valueOf(event.getArtifact()) + " to " + String.valueOf(event.getFile()));
    }

    public void artifactResolved(RepositoryEvent event) {
        this.out.println("Resolved artifact " + String.valueOf(event.getArtifact()) + " from " + String.valueOf(event.getRepository()));
    }

    public void artifactDownloading(RepositoryEvent event) {
        this.out.println("Downloading artifact " + String.valueOf(event.getArtifact()) + " from " + String.valueOf(event.getRepository()));
    }

    public void artifactDownloaded(RepositoryEvent event) {
        this.out.println("Downloaded artifact " + String.valueOf(event.getArtifact()) + " from " + String.valueOf(event.getRepository()));
    }

    public void artifactResolving(RepositoryEvent event) {
        this.out.println("Resolving artifact " + String.valueOf(event.getArtifact()));
    }

    public void metadataDeployed(RepositoryEvent event) {
        this.out.println("Deployed " + String.valueOf(event.getMetadata()) + " to " + String.valueOf(event.getRepository()));
    }

    public void metadataDeploying(RepositoryEvent event) {
        this.out.println("Deploying " + String.valueOf(event.getMetadata()) + " to " + String.valueOf(event.getRepository()));
    }

    public void metadataInstalled(RepositoryEvent event) {
        this.out.println("Installed " + String.valueOf(event.getMetadata()) + " to " + String.valueOf(event.getFile()));
    }

    public void metadataInstalling(RepositoryEvent event) {
        this.out.println("Installing " + String.valueOf(event.getMetadata()) + " to " + String.valueOf(event.getFile()));
    }

    public void metadataInvalid(RepositoryEvent event) {
        this.out.println("Invalid metadata " + String.valueOf(event.getMetadata()));
    }

    public void metadataResolved(RepositoryEvent event) {
        this.out.println("Resolved metadata " + String.valueOf(event.getMetadata()) + " from " + String.valueOf(event.getRepository()));
    }

    public void metadataResolving(RepositoryEvent event) {
        this.out.println("Resolving metadata " + String.valueOf(event.getMetadata()) + " from " + String.valueOf(event.getRepository()));
    }
}

