/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.visualization.engines.voicebrowser.CursorListener;
import org.eclipse.actf.visualization.engines.voicebrowser.CursorMovedEvent;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IVoiceBrowserController;
import org.eclipse.actf.visualization.engines.voicebrowser.IVoiceBrowserView;
import org.eclipse.actf.visualization.engines.voicebrowser.SelectionObserver;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.CurrentCursor;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.CursorMovedEventImpl;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.DomUtil;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.DummyTTSEngine;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.JWATCore;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JWATControllerImpl
implements IVoiceBrowserController {
    private static final String BACKSLASH_N = "\n";
    private static List<IVoiceBrowserView> views = new ArrayList<IVoiceBrowserView>();
    private static List<SelectionObserver> selObservers = new ArrayList<SelectionObserver>();
    private static MessageCollection mc = null;
    private JWATCore core = new JWATCore();
    private CurrentCursor ccursor = new CurrentCursor();
    private ITTSEngine speech = new DummyTTSEngine();
    private Vector<CursorListener> cursorListeners = new Vector();

    public JWATControllerImpl() {
        this.setMode(1);
    }

    public JWATControllerImpl(int n) {
        this.setMode(n);
    }

    public void setMode(int n) {
        this.setMode(n, "");
    }

    public void setMode(int n, String string) {
        mc = this.core.setJwatMode(n, string);
        this.doTopOfPage();
        String string2 = String.valueOf(OutLoud.name) + " mode";
        this.speech.stop();
        this.speech.speak(string2, 1, -1);
    }

    public void setDocument(Document document) {
        this.setDocument(document, null, null);
    }

    public void setDocument(Document document, String string, String string2) {
        NodeList nodeList;
        Node node = document;
        JWATCore.setUriPrefix(string);
        if (node != null && (nodeList = document.getElementsByTagName("body")) != null && nodeList.getLength() > 0) {
            node = nodeList.item(0);
            DomUtil.setFormList(node);
            this.ccursor.setPc(this.core.getPacketCollection(node));
            this.ccursor.setOwnerDocumentNode(document);
            if (this.ccursor.getPc() != null && this.ccursor.getPc().size() > 0 && this.ccursor.getCurPos() == 0) {
                int n = 0;
                if (string2 != null && string2.length() > 0) {
                    n = this.core.getAnchorPosition(string2, this.ccursor.getTopNode(), this.ccursor.getPc());
                    this.ccursor.setCurPos(n);
                    this.doCurLine();
                } else {
                    n = this.core.getNodePosition(node, this.ccursor.getPc());
                    this.ccursor.setCurPos(n);
                }
            }
        }
    }

    public void setNode(Node node) {
        this.setNode(node, null, null);
    }

    public void setNode(Node node, String string, String string2) {
        JWATCore.setUriPrefix(string);
        if (node != null) {
            Document document = node.getOwnerDocument();
            if (document != null && (this.ccursor.getPc() == null || this.ccursor.getPc().size() == 0 || this.ccursor.getOwnerDocumentNode() != document)) {
                this.setDocument(document);
            }
            int n = 0;
            if (string2 != null && string2.length() > 0) {
                n = this.core.getAnchorPosition(string2, this.ccursor.getTopNode(), this.ccursor.getPc());
                this.ccursor.setCurPos(n);
                this.doCurLine();
            } else {
                n = this.core.getNodePosition(node, this.ccursor.getPc());
                this.ccursor.setCurPos(n);
            }
        }
    }

    public String doCommand(int n) {
        int n2 = this.ccursor.getCurPos();
        switch (n) {
            case 1: {
                this.doPrevLine();
                break;
            }
            case 2: {
                this.doCurLine();
                break;
            }
            case 3: {
                this.doNextLine();
                break;
            }
            case 4: {
                this.doPrevLink();
                break;
            }
            case 5: {
                this.doCurLink();
                break;
            }
            case 6: {
                this.doNextLink();
                break;
            }
            case 7: {
                int n3 = 0;
                while (n3 < 10) {
                    this.doPrevLine();
                    ++n3;
                }
                break;
            }
            case 8: {
                int n4 = 0;
                while (n4 < 10) {
                    this.doNextLine();
                    ++n4;
                }
                break;
            }
            case 9: {
                this.doCurLine();
                break;
            }
            case 10: {
                this.doTopOfPage();
                break;
            }
            case 11: {
                this.doBottomOfPage();
                break;
            }
            case 14: {
                String string = this.doLinkJump();
                if (string == null || string.length() <= 0) break;
                return string;
            }
            case 12: {
                this.doPlay();
                break;
            }
            case 13: {
                this.doStop();
            }
        }
        if (this.ccursor.getCurPos() != n2) {
            this.sendCursorEvent(new CursorMovedEventImpl(this, this.ccursor.getCurPos()));
        }
        return null;
    }

    private void doCurLine() {
        try {
            PacketCollection packetCollection;
            PacketCollection packetCollection2 = this.ccursor.getPc();
            if (packetCollection2 != null && packetCollection2.size() > 0 && (packetCollection = this.getCurLine(true)) != null && packetCollection.size() > 0) {
                this.speakWithVisual(packetCollection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doPrevLine() {
        try {
            PacketCollection packetCollection = this.ccursor.getPc();
            if (packetCollection != null && packetCollection.size() > 0) {
                PacketCollection packetCollection2 = this.getPrevLine(true);
                if (packetCollection2 != null && packetCollection2.size() > 0) {
                    this.speakWithVisual(packetCollection2);
                } else {
                    this.speech.stop();
                    if (OutLoud.topofpage != null && OutLoud.topofpage.length() > 0) {
                        this.speech.speak(OutLoud.topofpage, 1, -1);
                    } else {
                        this.speech.speak("Top of page.", 1, -1);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doNextLine() {
        try {
            PacketCollection packetCollection = this.ccursor.getPc();
            if (packetCollection != null && packetCollection.size() > 0) {
                PacketCollection packetCollection2 = this.getNextLine(true);
                if (packetCollection2 != null && packetCollection2.size() > 0) {
                    this.speakWithVisual(packetCollection2);
                } else {
                    this.speech.stop();
                    if (OutLoud.endofpage != null && OutLoud.endofpage.length() > 0) {
                        this.speech.speak(OutLoud.endofpage, 1, -1);
                    } else {
                        this.speech.speak("End of page.", 1, -1);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doCurLink() {
        try {
            PacketCollection packetCollection = this.ccursor.getPc();
            if (packetCollection != null && packetCollection.size() > 0) {
                PacketCollection packetCollection2 = this.getCurLink();
                if (packetCollection2 != null && packetCollection2.size() > 0) {
                    this.speakWithVisual(packetCollection2);
                } else {
                    this.speech.stop();
                    if (OutLoud.nocurlink != null && OutLoud.nocurlink.length() > 0) {
                        this.speech.speak(OutLoud.nocurlink, 1, -1);
                    } else {
                        this.speech.speak("No Current Link.", 1, -1);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doPrevLink() {
        try {
            PacketCollection packetCollection = this.ccursor.getPc();
            if (packetCollection != null && packetCollection.size() > 0) {
                PacketCollection packetCollection2 = this.getPrevLink();
                if (packetCollection2 != null && packetCollection2.size() > 0) {
                    this.speakWithVisual(packetCollection2);
                } else {
                    this.speech.stop();
                    if (OutLoud.noprevlink != null && OutLoud.noprevlink.length() > 0) {
                        this.speech.speak(OutLoud.noprevlink, 1, -1);
                    } else {
                        this.speech.speak("No Previous Link.", 1, -1);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doNextLink() {
        try {
            PacketCollection packetCollection = this.ccursor.getPc();
            if (packetCollection != null && packetCollection.size() > 0) {
                PacketCollection packetCollection2 = this.getNextLink();
                if (packetCollection2 != null && packetCollection2.size() > 0) {
                    this.speakWithVisual(packetCollection2);
                } else {
                    this.speech.stop();
                    if (OutLoud.nonextlink != null && OutLoud.nonextlink.length() > 0) {
                        this.speech.speak(OutLoud.nonextlink, 1, -1);
                    } else {
                        this.speech.speak("No Next Link.", 1, -1);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doTopOfPage() {
        try {
            PacketCollection packetCollection = this.ccursor.getPc();
            if (packetCollection != null && packetCollection.size() > 0) {
                PacketCollection packetCollection2 = this.getTopLine();
                if (packetCollection2 != null && packetCollection2.size() > 0) {
                    this.speakWithVisual(packetCollection2);
                } else {
                    this.speech.stop();
                    if (OutLoud.topofpage != null && OutLoud.topofpage.length() > 0) {
                        this.speech.speak(OutLoud.topofpage, 1, -1);
                    } else {
                        this.speech.speak("Top of page.", 1, -1);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doBottomOfPage() {
        try {
            PacketCollection packetCollection = this.ccursor.getPc();
            if (packetCollection != null && packetCollection.size() > 0) {
                PacketCollection packetCollection2 = this.getBottomLine();
                if (packetCollection2 != null && packetCollection2.size() > 0) {
                    this.speakWithVisual(packetCollection2);
                } else {
                    this.speech.stop();
                    if (OutLoud.endofpage != null && OutLoud.endofpage.length() > 0) {
                        this.speech.speak(OutLoud.endofpage, 1, -1);
                    } else {
                        this.speech.speak("End of page.", 1, -1);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doPlay() {
        try {
            PacketCollection packetCollection = this.ccursor.getPc();
            if (packetCollection != null && packetCollection.size() > 0) {
                String string = this.render(packetCollection, this.ccursor.getCurPos());
                this.speech.stop();
                this.speech.speak(string, 1, -1);
                this.drawText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doStop() {
        this.speech.stop();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String doLinkJump() {
        try {
            PacketCollection packetCollection = this.ccursor.getPc();
            if (packetCollection != null) {
                Node node;
                int n = this.ccursor.getCurPos();
                Node node2 = null;
                node2 = ((IPacket)packetCollection.get(n)).getNode();
                if (!packetCollection.isLinkTag(n) && node2 != null) {
                    boolean bl = false;
                    for (node = node2.getParentNode(); !(node == null || node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals("body")); node = node.getParentNode()) {
                        if (node.getNodeType() != 1 || !node.getNodeName().toLowerCase().equals("a")) continue;
                        node2 = node;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.speech.stop();
                        if (OutLoud.notonalink != null && OutLoud.notonalink.length() > 0) {
                            this.speech.speak(OutLoud.notonalink, 1, -1);
                        } else {
                            this.speech.speak("Not on a link.", 1, -1);
                        }
                        return null;
                    }
                }
                if (this.ccursor.getTopNode() != null) {
                    node = null;
                    String string = this.core.getHrefString(node2);
                    if (string != null && string.length() > 0) {
                        if (string.charAt(0) == '#') {
                            node = this.core.getTargetNode(node2, this.ccursor.getTopNode());
                            int n2 = n;
                            if (node != null) {
                                n2 = this.core.getNodePosition(node, this.ccursor.getPc());
                            }
                            if (n != n2) {
                                boolean bl = false;
                                int n3 = n2;
                                while (n3 < packetCollection.size()) {
                                    String string2 = ((IPacket)packetCollection.get(n3)).getText();
                                    if (string2 != null && string2.length() > 0) {
                                        bl = true;
                                        break;
                                    }
                                    ++n3;
                                }
                                if (bl) {
                                    this.ccursor.setCurPos(n3);
                                    this.doCurLine();
                                } else {
                                    this.ccursor.setCurPos(n);
                                    this.speech.stop();
                                    if (OutLoud.nostring != null && OutLoud.nostring.length() > 0) {
                                        this.speech.speak(OutLoud.nostring, 1, -1);
                                    } else {
                                        this.speech.speak("Target has no strings.", 1, -1);
                                    }
                                }
                            }
                            return null;
                        }
                        if (!string.toLowerCase().startsWith("javascript:")) {
                            return string;
                        }
                    }
                }
            }
            this.speech.stop();
            if (OutLoud.notonalink != null && OutLoud.notonalink.length() > 0) {
                this.speech.speak(OutLoud.notonalink, 1, -1);
            } else {
                this.speech.speak("Not on a link.", 1, -1);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private PacketCollection getPrevLink() {
        PacketCollection packetCollection = this.ccursor.getPc();
        PacketCollection packetCollection2 = new PacketCollection();
        if (packetCollection != null && packetCollection.size() > 0) {
            int n;
            int n2;
            int n3 = n2 = this.ccursor.getCurPos();
            boolean bl = false;
            if (n2 > 0) {
                n = n2 - 1;
                while (n >= 0) {
                    if (n < packetCollection.size()) {
                        String string = ((IPacket)packetCollection.get(n)).getText();
                        if (string != null && string.length() > 0 && packetCollection.isInsideAnchor(n)) {
                            bl = true;
                        }
                        if (packetCollection.isLinkTag(n) && bl) {
                            n3 = n;
                            break;
                        }
                        if (packetCollection.isLinkTag(n)) {
                            bl = false;
                        }
                    }
                    --n;
                }
            }
            if (n2 != n3) {
                this.ccursor.setCurPos(n3);
                int n4 = this.getEndPositionOfCurLine();
                if (n3 == n4 && n4 < packetCollection.size() - 1) {
                    ++n4;
                }
                packetCollection2.addAll(packetCollection.subList(n3, n4));
                if (packetCollection2.size() > 0) {
                    n = 0;
                    int n5 = 0;
                    while (n5 < packetCollection2.size()) {
                        if (packetCollection2.isLinkTag(n5)) {
                            ++n;
                        }
                        ++n5;
                    }
                    if (n > 1) {
                        packetCollection2 = this.getCurLinkPC(true);
                    } else if (n == 0) {
                        packetCollection2 = null;
                    }
                }
            }
        }
        return packetCollection2;
    }

    private PacketCollection getCurLink() {
        PacketCollection packetCollection = this.ccursor.getPc();
        PacketCollection packetCollection2 = null;
        if (packetCollection != null && packetCollection.size() > 0 && (packetCollection2 = this.getCurLine(false)) != null && packetCollection2.size() > 0) {
            int n = 0;
            int n2 = 0;
            while (n2 < packetCollection2.size()) {
                if (packetCollection2.isLinkTag(n2)) {
                    ++n;
                }
                ++n2;
            }
            if (n > 1) {
                packetCollection2 = this.getCurLinkPC(true);
            } else if (n == 0) {
                packetCollection2 = null;
            }
        }
        return packetCollection2;
    }

    private PacketCollection getNextLink() {
        PacketCollection packetCollection = this.ccursor.getPc();
        PacketCollection packetCollection2 = new PacketCollection();
        if (packetCollection != null && packetCollection.size() > 0) {
            int n;
            int n2;
            int n3 = n2 = this.ccursor.getCurPos();
            boolean bl = false;
            int n4 = n2 + 1;
            while (n4 < packetCollection.size()) {
                if (packetCollection.isLinkTag(n4)) {
                    n = n4;
                    if (packetCollection.isInsideAnchor(n4)) {
                        n = n4;
                        while (n < packetCollection.size()) {
                            if (!packetCollection.isInsideAnchor(n)) break;
                            ++n;
                        }
                    }
                    int n5 = n4;
                    while (n5 <= n) {
                        String string = ((IPacket)packetCollection.get(n5)).getText();
                        if (string != null && string.length() > 0) {
                            bl = true;
                            break;
                        }
                        ++n5;
                    }
                    if (bl) {
                        n3 = n4;
                        break;
                    }
                }
                ++n4;
            }
            if (n2 != n3) {
                this.ccursor.setCurPos(n3);
                int n6 = this.getEndPositionOfCurLine();
                if (n3 == n6 && n6 < packetCollection.size() - 1) {
                    ++n6;
                }
                packetCollection2.addAll(packetCollection.subList(n3, n6));
                if (packetCollection2.size() > 0) {
                    n4 = 0;
                    n = 0;
                    while (n < packetCollection2.size()) {
                        if (packetCollection2.isLinkTag(n)) {
                            ++n4;
                        }
                        ++n;
                    }
                    if (n4 > 1) {
                        packetCollection2 = this.getCurLinkPC(true);
                        return packetCollection2;
                    }
                    if (n4 == 0) {
                        packetCollection2 = null;
                    }
                }
            }
        }
        return packetCollection2;
    }

    private PacketCollection getCurLine(boolean bl) {
        PacketCollection packetCollection = new PacketCollection();
        PacketCollection packetCollection2 = this.ccursor.getPc();
        if (packetCollection2 != null && packetCollection2.size() > 0) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            n3 = this.ccursor.getCurPos();
            n4 = packetCollection2.getTopNodePosition();
            n = n3;
            if (n4 >= n3) {
                n = n4;
            } else {
                if (n3 > 0) {
                    if (packetCollection2.isLinkTag(n3) && packetCollection2.isLinkTag(n3 - 1)) {
                        n5 = n3 - 1;
                    } else {
                        n5 = n3 - 1;
                        while (n5 >= 0) {
                            if (packetCollection2.isLineDelimiter(n5)) break;
                            --n5;
                        }
                    }
                }
                n6 = n5 + 1;
                while (n6 < packetCollection2.size()) {
                    String string = ((IPacket)packetCollection2.get(n6)).getText();
                    if (string != null && string.length() > 0) {
                        n3 = n6;
                        break;
                    }
                    ++n6;
                }
                if (packetCollection2.isInsideAnchor(n6)) {
                    int n7 = n6;
                    while (n7 >= 0) {
                        if (packetCollection2.isLinkTag(n7)) {
                            n = n7;
                            break;
                        }
                        --n7;
                    }
                } else {
                    n = n6;
                }
                if (n3 < n6) {
                    n = n3;
                }
            }
            n2 = this.searchEndPosition(n);
            if (n == n2) {
                ++n2;
            }
            if (bl) {
                this.ccursor.setCurPos(n);
            }
            packetCollection.addAll(packetCollection2.subList(n, n2));
        }
        return packetCollection;
    }

    private int getEndPositionOfCurLine() {
        int n = 0;
        PacketCollection packetCollection = this.ccursor.getPc();
        if (packetCollection != null && packetCollection.size() > 0) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            n3 = this.ccursor.getCurPos();
            n4 = packetCollection.getTopNodePosition();
            n2 = n3;
            if (n4 >= n3) {
                n2 = n4;
            } else {
                if (n3 > 0) {
                    if (packetCollection.isLinkTag(n3) && packetCollection.isLinkTag(n3 - 1)) {
                        n5 = n3 - 1;
                    } else {
                        n5 = n3 - 1;
                        while (n5 >= 0) {
                            if (packetCollection.isLineDelimiter(n5)) break;
                            --n5;
                        }
                    }
                }
                n6 = n5 + 1;
                while (n6 < packetCollection.size()) {
                    String string = ((IPacket)packetCollection.get(n6)).getText();
                    if (string != null && string.length() > 0) {
                        n3 = n6;
                        break;
                    }
                    ++n6;
                }
                if (packetCollection.isInsideAnchor(n6)) {
                    int n7 = n6;
                    while (n7 >= 0) {
                        if (packetCollection.isLinkTag(n7)) {
                            n2 = n7;
                            break;
                        }
                        --n7;
                    }
                } else {
                    n2 = n6;
                }
                if (n3 < n6) {
                    n2 = n3;
                }
            }
            n = this.searchEndPosition(n2);
            if (n2 == n) {
                ++n;
            }
        }
        return n;
    }

    private int searchEndPosition(int n) {
        int n2 = n;
        PacketCollection packetCollection = this.ccursor.getPc();
        if (packetCollection != null && packetCollection.size() > 0) {
            if (packetCollection.isStartSelect(n) || packetCollection.isLinkTag(n) && n + 1 < packetCollection.size() && packetCollection.isLinkTag(n + 1)) {
                n2 = n + 1;
            } else {
                boolean bl = packetCollection.isInsideForm(n);
                while (n < packetCollection.size() && !packetCollection.isLineDelimiter(n)) {
                    if (bl && !packetCollection.isInsideForm(n)) break;
                    ++n;
                }
                n2 = n;
            }
        }
        return n2;
    }

    private PacketCollection getPrevLine(boolean bl) {
        PacketCollection packetCollection = new PacketCollection();
        PacketCollection packetCollection2 = this.ccursor.getPc();
        if (packetCollection2 != null && packetCollection2.size() > 0) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n3 = this.ccursor.getCurPos();
            n4 = packetCollection2.getTopNodePosition();
            if (n4 >= n3) {
                this.ccursor.setCurPos(n4);
                return null;
            }
            int n5 = this.ccursor.getCurPos();
            boolean bl2 = false;
            if (n5 - 1 >= 0) {
                int n6 = n5 - 1;
                while (n6 >= 0) {
                    String string = ((IPacket)packetCollection2.get(n6)).getText();
                    if (!bl2 && string != null && string.length() > 0) {
                        bl2 = true;
                        if (bl2 && packetCollection2.isLineDelimiter(n6)) {
                            n3 = n6;
                            break;
                        }
                    } else if (bl2 && packetCollection2.isLineDelimiter(n6)) {
                        n3 = n6 + 1;
                        if (!packetCollection2.isLinkTag(n3) || !packetCollection2.isLinkTag(n3 + 1)) break;
                        ++n3;
                        break;
                    }
                    --n6;
                }
            }
            if ((n = n3 == n5 ? n3 - 1 : n3) == (n2 = this.searchEndPosition(n))) {
                ++n2;
            }
            if (bl) {
                this.ccursor.setCurPos(n);
            }
            packetCollection.addAll(packetCollection2.subList(n, n2));
        }
        return packetCollection;
    }

    /*
     * Unable to fully structure code
     */
    private PacketCollection getNextLine(boolean var1_1) {
        block7: {
            block8: {
                var2_2 = new PacketCollection();
                var3_3 = this.ccursor.getPc();
                if (var3_3 == null || var3_3.size() <= 0) break block7;
                var4_4 = 0;
                var5_5 = 0;
                var6_6 = 0;
                var7_7 = this.ccursor.getCurPos();
                if (var7_7 >= (var8_8 = var3_3.getBottomNodePosition())) {
                    return null;
                }
                var9_9 = var7_7;
                var10_10 = var3_3.isInsideForm(var9_9);
                if (!var3_3.isStartSelect(var9_9) && (!var3_3.isLinkTag(var9_9) || var9_9 + 1 >= var3_3.size() || !var3_3.isLinkTag(var9_9 + 1))) ** GOTO lbl17
                var6_6 = var9_9 + 1;
                break block8;
                while (!(var10_10 && !var3_3.isInsideForm(var9_9) || var3_3.isStartSelect(var9_9))) {
                    ++var9_9;
lbl17:
                    // 2 sources

                    if (var9_9 < var3_3.size() && !var3_3.isLineDelimiter(var9_9)) continue;
                }
                var6_6 = var10_10 != false && var3_3.isInsideForm(var9_9) == false || var3_3.isStartSelect(var9_9) != false ? var9_9 : var9_9 + 1;
            }
            if (var6_6 <= var3_3.size()) {
                var9_9 = var6_6;
                while (var9_9 < var3_3.size()) {
                    var11_11 = ((IPacket)var3_3.get(var9_9)).getText();
                    if (var11_11 != null && var11_11.length() > 0) {
                        var6_6 = var9_9;
                        break;
                    }
                    ++var9_9;
                }
            }
            if ((var4_4 = var6_6) == (var5_5 = this.searchEndPosition(var4_4))) {
                ++var5_5;
            }
            if (var1_1) {
                this.ccursor.setCurPos(var4_4);
            }
            var2_2.addAll(var3_3.subList(var4_4, var5_5));
        }
        return var2_2;
    }

    private PacketCollection getTopLine() {
        PacketCollection packetCollection = new PacketCollection();
        PacketCollection packetCollection2 = this.ccursor.getPc();
        if (packetCollection2 != null && packetCollection2.size() > 0) {
            int n = 0;
            int n2 = 0;
            int n3 = n = packetCollection2.getTopNodePosition();
            while (n3 < packetCollection2.size() && !packetCollection2.isLineDelimiter(n3)) {
                ++n3;
            }
            n2 = n3;
            if (n == n2) {
                ++n2;
            }
            this.ccursor.setCurPos(n);
            packetCollection.addAll(packetCollection2.subList(n, n2));
        }
        return packetCollection;
    }

    private PacketCollection getBottomLine() {
        PacketCollection packetCollection = new PacketCollection();
        PacketCollection packetCollection2 = this.ccursor.getPc();
        if (packetCollection2 != null && packetCollection2.size() > 0) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            n3 = packetCollection2.getBottomNodePosition();
            int n4 = n3;
            if (!packetCollection2.isLineDelimiter(n4)) {
                while (n4 < packetCollection2.size() && packetCollection2.isLineDelimiter(n4)) {
                    ++n4;
                }
            }
            n4 = n = n4;
            while (n4 < packetCollection2.size() - 1 && !packetCollection2.isLineDelimiter(n4)) {
                ++n4;
            }
            n2 = n4;
            if (n == n2) {
                ++n2;
            }
            this.ccursor.setCurPos(n);
            packetCollection.addAll(packetCollection2.subList(n, n2));
        }
        return packetCollection;
    }

    private PacketCollection getCurLinkPC(boolean bl) {
        PacketCollection packetCollection = new PacketCollection();
        PacketCollection packetCollection2 = this.ccursor.getPc();
        if (packetCollection2 != null && packetCollection2.size() > 0) {
            int n = 0;
            int n2 = 0;
            int n3 = n = this.ccursor.getCurPos();
            while (n3 < packetCollection2.size()) {
                if (packetCollection2.isLinkTag(n3)) {
                    n = n3;
                    break;
                }
                ++n3;
            }
            n2 = n + 1;
            if (packetCollection2.isInsideAnchor(n)) {
                n3 = n;
                while (n3 < packetCollection2.size()) {
                    if (!packetCollection2.isInsideAnchor(n3)) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
            }
            if (bl) {
                this.ccursor.setCurPos(n);
            }
            packetCollection.addAll(packetCollection2.subList(n, n2));
        }
        return packetCollection;
    }

    private void setRange(Node node, Node node2) {
        if (node != null && node2 != null) {
            int n = selObservers.size();
            int n2 = 0;
            while (n2 < n) {
                selObservers.get(n2).setRange(node, node2);
                ++n2;
            }
        }
    }

    private void speakWithVisual(PacketCollection packetCollection) {
        String string;
        Node node;
        Node node2;
        try {
            node2 = packetCollection.getFirstNode();
            node = packetCollection.getLastNode();
            string = this.render(packetCollection);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.speech.stop();
            if (OutLoud.endofpage != null && OutLoud.endofpage.length() > 0) {
                this.speech.speak(OutLoud.endofpage, 1, -1);
            } else {
                this.speech.speak("End of page.", 1, -1);
            }
            return;
        }
        if (string != null && string.length() > 0) {
            this.speech.stop();
            this.speech.speak(string, 1, -1);
            this.setRange(node2, node);
            this.drawText(string);
        }
    }

    public String render(PacketCollection packetCollection) {
        int n = 0;
        try {
            int n2 = packetCollection.size();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = n;
            while (n3 < n2) {
                char c;
                IPacket iPacket = (IPacket)packetCollection.get(n3);
                String string = iPacket.getText();
                if (string != null && string.length() > 0) {
                    if (stringBuffer.length() > 0 && (c = stringBuffer.charAt(stringBuffer.length() - 1)) != '\n' && iPacket.getContext().isStartSelect()) {
                        stringBuffer.append(BACKSLASH_N);
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(string);
                }
                if (stringBuffer.length() > 0 && (c = stringBuffer.charAt(stringBuffer.length() - 1)) != '\n' && (iPacket.getContext().isLineDelimiter() || packetCollection.isLinkTag(n3) && n3 + 1 < packetCollection.size() && packetCollection.isLinkTag(n3 + 1))) {
                    stringBuffer.append(BACKSLASH_N);
                }
                ++n3;
            }
            return stringBuffer.toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String render(PacketCollection packetCollection, int n) {
        try {
            int n2 = packetCollection.size();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = n;
            while (n3 < n2) {
                char c;
                IPacket iPacket = (IPacket)packetCollection.get(n3);
                String string = iPacket.getText();
                if (string != null && string.length() > 0 && iPacket.getContext().isStringOutput()) {
                    if (stringBuffer.length() > 0 && (c = stringBuffer.charAt(stringBuffer.length() - 1)) != '\n' && iPacket.getContext().isStartSelect()) {
                        stringBuffer.append(BACKSLASH_N);
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(string);
                }
                if (stringBuffer.length() > 0 && (c = stringBuffer.charAt(stringBuffer.length() - 1)) != '\n' && (iPacket.getContext().isLineDelimiter() || packetCollection.isLinkTag(n3) && n3 + 1 < packetCollection.size() && packetCollection.isLinkTag(n3 + 1))) {
                    stringBuffer.append(BACKSLASH_N);
                }
                ++n3;
            }
            return stringBuffer.toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void addView(IVoiceBrowserView iVoiceBrowserView) {
        views.add(iVoiceBrowserView);
    }

    public void removeView(IVoiceBrowserView iVoiceBrowserView) {
        views.remove(iVoiceBrowserView);
    }

    public void addSelectionObserver(SelectionObserver selectionObserver) {
        selObservers.add(selectionObserver);
    }

    public void removeSelectionObserver(SelectionObserver selectionObserver) {
        selObservers.remove(selectionObserver);
    }

    public PacketCollection getPacketCollection() {
        return this.ccursor.getPc();
    }

    void drawText(String string) {
        if (views == null) {
            return;
        }
        int n = views.size();
        int n2 = 0;
        while (n2 < n) {
            IVoiceBrowserView iVoiceBrowserView = views.get(n2);
            iVoiceBrowserView.drawText(string);
            ++n2;
        }
    }

    void drawAppendText(String string) {
        if (views == null) {
            return;
        }
        int n = views.size();
        int n2 = 0;
        while (n2 < n) {
            IVoiceBrowserView iVoiceBrowserView = views.get(n2);
            iVoiceBrowserView.drawAppendText(string);
            ++n2;
        }
    }

    public void addCursorListener(CursorListener cursorListener) {
        this.cursorListeners.addElement(cursorListener);
    }

    public void removeCursorListener(CursorListener cursorListener) {
        this.cursorListeners.removeElement(cursorListener);
    }

    public void sendCursorEvent(CursorMovedEvent cursorMovedEvent) {
        Vector vector = (Vector)this.cursorListeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CursorListener cursorListener = (CursorListener)enumeration.nextElement();
            cursorListener.doCursorMoved(cursorMovedEvent);
        }
    }

    public void setSpeechControl(ITTSEngine iTTSEngine) {
        if (iTTSEngine != null) {
            this.speech = iTTSEngine;
        }
    }
}

