/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocumentFragment;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGMLParentNode
extends SGMLNode {
    private static final long serialVersionUID = 3126509435625384557L;
    SGMLNode firstChild;
    SGMLNode lastChild;
    private static WeakHashMap<Document, HashMap<String, ArrayList<WeakReference<Node>>>> documentTagNameMap = new WeakHashMap();
    private static WeakHashMap<Document, HashMap<String, List<WeakReference<Element>>>> documentIdMap = new WeakHashMap();
    private static WeakHashMap<Document, HashMap<String, Long>> documentUpdatedMap = new WeakHashMap();

    SGMLParentNode(Document document) {
        super(document);
    }

    abstract void check(Node var1) throws DOMException;

    @Override
    public Node cloneNode(boolean bl) {
        SGMLParentNode sGMLParentNode = null;
        if (bl && this.firstChild != null) {
            sGMLParentNode = this.cloneNodeDeep();
            if (sGMLParentNode == null) {
                return null;
            }
        } else {
            try {
                sGMLParentNode = (SGMLParentNode)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
            sGMLParentNode.firstChild = null;
            sGMLParentNode.lastChild = null;
        }
        sGMLParentNode.previousSibling = null;
        sGMLParentNode.nextSibling = null;
        sGMLParentNode.parent = null;
        return sGMLParentNode;
    }

    private SGMLParentNode cloneNodeDeep() {
        try {
            SGMLParentNode sGMLParentNode = (SGMLParentNode)this.clone();
            sGMLParentNode.lastChild = null;
            sGMLParentNode.firstChild = null;
            sGMLParentNode.parent = null;
            sGMLParentNode.nextSibling = null;
            sGMLParentNode.previousSibling = null;
            if (this.firstChild == null) {
                return sGMLParentNode;
            }
            SGMLNode sGMLNode = sGMLParentNode.firstChild = (SGMLNode)this.firstChild.cloneNode(true);
            sGMLNode.parent = sGMLParentNode;
            SGMLNode sGMLNode2 = this.firstChild.nextSibling;
            while (sGMLNode2 != null) {
                sGMLNode.nextSibling = (SGMLNode)sGMLNode2.cloneNode(true);
                sGMLNode.nextSibling.previousSibling = sGMLNode;
                sGMLNode = sGMLNode.nextSibling;
                sGMLNode.parent = sGMLParentNode;
                sGMLNode2 = sGMLNode2.nextSibling;
            }
            sGMLParentNode.lastChild = sGMLNode;
            return sGMLParentNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    @Override
    public NodeList getChildNodes() {
        return new NodeList(){

            public Node item(int n) {
                SGMLNode sGMLNode = SGMLParentNode.this.firstChild;
                while (n > 0 && sGMLNode != null) {
                    sGMLNode = sGMLNode.nextSibling;
                    --n;
                }
                return n == 0 ? sGMLNode : null;
            }

            public int getLength() {
                int n = 0;
                SGMLNode sGMLNode = SGMLParentNode.this.firstChild;
                while (sGMLNode != null) {
                    ++n;
                    sGMLNode = sGMLNode.nextSibling;
                }
                return n;
            }
        };
    }

    @Override
    public Node getFirstChild() {
        return this.firstChild;
    }

    @Override
    public Node getLastChild() {
        return this.lastChild;
    }

    @Override
    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        if (node instanceof SGMLDocumentFragment && node.getOwnerDocument() == this.getOwnerDocument()) {
            SGMLDocumentFragment sGMLDocumentFragment = (SGMLDocumentFragment)node;
            SGMLNode sGMLNode = sGMLDocumentFragment.firstChild;
            while (sGMLNode != null) {
                sGMLNode.parent = this;
                sGMLNode = sGMLNode.nextSibling;
            }
            if (this.firstChild == null) {
                this.firstChild = sGMLDocumentFragment.firstChild;
                this.lastChild = sGMLDocumentFragment.lastChild;
            } else {
                this.lastChild.nextSibling = sGMLDocumentFragment.firstChild;
                sGMLDocumentFragment.firstChild.previousSibling = this.lastChild;
                this.lastChild = sGMLDocumentFragment.lastChild;
            }
            return node;
        }
        this.check(node);
        SGMLNode sGMLNode = (SGMLNode)node;
        if (sGMLNode.parent != null) {
            sGMLNode.parent.removeChild(sGMLNode);
        }
        sGMLNode.parent = this;
        if (this.firstChild == null) {
            this.firstChild = this.lastChild = sGMLNode;
            if (node instanceof Element) {
                this.processNodeForOptimization((Element)node);
            }
            return node;
        }
        this.lastChild.nextSibling = sGMLNode;
        sGMLNode.previousSibling = this.lastChild;
        this.lastChild = sGMLNode;
        if (node instanceof Element) {
            this.processNodeForOptimization((Element)node);
        }
        return node;
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (node2 == null) {
            return this.appendChild(node);
        }
        SGMLNode sGMLNode = (SGMLNode)node2;
        if (sGMLNode.parent != this) {
            throw new DOMException(8, "There isn't " + node2 + " as a children"){
                private static final long serialVersionUID = -401620698015402759L;
            };
        }
        if (node instanceof SGMLDocumentFragment && node.getOwnerDocument() == this.getOwnerDocument()) {
            SGMLDocumentFragment sGMLDocumentFragment = (SGMLDocumentFragment)node;
            SGMLNode sGMLNode2 = sGMLDocumentFragment.firstChild;
            while (sGMLNode2 != null) {
                sGMLNode2.parent = this;
                sGMLNode2 = sGMLNode2.nextSibling;
            }
            if (this.firstChild == node2) {
                this.firstChild.previousSibling = sGMLDocumentFragment.lastChild;
                sGMLDocumentFragment.lastChild.nextSibling = this.firstChild;
                this.firstChild = sGMLDocumentFragment.firstChild;
            } else {
                sGMLDocumentFragment.firstChild.previousSibling = sGMLNode.previousSibling;
                sGMLDocumentFragment.lastChild.nextSibling = sGMLNode;
                sGMLNode.previousSibling.nextSibling = sGMLDocumentFragment.firstChild;
                sGMLNode.previousSibling = sGMLDocumentFragment.lastChild;
            }
            return node;
        }
        this.check(node);
        SGMLNode sGMLNode3 = (SGMLNode)node;
        if (sGMLNode3.parent != null) {
            sGMLNode3.parent.removeChild(sGMLNode3);
        }
        if (this.firstChild == node2) {
            this.firstChild.previousSibling = sGMLNode3;
            sGMLNode3.nextSibling = this.firstChild;
            sGMLNode3.parent = this;
            this.firstChild = sGMLNode3;
        } else {
            sGMLNode3.previousSibling = sGMLNode.previousSibling;
            sGMLNode3.nextSibling = sGMLNode;
            sGMLNode.previousSibling.nextSibling = sGMLNode3;
            sGMLNode.previousSibling = sGMLNode3;
            sGMLNode3.parent = this;
        }
        if (node instanceof Element) {
            this.processNodeForOptimization((Element)node);
        }
        return node;
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        SGMLNode sGMLNode;
        block11: {
            block10: {
                if (this.firstChild == null || !(node instanceof SGMLNode)) break block10;
                sGMLNode = (SGMLNode)node;
                if (sGMLNode.parent == this) break block11;
            }
            throw new DOMException(8, "There isn't " + node + " as a children"){
                private static final long serialVersionUID = -4190622701270985282L;
            };
        }
        if (this.firstChild == node) {
            if (this.firstChild == this.lastChild) {
                this.lastChild = null;
                this.firstChild = null;
            } else {
                this.firstChild = sGMLNode.nextSibling;
                this.firstChild.previousSibling = null;
            }
        } else if (this.lastChild == node) {
            this.lastChild = sGMLNode.previousSibling;
            this.lastChild.nextSibling = null;
        } else {
            sGMLNode.nextSibling.previousSibling = sGMLNode.previousSibling;
            sGMLNode.previousSibling.nextSibling = sGMLNode.nextSibling;
        }
        sGMLNode.nextSibling = null;
        sGMLNode.previousSibling = null;
        sGMLNode.parent = null;
        if (node instanceof Element) {
            this.processNodeForOptimization((Element)node);
        }
        return node;
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.check(node);
        SGMLNode sGMLNode = (SGMLNode)node;
        SGMLNode sGMLNode2 = (SGMLNode)node2;
        if (sGMLNode2.parent != this) {
            throw new DOMException(8, this + "doesn't have " + node + " as a child"){
                private static final long serialVersionUID = 164773639627266417L;
            };
        }
        if (this.firstChild == node2) {
            if (this.firstChild != this.lastChild) {
                sGMLNode.nextSibling = this.firstChild.nextSibling;
                this.firstChild.nextSibling.previousSibling = sGMLNode;
            } else {
                this.lastChild = sGMLNode;
            }
            this.firstChild = sGMLNode;
            sGMLNode2.nextSibling = null;
            sGMLNode2.previousSibling = null;
            sGMLNode2.parent = null;
            sGMLNode.parent = this;
        } else if (this.lastChild == node2) {
            this.lastChild.previousSibling.nextSibling = sGMLNode;
            sGMLNode.previousSibling = this.lastChild.previousSibling;
            this.lastChild = sGMLNode;
            sGMLNode2.previousSibling = null;
            sGMLNode2.parent = null;
            sGMLNode.parent = this;
        } else {
            sGMLNode.previousSibling = sGMLNode2.previousSibling;
            sGMLNode.nextSibling = sGMLNode2.nextSibling;
            sGMLNode2.previousSibling.nextSibling = sGMLNode;
            sGMLNode2.nextSibling.previousSibling = sGMLNode;
            sGMLNode2.nextSibling = null;
            sGMLNode2.previousSibling = null;
            sGMLNode2.parent = null;
            sGMLNode.parent = this;
        }
        if (sGMLNode2 instanceof Element) {
            this.processNodeForOptimization((Element)((Object)sGMLNode2));
        }
        if (sGMLNode instanceof Element) {
            this.processNodeForOptimization((Element)((Object)sGMLNode));
        }
        return node;
    }

    @Override
    public void normalize() {
        SGMLNode sGMLNode = this.firstChild;
        while (sGMLNode != null) {
            if (sGMLNode.getNodeType() == 3) {
                if (sGMLNode.nextSibling != null && sGMLNode.nextSibling.getNodeType() == 3) {
                    ((Text)((Object)sGMLNode)).appendData(((Text)((Object)sGMLNode.nextSibling)).getData());
                    this.removeChild(sGMLNode.nextSibling);
                    continue;
                }
                sGMLNode = sGMLNode.nextSibling;
                continue;
            }
            sGMLNode.normalize();
            sGMLNode = sGMLNode.nextSibling;
        }
    }

    protected void processNodeForOptimization(Element element) {
        if (element.getParentNode() == null) {
            this.removeNodeForOptimization(element);
        } else {
            this.addNodeForOptimization(element);
        }
    }

    private void removeNodeForOptimization(Element element) {
        Object object;
        Object object2;
        String string = element.getAttribute("id");
        HashMap<String, List<WeakReference<Element>>> hashMap = SGMLParentNode.getIdMap(this.ownerDocument);
        if (string != null && (object2 = hashMap.get(string)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                if (((WeakReference)object.next()).get() != element) continue;
                object.remove();
            }
        }
        if ((object2 = element.getNodeName().toLowerCase()) != null) {
            object = SGMLParentNode.getNodeList(this.ownerDocument, (String)object2);
            int n = ((ArrayList)object).size() - 1;
            while (n >= 0) {
                if (((WeakReference)((ArrayList)object).get(n)).get() == element) break;
                --n;
            }
            if (n != -1) {
                ((ArrayList)object).remove(n);
            }
        }
        SGMLParentNode.updateNodeList(this.ownerDocument, (String)object2);
        object = element.getFirstChild();
        while (object != null) {
            if (object instanceof Element) {
                this.removeNodeForOptimization((Element)object);
            }
            object = object.getNextSibling();
        }
    }

    private void addNodeForOptimization(Element element) {
        ArrayList<WeakReference<Node>> arrayList;
        this.processIdForOptimization(element);
        String string = element.getNodeName().toLowerCase();
        if (string != null) {
            arrayList = SGMLParentNode.getNodeList(this.ownerDocument, string);
            if (arrayList.size() == 0) {
                arrayList.add(new WeakReference<Element>(element));
            } else {
                Node node = this.findPreviousNodeByTagName(element, string);
                int n = arrayList.size() - 1;
                if (node != null) {
                    while (n >= 0) {
                        if (((WeakReference)arrayList.get(n)).get() == node) break;
                        --n;
                    }
                }
                int n2 = arrayList.size() - 1;
                while (n2 >= 0) {
                    if (((WeakReference)arrayList.get(n2)).get() == element) break;
                    --n2;
                }
                if (n2 != -1) {
                    if (n + 1 != n2) {
                        arrayList.remove(n2);
                        if (n + 1 < arrayList.size()) {
                            arrayList.add(n + 1, new WeakReference<Element>(element));
                        } else {
                            arrayList.add(new WeakReference<Element>(element));
                        }
                    }
                } else {
                    arrayList.add(n + 1, new WeakReference<Element>(element));
                }
            }
        }
        SGMLParentNode.updateNodeList(this.ownerDocument, string);
        arrayList = element.getFirstChild();
        while (arrayList != null) {
            if (arrayList instanceof Element) {
                this.addNodeForOptimization((Element)((Object)arrayList));
            }
            arrayList = arrayList.getNextSibling();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void processIdForOptimization(Element element) {
        List<WeakReference<Element>> list;
        String string = element.getAttribute("id");
        HashMap<String, List<WeakReference<Element>>> hashMap = SGMLParentNode.getIdMap(this.ownerDocument);
        for (String list2 : hashMap.keySet()) {
            list = hashMap.get(list2);
            if (list == null) continue;
            Iterator<WeakReference<Element>> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().get() != element) continue;
                iterator.remove();
            }
        }
        if (string != null && string.length() > 0) {
            void var4_9;
            List<WeakReference<Element>> list2 = hashMap.get(string);
            if (list2 == null) {
                ArrayList arrayList = new ArrayList();
                hashMap.put(string, arrayList);
            }
            boolean bl = true;
            list = var4_9.iterator();
            while (list.hasNext()) {
                if (((WeakReference)list.next()).get() != element) continue;
                bl = false;
            }
            if (bl) {
                var4_9.add(new WeakReference<Element>(element));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Node findPreviousNodeByTagName(Node var1_1, String var2_2) {
        block2: {
            do {
                block3: {
                    var3_3 = var1_1.getPreviousSibling();
                    var4_4 = var1_1.getParentNode();
                    if (var3_3 != null) ** GOTO lbl8
                    var1_1 = var4_4 != null ? var4_4 : null;
                    break block3;
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = var3_3.getLastChild();
lbl8:
                        // 2 sources

                        ** while (var3_3.getLastChild() != null)
                    }
lbl9:
                    // 1 sources

                    var1_1 = var3_3;
                }
                if (var1_1 == null) break block2;
            } while (!var1_1.getNodeName().toLowerCase().equals(var2_2));
            return var1_1;
        }
        return null;
    }

    protected static ArrayList<WeakReference<Node>> getNodeList(Document document, String string) {
        ArrayList<WeakReference<Node>> arrayList;
        HashMap<String, ArrayList<WeakReference<Node>>> hashMap = documentTagNameMap.get(document);
        if (hashMap == null) {
            hashMap = new HashMap();
            documentTagNameMap.put(document, hashMap);
        }
        if ((arrayList = hashMap.get(string)) == null) {
            arrayList = new ArrayList();
            hashMap.put(string, arrayList);
        }
        return arrayList;
    }

    protected static HashMap<String, List<WeakReference<Element>>> getIdMap(Document document) {
        HashMap<String, List<WeakReference<Element>>> hashMap = documentIdMap.get(document);
        if (hashMap == null) {
            hashMap = new HashMap();
            documentIdMap.put(document, hashMap);
        }
        return hashMap;
    }

    private static HashMap<String, Long> getUpdatedMap(Document document, String string) {
        HashMap<String, Long> hashMap = documentUpdatedMap.get(document);
        if (hashMap == null) {
            hashMap = new HashMap();
            documentUpdatedMap.put(document, hashMap);
        }
        return hashMap;
    }

    protected static long getNodeListUpdatedAt(Document document, String string) {
        HashMap<String, Long> hashMap = SGMLParentNode.getUpdatedMap(document, string);
        Long l = hashMap.get(string);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    protected static void updateNodeList(Document document, String string) {
        HashMap<String, Long> hashMap = SGMLParentNode.getUpdatedMap(document, string);
        Long l = hashMap.get(string);
        if (l == null) {
            l = 0L;
        }
        l = l + 1L;
        hashMap.put(string, l);
    }
}

