/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.base.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFNode;
import org.eclipse.actf.model.dom.odf.base.impl.AbstractODFNodeFactory;
import org.eclipse.actf.model.dom.odf.base.impl.ODFAttrImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFCharacterDataImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFCommentImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFNodeImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFNodeListImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFProcessingInstructionImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFTextImpl;
import org.eclipse.actf.model.dom.odf.chart.impl.ChartNodeFactory;
import org.eclipse.actf.model.dom.odf.dr3d.impl.Dr3dNodeFactory;
import org.eclipse.actf.model.dom.odf.draw.impl.DrawNodeFactory;
import org.eclipse.actf.model.dom.odf.form.impl.FormNodeFactory;
import org.eclipse.actf.model.dom.odf.number.impl.NumberNodeFactory;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.DocumentStylesElement;
import org.eclipse.actf.model.dom.odf.office.impl.OfficeNodeFactory;
import org.eclipse.actf.model.dom.odf.presentation.impl.PresentationNodeFactory;
import org.eclipse.actf.model.dom.odf.style.impl.StyleNodeFactory;
import org.eclipse.actf.model.dom.odf.svg.impl.SVGNodeFactory;
import org.eclipse.actf.model.dom.odf.table.impl.TableNodeFactory;
import org.eclipse.actf.model.dom.odf.text.impl.TextNodeFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODFDocumentImpl
extends ODFNodeImpl
implements ODFDocument {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Class<? extends AbstractODFNodeFactory>> factoryMap = new HashMap<String, Class<? extends AbstractODFNodeFactory>>();
    private Map<Node, ODFNode> internalNodeMap = new HashMap<Node, ODFNode>();
    private String sUrl = null;
    private ODFDocument styleDoc = null;

    static {
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:chart:1.0", ChartNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0", Dr3dNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", DrawNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:form:1.0", FormNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0", NumberNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:office:1.0", OfficeNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:presentation:1.0", PresentationNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:style:1.0", StyleNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:table:1.0", TableNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:text:1.0", TextNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", SVGNodeFactory.class);
    }

    public ODFDocumentImpl(Document document) {
        super(document);
        this.internalNodeMap.put(document, this);
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttribute(String string) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return null;
    }

    @Override
    public CDATASection createCDATASection(String string) throws DOMException {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).createCDATASection(string);
        }
        return null;
    }

    @Override
    public Comment createComment(String string) {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).createComment(string);
        }
        return null;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return null;
    }

    @Override
    public Element createElement(String string) throws DOMException {
        if (this.iNode instanceof Document) {
            return (Element)((Object)this.getODFNode(((Document)this.iNode).createElement(string)));
        }
        return null;
    }

    @Override
    public Element createElementNS(String string, String string2) throws DOMException {
        if (this.iNode instanceof Document) {
            return (Element)((Object)this.getODFNode(((Document)this.iNode).createElementNS(string, string2)));
        }
        return null;
    }

    @Override
    public EntityReference createEntityReference(String string) throws DOMException {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).createEntityReference(string);
        }
        return null;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).createProcessingInstruction(string, string2);
        }
        return null;
    }

    @Override
    public Text createTextNode(String string) {
        if (this.iNode instanceof Document) {
            Text text = ((Document)this.iNode).createTextNode(string);
            return (Text)((Object)this.getODFNode(text));
        }
        return null;
    }

    @Override
    public DocumentType getDoctype() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getDoctype();
        }
        return null;
    }

    @Override
    public Element getDocumentElement() {
        if (this.iNode instanceof Document) {
            Element element = ((Document)this.iNode).getDocumentElement();
            if (element == null) {
                return element;
            }
            return (Element)((Object)this.getODFNode(element));
        }
        return null;
    }

    @Override
    public String getDocumentURI() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getDocumentURI();
        }
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getDomConfig();
        }
        return null;
    }

    @Override
    public Element getElementById(String string) {
        if (this.iNode instanceof Document) {
            Element element = ((Document)this.iNode).getElementById(string);
            if (element == null) {
                return null;
            }
            return (Element)((Object)this.getODFNode(element));
        }
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        if (this.iNode instanceof Document) {
            NodeList nodeList = ((Document)this.iNode).getElementsByTagName(string);
            if (nodeList == null) {
                return null;
            }
            return new ODFNodeListImpl(this, nodeList);
        }
        return null;
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string2) {
        if (this.iNode instanceof Document) {
            NodeList nodeList = ((Document)this.iNode).getElementsByTagNameNS(string, string2);
            if (nodeList == null) {
                return null;
            }
            return new ODFNodeListImpl(this, nodeList);
        }
        return null;
    }

    @Override
    public DOMImplementation getImplementation() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getImplementation();
        }
        return null;
    }

    @Override
    public String getInputEncoding() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getInputEncoding();
        }
        return null;
    }

    @Override
    public boolean getStrictErrorChecking() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getStrictErrorChecking();
        }
        return false;
    }

    @Override
    public String getXmlEncoding() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getXmlEncoding();
        }
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getXmlStandalone();
        }
        return false;
    }

    @Override
    public String getXmlVersion() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getXmlVersion();
        }
        return null;
    }

    @Override
    public Node importNode(Node node, boolean bl) throws DOMException {
        return null;
    }

    @Override
    public void normalizeDocument() {
    }

    @Override
    public Node renameNode(Node node, String string, String string2) throws DOMException {
        return null;
    }

    @Override
    public void setDocumentURI(String string) {
        if (this.iNode instanceof Document) {
            ((Document)this.iNode).setDocumentURI(string);
        }
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        if (this.iNode instanceof Document) {
            ((Document)this.iNode).setStrictErrorChecking(bl);
        }
    }

    @Override
    public void setXmlStandalone(boolean bl) throws DOMException {
        if (this.iNode instanceof Document) {
            ((Document)this.iNode).setXmlStandalone(bl);
        }
    }

    @Override
    public void setXmlVersion(String string) throws DOMException {
        if (this.iNode instanceof Document) {
            ((Document)this.iNode).setXmlVersion(string);
        }
    }

    private Method findCreateElementMethod(Class<? extends AbstractODFNodeFactory> clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = 0;
        while (n < methodArray.length) {
            Class<?>[] classArray;
            if ("createElement".equals(methodArray[n].getName()) && (classArray = methodArray[n].getParameterTypes()).length == 3 && classArray[0].equals(ODFDocument.class) && classArray[1].equals(String.class) && classArray[2].equals(Element.class)) {
                return methodArray[n];
            }
            ++n;
        }
        return null;
    }

    public ODFNode getODFNode(Node node) {
        ODFNode oDFNode = this.internalNodeMap.get(node);
        if (oDFNode != null) {
            return oDFNode;
        }
        Class<? extends AbstractODFNodeFactory> clazz = factoryMap.get(node.getNamespaceURI());
        if (clazz != null && node instanceof Element) {
            Method method = this.findCreateElementMethod(clazz);
            try {
                oDFNode = (ODFNode)method.invoke(clazz, this, node.getLocalName(), (Element)node);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        if (oDFNode == null) {
            oDFNode = node instanceof Element ? new ODFElementImpl((ODFDocument)this, (Element)node) : (node instanceof Attr ? new ODFAttrImpl((ODFDocument)this, (Attr)node) : (node instanceof Text ? new ODFTextImpl((ODFDocument)this, (Text)node) : (node instanceof Comment ? new ODFCommentImpl((ODFDocument)this, (Comment)node) : (node instanceof CharacterData ? new ODFCharacterDataImpl((ODFDocument)this, (CharacterData)node) : (node instanceof ProcessingInstruction ? new ODFProcessingInstructionImpl((ODFDocument)this, (ProcessingInstruction)node) : new ODFNodeImpl(this, node))))));
        }
        this.internalNodeMap.put(node, oDFNode);
        return oDFNode;
    }

    @Override
    public String getURL() {
        return this.sUrl;
    }

    @Override
    public void setURL(String string) {
        this.sUrl = string;
    }

    @Override
    public void setODFVersion(double d) {
        Element element = this.getDocumentElement();
        element.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version", new Double(d).toString());
    }

    @Override
    public double getODFVersion() {
        Element element = this.getDocumentElement();
        if (element instanceof DocumentContentElement) {
            return ((DocumentContentElement)element).getAttrOfficeVersion();
        }
        if (element instanceof DocumentStylesElement) {
            return ((DocumentStylesElement)element).getAttrOfficeVersion();
        }
        return -1.0;
    }

    @Override
    public void setStyleDocument(ODFDocument oDFDocument) {
        this.styleDoc = oDFDocument;
    }

    @Override
    public ODFDocument getStyleDocument() {
        return this.styleDoc;
    }
}

