/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.flash;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.OverlayIcon;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class FlashImages {
    public static final String OVER_RED = "icons/ovr16/red.gif";
    public static final String OVER_YELLOW = "icons/ovr16/yellow.gif";
    public static final String OVER_GREEN = "icons/ovr16/green.gif";
    public static final String OVER_BLACK = "icons/ovr16/black.gif";
    public static final String FLASH_TYPE = "icons/flash16/type_{0}.gif";
    public static final String TYPE_flash = "flash";
    public static final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    public static Map<String, Image> imageMap = new HashMap<String, Image>();

    public static Image getImage(String string) {
        ImageDescriptor imageDescriptor;
        if (string == null) {
            return null;
        }
        Image image = imageMap.get(string);
        if (image == null && (imageDescriptor = FlashImages.getImageDescriptor(string)) != null) {
            image = imageDescriptor.createImage(true);
            imageMap.put(string, image);
        }
        return image;
    }

    public static Image getImage(String string, String string2, Point point) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = String.valueOf(string) + "|" + string2;
        Image image = imageMap.get(string3);
        if (image == null) {
            ImageDescriptor imageDescriptor;
            ImageDescriptor imageDescriptor2 = FlashImages.getImageDescriptor(string);
            if (imageDescriptor2 != null && (imageDescriptor = FlashImages.getImageDescriptor(string2)) != null) {
                imageDescriptor2 = new OverlayIcon(imageDescriptor2, imageDescriptor, point);
                image = imageDescriptor2.createImage(true);
            }
            imageMap.put(string3, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.flash", (String)string);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return GuiImages.getImageDescriptor((String)string);
    }

    public static String flashIcon(String string) {
        return FlashImages.getFilename(FLASH_TYPE, string);
    }

    public static String getFilename(String string, String string2) {
        String string3 = MessageFormat.format((String)string, (Object[])new Object[]{string2.toLowerCase()});
        if (FlashImages.getImageDescriptor(string3) != null) {
            return string3;
        }
        DebugPrintUtil.devOrDebugPrintln((Object)("Missing Flash icon " + string3));
        return null;
    }
}

