/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32.comclutch;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.actf.util.win32.comclutch.IResource;

public class ResourceManager {
    private final ResourceManager parent;
    private ArrayList<ResourceManager> childRMs;
    private static final int HASHSIZE = 8191;
    private WeakReference<IResource>[] resourceHashArray = new WeakReference[8191];

    public IResource findInResource(long l) {
        int n = (int)l % 8191;
        WeakReference<IResource> weakReference = this.resourceHashArray[n];
        if (weakReference == null) {
            return null;
        }
        IResource iResource = (IResource)weakReference.get();
        if (iResource == null) {
            return null;
        }
        if (iResource.getPtr() == l) {
            return iResource;
        }
        return null;
    }

    public void releaseAll(IResource iResource) {
        int n = this.resourceHashArray.length;
        int n2 = 0;
        while (n2 < n) {
            WeakReference<IResource> weakReference = this.resourceHashArray[n2];
            if (weakReference != null) {
                this.resourceHashArray[n2] = null;
                IResource iResource2 = (IResource)weakReference.get();
                if (iResource2 != null) {
                    iResource2.release();
                }
            }
            ++n2;
        }
        this.addResource(iResource);
        if (this.childRMs != null) {
            Iterator<ResourceManager> iterator = this.childRMs.iterator();
            while (iterator.hasNext()) {
                iterator.next().releaseAll(iResource);
            }
        }
    }

    public void removeResource(IResource iResource) {
        long l = iResource.getPtr();
        int n = (int)l % 8191;
        WeakReference<IResource> weakReference = this.resourceHashArray[n];
        if (weakReference == null) {
            return;
        }
        IResource iResource2 = (IResource)weakReference.get();
        if (iResource2 == null) {
            this.resourceHashArray[n] = null;
            return;
        }
        if (iResource2.getPtr() != l) {
            return;
        }
        this.resourceHashArray[n] = null;
        weakReference.clear();
    }

    public void addResource(IResource iResource) {
        long l = iResource.getPtr();
        int n = (int)l % 8191;
        WeakReference<IResource> weakReference = new WeakReference<IResource>(iResource);
        this.resourceHashArray[n] = weakReference;
    }

    public static ResourceManager newResourceManager(ResourceManager resourceManager) {
        ResourceManager resourceManager2 = new ResourceManager(resourceManager);
        if (resourceManager != null) {
            if (resourceManager.childRMs == null) {
                resourceManager.childRMs = new ArrayList(1);
            }
            resourceManager.childRMs.add(resourceManager2);
        }
        return resourceManager2;
    }

    private ResourceManager(ResourceManager resourceManager) {
        this.parent = resourceManager;
    }
}

