/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.modelgroup;

import java.util.Hashtable;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.CompositeModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.PlusModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.RepModelGroup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SeqModelGroup
extends CompositeModelGroup {
    public SeqModelGroup(IModelGroup iModelGroup) {
        super(iModelGroup);
    }

    public void add(IModelGroup iModelGroup) {
        if (iModelGroup instanceof SeqModelGroup) {
            SeqModelGroup seqModelGroup = (SeqModelGroup)iModelGroup;
            int n = 0;
            while (n < seqModelGroup.childLength) {
                seqModelGroup.children[n].refer(false);
                this.children[this.childLength++] = seqModelGroup.children[n];
                ++n;
            }
        } else {
            this.children[this.childLength++] = iModelGroup;
            iModelGroup.refer(false);
        }
    }

    public String toString() {
        String string = new String("(");
        int n = 0;
        while (n < this.childLength - 1) {
            string = String.valueOf(string) + this.children[n] + ',';
            ++n;
        }
        string = String.valueOf(string) + this.children[this.childLength - 1] + ')';
        return string;
    }

    public boolean match(ISGMLParser iSGMLParser, Node node, Node node2) {
        Hashtable<Node, Integer> hashtable = iSGMLParser.getSeqMap();
        Integer n = hashtable.get(node);
        int n2 = n == null ? 0 : n;
        int n3 = 0;
        IModelGroup[] iModelGroupArray = iSGMLParser.getSeqArray();
        int n4 = 0;
        while (n2 < this.childLength) {
            IModelGroup iModelGroup = this.children[n2];
            if (iModelGroup.match(iSGMLParser, node, node2)) {
                if (!(iModelGroup instanceof PlusModelGroup) && !(iModelGroup instanceof RepModelGroup)) {
                    ++n2;
                }
                if (n4 > 0) {
                    iSGMLParser.error(7, "Order of " + node + "'s children is wrong.");
                }
                hashtable.put(node, new Integer(n2));
                return true;
            }
            if (iModelGroup.optional()) {
                ++n2;
                continue;
            }
            if (n3 < 2) {
                iModelGroupArray[n4++] = iModelGroup;
                ++n3;
                ++n2;
                continue;
            }
            System.out.println("match: false");
            return false;
        }
        Node node3 = node.getLastChild();
        if (node3 instanceof Element && node2 instanceof Element && node3.getNodeName().equalsIgnoreCase(node2.getNodeName()) && iSGMLParser.autoGenerated((Element)node3)) {
            while (node3.hasChildNodes()) {
                Node node4 = node3.getFirstChild();
                node3.removeChild(node4);
                node2.appendChild(node4);
            }
            node.replaceChild(node2, node3);
            return true;
        }
        return false;
    }

    public boolean optional() {
        int n = this.childLength - 1;
        while (n >= 0) {
            if (!this.children[n].optional()) {
                return false;
            }
            --n;
        }
        return true;
    }
}

