/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.image.BufferedImage;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.BlurOp;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.CVDOp;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ColorFilterOp;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.GlareOp;

public class LowVisionFilter {
    LowVisionType type = null;
    Vector<String> simVector = new Vector();
    private static final String TYPE_SENIOR_FILTER = "senior_color";
    private static final String TYPE_CVD = "color";
    private static final String TYPE_EYESIGHT = "focus";
    private static final String TYPE_GLARE = "glare";

    public LowVisionFilter(LowVisionType lowVisionType) {
        this.type = lowVisionType;
        if (this.type.countTypes() > 0) {
            if (this.type.doColorFilter()) {
                this.simVector.addElement(TYPE_SENIOR_FILTER);
            }
            if (this.type.doGlare()) {
                this.simVector.addElement(TYPE_GLARE);
            }
            if (this.type.doCVD()) {
                this.simVector.addElement(TYPE_CVD);
            }
            if (this.type.doEyesight()) {
                this.simVector.addElement(TYPE_EYESIGHT);
            }
        }
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) throws LowVisionException {
        if (this.type == null) {
            throw new LowVisionException("LowVisionType must be provided.");
        }
        try {
            int n = this.simVector.size();
            if (n > 1) {
                BufferedImage bufferedImage3 = this.oneFilter(this.simVector.elementAt(0), bufferedImage, null);
                int n2 = 1;
                while (n2 < n - 1) {
                    BufferedImage bufferedImage4;
                    String string = this.simVector.elementAt(n2);
                    bufferedImage3 = bufferedImage4 = this.oneFilter(string, bufferedImage3, null);
                    ++n2;
                }
                String string = this.simVector.elementAt(n - 1);
                return this.oneFilter(string, bufferedImage3, bufferedImage2);
            }
            if (n == 1) {
                return this.oneFilter(this.simVector.elementAt(0), bufferedImage, bufferedImage2);
            }
            return bufferedImage;
        }
        catch (ColorException colorException) {
            colorException.printStackTrace();
            throw new LowVisionException("ColorException occurred while filtering.");
        }
    }

    private BufferedImage oneFilter(String string, BufferedImage bufferedImage, BufferedImage bufferedImage2) throws LowVisionException, ColorException {
        if (string.equals(TYPE_SENIOR_FILTER)) {
            ColorFilterOp colorFilterOp = new ColorFilterOp();
            colorFilterOp.setRatio(this.type.getColorFilterRGB());
            return colorFilterOp.filter(bufferedImage, bufferedImage2);
        }
        if (string.equals(TYPE_GLARE)) {
            GlareOp glareOp = new GlareOp(this.type.getGlareDegree());
            return glareOp.filter(bufferedImage, bufferedImage2);
        }
        if (string.equals(TYPE_CVD)) {
            CVDOp cVDOp = new CVDOp(this.type.getCVDType());
            return cVDOp.filter(bufferedImage, bufferedImage2);
        }
        if (string.equals(TYPE_EYESIGHT)) {
            BlurOp blurOp = new BlurOp(this.type);
            return blurOp.filter(bufferedImage, bufferedImage2);
        }
        throw new LowVisionException("Unknown type: " + string);
    }
}

