/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import java.util.Stack;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.util.win32.HighlightComposite;
import org.eclipse.actf.util.win32.OverlayLabel;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.util.AccessiblePropertyUtil;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.preferences.GuiPreferenceManager;
import org.eclipse.actf.visualization.gui.ui.actions.HideHtmlAction;
import org.eclipse.actf.visualization.gui.ui.actions.RefreshRootAction;
import org.eclipse.actf.visualization.gui.ui.actions.ShowOffscreenAction;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAOutlineView;
import org.eclipse.actf.visualization.gui.ui.views.IMSAAProblemsView;
import org.eclipse.actf.visualization.gui.ui.views.MSAATreeContentProvider;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class MSAAOutlineView
extends ViewPart
implements IMSAAOutlineView {
    public static Color FLASH_COLOR = Display.getCurrent().getSystemColor(13);
    public static Color INVISIBLE_FLASH_COLOR = Display.getCurrent().getSystemColor(3);
    private TreeViewer viewer;
    private Action expandAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private RefreshRootAction refreshAction;
    private HideHtmlAction hideHtmlAction;
    private ShowOffscreenAction showOffscreenAction;
    private Action runCheckerAction;
    private Action showLabelsAction;
    private boolean suppressLabelAdjust = false;
    private boolean ignoreSelection = false;

    public void createPartControl(Composite composite) {
        this.viewer = new TreeViewer(composite, 772);
        this.viewer.setContentProvider((IContentProvider)MSAATreeContentProvider.getDefault());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MSAATreeLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (object != null) {
                        if (!MSAAOutlineView.this.ignoreSelection) {
                            MSAAViewRegistory.outlineSelected(object);
                        }
                        if (!MSAAOutlineView.this.suppressLabelAdjust && MSAAOutlineView.this.showLabelsAction.isChecked()) {
                            MSAAOutlineView.this.showOverlayLabels();
                        }
                    } else {
                        HighlightComposite.show((boolean)false);
                    }
                }
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                MSAAOutlineView.this.refreshLabels();
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                MSAAOutlineView.this.refreshLabels();
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        MSAAViewRegistory.refreshRootObject();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MSAAViewRegistory.showView(IGuiViewIDs.ID_EVENTVIEW, false);
            }
        });
        HighlightComposite.initOverlayWindow();
    }

    private void refreshLabels() {
        if (this.showLabelsAction.isChecked()) {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MSAAOutlineView.this.showOverlayLabels();
                }
            });
        }
    }

    public void refresh() {
        OverlayLabel.removeAll();
        AccessibleObject accessibleObject = MSAAViewRegistory.getRootObject();
        if (accessibleObject != null) {
            this.ignoreSelection = true;
            try {
                try {
                    this.viewer.setInput((Object)accessibleObject);
                    AccessibleObject accessibleObject2 = MSAAViewRegistory.adjustSelection(accessibleObject);
                    if (accessibleObject2 != null) {
                        this.viewer.setSelection((ISelection)new StructuredSelection((Object)accessibleObject2));
                        if (accessibleObject2.getChildCount() < 100) {
                            this.viewer.setExpandedState((Object)accessibleObject2, true);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.ignoreSelection = false;
                }
            }
            finally {
                this.ignoreSelection = false;
            }
        }
    }

    public void setSelection(Object object) {
        StructuredSelection structuredSelection = StructuredSelection.EMPTY;
        if (object instanceof AccessibleObject) {
            Stack<AccessibleObject> stack = new Stack<AccessibleObject>();
            AccessibleObject accessibleObject = (AccessibleObject)object;
            while ((accessibleObject = accessibleObject.getCachedParent()) != null && !this.viewer.getExpandedState((Object)accessibleObject)) {
                stack.push(accessibleObject);
            }
            while (!stack.isEmpty()) {
                this.viewer.setExpandedState(stack.pop(), true);
            }
            structuredSelection = new StructuredSelection(object);
        }
        this.viewer.setSelection((ISelection)structuredSelection, true);
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                MSAAOutlineView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.showOffscreenAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.hideHtmlAction);
        iMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                MSAAOutlineView.this.showOffscreenAction.adjust();
                MSAAOutlineView.this.hideHtmlAction.adjust();
            }
        });
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.showLabelsAction);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        Object object = this.getSelectedItem();
        if (object != null) {
            iMenuManager.add((IAction)this.expandAction);
        }
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.runCheckerAction);
        iMenuManager.add((IAction)this.refreshAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.expandAllAction);
        iToolBarManager.add((IAction)this.collapseAllAction);
        iToolBarManager.add((IAction)this.refreshAction);
        iToolBarManager.add((IAction)this.runCheckerAction);
        iToolBarManager.add((IAction)this.showLabelsAction);
    }

    private void makeActions() {
        Shell shell = this.getViewSite().getShell();
        this.expandAction = new Action(Messages.msaa_expand){

            public void run() {
                try {
                    Object object = MSAAOutlineView.this.getSelectedItem();
                    if (object != null) {
                        MSAAOutlineView.this.viewer.expandToLevel(object, -1);
                    }
                }
                catch (Error error) {
                    error.printStackTrace();
                }
            }
        };
        this.expandAllAction = new Action(Messages.msaa_expand_all){

            public void run() {
                try {
                    MSAAOutlineView.this.viewer.expandAll();
                }
                catch (Error error) {
                    error.printStackTrace();
                }
            }
        };
        this.expandAllAction.setToolTipText(Messages.msaa_expand_all);
        this.expandAllAction.setImageDescriptor(GuiImages.IMAGE_EXPAND_ALL);
        this.collapseAllAction = new Action(Messages.msaa_collapse_all){

            public void run() {
                try {
                    MSAAOutlineView.this.viewer.collapseAll();
                }
                catch (Error error) {
                    error.printStackTrace();
                }
            }
        };
        this.collapseAllAction.setToolTipText(Messages.msaa_collapse_all);
        this.collapseAllAction.setImageDescriptor(GuiImages.IMAGE_COLLAPSE_ALL);
        this.refreshAction = new RefreshRootAction();
        this.hideHtmlAction = new HideHtmlAction();
        this.showOffscreenAction = new ShowOffscreenAction();
        this.runCheckerAction = new Action(Messages.msaa_checker){

            public void run() {
                IMSAAProblemsView iMSAAProblemsView = (IMSAAProblemsView)MSAAViewRegistory.showView(IGuiViewIDs.ID_REPORTVIEW, true);
                if (iMSAAProblemsView != null) {
                    iMSAAProblemsView.refresh();
                }
            }
        };
        this.runCheckerAction.setToolTipText(Messages.msaa_checker_tip);
        this.runCheckerAction.setImageDescriptor(GuiImages.IMAGE_CHECKER);
        this.showLabelsAction = new Action(Messages.msaa_show_tree, 2){

            public void run() {
                MSAAOutlineView.this.showOverlayLabels();
            }
        };
        this.showLabelsAction.setToolTipText(Messages.msaa_show_tree);
        this.showLabelsAction.setImageDescriptor(GuiImages.IMAGE_OVERLAY);
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent shellEvent) {
                if (IGuiViewIDs.ID_OUTLINEVIEW.equals(OverlayLabel.getOwnerId())) {
                    MSAAOutlineView.this.showOverlayLabels();
                }
            }

            public void shellDeactivated(ShellEvent shellEvent) {
                if (IGuiViewIDs.ID_OUTLINEVIEW.equals(OverlayLabel.getOwnerId())) {
                    OverlayLabel.removeAll((boolean)false);
                }
            }
        });
        this.showLabelsAction.setEnabled(GuiPreferenceManager.getPreferenceBoolean("UseOverlayWindow"));
        IPreferenceStore iPreferenceStore = GuiPreferenceManager.getPreferenceStore();
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("UseOverlayWindow".equals(propertyChangeEvent.getProperty())) {
                    MSAAOutlineView.this.showLabelsAction.setEnabled(GuiPreferenceManager.getPreferenceBoolean("UseOverlayWindow"));
                }
            }
        });
    }

    private void showOverlayLabels() {
        OverlayLabel.removeAll();
        if (this.showLabelsAction.isChecked()) {
            new LabelOverlay().showLabels(this.viewer.getTree().getSelection());
            OverlayLabel.setOwnerId((String)IGuiViewIDs.ID_OUTLINEVIEW);
        }
    }

    private void showSelectionMenu(OverlayLabel[] overlayLabelArray, OverlayLabel overlayLabel) {
        Menu menu = overlayLabel.createPopupMenu();
        MenuItem[] menuItemArray = new MenuItem[overlayLabelArray.length];
        int n = 0;
        while (n < overlayLabelArray.length) {
            menuItemArray[n] = new MenuItem(menu, 8);
            menuItemArray[n].setText(overlayLabelArray[n].getMenuText());
            menuItemArray[n].setImage(overlayLabelArray[n].getImage());
            menuItemArray[n].setData(overlayLabelArray[n].associatedObject);
            menuItemArray[n].addArmListener(new ArmListener(){

                public void widgetArmed(ArmEvent armEvent) {
                    Object object = ((MenuItem)armEvent.getSource()).getData();
                    if (object instanceof AccessibleObject) {
                        HighlightComposite.flashRectangle((Rectangle)((AccessibleObject)object).getAccLocation());
                    }
                }
            });
            menuItemArray[n].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Object object = ((MenuItem)selectionEvent.getSource()).getData();
                    MSAAOutlineView.this.suppressLabelAdjust = true;
                    MSAAOutlineView.this.viewer.setSelection((ISelection)new StructuredSelection(object));
                    MSAAOutlineView.this.suppressLabelAdjust = false;
                }
            });
            ++n;
        }
        menu.setVisible(true);
    }

    private Object getSelectedItem() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        if (iStructuredSelection.size() == 1) {
            return iStructuredSelection.getFirstElement();
        }
        return null;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public static String getTreeText(Object object) {
        if (object instanceof AccessibleObject) {
            AccessibleObject accessibleObject = (AccessibleObject)object;
            try {
                String string = accessibleObject.getAccName();
                if (string == null || string.length() == 0) {
                    switch (accessibleObject.getAccRole()) {
                        case 1044: 
                        case 1054: {
                            string = accessibleObject.getAccValue();
                        }
                    }
                }
                if (string == null || string.length() == 0) {
                    string = Messages.msaa_NAMELESS;
                    String string2 = accessibleObject.getRoleText();
                    if (string2 != null) {
                        string = String.valueOf(string) + " (" + string2 + ")";
                    }
                }
                return string;
            }
            catch (Exception exception) {
                return exception.getMessage();
            }
        }
        return object.toString();
    }

    private Color getFlashBackground(AccessibleObject accessibleObject) {
        switch (accessibleObject.getAccRole()) {
            case 9: {
                if (!FlashMSAAUtil.isFlash((int)accessibleObject.getPtr())) break;
                return FLASH_COLOR;
            }
            case 10: {
                if (!FlashMSAAUtil.isInvisibleFlash((int)accessibleObject.getPtr())) break;
                return INVISIBLE_FLASH_COLOR;
            }
        }
        return null;
    }

    private class LabelOverlay {
        int index = 0;
        TreeItem currentItem = null;

        private LabelOverlay() {
        }

        public void showLabels(TreeItem[] treeItemArray) {
            if (treeItemArray.length == 1) {
                this.currentItem = treeItemArray[0];
                TreeItem treeItem = this.currentItem.getParentItem();
                if (treeItem != null) {
                    treeItemArray = treeItem.getItems();
                }
            }
            this.renderLabels(treeItemArray);
        }

        public void renderLabels(TreeItem[] treeItemArray) {
            int n = 0;
            while (n < treeItemArray.length) {
                OverlayLabel overlayLabel;
                Rectangle rectangle;
                Object object = treeItemArray[n].getData();
                if (object instanceof AccessibleObject && (rectangle = ((AccessibleObject)object).getAccLocation()) != null && (overlayLabel = OverlayLabel.create((Object)object)) != null) {
                    if (treeItemArray[n].equals(this.currentItem)) {
                        overlayLabel.setForeground(overlayLabel.getDisplay().getSystemColor(27));
                        overlayLabel.setBackground(overlayLabel.getDisplay().getSystemColor(26));
                    }
                    MSAATreeLabelProvider mSAATreeLabelProvider = (MSAATreeLabelProvider)MSAAOutlineView.this.viewer.getLabelProvider();
                    overlayLabel.setImage(mSAATreeLabelProvider.getImage(object));
                    overlayLabel.setText("" + this.index);
                    String string = "[" + this.index + "] " + mSAATreeLabelProvider.getText(object);
                    String[][] stringArray = AccessiblePropertyUtil.getPropertyStrings(object);
                    overlayLabel.setTooltop(string, stringArray);
                    overlayLabel.pack();
                    overlayLabel.setLocation(rectangle.x, rectangle.y);
                    ++this.index;
                    overlayLabel.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent mouseEvent) {
                            if (mouseEvent.widget instanceof OverlayLabel) {
                                OverlayLabel[] overlayLabelArray = OverlayLabel.getLabelsAtPosition((Point)mouseEvent.display.getCursorLocation());
                                if (overlayLabelArray.length > 0) {
                                    MSAAOutlineView.this.showSelectionMenu(overlayLabelArray, (OverlayLabel)mouseEvent.widget);
                                } else {
                                    MSAAOutlineView.this.suppressLabelAdjust = true;
                                    MSAAOutlineView.this.viewer.setSelection((ISelection)new StructuredSelection(((OverlayLabel)mouseEvent.widget).associatedObject));
                                    MSAAOutlineView.this.suppressLabelAdjust = false;
                                }
                            }
                        }
                    });
                    overlayLabel.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                        public void mouseEnter(MouseEvent mouseEvent) {
                            AccessibleObject accessibleObject;
                            if (mouseEvent.widget instanceof OverlayLabel && (accessibleObject = (AccessibleObject)((OverlayLabel)mouseEvent.widget).associatedObject) != null) {
                                HighlightComposite.flashRectangle((Rectangle)accessibleObject.getAccLocation());
                            }
                        }

                        public void mouseExit(MouseEvent mouseEvent) {
                            HighlightComposite.show((boolean)false);
                        }
                    });
                }
                if (treeItemArray[n].getExpanded()) {
                    this.renderLabels(treeItemArray[n].getItems());
                }
                ++n;
            }
        }
    }

    private class MSAATreeLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private Color colorInvisible = Display.getCurrent().getSystemColor(15);

        private MSAATreeLabelProvider() {
        }

        public Image getImage(Object object) {
            Accessible2 accessible2;
            String string = null;
            if (object instanceof AccessibleObject && (string = GuiImages.roleIcon(((AccessibleObject)object).getAccRole())) == null && (accessible2 = ((AccessibleObject)object).getAccessible2()) != null) {
                string = GuiImages.roleIcon("IA2_ROLE_UNKNOWN");
            }
            if (string == null) {
                string = GuiImages.roleIcon("ROLE_UNKNOWN");
            }
            return GuiImages.getImage(string);
        }

        public String getText(Object object) {
            return MSAAOutlineView.getTreeText(object);
        }

        public Color getBackground(Object object) {
            if (object instanceof AccessibleObject) {
                return MSAAOutlineView.this.getFlashBackground((AccessibleObject)object);
            }
            return null;
        }

        public Color getForeground(Object object) {
            int n;
            if (object instanceof AccessibleObject && ((n = ((AccessibleObject)object).getAccState()) & 0x8000) != 0) {
                return this.colorInvisible;
            }
            return null;
        }
    }
}

