/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.ui.internal;

import java.util.ArrayList;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.visualization.blind.ui.internal.PartControlBlind;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.w3c.dom.Node;

public class SelectionListenerBlind
implements ISelectionListener {
    private PartControlBlind prb;

    public SelectionListenerBlind(PartControlBlind partControlBlind) {
        this.prb = partControlBlind;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection == null || !(iSelection instanceof IStructuredSelection)) {
            System.err.println(String.valueOf(this.getClass().getName()) + ":Iselection");
            return;
        }
        IModelService iModelService = ModelServiceUtils.getActiveModelService();
        if (iModelService != null && iModelService instanceof IWebBrowserACTF) {
            ((IWebBrowserACTF)iModelService).clearHighlight();
        }
        this.prb.clearHighlight();
        ArrayList<HighlightTargetId> arrayList = new ArrayList<HighlightTargetId>();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Node node = null;
        for (Object e : iStructuredSelection) {
            if (!(e instanceof IProblemItem)) continue;
            IProblemItem iProblemItem = (IProblemItem)e;
            if (!this.prb.getCheckResult().getProblemList().contains(iProblemItem)) continue;
            node = iProblemItem.getTargetNode();
            if (!iProblemItem.isCanHighlight()) continue;
            HighlightTargetId[] highlightTargetIdArray = iProblemItem.getHighlightTargetIds();
            int n = 0;
            while (n < highlightTargetIdArray.length) {
                arrayList.add(highlightTargetIdArray[n]);
                ++n;
            }
        }
        HighlightTargetId[] highlightTargetIdArray = new HighlightTargetId[arrayList.size()];
        arrayList.toArray(highlightTargetIdArray);
        this.prb.highlight(arrayList);
        if (highlightTargetIdArray.length == 1 && iModelService != null) {
            iModelService.jumpToNode(node);
        }
    }
}

