/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.adesigner.eval.html.internal;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.examples.adesigner.eval.html.internal.FieldsetManager;
import org.eclipse.actf.examples.adesigner.eval.html.internal.LanguageTag;
import org.eclipse.actf.examples.adesigner.eval.html.internal.Messages;
import org.eclipse.actf.examples.adesigner.eval.html.internal.TitleCheckResult;
import org.eclipse.actf.model.dom.dombycom.IDocumentEx;
import org.eclipse.actf.model.dom.dombycom.IStyleSheet;
import org.eclipse.actf.model.dom.dombycom.IStyleSheets;
import org.eclipse.actf.model.dom.html.DocumentTypeUtil;
import org.eclipse.actf.visualization.engines.blind.TextCheckResult;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.actf.visualization.eval.html.HtmlEvalUtil;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetNodeInfo;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.ProblemItemImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLImageElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckEngine
extends HtmlTagUtil {
    private static final String SPACE_STR = " ";
    private static final String WINDOW_OPEN = "window.open";
    public static final int ITEM_COUNT = 1000;
    private static final int QUOTATION_SHORT_NUM = 10;
    private static final int TABLE_CELL_ABBR_CHARS = 30;
    private static final int TABLE_CELL_ABBR_WORDS = 10;
    private static final Pattern COMMENT = Pattern.compile("/\\*.*?\\*/", 34);
    private static final Pattern FIXSIZE_PATTERN = Pattern.compile(".*\\{[^\\}]*font-size(\\p{Space})*:[^;]*(mm|cm|in|pt|pc|px).*\\}.*", 34);
    private static final Pattern FIXSIZE_PATTERN_ATTR = Pattern.compile("font-size(\\p{Space})*:[^;]*(mm|cm|in|pt|pc|px)", 34);
    private static final Pattern BLINK_PATTERN = Pattern.compile(".*\\{[^\\}]*text-decoration(\\p{Space})*:[^;]*blink.*\\}.*", 34);
    private static final Pattern BLINK_PATTERN_ATTR = Pattern.compile("text-decoration(\\p{Space})*:[^;]*blink.*", 34);
    private static final Pattern BEFORE_PATTERN = Pattern.compile(".*:before(\\p{Space})*\\{[^\\}]*content(\\p{Space})*:.*\\}.*", 34);
    private static final Pattern AFTER_PATTERN = Pattern.compile(".*:after(\\p{Space})*\\{[^\\}]*content(\\p{Space})*:.*\\}.*", 34);
    private static final String CSS_COLORS = "(aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen|ActiveBorder|ActiveCaption|AppWorkspace|Background|ButtonFace|ButtonHighlight|ButtonShadow|ButtonText|CaptionText|GrayText|Highlight|HighlightText|InactiveBorder|InactiveCaption|InactiveCaptionText|InfoBackground|InfoText|Menu|MenuText|Scrollbar|ThreeDDarkShadow|ThreeDFace|ThreeDHighlight|ThreeDLightShadow|ThreeDShadow|Window|WindowFrame|WindowText|inherit|currentColor|rgb[a]?\\(.*\\)|hsl[a]?\\(.*\\)|#[a-f0-9]{3}|#[a-f0-9]{6})";
    private static final Pattern STYLEITEM = Pattern.compile(".*?\\{.*?\\}", 32);
    private static final Pattern COLOR = Pattern.compile("\\{(.*[^-]+)?color(\\p{Space})*:.*\\}", 34);
    private static final Pattern BGCOLOR = Pattern.compile("\\{.*background-color(\\p{Space})*:.*\\}", 34);
    private static final Pattern BGCOLOR2 = Pattern.compile("\\{.*background(\\p{Space})*:.*(aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen|ActiveBorder|ActiveCaption|AppWorkspace|Background|ButtonFace|ButtonHighlight|ButtonShadow|ButtonText|CaptionText|GrayText|Highlight|HighlightText|InactiveBorder|InactiveCaption|InactiveCaptionText|InfoBackground|InfoText|Menu|MenuText|Scrollbar|ThreeDDarkShadow|ThreeDFace|ThreeDHighlight|ThreeDLightShadow|ThreeDShadow|Window|WindowFrame|WindowText|inherit|currentColor|rgb[a]?\\(.*\\)|hsl[a]?\\(.*\\)|#[a-f0-9]{3}|#[a-f0-9]{6}).*\\}", 34);
    private static final Pattern COLOR_ATTR = Pattern.compile("(((.*[^\\-]+)color)|(\\p{Space})*color)(\\p{Space})*:.*", 34);
    private static final Pattern BGCOLOR_ATTR = Pattern.compile(".*background-color(\\p{Space})*:.*", 34);
    private static final Pattern BGCOLOR2_ATTR = Pattern.compile(".*background(\\p{Space})*:.*(aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen|ActiveBorder|ActiveCaption|AppWorkspace|Background|ButtonFace|ButtonHighlight|ButtonShadow|ButtonText|CaptionText|GrayText|Highlight|HighlightText|InactiveBorder|InactiveCaption|InactiveCaptionText|InfoBackground|InfoText|Menu|MenuText|Scrollbar|ThreeDDarkShadow|ThreeDFace|ThreeDHighlight|ThreeDLightShadow|ThreeDShadow|Window|WindowFrame|WindowText|inherit|currentColor|rgb[a]?\\(.*\\)|hsl[a]?\\(.*\\)|#[a-f0-9]{3}|#[a-f0-9]{6}).*", 34);
    private static final String[] ASCII_ART_CHAR = new String[]{"\u2227", "\uff3f", "\uffe3", "\uff20", "\uff0f", "\uff3c", "\u03b3", "\u03a6", "\u2229", "\u222a", "\u03b9", "\uff2f", "\u2282", "\uff9f", "\u0414", "\u03c3", "\uff65", "\u2200", "\u2211", "i", "o", "0", "_", "\uff3f", "\uffe3", "\u00b4", "\uff40", "\u30fe"};
    private static Set<String> artCharSet = new HashSet<String>();
    private static Method[] checkMethods;
    private static Method[] mobileCheckMethods;
    private static final String[] AUDIO_FILE_EXTENSION;
    private static final String[] MULTIMEDIA_FILE_EXTENSION;
    private static final boolean DEBUG = false;
    private Set<String> blockEleSet = HtmlTagUtil.getBlockElementSet();
    private Document target;
    private Document resultDoc;
    private URL baseUrl;
    private Map<Node, Integer> document2IdMap;
    private boolean isDBCS;
    private Vector<IProblemItem> result;
    private boolean[] items;
    private int validate_str_len;
    private int valid_total_text_len;
    private boolean hasAwithHref = false;
    private Element[] aWithHref_elements;
    private String[] aWithHref_hrefs;
    private String[] aWithHref_strings;
    private HTMLImageElement[] img_elements;
    private Element[] table_elements;
    private Element[] body_elements;
    private Element[] frame_elements;
    private Element[] iframe_elements;
    private Element[] object_elements;
    private Element[] embed_elements;
    private Element[] parent_table_elements;
    private Element[] bottom_data_tables;
    private Element[] bottom_1row1col_tables;
    private Element[] bottom_notdata_tables;
    private Element[] headings;
    private double invalidLinkRatio;
    private boolean isXHTML = false;
    private List<Element> labelList;
    private List<Element> formList;
    private Vector<Node> formVwithText;
    private List<Element> layoutTableList;
    private List<Element> dataTableList;
    private TextChecker checker;
    private List<Element> elementsWithStyleList;
    private Map<Element, String> styleElementMap = new HashMap<Element, String>();
    private int liveObject = 0;
    private int liveEmbed = 0;
    private HtmlEvalUtil edu;
    private String docTypeS;
    private Map<IStyleSheet, String> styleSheetsMap = new HashMap<IStyleSheet, String>();

    static {
        int n = 0;
        while (n < ASCII_ART_CHAR.length) {
            artCharSet.add(ASCII_ART_CHAR[n]);
            ++n;
        }
        Method[] methodArray = CheckEngine.class.getDeclaredMethods();
        checkMethods = new Method[1000];
        mobileCheckMethods = new Method[1000];
        Method[] methodArray2 = methodArray;
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            Method method = methodArray2[n3];
            String string = method.getName();
            if (string.startsWith("item_")) {
                try {
                    n4 = Integer.parseInt(string.substring(5));
                    CheckEngine.checkMethods[n4] = method;
                }
                catch (Exception exception) {}
            } else if (string.startsWith("mobile_")) {
                try {
                    n4 = Integer.parseInt(string.substring(7));
                    CheckEngine.mobileCheckMethods[n4] = method;
                }
                catch (Exception exception) {}
            }
            ++n3;
        }
        AUDIO_FILE_EXTENSION = new String[]{"mp3", "mid", "mrm", "mrl", "vqf", "wav"};
        MULTIMEDIA_FILE_EXTENSION = new String[]{"avi", "ram", "rm", "asf", "wm", "wmx", "wmv", "asx", "mpeg", "mpg"};
    }

    public CheckEngine(HtmlEvalUtil htmlEvalUtil, boolean[] blArray) {
        Node node;
        Object object;
        this.edu = htmlEvalUtil;
        this.target = htmlEvalUtil.getTarget();
        this.resultDoc = htmlEvalUtil.getResult();
        Document document = htmlEvalUtil.getLiveDom();
        if (document instanceof IDocumentEx) {
            object = ((IDocumentEx)document).getStyleSheets();
            this.prepStyleSheets((IStyleSheets)object);
            this.liveObject = document.getElementsByTagName("object").getLength();
            this.liveEmbed = document.getElementsByTagName("embed").getLength();
        }
        this.baseUrl = htmlEvalUtil.getBaseUrl();
        this.invalidLinkRatio = 0.0;
        this.items = blArray;
        this.document2IdMap = htmlEvalUtil.getDocument2IdMap();
        this.isDBCS = htmlEvalUtil.isDBCS();
        if (this.isDBCS) {
            this.validate_str_len = 20;
            this.valid_total_text_len = 50;
        } else {
            this.validate_str_len = 50;
            this.valid_total_text_len = 100;
        }
        this.result = new Vector();
        this.hasAwithHref = htmlEvalUtil.isHasAwithHref();
        this.aWithHref_elements = htmlEvalUtil.getAWithHref_elements();
        this.aWithHref_hrefs = htmlEvalUtil.getAWithHref_hrefs();
        this.aWithHref_strings = htmlEvalUtil.getAWithHref_strings();
        this.img_elements = htmlEvalUtil.getImg_elements();
        this.table_elements = htmlEvalUtil.getTable_elements();
        this.bottom_data_tables = htmlEvalUtil.getBottom_data_tables();
        this.bottom_1row1col_tables = htmlEvalUtil.getBottom_1row1col_tables();
        this.bottom_notdata_tables = htmlEvalUtil.getBottom_notdata_tables();
        this.parent_table_elements = htmlEvalUtil.getParent_table_elements();
        this.layoutTableList = new ArrayList<Element>();
        this.layoutTableList.addAll(Arrays.asList(this.parent_table_elements));
        this.layoutTableList.addAll(Arrays.asList(this.bottom_1row1col_tables));
        this.layoutTableList.addAll(Arrays.asList(this.bottom_notdata_tables));
        this.dataTableList = new ArrayList<Element>();
        this.dataTableList.addAll(Arrays.asList(this.bottom_data_tables));
        assert (this.table_elements.length == this.layoutTableList.size() + this.dataTableList.size());
        this.body_elements = htmlEvalUtil.getBody_elements();
        this.frame_elements = htmlEvalUtil.getFrame_elements();
        this.iframe_elements = htmlEvalUtil.getIframe_elements();
        this.object_elements = htmlEvalUtil.getObject_elements();
        this.embed_elements = htmlEvalUtil.getEmbed_elements();
        this.formList = htmlEvalUtil.getElementsList((Node)this.target, "form", new String[0]);
        this.elementsWithStyleList = htmlEvalUtil.getElementsWithStyle();
        object = htmlEvalUtil.getStyleElements();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            node = (Element)iterator.next();
            if (!node.hasChildNodes()) continue;
            Node node2 = node.getFirstChild();
            String string = node2.getNodeValue();
            String[] stringArray = COMMENT.split(string);
            String string2 = "";
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = stringArray2[n2];
                string2 = String.valueOf(string2) + string3;
                ++n2;
            }
            this.styleElementMap.put((Element)node, string2);
        }
        this.headings = htmlEvalUtil.getHeadings();
        node = this.target.getDoctype();
        this.docTypeS = DocumentTypeUtil.getOriginalID((DocumentType)node);
        if (this.docTypeS.indexOf("XHTML") > 0) {
            this.isXHTML = true;
        }
        this.checker = TextChecker.getInstance();
    }

    private void prepStyleSheets(IStyleSheets iStyleSheets) {
        if (iStyleSheets != null) {
            int n = 0;
            while (n < iStyleSheets.getLength()) {
                IStyleSheet iStyleSheet = iStyleSheets.item(n);
                this.styleSheetsMap.put(iStyleSheet, iStyleSheet.getCssText());
                this.prepStyleSheets(iStyleSheet.getImports());
                ++n;
            }
        }
    }

    public Vector<IProblemItem> check() {
        this.validateHtml();
        Object[] objectArray = null;
        int n = 0;
        while (n < this.items.length) {
            if (this.items[n] && checkMethods[n] != null) {
                try {
                    checkMethods[n].invoke((Object)this, objectArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        if (this.items.length < 90 || !this.items[89]) {
            this.item_89();
        }
        this.formCheck();
        this.styleCheck();
        this.mediaCheck();
        this.always();
        n = 0;
        while (n < mobileCheckMethods.length) {
            if (mobileCheckMethods[n] != null) {
                try {
                    mobileCheckMethods[n].invoke((Object)this, objectArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        this.edu.getPageData().setInvalidLinkRatio(this.invalidLinkRatio);
        return this.result;
    }

    private IProblemItem addCheckerProblem(String string) {
        ProblemItemImpl problemItemImpl = new ProblemItemImpl(string);
        this.result.add((IProblemItem)problemItemImpl);
        return problemItemImpl;
    }

    private IProblemItem addCheckerProblem(String string, String string2) {
        ProblemItemImpl problemItemImpl = new ProblemItemImpl(string);
        problemItemImpl.setTargetString(string2);
        this.result.add((IProblemItem)problemItemImpl);
        return problemItemImpl;
    }

    private IProblemItem addCheckerProblem(String string, Element element) {
        return this.addCheckerProblem(string, "", element);
    }

    private IProblemItem addCheckerProblem(String string, String string2, Element element) {
        ProblemItemImpl problemItemImpl = new ProblemItemImpl(string, (Node)element);
        problemItemImpl.setHighlightTargetNodeInfo(new HighlightTargetNodeInfo((Node)element));
        problemItemImpl.setTargetString(string2);
        this.result.add((IProblemItem)problemItemImpl);
        return problemItemImpl;
    }

    private IProblemItem addCheckerProblem(String string, Element element, Element element2) {
        ProblemItemImpl problemItemImpl = new ProblemItemImpl(string, (Node)element);
        problemItemImpl.setHighlightTargetNodeInfo(new HighlightTargetNodeInfo((Node)element, (Node)element2));
        this.result.add((IProblemItem)problemItemImpl);
        return problemItemImpl;
    }

    private IProblemItem addCheckerProblem(String string, String string2, Vector<Node> vector) {
        ProblemItemImpl problemItemImpl = new ProblemItemImpl(string);
        problemItemImpl.setTargetString(string2);
        problemItemImpl.setHighlightTargetNodeInfo(new HighlightTargetNodeInfo(vector));
        this.result.add((IProblemItem)problemItemImpl);
        return problemItemImpl;
    }

    private IProblemItem addCheckerProblem(String string, String string2, NodeList nodeList) {
        Vector<Node> vector = new Vector<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            vector.add(nodeList.item(n));
            ++n;
        }
        return this.addCheckerProblem(string, string2, vector);
    }

    private void item_0() {
        for (Element element : this.edu.getAppletElements()) {
            String string;
            boolean bl = false;
            boolean bl2 = false;
            String string2 = element.getAttribute("alt");
            if (string2.length() > 0) {
                bl = true;
            }
            boolean bl3 = bl2 = (string = CheckEngine.getTextAltDescendant((Node)element)).length() > 0;
            if (!bl) {
                this.addCheckerProblem("C_0.0", element);
            }
            if (bl2) continue;
            this.addCheckerProblem("C_0.1", element);
        }
    }

    private void item_1() {
        int n = 0;
        while (n < this.object_elements.length) {
            Element element = this.object_elements[n];
            if (CheckEngine.getTextAltDescendant((Node)element).trim().length() == 0) {
                this.addCheckerProblem("C_1.1", element);
            }
            ++n;
        }
    }

    private void item_2() {
        String string;
        Element element;
        NodeList nodeList = this.target.getElementsByTagName("input");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            element = (Element)nodeList.item(n2);
            string = element.getAttribute("type");
            if (string != null && string.equalsIgnoreCase("image")) {
                String string2;
                boolean bl;
                try {
                    bl = ((HTMLImageElement)element).getIsMap();
                    string2 = ((HTMLImageElement)element).getUseMap();
                }
                catch (RuntimeException runtimeException) {
                    bl = false;
                    string2 = "";
                }
                if (bl || !string2.equals("")) {
                    this.addCheckerProblem("C_2.0", element);
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.img_elements.length) {
            element = this.img_elements[n2];
            string = ((HTMLImageElement)element).getUseMap();
            if (((HTMLImageElement)element).getIsMap() && string.equals("")) {
                this.addCheckerProblem("C_2.1", element);
                this.addCheckerProblem("C_2.2", element);
            }
            ++n2;
        }
    }

    private void item_3() {
        HTMLImageElement[] hTMLImageElementArray = this.img_elements;
        int n = this.img_elements.length;
        int n2 = 0;
        while (n2 < n) {
            HTMLImageElement hTMLImageElement = hTMLImageElementArray[n2];
            if (hTMLImageElement.hasAttribute("longdesc")) {
                String string = hTMLImageElement.getAttribute("longdesc");
                if (string.length() > 0) {
                    boolean bl = false;
                    int n3 = this.aWithHref_hrefs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string2;
                        if (string.equalsIgnoreCase(this.aWithHref_hrefs[n4]) && (string2 = this.aWithHref_strings[n4]).trim().equalsIgnoreCase("d")) {
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        this.addCheckerProblem("C_3.0", hTMLImageElement);
                    }
                }
                this.addCheckerProblem("C_3.1", hTMLImageElement);
            }
            ++n2;
        }
    }

    private void item_4() {
        Vector<Node> vector = new Vector<Node>();
        int n = 0;
        while (n < this.img_elements.length) {
            String string;
            HTMLImageElement hTMLImageElement = this.img_elements[n];
            if (!(!this.isNormalImage(hTMLImageElement) || !hTMLImageElement.hasAttribute("alt") || this.getWordCount(string = hTMLImageElement.getAttribute("alt")) < 3 && string.length() < this.validate_str_len || string.matches("\\p{ASCII}*") && string.length() <= 30)) {
                vector.add(hTMLImageElement);
            }
            ++n;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_4.0", "", vector);
        }
    }

    private void item_5() {
        int n = this.aWithHref_elements.length;
        int n2 = 0;
        while (n2 < n) {
            Element element = this.aWithHref_elements[n2];
            String string = this.aWithHref_hrefs[n2];
            if (string != null && string.length() > 0) {
                String string2 = this.getFileExtension(string);
                if (this.isAudioFileExt(string2)) {
                    this.addCheckerProblem("C_5.0", element);
                    break;
                }
                if (this.isMultimediaFileExt(string2)) {
                    this.addCheckerProblem("C_5.1", element);
                    this.addCheckerProblem("C_5.2", element);
                    this.addCheckerProblem("C_5.3", element);
                    break;
                }
            }
            ++n2;
        }
    }

    private void item_6() {
        if (this.body_elements.length > 0) {
            Element element = this.body_elements[0];
            Stack<Element> stack = new Stack<Element>();
            Node node = element;
            while (node != null) {
                boolean bl = false;
                if (this.isLeafBlockEle(node) && this.isAsciiArtString(CheckEngine.getTextAltDescendant((Node)node))) {
                    this.addCheckerProblem("C_6.0", (Element)node);
                    this.addCheckerProblem("C_6.1", (Element)node);
                    bl = true;
                }
                if (!bl && node.hasChildNodes()) {
                    stack.push((Element)node);
                    node = node.getFirstChild();
                    continue;
                }
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    continue;
                }
                node = null;
                while (node == null && stack.size() > 0) {
                    node = (Node)stack.pop();
                    node = node.getNextSibling();
                }
            }
        }
    }

    private void item_7() {
        int n = this.aWithHref_elements.length;
        NodeList nodeList = this.target.getElementsByTagName("area");
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            boolean bl = false;
            Element element = (Element)nodeList.item(n3);
            String string = "";
            if (element.hasAttribute("href") && (string = element.getAttribute("href")).length() > 0) {
                int n4 = 0;
                while (n4 < n) {
                    if (string.equalsIgnoreCase(this.aWithHref_hrefs[n4])) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
            }
            if (!bl) {
                this.addCheckerProblem("C_7.0", " (href=\"" + string + "\")");
            }
            ++n3;
        }
    }

    private void item_8() {
        NodeList nodeList = this.target.getElementsByTagName("font");
        Vector<Node> vector = new Vector<Node>();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            if (element.hasAttribute("color") || element.hasAttribute("bgcolor")) {
                String string = element.getAttribute("color");
                String string2 = element.getAttribute("bgcolor");
                if (!string.equals("") || !string2.equals("")) {
                    vector.add(element);
                }
            }
            ++n2;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_8.0", "", vector);
        }
    }

    private void item_9() {
        boolean bl = false;
        int n = 0;
        while (n < this.img_elements.length) {
            HTMLImageElement hTMLImageElement = this.img_elements[n];
            if (this.isNormalImage(hTMLImageElement)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            this.addCheckerProblem("C_9.0");
        }
    }

    private void item_10() {
        this.addCheckerProblem("C_10.0");
    }

    private void item_12() {
        int n = 0;
        while (n < this.parent_table_elements.length) {
            Element element = this.parent_table_elements[n];
            Stack<Node> stack = new Stack<Node>();
            Node node = element.getFirstChild();
            int n2 = 0;
            int n3 = 0;
            String string = "";
            while (node != null) {
                string = node.getNodeName();
                if (node.getNodeType() == 1 && string.equalsIgnoreCase("table") && n3 < ++n2) {
                    n3 = n2;
                }
                if (node.hasChildNodes()) {
                    stack.push(node);
                    node = node.getFirstChild();
                    continue;
                }
                if (node.getNextSibling() != null) {
                    if (node.getNodeType() == 1 && node.getNodeName().equals("table")) {
                        --n2;
                    }
                    node = node.getNextSibling();
                    continue;
                }
                if (node.getNodeType() == 1 && node.getNodeName().equals("table")) {
                    --n2;
                }
                node = null;
                while (node == null && stack.size() > 0) {
                    node = (Node)stack.pop();
                    if (node.getNodeType() == 1 && node.getNodeName().equals("table")) {
                        --n2;
                    }
                    node = node.getNextSibling();
                }
            }
            if (n3 > 0) {
                String string2 = null;
                string2 = n3 == 1 ? Messages.CheckEngine_ChildTable : MessageFormat.format((String)Messages.CheckEngine_TieredChildTable, (Object[])new Object[]{String.valueOf(n3)});
                this.addCheckerProblem("C_12.0", string2, element);
            }
            ++n;
        }
        n = 0;
        while (n < this.bottom_1row1col_tables.length) {
            this.addCheckerProblem("C_12.1", this.bottom_1row1col_tables[n]);
            ++n;
        }
        n = 0;
        while (n < this.bottom_notdata_tables.length) {
            this.addCheckerProblem("C_12.2", this.bottom_notdata_tables[n]);
            ++n;
        }
    }

    private void item_13() {
        NodeList nodeList = this.target.getElementsByTagName("font");
        int n = nodeList.getLength();
        Vector<Node> vector = new Vector<Node>();
        int n2 = 0;
        while (n2 < n) {
            String string;
            Element element = (Element)nodeList.item(n2);
            if (element.hasAttribute("size") && (string = element.getAttribute("size")) != null && string.length() > 0 && string.indexOf("+") == -1 && string.indexOf("-") == -1) {
                vector.add(element);
            }
            ++n2;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_13.0", "", vector);
        }
        this.checkAbsoluteSize("table");
        this.checkAbsoluteSize("tr");
        this.checkAbsoluteSize("td");
        this.checkAbsoluteSize("col");
    }

    private void item_14() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.headings.length) {
            n = this.edu.getHeadingLevel(this.headings[n3].getNodeName());
            if (n > 0) {
                if (n2 > 0 && n - n2 > 1) {
                    String string = MessageFormat.format((String)Messages.CheckEngine_Headings, (Object[])new Object[]{n, n2});
                    Vector<Node> vector = new Vector<Node>();
                    vector.add(this.headings[n3 - 1]);
                    vector.add(this.headings[n3]);
                    this.addCheckerProblem("C_14.0", string, vector);
                }
                n2 = n;
            }
            ++n3;
        }
    }

    private void item_15() {
        Vector<Node> vector = new Vector<Node>();
        int n = 0;
        while (n < this.headings.length) {
            vector.add(this.headings[n]);
            ++n;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_15.0", "", vector);
        }
    }

    private void item_16() {
        NodeList nodeList;
        Element element;
        NodeList nodeList2 = this.target.getElementsByTagName("ol");
        int n = nodeList2.getLength();
        int n2 = 0;
        while (n2 < n) {
            element = (Element)nodeList2.item(n2);
            nodeList = element.getElementsByTagName("li");
            if (nodeList.getLength() == 0) {
                this.addCheckerProblem("C_16.1", element);
            }
            ++n2;
        }
        nodeList2 = this.target.getElementsByTagName("ul");
        n = nodeList2.getLength();
        n2 = 0;
        while (n2 < n) {
            element = (Element)nodeList2.item(n2);
            nodeList = element.getElementsByTagName("li");
            if (nodeList.getLength() == 0) {
                this.addCheckerProblem("C_16.1", element);
            }
            ++n2;
        }
        nodeList2 = this.target.getElementsByTagName("li");
        n = nodeList2.getLength();
        Vector<Node> vector = new Vector<Node>();
        int n3 = 0;
        while (n3 < n) {
            boolean bl = false;
            Node node = nodeList2.item(n3);
            if (!vector.contains(node)) {
                String string = "";
                while (node != null) {
                    string = node.getNodeName();
                    if (string.equalsIgnoreCase("ol") || string.equalsIgnoreCase("ul")) {
                        bl = true;
                        break;
                    }
                    if (string.equalsIgnoreCase("body")) break;
                    node = node.getParentNode();
                }
                if (!bl) {
                    Node node2 = nodeList2.item(n3);
                    Node node3 = nodeList2.item(n3);
                    vector.add(nodeList2.item(n3));
                    Node node4 = nodeList2.item(n3).getPreviousSibling();
                    while (node4 != null) {
                        if (!node4.getNodeName().equalsIgnoreCase("li") || vector.contains(node4)) break;
                        vector.add(node4);
                        node2 = node4;
                        node4 = node4.getPreviousSibling();
                    }
                    Node node5 = nodeList2.item(n3).getNextSibling();
                    while (node5 != null) {
                        if (!node5.getNodeName().equalsIgnoreCase("li") || vector.contains(node5)) break;
                        vector.add(node5);
                        node3 = node5;
                        node5 = node5.getNextSibling();
                    }
                    this.addCheckerProblem("C_16.2", (Element)node2, (Element)node3);
                }
            }
            ++n3;
        }
    }

    private void item_17() {
        Element element;
        Node node;
        boolean bl;
        NodeList nodeList = this.target.getElementsByTagName("q");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            bl = false;
            node = nodeList.item(n2);
            bl = CheckEngine.hasTextDescendant((Node)node);
            if (!bl) {
                element = (Element)node;
                this.addCheckerProblem("C_17.0", element);
            }
            ++n2;
        }
        nodeList = this.target.getElementsByTagName("blockquote");
        n = nodeList.getLength();
        n2 = 0;
        while (n2 < n) {
            bl = false;
            node = nodeList.item(n2);
            bl = CheckEngine.hasTextDescendant((Node)node);
            if (!bl) {
                element = (Element)node;
                this.addCheckerProblem("C_17.0", element);
            }
            ++n2;
        }
        if (n > 0) {
            this.addCheckerProblem("C_17.1", "", nodeList);
        }
    }

    private void item_18() {
        Object object;
        Object object2;
        Node node;
        NodeList nodeList = this.target.getElementsByTagName("q");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            node = nodeList.item(n2);
            object2 = CheckEngine.getTextDescendant((Node)node);
            if (((String)object2).length() > 10) {
                object = (Element)node;
                this.addCheckerProblem("C_18.0", (Element)object);
                object2 = object.getAttribute("cite");
                if (((String)object2).equals("")) {
                    this.addCheckerProblem("C_18.2", (Element)object);
                }
            }
            ++n2;
        }
        nodeList = this.target.getElementsByTagName("blockquote");
        n = nodeList.getLength();
        n2 = 0;
        while (n2 < n) {
            node = nodeList.item(n2);
            object2 = (Element)node;
            object = CheckEngine.getTextDescendant((Node)node);
            if (((String)object).length() <= 10) {
                this.addCheckerProblem("C_18.1", (Element)object2);
            }
            if (((String)(object = object2.getAttribute("cite"))).equals("")) {
                this.addCheckerProblem("C_18.2", (Element)object2);
            }
            ++n2;
        }
    }

    private void item_21() {
        String string;
        Element element = this.target.getDocumentElement();
        String string2 = element.getAttribute(string = this.isXHTML ? "xml:lang" : "lang");
        if (this.isEmptyString(string2)) {
            this.addCheckerProblem("C_21.0", string, element);
        } else {
            LanguageTag languageTag = new LanguageTag(string2, false);
            if (!languageTag.isWellFormed()) {
                this.addCheckerProblem("C_21.1", string, element);
            } else {
                this.addCheckerProblem("C_21.2", string, element);
            }
        }
    }

    private void item_22() {
        if (this.table_elements.length > 0) {
            Vector<Node> vector = new Vector<Node>(Arrays.asList(this.table_elements));
            this.addCheckerProblem("C_22.0", null, vector);
        }
    }

    private void item_23() {
        int n = 0;
        while (n < this.parent_table_elements.length) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            Element element = this.parent_table_elements[n];
            bl2 = element.getAttribute("summary") != null && element.getAttribute("summary").length() > 0;
            bl3 = element.getElementsByTagName("caption").getLength() > 0;
            Stack<Node> stack = new Stack<Node>();
            Node node = element.getFirstChild();
            while (node != null) {
                String string = "";
                string = node.getNodeName();
                if (string.equalsIgnoreCase("th")) {
                    bl = true;
                    break;
                }
                if (node.hasChildNodes() && !string.equalsIgnoreCase("table")) {
                    stack.push(node);
                    node = node.getFirstChild();
                    continue;
                }
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    continue;
                }
                node = null;
                while (node == null && stack.size() > 0) {
                    node = (Node)stack.pop();
                    node = node.getNextSibling();
                }
            }
            if (bl || bl3 || bl2) {
                this.addCheckerProblem("C_23.0", element);
            }
            ++n;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Vector<Node> vector = new Vector<Node>();
        Vector<Node> vector2 = new Vector<Node>();
        for (Element element : this.dataTableList) {
            boolean bl = false;
            if (this.getDirectDescendantElements(element, "th").size() > 0) {
                arrayList.add(element);
                bl = true;
            }
            if (this.getDirectDescendantElements(element, "caption").size() > 0) {
                if (!bl) {
                    arrayList.add(element);
                    bl = true;
                }
                this.addCheckerProblem("C_25.3", element);
            } else {
                vector.add(element);
            }
            if (element.hasAttribute("summary") && !this.isEmptyString(element.getAttribute("summary"))) {
                if (!bl) {
                    arrayList.add(element);
                    bl = true;
                }
                this.addCheckerProblem("C_25.4", element);
                continue;
            }
            vector2.add(element);
        }
        if (arrayList.size() > 0) {
            Vector<Node> vector3 = new Vector<Node>(arrayList);
            this.addCheckerProblem("C_23.1", "", vector3);
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_25.1", null, vector);
        }
        if (vector2.size() > 0) {
            this.addCheckerProblem("C_25.2", null, vector2);
        }
        arrayList.clear();
        for (Element element : this.layoutTableList) {
            if (this.getDirectDescendantElements(element, "th").size() > 0) {
                arrayList.add(element);
                continue;
            }
            if (this.getDirectDescendantElements(element, "caption").size() > 0) {
                arrayList.add(element);
                continue;
            }
            if (!element.hasAttribute("summary") || this.isEmptyString(element.getAttribute("summary"))) continue;
            arrayList.add(element);
        }
        if (arrayList.size() > 0) {
            Vector<Node> vector4 = new Vector<Node>(arrayList);
            this.addCheckerProblem("C_23.2", "", vector4);
        }
    }

    private void item_26() {
        NodeList nodeList = this.target.getElementsByTagName("th");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            String string = CheckEngine.getTextAltDescendant((Node)element);
            if (this.isDBCS) {
                if (string.length() > 30) {
                    this.addCheckerProblem("C_26.0", element);
                }
            } else if (this.getWordCount(string) > 10) {
                this.addCheckerProblem("C_26.0", element);
            }
            ++n2;
        }
    }

    private void item_27() {
        int n = 0;
        while (n < this.frame_elements.length) {
            Element element = this.frame_elements[n];
            String string = element.getAttribute("src");
            if (!this.isHtmlFile(string)) {
                this.addCheckerProblem("C_27.0", "(src=" + string + ")", element);
            }
            ++n;
        }
    }

    private void item_28() {
        NodeList nodeList;
        int n = this.edu.getScript_elements().length;
        if (n > 0 && n > (nodeList = this.target.getElementsByTagName("noscript")).getLength()) {
            this.addCheckerProblem("C_28.0");
        }
    }

    private void item_29() {
        if (this.edu.isHasJavascript() || this.edu.getScript_elements().length > 0) {
            this.addCheckerProblem("C_29.0");
        }
        for (Element element : this.edu.getAppletElements()) {
            this.addCheckerProblem("C_29.2", element);
        }
        int n = 0;
        while (n < this.aWithHref_hrefs.length) {
            String string = this.aWithHref_hrefs[n];
            if (string.toLowerCase().startsWith("javascript:")) {
                this.addCheckerProblem("C_29.1", " (href=\"" + (String)string + "\")", this.aWithHref_elements[n]);
            }
            ++n;
        }
    }

    private void mediaCheck() {
        Object object;
        Vector<Node> vector = new Vector<Node>();
        Element[] elementArray = this.object_elements;
        int n = this.object_elements.length;
        int n2 = 0;
        while (n2 < n) {
            object = elementArray[n2];
            vector.add((Node)object);
            ++n2;
        }
        elementArray = this.embed_elements;
        n = this.embed_elements.length;
        n2 = 0;
        while (n2 < n) {
            object = elementArray[n2];
            vector.add((Node)object);
            ++n2;
        }
        vector.addAll(this.edu.getAppletElements());
        if (vector.size() > 0) {
            this.addCheckerProblem("C_30.0", "", vector);
            this.addCheckerProblem("C_30.1", "", vector);
            this.addCheckerProblem("C_500.0", "", vector);
            this.addCheckerProblem("C_500.1", "", vector);
            this.addCheckerProblem("C_600.1", "", vector);
            this.addCheckerProblem("C_600.2", "", vector);
            this.addCheckerProblem("C_600.6", "", vector);
            this.addCheckerProblem("C_600.7", "", vector);
            this.addCheckerProblem("C_600.16", "", vector);
        }
        if (this.edu.isHasJavascript()) {
            this.addCheckerProblem("C_30.1", "(JavaScript)");
        }
        object = "";
        if (this.object_elements.length < this.liveObject) {
            object = String.valueOf(object) + " object";
        }
        if (this.object_elements.length < this.liveObject) {
            object = String.valueOf(object) + " embed";
        }
        if (((String)object).length() > 0) {
            this.addCheckerProblem("C_30.0", "(" + Messages.Dynamic + (String)object + ")");
            this.addCheckerProblem("C_30.1", "(" + Messages.Dynamic + (String)object + ")");
            this.addCheckerProblem("C_500.0", "(" + Messages.Dynamic + (String)object + ")");
            this.addCheckerProblem("C_500.1", "(" + Messages.Dynamic + (String)object + ")");
            this.addCheckerProblem("C_600.1", "(" + Messages.Dynamic + (String)object + ")");
            this.addCheckerProblem("C_600.2", "(" + Messages.Dynamic + (String)object + ")");
            this.addCheckerProblem("C_600.6", "(" + Messages.Dynamic + (String)object + ")");
            this.addCheckerProblem("C_600.7", "(" + Messages.Dynamic + (String)object + ")");
            this.addCheckerProblem("C_600.16", "(" + Messages.Dynamic + (String)object + ")");
        }
    }

    private void item_31() {
        NodeList nodeList;
        NodeList nodeList2 = this.target.getElementsByTagName("frameset");
        if (nodeList2.getLength() > 0 && (nodeList = this.target.getElementsByTagName("noframes")).getLength() == 0) {
            Element element = (Element)nodeList2.item(0);
            this.addCheckerProblem("C_31.0", element);
        }
    }

    private void item_32() {
        if (this.object_elements.length > 0) {
            this.result.add((IProblemItem)new ProblemItemImpl("C_32.0"));
        } else if (this.edu.getAppletElements().size() > 0) {
            this.result.add((IProblemItem)new ProblemItemImpl("C_32.0"));
        }
    }

    private void item_33() {
        Object object2;
        NodeList nodeList = this.target.getElementsByTagName("blink");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            boolean bl = false;
            object2 = (Element)nodeList.item(n2);
            bl = CheckEngine.hasTextDescendant((Node)object2);
            if (bl) {
                this.addCheckerProblem("C_33.0", (Element)object2);
            }
            ++n2;
        }
        for (Element element : this.elementsWithStyleList) {
            object2 = element.getAttribute("style");
            if (!BLINK_PATTERN_ATTR.matcher((CharSequence)object2).matches()) continue;
            this.addCheckerProblem("C_33.1", "style=\"" + (String)object2 + "\"", element);
        }
        Set<Element> set = this.styleElementMap.keySet();
        for (Element element : set) {
            String string = this.styleElementMap.get(element);
            if (string == null || !BLINK_PATTERN.matcher(string).matches()) continue;
            this.addCheckerProblem("C_33.2", "", element);
        }
        Set<IStyleSheet> set2 = this.styleSheetsMap.keySet();
        for (Object object2 : set2) {
            if (object2.getHref() == null || object2.getHref().length() <= 0 || !BLINK_PATTERN.matcher(this.styleSheetsMap.get(object2)).matches()) continue;
            this.addCheckerProblem("C_33.2", "(" + object2.getHref() + ")");
        }
    }

    private void item_34() {
        NodeList nodeList = this.target.getElementsByTagName("marquee");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            this.addCheckerProblem("C_34.0", element);
            ++n2;
        }
    }

    private void item_35() {
        Vector<Node> vector = new Vector<Node>();
        int n = 0;
        while (n < this.img_elements.length) {
            String string;
            String string2;
            HTMLImageElement hTMLImageElement = this.img_elements[n];
            if (this.isNormalImage(hTMLImageElement) && hTMLImageElement.hasAttribute("src") && (string2 = hTMLImageElement.getAttribute("src")) != null && string2.length() > 0 && (string = this.getFileExtension(string2)).equalsIgnoreCase("gif")) {
                vector.add(hTMLImageElement);
            }
            ++n;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_35.0", "", vector);
        }
    }

    private void item_36() {
        NodeList nodeList = this.target.getElementsByTagName("meta");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string;
            Element element = (Element)nodeList.item(n2);
            if (element.hasAttribute("http-equiv") && (string = element.getAttribute("http-equiv")) != null && string.equalsIgnoreCase("refresh")) {
                String string2 = element.getAttribute("content");
                if (string2 == null || string2.toLowerCase().indexOf("url") < 0) {
                    this.addCheckerProblem("C_36.0", element);
                } else {
                    Matcher matcher = Pattern.compile("(\\d+);.*").matcher(string2);
                    if (matcher.matches() && Integer.parseInt(matcher.group(1)) > 0) {
                        this.addCheckerProblem("C_36.1", element);
                    }
                }
            }
            ++n2;
        }
    }

    private void item_38() {
        Element element;
        Element[] elementArray = this.edu.getEventMouseButtonElements();
        Element[] elementArray2 = this.edu.getEventOnMouseElements();
        HashSet<Element> hashSet = new HashSet<Element>();
        Vector<Node> vector = new Vector<Node>();
        int n = 0;
        while (n < elementArray.length) {
            element = elementArray[n];
            hashSet.add(element);
            if (!(element.hasAttribute("onkeydown") || element.hasAttribute("onkeypress") || element.hasAttribute("onkeyup"))) {
                vector.add(element);
            }
            ++n;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_38.0", "", vector);
        }
        vector.clear();
        n = 0;
        while (n < elementArray2.length) {
            element = elementArray2[n];
            if (hashSet.add(element) && !element.hasAttribute("onfocus") && !element.hasAttribute("onblur") && !element.hasAttribute("onselect")) {
                vector.add(element);
            }
            ++n;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_38.0", "", vector);
        }
    }

    private void item_39() {
        boolean bl = false;
        if (this.body_elements.length > 0) {
            Element element = this.body_elements[0];
            Stack<Element> stack = new Stack<Element>();
            Node node = element;
            while (node != null) {
                String string;
                Element element2;
                if (node.getNodeType() == 1 && (element2 = node).hasAttribute("tabindex") && !(string = element2.getAttribute("tabindex")).equals("")) {
                    bl = true;
                    break;
                }
                if (node.hasChildNodes()) {
                    stack.push((Element)node);
                    node = node.getFirstChild();
                    continue;
                }
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    continue;
                }
                node = null;
                while (node == null && stack.size() > 0) {
                    node = (Node)stack.pop();
                    node = node.getNextSibling();
                }
            }
        }
        if (!bl) {
            this.addCheckerProblem("C_39.0");
        }
    }

    private void item_40() {
        boolean bl = false;
        int n = 0;
        while (n < this.aWithHref_elements.length) {
            String string;
            Element element = this.aWithHref_elements[n];
            if (element.hasAttribute("accesskey") && (string = element.getAttribute("accesskey")).length() > 0) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.addCheckerProblem("C_40.0");
        }
    }

    private void item_41() {
        boolean bl = false;
        int n = this.formList.size();
        if (n == 0) {
            return;
        }
        for (Element element : this.formList) {
            Stack<Node> stack = new Stack<Node>();
            Node node = element.getFirstChild();
            while (node != null) {
                String string;
                Element element2;
                if (node.getNodeType() == 1 && (element2 = (Element)node).hasAttribute("accesskey") && !(string = element2.getAttribute("accesskey")).equals("")) {
                    bl = true;
                    break;
                }
                if (node.hasChildNodes()) {
                    stack.push(node);
                    node = node.getFirstChild();
                    continue;
                }
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    continue;
                }
                node = null;
                while (node == null && stack.size() > 0) {
                    node = (Node)stack.pop();
                    node = node.getNextSibling();
                }
            }
            if (bl) break;
        }
        if (!bl) {
            this.addCheckerProblem("C_41.0");
        }
    }

    private void item_42() {
        Vector<Node> vector = new Vector<Node>();
        int n = 0;
        while (n < this.aWithHref_elements.length) {
            String string;
            Element element = this.aWithHref_elements[n];
            if (!(!element.hasAttribute("target") || (string = element.getAttribute("target")).equals("") || string.equalsIgnoreCase("_top") || string.equalsIgnoreCase("_self") || string.equalsIgnoreCase("top") || string.equalsIgnoreCase("self"))) {
                vector.add(element);
            }
            ++n;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_42.0", null, vector);
        }
    }

    private void item_43() {
        boolean bl = false;
        Element[] elementArray = this.edu.getScript_elements();
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Element element = elementArray[n2];
            Node node = element.getFirstChild();
            while (node != null) {
                String string;
                if (node.getNodeType() == 4 && (string = node.getNodeValue()) != null && string.toLowerCase().indexOf(WINDOW_OPEN) >= 0) {
                    bl = true;
                    break;
                }
                node = node.getNextSibling();
            }
            if (bl) {
                this.result.add((IProblemItem)new ProblemItemImpl("C_43.0"));
                break;
            }
            ++n2;
        }
        HashSet<Element> hashSet = new HashSet<Element>();
        elementArray = this.edu.getEventFocusElements();
        int n3 = 0;
        while (n3 < elementArray.length) {
            if (this.hasOpenWndEvent(elementArray[n3], HtmlEvalUtil.EVENT_FOCUS) && hashSet.add(elementArray[n3])) {
                this.result.add((IProblemItem)new ProblemItemImpl("C_43.0", (Node)elementArray[n3]));
            }
            ++n3;
        }
        elementArray = this.edu.getEventLoadElements();
        n3 = 0;
        while (n3 < elementArray.length) {
            if (this.hasOpenWndEvent(elementArray[n3], HtmlEvalUtil.EVENT_LOAD) && hashSet.add(elementArray[n3])) {
                this.result.add((IProblemItem)new ProblemItemImpl("C_43.0", (Node)elementArray[n3]));
            }
            ++n3;
        }
        elementArray = this.edu.getEventMouseButtonElements();
        n3 = 0;
        while (n3 < elementArray.length) {
            if (this.hasOpenWndEvent(elementArray[n3], HtmlEvalUtil.EVENT_MOUSE_BUTTON) && hashSet.add(elementArray[n3])) {
                this.result.add((IProblemItem)new ProblemItemImpl("C_43.0", (Node)elementArray[n3]));
            }
            ++n3;
        }
        elementArray = this.edu.getEventOnMouseElements();
        n3 = 0;
        while (n3 < elementArray.length) {
            if (this.hasOpenWndEvent(elementArray[n3], HtmlEvalUtil.EVENT_MOUSE_FOCUS) && hashSet.add(elementArray[n3])) {
                this.result.add((IProblemItem)new ProblemItemImpl("C_43.0", (Node)elementArray[n3]));
            }
            ++n3;
        }
        elementArray = this.edu.getEventOnKeyElements();
        n3 = 0;
        while (n3 < elementArray.length) {
            if (this.hasOpenWndEvent(elementArray[n3], HtmlEvalUtil.EVENT_ON_KEY) && hashSet.add(elementArray[n3])) {
                this.result.add((IProblemItem)new ProblemItemImpl("C_43.0", (Node)elementArray[n3]));
            }
            ++n3;
        }
        elementArray = this.edu.getEventWindowElements();
        n3 = 0;
        while (n3 < elementArray.length) {
            if (this.hasOpenWndEvent(elementArray[n3], HtmlEvalUtil.EVENT_WINDOW) && hashSet.add(elementArray[n3])) {
                this.result.add((IProblemItem)new ProblemItemImpl("C_43.0", (Node)elementArray[n3]));
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void item_45() {
        var1_1 = this.target.getElementsByTagName("input");
        var2_2 = var1_1.getLength();
        var3_3 = 0;
        while (var3_3 < var2_2) {
            block21: {
                block24: {
                    block23: {
                        block22: {
                            var4_4 = false;
                            var5_5 = (Element)var1_1.item(var3_3);
                            if (!var5_5.hasAttribute("type")) break block21;
                            var6_6 = var5_5.getAttribute("type");
                            if (!var6_6.equalsIgnoreCase("text") && !var6_6.equalsIgnoreCase("textbox") && !var6_6.equalsIgnoreCase("textarea") && !var6_6.equals("")) break block22;
                            var7_7 = var5_5.getAttribute("value");
                            var4_4 = var7_7 != null && var7_7.length() > 0 ? true : CheckEngine.hasTextDescendant((Node)var5_5);
                            if (!var4_4) {
                                this.addCheckerProblem("C_45.0", var5_5);
                            }
                            break block21;
                        }
                        if (!var6_6.equalsIgnoreCase("radio")) break block21;
                        var7_7 = var5_5.getAttribute("checked");
                        if (var7_7 == null || var7_7.equals("")) break block23;
                        var4_4 = true;
                        break block24;
                    }
                    if (var5_5.hasAttribute("name")) {
                        var8_11 = var5_5.getAttribute("name");
                        var9_13 = 0;
                        while (var9_13 < var2_2) {
                            if (var3_3 != var9_13 && (var10_17 = (Element)var1_1.item(var9_13)).hasAttribute("type") && (var11_18 = var10_17.getAttribute("type")).equalsIgnoreCase("radio") && (var12_19 = var10_17.getAttribute("name")) != null && var8_11.equalsIgnoreCase(var12_19)) {
                                if (var9_13 < var3_3) {
                                    var4_4 = true;
                                    ** break;
                                }
                                var13_20 = var10_17.getAttribute("checked");
                                if (var13_20 != null && !var13_20.equals("")) {
                                    var4_4 = true;
                                    ** break;
                                }
                            }
                            ++var9_13;
                        }
                    }
                    break block21;
                }
                if (!var4_4) {
                    this.addCheckerProblem("C_45.1", var5_5);
                }
            }
            ++var3_3;
        }
        var1_1 = this.target.getElementsByTagName("select");
        var2_2 = var1_1.getLength();
        var3_3 = 0;
        while (var3_3 < var2_2) {
            var4_4 = false;
            var5_5 = (Element)var1_1.item(var3_3);
            var6_6 = var5_5.getElementsByTagName("option");
            var7_9 = var6_6.getLength();
            var8_12 = 0;
            while (var8_12 < var7_9) {
                var9_15 = ((Element)var6_6.item(var8_12)).getAttribute("selected");
                if (var9_15 != null) {
                    var4_4 = true;
                    break;
                }
                ++var8_12;
            }
            if (!var4_4) {
                this.addCheckerProblem("C_45.1", var5_5);
            }
            ++var3_3;
        }
        var1_1 = this.target.getElementsByTagName("html:text");
        var2_2 = var1_1.getLength();
        var3_3 = 0;
        while (var3_3 < var2_2) {
            var4_4 = false;
            var5_5 = (Element)var1_1.item(var3_3);
            var6_6 = var5_5.getAttribute("value");
            var4_4 = var6_6 != null && var6_6.length() > 0 ? true : CheckEngine.hasTextDescendant((Node)var5_5);
            if (!var4_4) {
                this.addCheckerProblem("C_45.0", var5_5);
            }
            ++var3_3;
        }
        var1_1 = this.target.getElementsByTagName("textarea");
        var2_2 = var1_1.getLength();
        var3_3 = 0;
        while (var3_3 < var2_2) {
            var4_4 = false;
            var5_5 = (Element)var1_1.item(var3_3);
            var6_6 = var5_5.getAttribute("value");
            var4_4 = var6_6 != null && var6_6.length() > 0 ? true : CheckEngine.hasTextDescendant((Node)var5_5);
            if (!var4_4) {
                this.addCheckerProblem("C_45.0", var5_5);
            }
            ++var3_3;
        }
        var1_1 = this.target.getElementsByTagName("html:radio");
        var2_2 = var1_1.getLength();
        var3_3 = 0;
        while (var3_3 < var2_2) {
            var4_4 = false;
            var5_5 = (Element)var1_1.item(var3_3);
            var6_6 = var5_5.getAttribute("name");
            if (var6_6 != null) {
                var7_10 = var3_3 + 1;
                while (var3_3 < var2_2) {
                    var8_11 = (Element)var1_1.item(var7_10);
                    var9_16 = var8_11.getAttribute("name");
                    if (var9_16 != null && var6_6.equalsIgnoreCase(var9_16) && (var10_17 = var8_11.getAttribute("checked")) != null) {
                        var4_4 = true;
                        break;
                    }
                    ++var7_10;
                }
                if (!var4_4) {
                    this.addCheckerProblem("C_45.1", var5_5);
                }
            }
            ++var3_3;
        }
    }

    private void item_46() {
        Vector<Element> vector = new Vector<Element>();
        int n = 0;
        while (n < this.aWithHref_elements.length) {
            boolean bl = false;
            Element element = this.aWithHref_elements[n];
            if (!vector.contains(element)) {
                Element element2 = null;
                Node node = element.getNextSibling();
                String string = this.aWithHref_hrefs[n];
                try {
                    string = new URL(this.baseUrl, this.aWithHref_hrefs[n]).toString();
                }
                catch (MalformedURLException malformedURLException) {}
                while (node != null) {
                    String string2;
                    if (node.getNodeType() == 1) {
                        string2 = node.getNodeName();
                        if (string2 != null) {
                            String string3;
                            if (string2.equalsIgnoreCase("br") || string2.equalsIgnoreCase("p")) {
                                node = node.getNextSibling();
                                continue;
                            }
                            if (!string2.equalsIgnoreCase("a")) break;
                            try {
                                string3 = new URL(this.baseUrl, ((Element)node).getAttribute("href")).toString();
                            }
                            catch (MalformedURLException malformedURLException) {
                                string3 = ((Element)node).getAttribute("href");
                            }
                            if (string.equals(string3)) break;
                            element2 = (Element)node;
                            if (!vector.contains(element)) {
                                vector.add(element);
                            }
                            if (!vector.contains(element2)) {
                                vector.add(element2);
                            }
                            bl = true;
                        }
                    } else if (node.getNodeType() == 3 && (string2 = node.getNodeValue()) != null && !string2.trim().equals("")) break;
                    node = node.getNextSibling();
                }
                if (bl) {
                    this.addCheckerProblem("C_46.0", element, element2);
                }
            }
            ++n;
        }
    }

    private void item_48() {
        this.checkObsoluteEle("C_48.1", "applet");
        this.checkObsoluteEle("C_48.2", "basefont");
        this.checkObsoluteEle("C_48.2", "center");
        this.checkObsoluteEle("C_48.2", "font");
        this.checkObsoluteEle("C_48.2", "strike");
        this.checkObsoluteEle("C_48.2", "u");
        this.checkObsoluteEle("C_48.2", "s");
        this.checkObsoluteEle("C_48.3", "dir");
        this.checkObsoluteEle("C_48.3", "menu");
        this.checkObsoluteEle("C_48.4", "isindex");
        this.checkObsoluteEle("C_48.5", "listing");
        this.checkObsoluteEle("C_48.5", "plaintext");
        this.checkObsoluteEle("C_48.5", "xmp");
        this.checkObsoluteEle("C_48.6", "b");
        this.checkObsoluteEle("C_48.6", "i");
    }

    private void item_49() {
        this.addCheckerProblem("C_49.0");
    }

    private void item_50() {
        this.addCheckerProblem("C_50.0");
    }

    private void item_51() {
        Element element;
        int n = 0;
        while (n < this.frame_elements.length) {
            element = this.frame_elements[n];
            if (!this.hasTitle(element)) {
                this.addCheckerProblem("C_51.0", element);
            } else if (this.hasBlankTitle(element)) {
                this.addCheckerProblem("C_51.4", element);
            } else {
                this.addCheckerProblem("C_51.2", element.getAttribute("title"), element);
            }
            ++n;
        }
        n = 0;
        while (n < this.iframe_elements.length) {
            element = this.iframe_elements[n];
            if (!this.hasTitle(element)) {
                this.addCheckerProblem("C_51.1", ": src=" + element.getAttribute("src"), element);
            } else if (this.hasBlankTitle(element)) {
                this.addCheckerProblem("C_51.5", ": src=" + element.getAttribute("src"), element);
            } else {
                this.addCheckerProblem("C_51.3", element.getAttribute("title"), element);
            }
            ++n;
        }
    }

    private void item_52() {
        String string;
        String string2;
        Element element;
        int n = 0;
        while (n < this.frame_elements.length) {
            element = this.frame_elements[n];
            string2 = element.getAttribute("title");
            if (!string2.equals("") && ((string = element.getAttribute("longdesc")) == null || string.equals(""))) {
                this.addCheckerProblem("C_52.0", element);
            }
            ++n;
        }
        n = 0;
        while (n < this.iframe_elements.length) {
            element = this.iframe_elements[n];
            string2 = element.getAttribute("title");
            if (!string2.equals("") && ((string = element.getAttribute("longdesc")) == null || string.equals(""))) {
                this.addCheckerProblem("C_52.1", element);
            }
            ++n;
        }
    }

    private void item_53() {
        NodeList nodeList = this.target.getElementsByTagName("select");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            NodeList nodeList2 = element.getElementsByTagName("optgroup");
            if (nodeList2.getLength() == 0) {
                this.addCheckerProblem("C_53.2", element);
                NodeList nodeList3 = element.getElementsByTagName("option");
                if (nodeList3.getLength() > 10) {
                    this.addCheckerProblem("C_53.1", element);
                }
            }
            ++n2;
        }
    }

    private void item_54() {
        Vector<Node> vector = new Vector<Node>();
        Vector<Node> vector2 = new Vector<Node>();
        for (Element element : this.formList) {
            Object object22;
            if (this.getFormControlNum(element) <= 1) continue;
            List list = this.edu.getElementsList((Node)element, "fieldset", new String[0]);
            if (list.size() == 0) {
                vector.add(element);
            } else {
                for (Object object22 : list) {
                    vector2.add((Node)object22);
                    List list2 = this.edu.getElementsList((Node)object22, "legend", new String[0]);
                    if (list2.size() == 0) {
                        this.addCheckerProblem("C_54.1", (Element)object22);
                        continue;
                    }
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        Element element2 = (Element)iterator.next();
                        this.addCheckerProblem("C_54.4", element2);
                    }
                }
            }
            object22 = new FieldsetManager();
            for (Element element3 : this.getRadioAndCheck(element)) {
                ((FieldsetManager)object22).addEntry(element3.getAttribute("name"), element3);
            }
            for (Vector vector3 : ((FieldsetManager)object22).getErrorList()) {
                this.addCheckerProblem("C_54.3", "", vector3);
            }
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_54.0", null, vector);
        }
        if (vector2.size() > 0) {
            this.addCheckerProblem("C_54.2", null, vector2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void item_57() {
        void node;
        Element element = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.aWithHref_elements.length;
        Vector<Node> vector = new Vector<Node>();
        Vector<Element> vector2 = new Vector<Element>();
        boolean n4 = false;
        while (node < n3) {
            element = this.aWithHref_elements[node];
            String string = this.aWithHref_strings[node];
            if (element.hasAttribute("title")) {
                if (this.hasBlankTitle(element)) {
                    this.addCheckerProblem("C_57.3", element);
                } else {
                    vector2.add(element);
                }
            }
            if (this.getWordCount(string) < 3 && string.length() < this.validate_str_len) {
                String string2 = element.getAttribute("title");
                if (string2.equals("")) {
                    if (string.trim().length() > 0) {
                        vector.add(element);
                    } else if (!this.aWithHref_hrefs[node].startsWith("#")) {
                        String string3 = CheckEngine.getNoScriptText((Node)element);
                        if (!element.hasChildNodes() || element.getElementsByTagName("img").getLength() == 0) {
                            ++n2;
                        } else if (string3.length() > 0) {
                            ++n2;
                        } else {
                            IProblemItem iProblemItem;
                            ++n;
                            String string4 = this.aWithHref_hrefs[node];
                            boolean bl = false;
                            if (node - true > 0 && string4.equals(this.aWithHref_hrefs[node - true]) && this.aWithHref_strings[node - true].length() > 0) {
                                bl = true;
                            }
                            if (!bl && node + true < this.aWithHref_hrefs.length && string4.equals(this.aWithHref_hrefs[node + true]) && this.aWithHref_strings[node + true].length() > 0) {
                                bl = true;
                            }
                            if (bl) {
                                iProblemItem = this.addCheckerProblem("C_57.5", " (href=\"" + this.aWithHref_hrefs[node] + "\")", element);
                                this.edu.appendErrorIcon(iProblemItem, element);
                            } else {
                                iProblemItem = this.addCheckerProblem("C_57.2", " (href=\"" + this.aWithHref_hrefs[node] + "\")", element);
                                this.edu.appendErrorIcon(iProblemItem, element);
                            }
                        }
                    } else {
                        ++n;
                    }
                } else if (this.getWordCount(string2) < 3 && string2.length() < this.validate_str_len) {
                    this.addCheckerProblem("C_57.1", " (linktext=\"" + (String)string + "\", title=\"" + string2 + "\", href=\"" + this.aWithHref_hrefs[node] + "\")", element);
                }
            }
            ++node;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_57.0", "", vector);
        }
        for (Node node2 : vector2) {
            this.addCheckerProblem("C_57.4", ((Element)node2).getAttribute("title"), (Element)node2);
        }
        if ((n3 -= n2) > 0) {
            this.invalidLinkRatio = (double)n / (double)n3;
        }
    }

    private void item_58() {
        int n;
        int[] nArray = new int[5];
        int n2 = 0;
        while (n2 < this.aWithHref_elements.length) {
            int n3 = this.aWithHref_strings[n2].length();
            if (n3 != 0) {
                if (n3 > 9) {
                    if (n3 < 20) {
                        nArray[3] = nArray[3] + 1;
                    } else {
                        nArray[4] = nArray[4] + 1;
                    }
                } else if (n3 < 7) {
                    if (n3 < 4) {
                        nArray[0] = nArray[0] + 1;
                    } else {
                        nArray[1] = nArray[1] + 1;
                    }
                } else {
                    nArray[2] = nArray[2] + 1;
                }
            }
            ++n2;
        }
        int[][] nArrayArray = new int[5][];
        Node[][] nodeArrayArray = new Node[5][];
        String[][] stringArrayArray = new String[5][];
        String[][] stringArrayArray2 = new String[5][];
        boolean[][] blArrayArray = new boolean[5][];
        int n4 = 0;
        while (n4 < 5) {
            nArrayArray[n4] = new int[nArray[n4]];
            blArrayArray[n4] = new boolean[nArray[n4]];
            nodeArrayArray[n4] = new Node[nArray[n4]];
            stringArrayArray[n4] = new String[nArray[n4]];
            stringArrayArray2[n4] = new String[nArray[n4]];
            nArray[n4] = 0;
            ++n4;
        }
        n4 = this.aWithHref_elements.length;
        int n5 = 0;
        while (n5 < n4) {
            n = this.aWithHref_strings[n5].length();
            if (n != 0) {
                if (n > 9) {
                    if (n < 20) {
                        nArrayArray[3][nArray[3]] = this.aWithHref_strings[n5].hashCode();
                        nodeArrayArray[3][nArray[3]] = this.aWithHref_elements[n5];
                        stringArrayArray[3][nArray[3]] = this.aWithHref_strings[n5];
                        stringArrayArray2[3][nArray[3]] = this.aWithHref_hrefs[n5];
                        nArray[3] = nArray[3] + 1;
                    } else {
                        nArrayArray[4][nArray[4]] = this.aWithHref_strings[n5].hashCode();
                        nodeArrayArray[4][nArray[4]] = this.aWithHref_elements[n5];
                        stringArrayArray[4][nArray[4]] = this.aWithHref_strings[n5];
                        stringArrayArray2[4][nArray[4]] = this.aWithHref_hrefs[n5];
                        nArray[4] = nArray[4] + 1;
                    }
                } else if (n < 7) {
                    if (n < 4) {
                        nArrayArray[0][nArray[0]] = this.aWithHref_strings[n5].hashCode();
                        nodeArrayArray[0][nArray[0]] = this.aWithHref_elements[n5];
                        stringArrayArray[0][nArray[0]] = this.aWithHref_strings[n5];
                        stringArrayArray2[0][nArray[0]] = this.aWithHref_hrefs[n5];
                        nArray[0] = nArray[0] + 1;
                    } else {
                        nArrayArray[1][nArray[1]] = this.aWithHref_strings[n5].hashCode();
                        nodeArrayArray[1][nArray[1]] = this.aWithHref_elements[n5];
                        stringArrayArray[1][nArray[1]] = this.aWithHref_strings[n5];
                        stringArrayArray2[1][nArray[1]] = this.aWithHref_hrefs[n5];
                        nArray[1] = nArray[1] + 1;
                    }
                } else {
                    nArrayArray[2][nArray[2]] = this.aWithHref_strings[n5].hashCode();
                    nodeArrayArray[2][nArray[2]] = this.aWithHref_elements[n5];
                    stringArrayArray[2][nArray[2]] = this.aWithHref_strings[n5];
                    stringArrayArray2[2][nArray[2]] = this.aWithHref_hrefs[n5];
                    nArray[2] = nArray[2] + 1;
                }
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < 5) {
            n = 0;
            while (n < nArrayArray[n5].length - 1) {
                if (!blArrayArray[n5][n]) {
                    Vector<Node> vector = new Vector<Node>();
                    int n6 = n + 1;
                    while (n6 < nArrayArray[n5].length) {
                        if (!blArrayArray[n5][n6] && nArrayArray[n5][n] == nArrayArray[n5][n6]) {
                            String string = stringArrayArray2[n5][n];
                            try {
                                string = new URL(this.baseUrl, string).toString();
                            }
                            catch (MalformedURLException malformedURLException) {}
                            String string2 = stringArrayArray2[n5][n6];
                            try {
                                string2 = new URL(this.baseUrl, string2).toString();
                            }
                            catch (MalformedURLException malformedURLException) {}
                            if (!string.equalsIgnoreCase(string2)) {
                                if (!blArrayArray[n5][n]) {
                                    vector.add(nodeArrayArray[n5][n]);
                                    blArrayArray[n5][n] = true;
                                }
                                vector.add(nodeArrayArray[n5][n6]);
                                blArrayArray[n5][n6] = true;
                            }
                        }
                        ++n6;
                    }
                    if (vector.size() > 0) {
                        this.addCheckerProblem("C_58.0", " (linktext=\"" + stringArrayArray[n5][n] + "\")", vector);
                    }
                }
                ++n;
            }
            ++n5;
        }
    }

    private void item_59() {
        boolean bl = false;
        NodeList nodeList = this.target.getElementsByTagName("meta");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            String string = element.getAttribute("name");
            if (string != null && string.equalsIgnoreCase("keywords")) {
                bl = true;
            } else if (string != null && string.equalsIgnoreCase("description")) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            this.addCheckerProblem("C_59.1");
        }
        if ((nodeList = this.target.getElementsByTagName("address")).getLength() == 0) {
            this.addCheckerProblem("C_59.2");
        }
        this.addCheckerProblem("C_59.3");
    }

    private void item_60() {
        Object object;
        Object object2;
        boolean bl = false;
        Element element = null;
        NodeList nodeList = this.target.getElementsByTagName("head");
        if (nodeList.getLength() > 0) {
            object2 = ((Element)nodeList.item(0)).getElementsByTagName("title");
            int n = object2.getLength();
            int n2 = 0;
            while (n2 < n) {
                object = (Element)object2.item(n2);
                if (element == null) {
                    element = object;
                }
                bl = CheckEngine.hasTextDescendant((Node)object);
                ++n2;
            }
        }
        if (!bl) {
            this.result.add((IProblemItem)new ProblemItemImpl("C_60.0"));
        } else {
            object2 = new ArrayList();
            object2.add("\u7121\u984c.*");
            object2.add(".*untitled.*");
            object2.add(".*no title.*");
            object2.add(".*\\.html?");
            object2.add("[\\p{Punct}\\d]+");
            String string = CheckEngine.getTextDescendant((Node)element).toLowerCase().trim();
            object = object2.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (!string.matches(string2)) continue;
                this.addCheckerProblem("C_60.1", string, element);
                break;
            }
        }
    }

    private void item_66() {
        for (Element element : this.formList) {
            this.addCheckerProblem("C_66.0", element);
        }
    }

    private void item_68() {
        boolean bl = false;
        NodeList nodeList = this.target.getElementsByTagName("link");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            String string = element.getAttribute("rel");
            if (string != null && !string.equals("") && !string.equalsIgnoreCase("stylesheet")) {
                bl = true;
                break;
            }
            string = element.getAttribute("rev");
            if (string != null && !string.equals("")) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            this.addCheckerProblem("C_68.0");
        }
    }

    private void item_69() {
        if (this.body_elements.length > 0) {
            Element element = this.body_elements[0];
            Stack<Element> stack = new Stack<Element>();
            Node node = element;
            while (node != null) {
                boolean bl = false;
                if (this.isLeafBlockEle(node) && this.isAsciiArtString(CheckEngine.getTextAltDescendant((Node)node))) {
                    this.addCheckerProblem("C_69.0", (Element)node);
                    bl = true;
                }
                if (!bl && node.hasChildNodes()) {
                    stack.push((Element)node);
                    node = node.getFirstChild();
                    continue;
                }
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    continue;
                }
                node = null;
                while (node == null && stack.size() > 0) {
                    node = (Node)stack.pop();
                    node = node.getNextSibling();
                }
            }
        }
    }

    private void item_73() {
        Object object;
        Object object2;
        Vector<Node> vector = new Vector<Node>();
        int n = 0;
        while (n < this.object_elements.length) {
            object2 = this.object_elements[n];
            object = object2.getAttribute("data");
            if (((String)(object = this.getFileExtension((String)object))).equalsIgnoreCase("pdf") || ((String)object).equalsIgnoreCase("ppt") || this.isAudioFileExt((String)object) || this.isMultimediaFileExt((String)object)) {
                vector.add((Node)object2);
            }
            ++n;
        }
        n = 0;
        while (n < this.aWithHref_hrefs.length) {
            object2 = this.aWithHref_elements[n];
            object = this.aWithHref_hrefs[n];
            if (((String)(object = this.getFileExtension((String)object))).equalsIgnoreCase("pdf") || ((String)object).equalsIgnoreCase("ppt") || this.isAudioFileExt((String)object) || this.isMultimediaFileExt((String)object)) {
                vector.add((Node)object2);
            }
            ++n;
        }
        for (Element element : this.edu.getAppletElements()) {
            object = element.getElementsByTagName("param");
            int n2 = object.getLength();
            int n3 = 0;
            while (n3 < n2) {
                String string = ((Element)object.item(n3)).getAttribute("value");
                if ((string = this.getFileExtension(string)).equalsIgnoreCase("pdf") || string.equalsIgnoreCase("ppt") || this.isAudioFileExt(string) || this.isMultimediaFileExt(string)) {
                    vector.add(element);
                }
                ++n3;
            }
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_73.0", "", vector);
        }
    }

    private void item_74() {
        boolean bl = false;
        NodeList nodeList = this.target.getElementsByTagName("meta");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            String string = element.getAttribute("http-equiv");
            if (string.equalsIgnoreCase("refresh") || string.equalsIgnoreCase("location")) {
                this.addCheckerProblem("C_74.1", element);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            this.addCheckerProblem("C_74.0");
        }
        if (this.formList.size() > 0) {
            this.addCheckerProblem("C_74.2");
        }
    }

    private void item_75() {
        int n = 0;
        while (n < this.bottom_data_tables.length) {
            Element element = this.bottom_data_tables[n];
            NodeList nodeList = element.getElementsByTagName("th");
            if (nodeList.getLength() == 0) {
                this.addCheckerProblem("C_75.0", element);
            }
            ++n;
        }
    }

    private void item_76() {
        Vector<Node> vector = new Vector<Node>();
        for (Element element : this.dataTableList) {
            if (!this.hasRowColSpan(element)) continue;
            vector.add(element);
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_76.1", "", vector);
        }
    }

    private boolean hasRowColSpan(Element element) {
        boolean bl = false;
        for (Element element2 : this.edu.getElementsList((Node)element, "th", new String[]{"td"})) {
            String string = this.getAttribute(element2, "rowspan");
            String string2 = this.getAttribute(element2, "colspan");
            if ((string == null || Integer.parseInt(string) <= 1) && (string2 == null || Integer.parseInt(string2) <= 1)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void item_77() {
        Object object;
        Element element = null;
        boolean bl = false;
        NodeList nodeList = this.target.getElementsByTagName("link");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            element = (Element)nodeList.item(n2);
            object = element.getAttribute("rel");
            if (object != null && ((String)object).equalsIgnoreCase("stylesheet")) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            this.addCheckerProblem("C_77.0", element);
        }
        if ((nodeList = this.target.getElementsByTagName("style")).getLength() > 0) {
            this.addCheckerProblem("C_77.1", "", nodeList);
        }
        Vector<Node> vector = new Vector<Node>();
        if (this.body_elements.length > 0) {
            object = this.body_elements[0];
            Stack<Object> stack = new Stack<Object>();
            Object object2 = object;
            while (object2 != null) {
                String string;
                if (object2.getNodeType() == 1 && !(string = (element = (Element)object2).getAttribute("style")).equals("")) {
                    vector.add(element);
                }
                if (object2.hasChildNodes()) {
                    stack.push(object2);
                    object2 = object2.getFirstChild();
                    continue;
                }
                if (object2.getNextSibling() != null) {
                    object2 = object2.getNextSibling();
                    continue;
                }
                object2 = null;
                while (object2 == null && stack.size() > 0) {
                    object2 = (Node)stack.pop();
                    object2 = object2.getNextSibling();
                }
            }
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_77.2", "", vector);
        }
    }

    private void item_78() {
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = this.target.getElementsByTagName("input");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string;
            Element element = (Element)nodeList.item(n2);
            if (element.hasAttribute("type") && ((string = element.getAttribute("type")).equalsIgnoreCase("text") || string.equalsIgnoreCase("textbox") || string.equals(""))) {
                vector.add(element);
            }
            ++n2;
        }
        nodeList = this.target.getElementsByTagName("html:text");
        n = nodeList.getLength();
        n2 = 0;
        while (n2 < n) {
            vector.add((Element)nodeList.item(n2));
            ++n2;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_78.2", null, vector);
        }
    }

    private void item_79() {
        if (this.labelList == null) {
            this.labelList = this.edu.getElementsList((Node)this.target, "label", new String[0]);
        }
        Vector<Node> vector = new Vector<Node>();
        Vector<Node> vector2 = new Vector<Node>();
        Vector<Node> vector3 = new Vector<Node>();
        Element[] elementArray = this.body_elements;
        int n = this.body_elements.length;
        int n2 = 0;
        while (n2 < n) {
            Element element = elementArray[n2];
            for (Element element2 : this.getFormControl(element)) {
                TitleCheckResult titleCheckResult = this.item_79_title(element2);
                if (titleCheckResult == TitleCheckResult.NO_TITLE) {
                    vector.add(element2);
                }
                this.item_79_label(element2, titleCheckResult, vector2, vector3);
            }
            ++n2;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_79.6", "", vector);
        }
        if (vector2.size() > 0) {
            this.addCheckerProblem("C_79.0", "", vector2);
        }
        if (vector3.size() > 0) {
            this.addCheckerProblem("C_79.2", "", vector3);
        }
    }

    private void item_79_label(Element element, TitleCheckResult titleCheckResult, Vector<Node> vector, Vector<Node> vector2) {
        String string = this.getFormControlType(element);
        Element element2 = this.hasImplicitLabel(element);
        if (element2 != null) {
            vector2.add(element2);
            return;
        }
        if (!this.isLabelable(string)) {
            return;
        }
        element.getAttribute("id");
        boolean bl = this.hasLabel(element);
        this.hasTitle(element);
        if (!bl && titleCheckResult != TitleCheckResult.G167) {
            if (titleCheckResult == TitleCheckResult.EMPTY_TITLE) {
                vector.add(element);
            }
        } else if (!this.hasProperLabel(element)) {
            this.addCheckerProblem("C_79.1", " (input type: " + (string.equals("") ? "text" : string) + ")", element);
        } else {
            this.addCheckerProblem("C_79.5", element);
        }
    }

    private TitleCheckResult item_79_title(Element element) {
        if (this.hasTitle(element)) {
            if (this.hasBlankTitle(element)) {
                return TitleCheckResult.EMPTY_TITLE;
            }
            this.addCheckerProblem("C_79.4", element.getAttribute("title"), element);
            return TitleCheckResult.OK;
        }
        if (this.isLabelable(this.getFormControlType(element)) && this.hasLabel(element)) {
            return TitleCheckResult.OK;
        }
        if (this.check_G167(element)) {
            return TitleCheckResult.G167;
        }
        return TitleCheckResult.NO_TITLE;
    }

    private boolean check_G167(Element element) {
        if (HtmlTagUtil.isTextControl((Element)element)) {
            Element element2 = this.findNextElementNode(element);
            if (element2 == null || !CheckEngine.isButtonControl((Element)element2)) {
                return false;
            }
            Vector<Node> vector = new Vector<Node>();
            vector.add(element);
            vector.add(element2);
            this.addCheckerProblem("C_79.7", null, vector);
            return true;
        }
        if (HtmlTagUtil.isButtonControl((Element)element)) {
            return false;
        }
        return false;
    }

    private Element findNextElementNode(Element element) {
        Node node = element;
        while ((node = node.getNextSibling()) != null) {
            node.getNodeType();
            if (node.getNodeType() == 3) {
                if (CheckEngine.isBlankString((String)node.getNodeValue())) continue;
                return null;
            }
            if (node.getNodeType() == 1) break;
        }
        return node;
    }

    private void item_80() {
        if (this.body_elements.length > 0) {
            Element element = this.body_elements[0];
            Stack<Element> stack = new Stack<Element>();
            Node node = element;
            while (node != null) {
                Element element2;
                String string;
                if (node.getNodeType() == 1 && (string = (element2 = node).getAttribute("alt")) != null && string.length() > 150) {
                    this.addCheckerProblem("C_80.0", element2);
                }
                if (node.hasChildNodes()) {
                    stack.push((Element)node);
                    node = node.getFirstChild();
                    continue;
                }
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    continue;
                }
                node = null;
                while (node == null && stack.size() > 0) {
                    node = (Node)stack.pop();
                    node = node.getNextSibling();
                }
            }
        }
    }

    private void item_85() {
        boolean bl = false;
        NodeList nodeList = this.target.getElementsByTagName("head");
        Element element = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            NodeList nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName("bgsound");
            if (nodeList2.getLength() > 0) {
                bl = true;
                element = (Element)nodeList2.item(0);
                break;
            }
            ++n;
        }
        if (bl) {
            this.addCheckerProblem("C_85.0", element);
        }
    }

    private void item_86() {
        Object object;
        Object object2;
        boolean bl = false;
        int n = 0;
        while (n < this.object_elements.length) {
            object2 = this.object_elements[n];
            object = object2.getAttribute("data");
            if (this.isAudioFileExt((String)(object = this.getFileExtension((String)object))) || this.isMultimediaFileExt((String)object)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            for (Element element : this.edu.getAppletElements()) {
                object = element.getElementsByTagName("param");
                int n2 = object.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    String string = ((Element)object.item(n3)).getAttribute("value");
                    if (this.isAudioFileExt(string = this.getFileExtension(string)) || this.isMultimediaFileExt(string)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (bl) break;
            }
        }
        if (!bl) {
            int n4 = 0;
            while (n4 < this.aWithHref_hrefs.length) {
                object2 = this.aWithHref_hrefs[n4];
                if (this.isAudioFileExt((String)(object2 = this.getFileExtension((String)object2))) || this.isMultimediaFileExt((String)object2)) {
                    bl = true;
                    break;
                }
                ++n4;
            }
        }
        if (bl) {
            this.addCheckerProblem("C_86.0");
        }
    }

    private void item_88() {
        String string = "";
        NodeList nodeList = this.target.getElementsByTagName("meta");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            if (element.hasAttribute("http-equiv") && element.hasAttribute("content")) {
                int n3;
                String string2 = element.getAttribute("http-equiv");
                String string3 = element.getAttribute("content");
                if (string2 != null && string2.equalsIgnoreCase("Content-Type") && string3 != null && (n3 = string3.toLowerCase().indexOf("text/html")) >= 0 && (n3 = (string3 = string3.substring(n3 + 9)).indexOf(";")) >= 0 && (n3 = (string3 = string3.substring(n3 + 1)).toLowerCase().indexOf("charset")) >= 0 && (n3 = (string3 = string3.substring(n3 + 7)).indexOf("=")) >= 0) {
                    string = string3.substring(n3 + 1);
                }
            }
            ++n2;
        }
        if (string.length() == 0) {
            this.result.add((IProblemItem)new ProblemItemImpl("C_88.0"));
        }
    }

    private void item_89() {
        if (this.body_elements.length == 1 && this.target.getElementsByTagName("frameset").getLength() == 0) {
            Node node = this.body_elements[0].getFirstChild();
            StringBuffer stringBuffer = new StringBuffer(512);
            Stack<Node> stack = new Stack<Node>();
            while (node != null && stringBuffer.length() < this.valid_total_text_len) {
                if (node.getNodeType() == 3) {
                    stringBuffer.append(node.getNodeValue().replaceAll(String.valueOf('\u00a0'), "").trim());
                } else if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    if (element.hasAttribute("alt")) {
                        stringBuffer.append(element.getAttribute("alt").replaceAll(String.valueOf('\u00a0'), "").trim());
                    }
                    if (element.hasAttribute("title")) {
                        stringBuffer.append(element.getAttribute("title").replaceAll(String.valueOf('\u00a0'), "").trim());
                    }
                }
                if (node.hasChildNodes()) {
                    stack.push(node);
                    node = node.getFirstChild();
                    continue;
                }
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    continue;
                }
                node = null;
                while (node == null && stack.size() > 0) {
                    node = (Node)stack.pop();
                    node = node.getNextSibling();
                }
            }
            if (stringBuffer.length() == 0) {
                this.addCheckerProblem("C_89.0");
            } else if (stringBuffer.length() < this.valid_total_text_len) {
                if (this.img_elements.length > 0) {
                    this.addCheckerProblem("C_89.1");
                } else {
                    this.addCheckerProblem("C_89.2");
                }
            }
        }
    }

    private void item_90() {
        Set<Element> set = this.styleElementMap.keySet();
        for (Element object22 : set) {
            String string = this.styleElementMap.get(object22);
            if (string == null) continue;
            if (BEFORE_PATTERN.matcher(string).matches()) {
                this.addCheckerProblem("C_90.0", "", object22);
            }
            if (!AFTER_PATTERN.matcher(string).matches()) continue;
            this.addCheckerProblem("C_90.1", "", object22);
        }
        Set<IStyleSheet> set2 = this.styleSheetsMap.keySet();
        for (IStyleSheet iStyleSheet : set2) {
            if (iStyleSheet.getHref() == null || iStyleSheet.getHref().length() <= 0) continue;
            String string = this.styleSheetsMap.get(iStyleSheet);
            if (BEFORE_PATTERN.matcher(string).matches()) {
                this.addCheckerProblem("C_90.0", "(" + iStyleSheet.getHref() + ")");
            }
            if (!AFTER_PATTERN.matcher(string).matches()) continue;
            this.addCheckerProblem("C_90.1", "(" + iStyleSheet.getHref() + ")");
        }
    }

    private void item_300() {
        TextCheckResult textCheckResult;
        Object object;
        String string;
        for (Element element : this.edu.getImageButtons()) {
            string = this.getAttribute(element, "alt");
            if (string == null || TextCheckResult.OK.equals(object = this.checker.checkAlt(string))) continue;
            if (TextCheckResult.SPACE_SEPARATED.equals(object) || TextCheckResult.SPACE_SEPARATED_JP.equals(object)) {
                this.addCheckerProblem("C_300.3", string, element);
                continue;
            }
            if (object.equals((Object)TextCheckResult.NULL) || object.equals((Object)TextCheckResult.BLANK)) {
                this.addCheckerProblem("C_300.4", string, element);
                continue;
            }
            this.addCheckerProblem("C_300.0", string, element);
        }
        for (Element element : this.edu.getTextButtons()) {
            string = this.getAttribute(element, "value");
            if (string == null) continue;
            object = this.checker.checkAlt(string);
            TextCheckResult.OK.equals(object);
        }
        for (Element element : this.edu.getAreaElements()) {
            string = this.getAttribute(element, "alt");
            if (string == null) continue;
            object = new TreeSet();
            object.add("area");
            textCheckResult = this.checker.checkAlt(string, (Set)object);
            if (textCheckResult.equals((Object)TextCheckResult.OK) || textCheckResult.equals((Object)TextCheckResult.SPACE_SEPARATED) || textCheckResult.equals((Object)TextCheckResult.SPACE_SEPARATED_JP) || textCheckResult.equals((Object)TextCheckResult.BLANK) && !element.hasAttribute("href")) continue;
            Element element2 = (Element)element.getParentNode();
            for (Element element3 : HtmlTagUtil.getImgElementsFromMap((Document)this.target, (Element)element2)) {
                int n = this.document2IdMap.get(element3);
                IProblemItem iProblemItem = this.addCheckerProblem("C_300.1", string, element);
                iProblemItem.setHighlightTargetIds(new HighlightTargetId(n, n));
                this.edu.appendErrorIcon(iProblemItem, element);
            }
        }
        for (Element element : this.edu.getAppletElements()) {
            string = this.getAttribute(element, "alt");
            if (string == null) continue;
            object = new TreeSet();
            object.add("applet");
            object.add("\u30a2\u30d7\u30ec\u30c3\u30c8");
            object.add("\u30d7\u30ed\u30b0\u30e9\u30e0");
            textCheckResult = this.checker.checkAlt(string, (Set)object);
            if (TextCheckResult.OK.equals((Object)textCheckResult)) continue;
            this.addCheckerProblem("C_300.2", string, element);
        }
    }

    private void item_331() {
        Vector<Node> vector = new Vector<Node>();
        Vector<Node> vector2 = new Vector<Node>();
        for (Element element : this.dataTableList) {
            int n = 0;
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = true;
            int n2 = 0;
            int n3 = 0;
            for (Element element2 : this.edu.getElementsList((Node)element, "tr", new String[0])) {
                ++n3;
                List list = this.edu.getElementsList((Node)element2, "th", new String[0]);
                if (bl) {
                    bl = false;
                    n2 = element2.getChildNodes().getLength();
                    if (list.size() == n2) {
                        bl2 = true;
                    }
                }
                if (bl3) {
                    boolean bl4 = bl3 = element2.hasChildNodes() && element2.getFirstChild().getNodeName().equalsIgnoreCase("th");
                }
                if (list.size() <= 0) continue;
                n += list.size();
            }
            boolean bl5 = bl2 && n2 == n || bl3 && n3 == n;
            for (Object object : this.edu.getElementsList((Node)element, "th", new String[0])) {
                if (!object.hasAttribute("scope")) {
                    if (bl5) continue;
                    vector.add((Node)object);
                    continue;
                }
                if (object.getAttribute("scope").matches("row(group)?|col(group)?")) continue;
                vector2.add((Node)object);
            }
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_331.0", "", vector);
        }
        if (vector2.size() > 0) {
            this.addCheckerProblem("C_331.1", "", vector2);
        }
    }

    private void item_332() {
        Iterator<Element> iterator = this.dataTableList.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            List list = this.edu.getElementsList((Node)this.target, "th", new String[]{"td"});
            for (Element element : list) {
                if (!element.hasAttribute("headers")) continue;
                String[] stringArray = element.getAttribute("headers").split("[ \t]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    Element element2 = this.target.getElementById(string);
                    if (element2 == null) {
                        this.addCheckerProblem("C_332.1", "(id=" + string + ")", element);
                    } else if (!element2.getTagName().toLowerCase().matches("td|th")) {
                        this.addCheckerProblem("C_332.2", element2.getTagName().toLowerCase(), element);
                    }
                    ++n2;
                }
            }
        }
    }

    private void item_380() {
        Vector<Node> vector = new Vector<Node>();
        for (Element element : this.formList) {
            Object object;
            boolean bl = false;
            NodeList nodeList = element.getElementsByTagName("input");
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element2 = (Element)nodeList.item(n);
                object = element2.getAttribute("type");
                if ("submit".equals(object) || "image".equals(object)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                NodeList nodeList2 = element.getElementsByTagName("button");
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    object = (Element)nodeList2.item(n2);
                    String string = object.getAttribute("type");
                    if ("submit".equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (bl) continue;
            vector.add(element);
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_380.0", null, vector);
        }
    }

    private void formCheck() {
        for (Element object2 : this.formList) {
            if (object2.getElementsByTagName("select").getLength() <= 0) continue;
            this.addCheckerProblem("C_381.0", object2);
        }
        Object var1_3 = null;
        NodeList nodeList = this.target.getElementsByTagName("form");
        if (nodeList.getLength() > 0) {
            this.addCheckerProblem("C_382.0", "", nodeList);
            this.addCheckerProblem("C_383.0", "", nodeList);
            this.addCheckerProblem("C_387.0", "", nodeList);
            this.addCheckerProblem("C_388.0", "", nodeList);
        }
    }

    private void item_384() {
        if (this.formVwithText == null) {
            this.formVwithText = this.getFormsWithTextinput();
        }
        if (this.formVwithText.size() > 0) {
            this.addCheckerProblem("C_384.0", "", this.formVwithText);
        }
    }

    private void item_385() {
        if (this.formVwithText == null) {
            this.formVwithText = this.getFormsWithTextinput();
        }
        if (this.formVwithText.size() > 0) {
            this.addCheckerProblem("C_385.0", "", this.formVwithText);
        }
    }

    private void item_386() {
        if (this.formVwithText == null) {
            this.formVwithText = this.getFormsWithTextinput();
        }
        if (this.formVwithText.size() > 0) {
            this.addCheckerProblem("C_386.0", "", this.formVwithText);
        }
    }

    private void item_389() {
        if (this.formVwithText == null) {
            this.formVwithText = this.getFormsWithTextinput();
        }
        if (this.formVwithText.size() > 0) {
            this.addCheckerProblem("C_389.0", "", this.formVwithText);
        }
    }

    private void item_422() {
        List list = this.edu.getAccessKeyElements();
        HashMap hashMap = new HashMap();
        for (Object object : list) {
            String string = object.getAttribute("accesskey");
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            ((List)hashMap.get(string)).add(object);
        }
        for (Object object : hashMap.keySet()) {
            if (((List)hashMap.get(object)).size() <= 1) continue;
            this.addCheckerProblem("C_422.0", (String)object, new Vector<Node>((Collection)hashMap.get(object)));
        }
    }

    private void item_423() {
        List list = this.edu.getElementsWithId();
        HashMap hashMap = new HashMap();
        for (Object object : list) {
            String string = object.getAttribute("id");
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            ((List)hashMap.get(string)).add(object);
        }
        for (Object object : hashMap.keySet()) {
            if (((List)hashMap.get(object)).size() <= 1) continue;
            this.addCheckerProblem("C_423.0", (String)object, new Vector<Node>((Collection)hashMap.get(object)));
        }
    }

    private void always() {
        this.addCheckerProblem("C_19.0");
        this.addCheckerProblem("C_20.0");
        this.addCheckerProblem("C_47.0");
        this.addCheckerProblem("C_55.0");
        if (this.hasAwithHref) {
            this.addCheckerProblem("C_56.1");
            this.addCheckerProblem("C_64.0");
            this.addCheckerProblem("C_65.0");
            this.addCheckerProblem("C_81.0");
        }
        this.addCheckerProblem("C_61.0");
        this.addCheckerProblem("C_62.0");
        this.addCheckerProblem("C_63.0");
        this.addCheckerProblem("C_67.0");
        this.addCheckerProblem("C_70.0");
        this.addCheckerProblem("C_71.0");
        this.addCheckerProblem("C_72.0");
        this.addCheckerProblem("C_82.0");
        this.addCheckerProblem("C_83.0");
        this.addCheckerProblem("C_84.0");
        this.addCheckerProblem("C_87.0");
        this.addCheckerProblem("C_321.0");
        this.addCheckerProblem("C_322.0");
        this.addCheckerProblem("C_421.0");
        this.addCheckerProblem("C_421.1", this.isXHTML ? "XHTML" : "HTML");
        this.addCheckerProblem("C_500.11");
        this.addCheckerProblem("C_500.12");
        this.addCheckerProblem("C_500.2");
        this.addCheckerProblem("C_500.3");
        this.addCheckerProblem("C_500.5");
        this.addCheckerProblem("C_500.6");
        this.addCheckerProblem("C_500.7");
        this.addCheckerProblem("C_500.8");
        this.addCheckerProblem("C_500.9");
        this.addCheckerProblem("C_500.10");
        this.addCheckerProblem("C_600.0");
        this.addCheckerProblem("C_600.3");
        this.addCheckerProblem("C_600.4");
        this.addCheckerProblem("C_600.5");
        this.addCheckerProblem("C_600.8");
        this.addCheckerProblem("C_600.9");
        this.addCheckerProblem("C_600.10");
        this.addCheckerProblem("C_600.11");
        this.addCheckerProblem("C_600.12");
        this.addCheckerProblem("C_600.13");
        this.addCheckerProblem("C_600.14");
        this.addCheckerProblem("C_600.15");
        this.addCheckerProblem("C_600.17");
        this.addCheckerProblem("C_600.18");
        this.addCheckerProblem("C_600.19");
    }

    private void styleCheck() {
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        HashSet<String> hashSet;
        HashSet<String> hashSet2;
        HashSet<String> hashSet3;
        Object object3;
        Set<Element> set = this.styleElementMap.keySet();
        for (Element element : set) {
            String string = this.styleElementMap.get(element);
            if (string == null) continue;
            object3 = new HashSet();
            hashSet3 = new HashSet<String>();
            hashSet2 = new HashSet<String>();
            hashSet = new HashSet<String>();
            object2 = STYLEITEM.matcher(string);
            while (((Matcher)object2).find()) {
                object = ((Matcher)object2).group();
                boolean bl3 = COLOR.matcher((CharSequence)object).find();
                bl2 = BGCOLOR.matcher((CharSequence)object).find() || BGCOLOR2.matcher((CharSequence)object).find();
                bl = FIXSIZE_PATTERN.matcher((CharSequence)object).find();
                if (bl3 || bl2) {
                    String string2 = this.getSelector((String)object);
                    if (bl3 && !bl2) {
                        object3.add(string2);
                    } else if (!bl3 && bl2) {
                        hashSet3.add(string2);
                    } else {
                        hashSet2.add(string2);
                    }
                }
                if (!bl) continue;
                hashSet.add(this.getSelector((String)object));
            }
            if (object3.size() > 0) {
                this.addCheckerProblem("C_500.17", "(" + Messages.StyleElement + ", " + Messages.Selector + "=" + this.getSelectors((Set<String>)object3) + ")", element);
            }
            if (hashSet3.size() > 0) {
                this.addCheckerProblem("C_500.18", "(" + Messages.StyleElement + ", " + Messages.Selector + "=" + this.getSelectors(hashSet3) + ")", element);
            }
            if (hashSet2.size() > 0) {
                this.addCheckerProblem("C_8.0", "(" + Messages.StyleElement + ", " + Messages.Selector + "=" + this.getSelectors(hashSet2) + ")", element);
            }
            if (hashSet.size() <= 0) continue;
            this.addCheckerProblem("C_500.19", "(" + Messages.StyleElement + ", " + Messages.Selector + "=" + this.getSelectors(hashSet) + ")", element);
        }
        Set<IStyleSheet> set2 = this.styleSheetsMap.keySet();
        for (IStyleSheet iStyleSheet : set2) {
            if (iStyleSheet.getHref() == null || iStyleSheet.getHref().length() <= 0) continue;
            object3 = this.styleSheetsMap.get(iStyleSheet);
            hashSet3 = new HashSet();
            hashSet2 = new HashSet();
            hashSet = new HashSet();
            object2 = new HashSet();
            object = STYLEITEM.matcher((CharSequence)object3);
            while (((Matcher)object).find()) {
                String string = ((Matcher)object).group();
                bl2 = COLOR.matcher(string).find();
                bl = BGCOLOR.matcher(string).find() || BGCOLOR2.matcher(string).find();
                boolean bl4 = FIXSIZE_PATTERN.matcher(string).find();
                if (bl2 || bl) {
                    String string3 = this.getSelector(string);
                    if (bl2 && !bl) {
                        hashSet3.add(string3);
                    } else if (!bl2 && bl) {
                        hashSet2.add(string3);
                    } else {
                        hashSet.add(string3);
                    }
                }
                if (!bl4) continue;
                object2.add(this.getSelector(string));
            }
            if (hashSet3.size() > 0) {
                this.addCheckerProblem("C_500.17", "(" + iStyleSheet.getHref() + ", " + Messages.Selector + "=" + this.getSelectors(hashSet3) + ")");
            }
            if (hashSet2.size() > 0) {
                this.addCheckerProblem("C_500.18", "(" + iStyleSheet.getHref() + ", " + Messages.Selector + "=" + this.getSelectors(hashSet2) + ")");
            }
            if (hashSet.size() > 0) {
                this.addCheckerProblem("C_8.0", "(" + iStyleSheet.getHref() + ", " + Messages.Selector + "=" + this.getSelectors(hashSet) + ")");
            }
            if (object2.size() <= 0) continue;
            this.addCheckerProblem("C_500.19", "(" + iStyleSheet.getHref() + ", " + Messages.Selector + "=" + this.getSelectors((Set<String>)object2) + ")");
        }
        for (Element element : this.elementsWithStyleList) {
            object3 = element.getAttribute("style");
            boolean bl5 = COLOR_ATTR.matcher((CharSequence)object3).matches();
            boolean bl6 = BGCOLOR_ATTR.matcher((CharSequence)object3).find() || BGCOLOR2_ATTR.matcher((CharSequence)object3).find();
            boolean bl7 = FIXSIZE_PATTERN_ATTR.matcher((CharSequence)object3).find();
            if (bl5 || bl6) {
                if (bl5 && !bl6) {
                    this.addCheckerProblem("C_500.17", "(" + (String)object3 + ")", element);
                } else if (!bl5 && bl6) {
                    this.addCheckerProblem("C_500.18", "(" + (String)object3 + ")", element);
                } else {
                    this.addCheckerProblem("C_8.0", "(" + (String)object3 + ")", element);
                }
            }
            if (!bl7) continue;
            this.addCheckerProblem("C_500.20", "(" + (String)object3 + ")", element);
        }
        if (this.body_elements.length > 0) {
            boolean bl8;
            Element element = this.body_elements[0];
            boolean bl9 = element.getAttribute("text").length() > 0;
            boolean bl10 = element.getAttribute("bgcolor").length() > 0;
            boolean bl11 = bl8 = element.getAttribute("link").length() > 0 || element.getAttribute("vlink").length() > 0 || element.getAttribute("alink").length() > 0;
            if (bl9 && !bl10) {
                this.addCheckerProblem("C_500.17", "", element);
            } else if (!bl9 && bl10) {
                this.addCheckerProblem("C_500.18", "", element);
            }
            if (bl8) {
                this.addCheckerProblem("C_500.18", "(link)", element);
            }
        }
    }

    private String getSelector(String string) {
        Pattern pattern = Pattern.compile("^.*\\{", 8);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group();
            return string2.substring(0, string2.lastIndexOf("{")).trim();
        }
        return "";
    }

    private String getSelectors(Set<String> set) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : set) {
            stringBuffer.append("\"" + string + "\", ");
        }
        if (stringBuffer.length() > 2) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return stringBuffer.toString();
    }

    private void mobile_1() {
    }

    private void validateHtml() {
        if (this.body_elements.length > 1) {
            this.addCheckerProblem("C_1000.0");
        } else if (this.body_elements.length == 0 && !this.docTypeS.toLowerCase().contains("frameset")) {
            this.addCheckerProblem("C_1000.4");
        }
    }

    private void checkAbsoluteSize(String string) {
        NodeList nodeList = this.target.getElementsByTagName(string);
        int n = nodeList.getLength();
        Vector<Node> vector = new Vector<Node>();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            String string2 = element.getAttribute("width");
            String string3 = element.getAttribute("height");
            if (string2 != null && !string2.equals("") && string2.indexOf("%") == -1 || string3 != null && !string3.equals("") && string3.indexOf("%") == -1) {
                vector.add(element);
            }
            ++n2;
        }
        if (vector.size() > 0) {
            this.addCheckerProblem("C_13.0", "", vector);
        }
    }

    private boolean hasOpenWndEvent(Element element, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = element.getAttribute(stringArray[n]);
            if (string.toLowerCase().indexOf(WINDOW_OPEN) >= 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void checkObsoluteEle(String string, String string2) {
        NodeList nodeList = this.target.getElementsByTagName(string2);
        if (nodeList.getLength() > 0) {
            this.addCheckerProblem(string, string2, nodeList);
        }
    }

    private String getFormControlType(Element element) {
        String string = element.getNodeName().toLowerCase();
        if (string.equals("input")) {
            return element.getAttribute("type").toLowerCase();
        }
        return string;
    }

    private List<Element> getRadioAndCheck(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        List list = this.edu.getElementsList((Node)element, "input", new String[0]);
        for (Element element2 : list) {
            if (!element2.getAttribute("type").toLowerCase().matches("radio|checkbox")) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    private List<Element> getFormControl(Element element) {
        Element element2;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("input");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            element2 = (Element)nodeList.item(n2);
            String string = element2.getAttribute("type").toLowerCase();
            if (string.equals("") || string.equals("text") || string.equals("textarea") || string.equals("radio") || string.equals("checkbox") || string.equals("file") || string.equals("password")) {
                arrayList.add(element2);
            }
            ++n2;
        }
        nodeList = element.getElementsByTagName("textarea");
        n = nodeList.getLength();
        n2 = 0;
        while (n2 < n) {
            element2 = (Element)nodeList.item(n2);
            arrayList.add(element2);
            ++n2;
        }
        nodeList = element.getElementsByTagName("select");
        n = nodeList.getLength();
        n2 = 0;
        while (n2 < n) {
            element2 = (Element)nodeList.item(n2);
            arrayList.add(element2);
            ++n2;
        }
        nodeList = element.getElementsByTagName("html:text");
        n = nodeList.getLength();
        n2 = 0;
        while (n2 < n) {
            element2 = (Element)nodeList.item(n2);
            arrayList.add(element2);
            ++n2;
        }
        nodeList = element.getElementsByTagName("html:radio");
        n = nodeList.getLength();
        n2 = 0;
        while (n2 < n) {
            element2 = (Element)nodeList.item(n2);
            arrayList.add(element2);
            ++n2;
        }
        return arrayList;
    }

    private int getFormControlNum(Element element) {
        int n = 0;
        NodeList nodeList = element.getElementsByTagName("input");
        n += nodeList.getLength();
        nodeList = element.getElementsByTagName("select");
        n += nodeList.getLength();
        nodeList = element.getElementsByTagName("textarea");
        n += nodeList.getLength();
        nodeList = element.getElementsByTagName("html:text");
        n += nodeList.getLength();
        nodeList = element.getElementsByTagName("html:radio");
        return n += nodeList.getLength();
    }

    private boolean hasTextFormControl(Element element) {
        int n = 0;
        for (Element element2 : this.edu.getElementsList((Node)element, "input", new String[0])) {
            if (!element2.getAttribute("type").toLowerCase().matches("|text(area)?|password")) continue;
            ++n;
        }
        n += element.getElementsByTagName("textarea").getLength();
        return (n += element.getElementsByTagName("html:text").getLength()) > 0;
    }

    private Vector<Node> getFormsWithTextinput() {
        Vector<Node> vector = new Vector<Node>();
        for (Element element : this.formList) {
            if (!this.hasTextFormControl(element)) continue;
            vector.add(element);
        }
        return vector;
    }

    private boolean isLabelable(String string) {
        return string.matches("|text(area)?|checkbox|radio|file|password|select");
    }

    private boolean hasLabel(Element element) {
        String string = element.getAttribute("id");
        if (string.equals("")) {
            return false;
        }
        for (Element element2 : this.labelList) {
            String string2 = element2.getAttribute("for");
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private Element hasImplicitLabel(Element element) {
        Node node = element.getParentNode();
        if (!(node instanceof Element)) {
            return null;
        }
        Element element2 = (Element)node;
        if (element2.getTagName().toLowerCase().equals("label")) {
            return element2;
        }
        return null;
    }

    private boolean isInappropriateTitle(String string) {
        return string.matches("(?i).*untitled.*");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean hasProperLabel(Element var1_1) {
        var2_2 = this.getFormControlType(var1_1).matches("radio|checkbox");
        var3_3 /* !! */  = var1_1;
        if (!var2_2) ** GOTO lbl27
        while (var3_3 /* !! */ .getNextSibling() == null) {
            if (var3_3 /* !! */ .getNodeName().equalsIgnoreCase("body")) {
                return false;
            }
            var3_3 /* !! */  = var3_3 /* !! */ .getParentNode();
        }
        if (var3_3 /* !! */ .getNextSibling().getNodeType() != 1) {
            return false;
        }
        var4_4 = (Element)var3_3 /* !! */ .getNextSibling();
        if (var4_4.getNodeName().equalsIgnoreCase("label")) {
            var5_6 = var4_4;
        } else {
            var6_8 = var4_4.getElementsByTagName("label");
            if (var6_8.getLength() == 0) {
                return false;
            }
            var5_6 = (Element)var6_8.item(0);
        }
        var6_8 = var1_1.getAttribute("id");
        var7_10 = var5_6.getAttribute("for");
        if (!var6_8.equals(var7_10)) {
            return false;
        }
        return CheckEngine.getTextAltDescendant((Node)var4_4).trim().indexOf(CheckEngine.getTextAltDescendant((Node)var5_6).trim()) == 0;
lbl-1000:
        // 1 sources

        {
            if (var3_3 /* !! */ .getNodeName().equalsIgnoreCase("body")) {
                return false;
            }
            var3_3 /* !! */  = var3_3 /* !! */ .getParentNode();
lbl27:
            // 2 sources

            ** while (var3_3 /* !! */ .getPreviousSibling() == null)
        }
lbl28:
        // 1 sources

        if (var3_3 /* !! */ .getPreviousSibling().getNodeType() != 1) {
            return false;
        }
        var4_5 = (Element)var3_3 /* !! */ .getPreviousSibling();
        if (var4_5.getNodeName().equalsIgnoreCase("label")) {
            var5_7 = var4_5;
        } else {
            var6_9 = var4_5.getElementsByTagName("label");
            if (var6_9.getLength() == 0) {
                return false;
            }
            var5_7 = (Element)var6_9.item(var6_9.getLength() - 1);
        }
        var6_9 = var1_1.getAttribute("id");
        var7_11 = var5_7.getAttribute("for");
        if (!var6_9.equals(var7_11)) {
            return false;
        }
        var8_12 = CheckEngine.getTextAltDescendant((Node)var4_5).trim();
        return var8_12.indexOf(var9_13 = CheckEngine.getTextAltDescendant((Node)var5_7).trim()) == var8_12.length() - var9_13.length();
    }

    private boolean isAsciiArtString(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = string.split("\\p{Space}");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string2 = stringArray[n3];
            int n4 = string2.length();
            n2 += n4;
            string2 = string2.replaceAll("\\p{Punct}", "");
            n += n4 - string2.length();
            n4 = string2.length();
            int n5 = 0;
            while (n5 < n4) {
                if (artCharSet.contains(string2.substring(n5, n5 + 1))) {
                    ++n;
                }
                ++n5;
            }
            ++n3;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (n > 30 && (double)n / (double)n2 > 0.8) {
            return true;
        }
        return n > 30 && this.checker.isAsciiArtString(string);
    }

    private boolean isNormalImage(Element element) {
        String string = element.getAttribute("width");
        String string2 = element.getAttribute("height");
        int n = 0;
        int n2 = 0;
        try {
            if (string != null) {
                n = Integer.valueOf(string);
            }
            if (string2 != null) {
                n2 = Integer.valueOf(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 100;
            n2 = 100;
        }
        if (n < 50 || n2 < 50) {
            int n3;
            int n4;
            if (n > n2) {
                n4 = n;
                n3 = n2;
            } else {
                n4 = n2;
                n3 = n;
            }
            if (n4 < 50) {
                return false;
            }
            if ((double)n3 / (double)n4 < 0.2) {
                return false;
            }
        }
        return true;
    }

    private boolean isHtmlFile(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            String string2 = string.substring(n + 1).toLowerCase();
            if (string2.equals("html") || string2.equals("htm") || string2.equals("jsp") || string2.equals("php") || string2.equals("shtml")) {
                return true;
            }
            if (string.toLowerCase().indexOf(".cgi") > 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isAudioFileExt(String string) {
        int n = 0;
        while (n < AUDIO_FILE_EXTENSION.length) {
            if (string.equalsIgnoreCase(AUDIO_FILE_EXTENSION[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isMultimediaFileExt(String string) {
        int n = 0;
        while (n < MULTIMEDIA_FILE_EXTENSION.length) {
            if (string.equalsIgnoreCase(MULTIMEDIA_FILE_EXTENSION[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isLeafBlockEle(Node node) {
        String string = node.getNodeName().toLowerCase();
        if (!this.blockEleSet.contains(string)) {
            return false;
        }
        if (!node.hasChildNodes()) {
            return true;
        }
        Node node2 = node.getFirstChild();
        Stack<Node> stack = new Stack<Node>();
        while (node2 != null) {
            string = node2.getNodeName().toLowerCase();
            if (this.blockEleSet.contains(string)) {
                return false;
            }
            if (node2.hasChildNodes()) {
                stack.push(node2);
                node2 = node2.getFirstChild();
                continue;
            }
            if (node2.getNextSibling() != null) {
                node2 = node2.getNextSibling();
                continue;
            }
            node2 = null;
            while (node2 == null && stack.size() > 0) {
                node2 = (Node)stack.pop();
                node2 = node2.getNextSibling();
            }
        }
        return true;
    }

    private int getWordCount(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,.[]()<>!?:/\"\u3001\u3002\u300c\u300d\u30fb\u3008\u3009\u3000");
        return stringTokenizer.countTokens();
    }

    private String getFileExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    private boolean isElementVisible(Element element) {
        return true;
    }

    private boolean isButton(Element element) {
        return element.getTagName().toLowerCase().equals("input") && (element.getAttribute("type").toLowerCase().equals("submit") || element.getAttribute("type").equals("image")) || element.getTagName().toLowerCase().equals("button") && element.getAttribute("type").toLowerCase().equals("submit");
    }

    private List<Element> getDirectDescendantElements(Element element, String string) {
        return this.getDirectDescendantElements(element, string, element.getTagName().toLowerCase());
    }

    private List<Element> getDirectDescendantElements(Element element, String string, String string2) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                if (element2.getTagName().toLowerCase().equals(string)) {
                    arrayList.add(element2);
                } else if (!element2.getTagName().toLowerCase().equals(string2)) {
                    arrayList.addAll(this.getDirectDescendantElements(element2, string, string2));
                }
            }
            ++n;
        }
        return arrayList;
    }

    private String getAttribute(Element element, String string) {
        Attr attr = element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    private Element nearestTable(Element element) {
        Node node = element;
        while (node instanceof Element && !node.getTagName().toLowerCase().equals("table")) {
            node = node.getParentNode();
        }
        return node instanceof Element ? node : null;
    }

    private boolean longdescLongerThanALT(String string, String string2) {
        return false;
    }

    private boolean isExistingUrl(String string) {
        return (string = string.trim()).length() != 0;
    }

    private boolean hasDuplicatedCaptionAndSummary(Element element) {
        String string = element.getAttribute("summary").trim();
        NodeList nodeList = element.getElementsByTagName("caption");
        int n = 0;
        while (n < nodeList.getLength()) {
            if (string.equals(HtmlTagUtil.getTextDescendant((Node)nodeList.item(n)).trim())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasSummary(Element element) {
        String string = element.getAttribute("summary");
        return string.length() > 0;
    }

    private boolean hasCaption(Element element) {
        return element.getElementsByTagName("caption").getLength() > 0;
    }

    private boolean hasTitle(Element element) {
        return element.hasAttribute("title");
    }

    private boolean hasBlankTitle(Element element) {
        if (!element.hasAttribute("title")) {
            return true;
        }
        String string = element.getAttribute("title");
        return string.matches("^[\\s\u3000]*$");
    }

    private boolean isEmptyString(String string) {
        return string == null || string.length() == 0;
    }
}

