/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.vocab;

import java.util.HashMap;
import org.eclipse.actf.util.internal.vocab.VocabPlugin;
import org.eclipse.actf.util.internal.vocab.impl.AndOperator;
import org.eclipse.actf.util.internal.vocab.impl.Function;
import org.eclipse.actf.util.internal.vocab.impl.OrOperator;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.IProposition;
import org.eclipse.actf.util.vocab.WidgetsVocabulary;
import org.w3c.dom.Node;

public class Vocabulary {
    private static HashMap<String, IProposition> propMap = new HashMap();

    static {
        WidgetsVocabulary.initialize();
        Vocabulary.add("Clickable", new IsClickable());
        Vocabulary.add("Clickable", Vocabulary.or("Button", "Checkbox", "Submit", "Link"));
        Vocabulary.add("Inputable", new IsInputable());
        Vocabulary.add("Inputable", Vocabulary.or("Textbox", "Textarea", "Password"));
        Vocabulary.add("Selectable", new IsSelectable());
        Vocabulary.add("MultiSelectable", new IsMultiSelectable());
        Vocabulary.add("Selectable", Vocabulary.or("Combobox", "Radio"));
        Vocabulary.add("Editable", Vocabulary.or("Inputable", "Selectable", "MultiSelectable"));
        Vocabulary.add("ValidNode", new IsValidNode());
        Vocabulary.add("HasContent", new HasContent());
        Vocabulary.add("HasReadingContent", new HasReadingContent());
        Vocabulary.add("VisibleNode", new IsVisibleNode());
        Vocabulary.add("EmbeddedObject", new IsEmbeddedObject());
        Vocabulary.add("Reducible", new IsReducible());
        Vocabulary.add("BlockJumpPointF", new IsBlockJumpPointF());
        Vocabulary.add("BlockJumpPointB", new IsBlockJumpPointB());
        Vocabulary.add("Media", new IsMedia());
        Vocabulary.add("Connectable", new IsConnectable());
        Vocabulary.add("Alterable", new IsAlterable());
    }

    static void addFunc(String string, String string2, String ... stringArray) {
        Vocabulary.add(string, new Function(string2, stringArray));
    }

    static void add(String string, IProposition iProposition) {
        IProposition iProposition2 = propMap.get(string);
        if (iProposition2 == null) {
            propMap.put(string, iProposition);
        } else {
            OrOperator orOperator = new OrOperator(iProposition2, iProposition);
            propMap.put(string, orOperator);
        }
    }

    private static IProposition or(String ... stringArray) {
        OrOperator orOperator = new OrOperator(new IProposition[0]);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            orOperator.add(Vocabulary.get(string));
            ++n2;
        }
        return orOperator;
    }

    public static IProposition or(IProposition ... iPropositionArray) {
        OrOperator orOperator = new OrOperator(new IProposition[0]);
        IProposition[] iPropositionArray2 = iPropositionArray;
        int n = iPropositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProposition iProposition = iPropositionArray2[n2];
            orOperator.add(iProposition);
            ++n2;
        }
        return orOperator;
    }

    public static IProposition and(IProposition ... iPropositionArray) {
        AndOperator andOperator = new AndOperator(new IProposition[0]);
        IProposition[] iPropositionArray2 = iPropositionArray;
        int n = iPropositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProposition iProposition = iPropositionArray2[n2];
            andOperator.add(iProposition);
            ++n2;
        }
        return andOperator;
    }

    public static IProposition get(String string) {
        return propMap.get(string);
    }

    public static IProposition isClickable() {
        return Vocabulary.get("Clickable");
    }

    public static IProposition hasContent() {
        return Vocabulary.get("HasContent");
    }

    public static IProposition isEditable() {
        return Vocabulary.get("Editable");
    }

    public static IProposition isSelectable() {
        return Vocabulary.get("Selectable");
    }

    public static IProposition isEmbeddedObject() {
        return Vocabulary.get("EmbeddedObject");
    }

    public static IProposition isValidNode() {
        return Vocabulary.get("ValidNode");
    }

    public static IProposition isVisibleNode() {
        return Vocabulary.get("VisibleNode");
    }

    public static IProposition isInputable() {
        return Vocabulary.get("Inputable");
    }

    public static IProposition isButton() {
        return Vocabulary.get("Button");
    }

    public static IProposition isListItem() {
        return Vocabulary.get("ListItem");
    }

    public static IProposition isListTop() {
        return Vocabulary.get("ListTop");
    }

    public static IProposition isCheckbox() {
        return Vocabulary.get("Checkbox");
    }

    public static IProposition isChecked() {
        return Vocabulary.get("Checked");
    }

    public static IProposition isLabel() {
        return Vocabulary.get("Label");
    }

    public static IProposition isLink() {
        return Vocabulary.get("Link");
    }

    public static IProposition isVisitedLink() {
        return Vocabulary.get("VisitedLink");
    }

    public static IProposition isRadio() {
        return Vocabulary.get("Radio");
    }

    public static IProposition isSubmit() {
        return Vocabulary.get("Submit");
    }

    public static IProposition isFileEdit() {
        return Vocabulary.get("FileEdit");
    }

    public static IProposition isCombobox() {
        return Vocabulary.get("Combobox");
    }

    public static IProposition isTextarea() {
        return Vocabulary.get("Textarea");
    }

    public static IProposition isTextbox() {
        return Vocabulary.get("Textbox");
    }

    public static IProposition isPassword() {
        return Vocabulary.get("Password");
    }

    public static IProposition isSelectOption() {
        return Vocabulary.get("SelectOption");
    }

    public static IProposition isImage() {
        return Vocabulary.get("Image");
    }

    public static IProposition isMultilineEdit() {
        return Vocabulary.get("MultilineEdit");
    }

    public static IProposition isReducible() {
        return Vocabulary.get("Reducible");
    }

    public static IProposition isHeading() {
        return Vocabulary.get("Heading");
    }

    public static IProposition isHeading1() {
        return Vocabulary.get("Heading1");
    }

    public static IProposition isHeading2() {
        return Vocabulary.get("Heading2");
    }

    public static IProposition isHeading3() {
        return Vocabulary.get("Heading3");
    }

    public static IProposition isHeading4() {
        return Vocabulary.get("Heading4");
    }

    public static IProposition isHeading5() {
        return Vocabulary.get("Heading5");
    }

    public static IProposition isHeading6() {
        return Vocabulary.get("Heading6");
    }

    public static IProposition find(String string, boolean bl) {
        return new FindProposition(string, bl);
    }

    public static IProposition startsWith(String string, boolean bl) {
        return new StartsWithProposition(string, bl);
    }

    public static IProposition nodeLocation(Node node, boolean bl) {
        return new NodeLocationProposition(node, bl);
    }

    public static IProposition isAccessKey(char c) {
        return new IsAccessKey(c);
    }

    public static IProposition isConnectable() {
        return Vocabulary.get("Connectable");
    }

    public static IProposition hasReadingContent() {
        return Vocabulary.get("HasReadingContent");
    }

    public static IProposition isBlockJumpPointF() {
        return Vocabulary.get("BlockJumpPointF");
    }

    public static IProposition isBlockJumpPointB() {
        return Vocabulary.get("BlockJumpPointB");
    }

    public static IProposition isMultiSelectable() {
        return Vocabulary.get("MultiSelectable");
    }

    public static IProposition isMedia() {
        return Vocabulary.get("Media");
    }

    public static IProposition isFlashTopNode() {
        return Vocabulary.get("FlashTopNode");
    }

    public static IProposition isFlashLastNode() {
        return Vocabulary.get("FlashLastNode");
    }

    public static IProposition isMSAAFlash() {
        return Vocabulary.get("MSAAFlash");
    }

    public static IProposition isReachable(Node node) {
        return new IsReachable(node);
    }

    public static IProposition isAlterable() {
        return Vocabulary.get("Alterable");
    }

    public static FlashMode getNormalFlashMode() {
        String string = VocabPlugin.getDefault().getPreferenceStore().getString("normal_flash");
        if ("msaa_flash".equals(string)) {
            return FlashMode.MSAA;
        }
        if ("flash_dom".equals(string)) {
            return FlashMode.FLASH_DOM;
        }
        if ("no_flash".equals(string)) {
            return FlashMode.NO_FLASH;
        }
        return FlashMode.NO_FLASH;
    }

    public static FlashMode getWindowlessFlashMode() {
        String string = VocabPlugin.getDefault().getPreferenceStore().getString("wndless_flash");
        if ("flash_dom".equals(string)) {
            return FlashMode.FLASH_DOM;
        }
        if ("no_flash".equals(string)) {
            return FlashMode.NO_FLASH;
        }
        return FlashMode.NO_FLASH;
    }

    public static boolean isReadNoAltImage() {
        return VocabPlugin.getDefault().getPreferenceStore().getBoolean("read_no_alt");
    }

    public static boolean isReadNullAltImage() {
        return VocabPlugin.getDefault().getPreferenceStore().getBoolean("read_null_alt");
    }

    public static boolean isReadNoAltImageLink() {
        return VocabPlugin.getDefault().getPreferenceStore().getBoolean("read_no_alt_link");
    }

    public static boolean isReadNullAltImageLink() {
        return VocabPlugin.getDefault().getPreferenceStore().getBoolean("read_null_alt_link");
    }

    public static boolean isSkipIconLink() {
        return VocabPlugin.getDefault().getPreferenceStore().getBoolean("skip_icon_link");
    }

    private static class FindProposition
    implements IProposition {
        private final String str;
        private final boolean exact;

        public FindProposition(String string, boolean bl) {
            this.str = string;
            this.exact = bl;
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().find(this.str, this.exact, iEvalTarget);
        }

        public String getName() {
            return "find(" + this.str + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlashMode {
        MSAA,
        FLASH_DOM,
        NO_FLASH;

    }

    private static class HasContent
    implements IProposition {
        private HasContent() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().hasContent(iEvalTarget);
        }

        public String getName() {
            return "hasContent";
        }
    }

    private static class HasReadingContent
    implements IProposition {
        private HasReadingContent() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().hasReadingContent(iEvalTarget);
        }

        public String getName() {
            return "hasReadingContent";
        }
    }

    private static class IsAccessKey
    implements IProposition {
        private final char key;

        public IsAccessKey(char c) {
            this.key = c;
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isAccessKey(this.key, iEvalTarget);
        }

        public String getName() {
            return "accessKey(" + this.key + ")";
        }
    }

    private static class IsAlterable
    implements IProposition {
        private IsAlterable() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isAlterable(iEvalTarget);
        }

        public String getName() {
            return "isAlterable";
        }
    }

    private static class IsBlockJumpPointB
    implements IProposition {
        private IsBlockJumpPointB() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isBlockJumpPointB(iEvalTarget);
        }

        public String getName() {
            return "isBlockJumpPointB";
        }
    }

    private static class IsBlockJumpPointF
    implements IProposition {
        private IsBlockJumpPointF() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isBlockJumpPointF(iEvalTarget);
        }

        public String getName() {
            return "isBlockJumpPointF";
        }
    }

    private static class IsClickable
    implements IProposition {
        private IsClickable() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isClickable(iEvalTarget);
        }

        public String getName() {
            return "isClickable";
        }
    }

    private static class IsConnectable
    implements IProposition {
        private IsConnectable() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isConnectable(iEvalTarget);
        }

        public String getName() {
            return "isConnectable";
        }
    }

    private static class IsEmbeddedObject
    implements IProposition {
        private IsEmbeddedObject() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isEmbeddedObject(iEvalTarget);
        }

        public String getName() {
            return "isEmbeddedObject";
        }
    }

    private static class IsInputable
    implements IProposition {
        private IsInputable() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isInputable(iEvalTarget);
        }

        public String getName() {
            return "isInputable";
        }
    }

    private static class IsMedia
    implements IProposition {
        private IsMedia() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isMedia(iEvalTarget);
        }

        public String getName() {
            return "isMedia";
        }
    }

    private static class IsMultiSelectable
    implements IProposition {
        private IsMultiSelectable() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isMultiSelectable(iEvalTarget);
        }

        public String getName() {
            return "isMultiSelectable";
        }
    }

    private static class IsReachable
    implements IProposition {
        private Node target;

        public IsReachable(Node node) {
            this.target = node;
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isReachable(iEvalTarget, this.target);
        }

        public String getName() {
            return "isReachable";
        }
    }

    private static class IsReducible
    implements IProposition {
        private IsReducible() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isReducible(iEvalTarget);
        }

        public String getName() {
            return "isReducible";
        }
    }

    private static class IsSelectable
    implements IProposition {
        private IsSelectable() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isSelectable(iEvalTarget);
        }

        public String getName() {
            return "isSelectable";
        }
    }

    private static class IsValidNode
    implements IProposition {
        private IsValidNode() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isValidNode(iEvalTarget);
        }

        public String getName() {
            return "isValidNode";
        }
    }

    private static class IsVisibleNode
    implements IProposition {
        private IsVisibleNode() {
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().isVisibleNode(iEvalTarget);
        }

        public String getName() {
            return "isVisibleNode";
        }
    }

    private static class NodeLocationProposition
    implements IProposition {
        private final Node refNode;
        private final boolean backward;

        public NodeLocationProposition(Node node, boolean bl) {
            this.refNode = node;
            this.backward = bl;
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().nodeLocation(this.refNode, this.backward, iEvalTarget);
        }

        public String getName() {
            return "nodeLocation(" + this.refNode + ":" + this.backward + ")";
        }
    }

    private static class StartsWithProposition
    implements IProposition {
        private final String str;
        private final boolean exact;

        public StartsWithProposition(String string, boolean bl) {
            this.str = string;
            this.exact = bl;
        }

        public boolean eval(IEvalTarget iEvalTarget) {
            return iEvalTarget.getTerms().startsWith(this.str, this.exact, iEvalTarget);
        }

        public String getName() {
            return "startsWith(" + this.str + ")";
        }
    }
}

