/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.blind.ParamBlind;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacketCollection;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.html.BlindProblem;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.TextCounter;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkAnalyzer {
    private static final String NULL_STRING = "";
    private static final String SKIP_TO_MAIN_LINK_DEFINITION = ".*([sS]kip|[jJ]ump to|[lL]ink to) .+|.*(\u672c\u6587|\u30e1\u30a4\u30f3|\u3092\u8aad\u3080|(\u3078|\u306b)\u30b8\u30e3\u30f3\u30d7|(\u3078|\u306b)\u79fb\u52d5|\u3078\u306e\u30ea\u30f3\u30af).*";
    private static final String WRONG_SKIPLINK_DEFINITION = ".+ ([sS]kip to|[jJ]ump to) .+";
    private static final int MAX_SKIPLINK_REACHING_TIME = 20;
    private static final int MIN_MAX_TIME_TO_ELIMINATE_SKIP_LINK = 90;
    private List<Element> intraPageLinkList = new ArrayList<Element>();
    private Map<String, Element> anchorMap = new HashMap<String, Element>();
    private Map<Element, String> skipLinkMap = new HashMap<Element, String>();
    private Document doc;
    private IPacketCollection allPc;
    private VisualizeMapDataImpl mapData;
    private Set<String> invisibleIdSet;
    private List<IProblemItem> problems;
    private int intralinkErrorCount = 0;
    private int skiplinkErrorCount = 0;
    private TextCounter textCounter;
    private PageData pageData;

    public LinkAnalyzer(Document document, IPacketCollection iPacketCollection, VisualizeMapDataImpl visualizeMapDataImpl, List<IProblemItem> list, Set<String> set, ParamBlind paramBlind, PageData pageData) {
        this.doc = document;
        this.allPc = iPacketCollection;
        this.mapData = visualizeMapDataImpl;
        this.invisibleIdSet = set;
        this.problems = list;
        this.pageData = pageData;
        this.textCounter = new TextCounter(paramBlind.iLanguage);
        this.listIntraPageLinks();
        this.analyzeIntraPageLinkMapping();
    }

    private void listIntraPageLinks() {
        NodeList nodeList = this.doc.getElementsByTagName("a");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            String string = element.getAttribute("href");
            String string2 = element.getAttribute("name");
            if (string != null && string.length() > 0 && string.charAt(0) == '#') {
                Object object;
                Object object2;
                String string3;
                String string4;
                int n3;
                VisualizationNodeInfo visualizationNodeInfo = this.mapData.getNodeInfo(element);
                StringBuffer stringBuffer = new StringBuffer();
                int n4 = this.allPc.size();
                if (visualizationNodeInfo != null) {
                    n3 = visualizationNodeInfo.getPacketId();
                    while (n3 < n4) {
                        string4 = (IPacket)this.allPc.get(n3);
                        string3 = string4.getText();
                        if (string3 != null) {
                            stringBuffer.append(string3);
                        }
                        if (!string4.getContext().isInsideAnchor()) break;
                        ++n3;
                    }
                }
                n3 = this.textCounter.getWordCount(stringBuffer.toString());
                string4 = NULL_STRING;
                string3 = NULL_STRING;
                BlindProblem blindProblem = null;
                if (element.hasAttribute("title")) {
                    string4 = string3 = element.getAttribute("title");
                    if (n3 == 0 && (n3 += this.textCounter.getWordCount(string4)) > 0) {
                        blindProblem = new BlindProblem(25, string3);
                        blindProblem.setTargetNode(this.mapData.getOrigNode(element));
                        object2 = this.mapData.getIdOfNode(element);
                        if (object2 != null) {
                            blindProblem.setNode(element, (Integer)object2);
                        } else {
                            blindProblem.setNode(element);
                        }
                        this.problems.add(blindProblem);
                    }
                    string3 = string3.trim();
                    string3 = string3.replaceAll("\\[|\\]|\\.|\\!|\\>", NULL_STRING);
                }
                object2 = stringBuffer.toString();
                object2 = ((String)object2).trim();
                object2 = ((String)object2).replaceAll("\\[|\\]|\\.|\\!|\\>", NULL_STRING);
                blindProblem = null;
                if (n3 > 0) {
                    if (((String)object2).matches(SKIP_TO_MAIN_LINK_DEFINITION)) {
                        this.skipLinkMap.put(element, stringBuffer.toString());
                    } else if (string3.matches(SKIP_TO_MAIN_LINK_DEFINITION)) {
                        this.skipLinkMap.put(element, string4);
                    } else {
                        if (string3.matches(WRONG_SKIPLINK_DEFINITION)) {
                            blindProblem = new BlindProblem(26, (String)object2);
                        }
                        if (((String)object2).matches(WRONG_SKIPLINK_DEFINITION)) {
                            blindProblem = new BlindProblem(19, (String)object2);
                        }
                    }
                    this.intraPageLinkList.add(element);
                } else {
                    object = HtmlTagUtil.getNoScriptText((Node)element);
                    if (((String)object).length() <= 0) {
                        blindProblem = new BlindProblem(14, string);
                        if (!element.hasAttribute("onclick") && !element.hasAttribute("onmouseover")) {
                            ++this.intralinkErrorCount;
                        }
                    }
                }
                if (blindProblem != null) {
                    blindProblem.setTargetNode(this.mapData.getOrigNode(element));
                    object = this.mapData.getIdOfNode(element);
                    if (object != null) {
                        blindProblem.setNode(element, (Integer)object);
                    } else {
                        blindProblem.setNode(element);
                    }
                    this.problems.add(blindProblem);
                }
            }
            if (string2 != null && string2.length() > 0) {
                this.anchorMap.put(string2, element);
            }
            ++n2;
        }
    }

    private void analyzeIntraPageLinkMapping() {
        for (Element element : this.intraPageLinkList) {
            Object object;
            Object object2;
            Object object3;
            String string = element.getAttribute("href").substring(1);
            Element element2 = element;
            boolean bl = true;
            while (bl && element2 != null) {
                object3 = element2.getAttribute("id");
                if (this.invisibleIdSet.contains(object3)) {
                    object2 = new BlindProblem(35, "\"" + HtmlTagUtil.getTextAltDescendant((Node)element) + "\"(href=#" + string + ", id=" + (String)object3 + ") ");
                    object2.setTargetNode(this.mapData.getOrigNode(element));
                    object = this.mapData.getIdOfNode(element);
                    if (object != null) {
                        ((BlindProblem)object2).setNode(element, (Integer)object);
                    } else {
                        ((BlindProblem)object2).setNode(element);
                    }
                    ++this.intralinkErrorCount;
                    this.problems.add((IProblemItem)object2);
                    bl = false;
                }
                element2 = (object2 = element2.getParentNode()) != null && object2.getNodeType() == 1 ? (Element)object2 : null;
            }
            if (!bl) continue;
            if (string.length() == 0) {
                object3 = this.doc.getElementsByTagName("body");
                if (object3 == null || object3.getLength() <= 0) continue;
                object2 = object3.item(0);
                this.mapData.addIntraPageLinkMapping(element, (Node)object2);
                continue;
            }
            object3 = this.anchorMap.get(string);
            if (object3 != null) {
                this.mapData.addIntraPageLinkMapping(element, (Node)object3);
                continue;
            }
            object2 = this.doc.getElementById(string);
            if (object2 != null) {
                this.mapData.addIntraPageLinkMapping(element, (Node)object2);
                continue;
            }
            object = null;
            boolean bl2 = false;
            String string2 = HtmlTagUtil.getTextAltDescendant((Node)element);
            if (string2.matches(".*(\u5148\u982d|\u30c8\u30c3\u30d7|\u4e0a|top|start).*")) {
                bl2 = true;
            }
            if (this.skipLinkMap.containsKey(element)) {
                if (string.matches(".*top.*") || bl2) {
                    object = new BlindProblem(33, string);
                } else {
                    object = new BlindProblem(18, string);
                    ++this.intralinkErrorCount;
                    ++this.skiplinkErrorCount;
                }
                this.skipLinkMap.remove(element);
            } else if (string.matches(".*top.*") || bl2) {
                object = new BlindProblem(33, string);
            } else {
                object = new BlindProblem(8, string);
                if (!element.hasAttribute("onClick") && !element.hasAttribute("onmouseover")) {
                    ++this.intralinkErrorCount;
                }
            }
            object.setTargetNode(this.mapData.getOrigNode(element));
            Integer n = this.mapData.getIdOfNode(element);
            if (n != null) {
                ((BlindProblem)object).setNode(element, n);
            } else {
                ((BlindProblem)object).setNode(element);
            }
            this.problems.add((IProblemItem)object);
        }
    }

    public Vector<IProblemItem> skipLinkCheck(int n, int n2) {
        Object n12;
        Object object;
        Object object22;
        Vector<IProblemItem> vector = new Vector<IProblemItem>();
        VisualizationNodeInfo object5 = null;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        int n5 = this.skipLinkMap.size();
        int n6 = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Node> hashSet2 = new HashSet<Node>();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        Vector<HighlightTargetId> vector2 = new Vector<HighlightTargetId>();
        HashSet<Object> hashSet4 = new HashSet<Object>();
        List<VisualizationNodeInfo> list = this.mapData.getNodeInfoList();
        for (VisualizationNodeInfo object42 : list) {
            Node n11 = object42.getNode();
            if (n11 == null) continue;
            if (this.skipLinkMap.containsKey(n11) && object42.getTime() < n3) {
                object5 = object42;
                n3 = object42.getTime();
            }
            if (object42.isHeading()) {
                ++n4;
                hashSet3.add(new Integer(object42.getId()));
            }
            object22 = n11;
            if (!object42.isBlockElement() || object42.isSequence() || object42.getTime() <= 120 || hashSet4.contains(n11)) continue;
            vector2.add(new HighlightTargetId(object42.getId(), object42.getId()));
            object = new Stack();
            object22 = object22.getFirstChild();
            while (object22 != null) {
                if (object22.getNodeType() == 1) {
                    hashSet4.add(object22);
                }
                if (object22.hasChildNodes()) {
                    ((Stack)object).push(object22);
                    object22 = object22.getFirstChild();
                    continue;
                }
                if (object22.getNextSibling() != null) {
                    object22 = object22.getNextSibling();
                    continue;
                }
                object22 = null;
                while (object22 == null && ((Vector)object).size() > 0) {
                    object22 = (Node)((Stack)object).pop();
                    object22 = object22.getNextSibling();
                }
            }
        }
        Map<Node, Node> map = this.mapData.getIntraPageLinkMap();
        for (Object object22 : map.keySet()) {
            Integer n7;
            int n8;
            int n9;
            object = map.get(object22);
            hashSet2.add((Node)object);
            n12 = this.mapData.getResult2idMap();
            if (!n12.containsKey(object22) || !n12.containsKey(object) || (n9 = this.mapData.getIdOfNode((Node)object22).intValue()) >= (n8 = (n7 = this.mapData.getIdOfNode((Node)object)).intValue())) continue;
            VisualizationNodeInfo visualizationNodeInfo = this.mapData.getNodeInfo((Node)object22);
            if (visualizationNodeInfo != null) {
                int n10 = visualizationNodeInfo.getTime();
                if (n10 >= 60) continue;
                hashSet.add(n7);
                continue;
            }
            hashSet.add(n7);
        }
        n6 = hashSet.size();
        hashSet2.size();
        hashSet3.size();
        int n11 = vector2.size();
        object22 = new HighlightTargetId[n11];
        vector2.toArray((T[])object22);
        this.pageData.setSkipMainNum(n5);
        this.pageData.setForwardIntraPageLinkNum(n6);
        this.pageData.setBrokenSkipMainNum(this.skiplinkErrorCount);
        this.pageData.setBrokenIntraPageLinkNum(this.intralinkErrorCount);
        if (object5 == null) {
            if (n4 > 0 || n6 > 0) {
                if (n >= 90) {
                    vector.add(new BlindProblem(20));
                }
            } else if (n < 90) {
                vector.add(new BlindProblem(21, NULL_STRING + n));
            } else {
                vector.add(new BlindProblem(10));
            }
        } else if (n3 >= 20) {
            object = new BlindProblem(17, String.valueOf(n3) + " ");
            n12 = this.mapData.getIdOfNode(object5.getNode());
            if (n12 != null) {
                ((BlindProblem)object).setNode(object5.getNode(), (Integer)n12);
            } else {
                ((BlindProblem)object).setNode(object5.getNode());
            }
            object.setTargetNode(this.mapData.getOrigNode(object5.getNode()));
            vector.add((IProblemItem)object);
        }
        if (n11 > 0) {
            object = null;
            object = n4 > 0 ? (n6 > 0 ? new BlindProblem(24) : new BlindProblem(23)) : (n6 > 0 ? new BlindProblem(22) : new BlindProblem(12));
            int n13 = 0;
            while (n13 < n11) {
                ((BlindProblem)object).addNodeIds((HighlightTargetId)object22[n13]);
                ++n13;
            }
            vector.add((IProblemItem)object);
        }
        return vector;
    }
}

