/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.visualization.gui.TargetWindowDataProvider;
import org.eclipse.actf.visualization.gui.internal.GuiTargetWindowData;
import org.eclipse.actf.visualization.gui.internal.util.TargetWindow;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetWindowDataCollector {
    private static final String TARGETDATA_EXTENSION = "org.eclipse.actf.visualization.gui.targetWindowData";
    private static TargetWindowDataProvider[] targetDataProviders = new TargetWindowDataProvider[0];
    private Map<String, List<Object>> categoryMap = new HashMap<String, List<Object>>();

    static {
        ArrayList<TargetWindowDataProvider> arrayList = new ArrayList<TargetWindowDataProvider>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(TARGETDATA_EXTENSION);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            try {
                TargetWindowDataProvider targetWindowDataProvider = (TargetWindowDataProvider)iConfigurationElementArray[n].createExecutableExtension("class");
                if (targetWindowDataProvider != null) {
                    arrayList.add(targetWindowDataProvider);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        targetDataProviders = arrayList.toArray(new TargetWindowDataProvider[arrayList.size()]);
    }

    public static Object[] getElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < targetDataProviders.length) {
            if (targetDataProviders[n] != null) {
                IModelService[] iModelServiceArray = targetDataProviders[n].getModelService();
                if (iModelServiceArray != null) {
                    arrayList.addAll(Arrays.asList(iModelServiceArray));
                } else {
                    arrayList.add(targetDataProviders[n]);
                }
            }
            ++n;
        }
        return arrayList.toArray();
    }

    public static Object getDefaultElement() {
        Object[] objectArray = TargetWindowDataCollector.getElements();
        int n = 0;
        while (n < objectArray.length) {
            if (TargetWindow.isEmbeddedBrowser(objectArray[n])) {
                return objectArray[n];
            }
            ++n;
        }
        return null;
    }

    public TargetWindowDataCollector() {
        Object[] objectArray = TargetWindowDataCollector.getElements();
        int n = 0;
        while (n < objectArray.length) {
            List<Object> list;
            String string = null;
            if (objectArray[n] instanceof GuiTargetWindowData) {
                string = ((GuiTargetWindowData)objectArray[n]).getCategory();
            }
            if ((list = this.categoryMap.get(string)) == null) {
                list = new ArrayList<Object>();
                this.categoryMap.put(string, list);
            }
            list.add(objectArray[n]);
            ++n;
        }
    }

    public String[] getCategories(Comparator<Object> comparator) {
        ArrayList<String> arrayList = new ArrayList<String>(this.categoryMap.keySet());
        if (comparator != null) {
            Collections.sort(arrayList, comparator);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Object[] getElements(String string) {
        List<Object> list = this.categoryMap.get(string);
        if (list != null) {
            return list.toArray();
        }
        return new Object[0];
    }
}

