/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.store.SingleInstanceLockFactory;

public class RAMDirectory
extends Directory
implements Serializable {
    private static final long serialVersionUID = 1L;
    HashMap fileMap = new HashMap();
    long sizeInBytes = 0L;

    public RAMDirectory() {
        this.setLockFactory(new SingleInstanceLockFactory());
    }

    public RAMDirectory(Directory dir) throws IOException {
        this(dir, false);
    }

    private RAMDirectory(Directory dir, boolean closeDir) throws IOException {
        this();
        Directory.copy(dir, this, closeDir);
    }

    public RAMDirectory(File dir) throws IOException {
        this(FSDirectory.getDirectory(dir), true);
    }

    public RAMDirectory(String dir) throws IOException {
        this(FSDirectory.getDirectory(dir), true);
    }

    public final synchronized String[] list() {
        return this.listAll();
    }

    public final synchronized String[] listAll() {
        this.ensureOpen();
        Set fileNames = this.fileMap.keySet();
        String[] result = new String[fileNames.size()];
        int i = 0;
        Iterator it = fileNames.iterator();
        while (it.hasNext()) {
            result[i++] = (String)it.next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean fileExists(String name) {
        RAMFile file;
        this.ensureOpen();
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        return file != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long fileModified(String name) throws IOException {
        RAMFile file;
        this.ensureOpen();
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchFile(String name) throws IOException {
        long ts2;
        RAMFile file;
        this.ensureOpen();
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        file.setLastModified(ts2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long fileLength(String name) throws IOException {
        RAMFile file;
        this.ensureOpen();
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    public final synchronized long sizeInBytes() {
        this.ensureOpen();
        return this.sizeInBytes;
    }

    public synchronized void deleteFile(String name) throws IOException {
        this.ensureOpen();
        RAMFile file = (RAMFile)this.fileMap.get(name);
        if (file != null) {
            this.fileMap.remove(name);
            file.directory = null;
            this.sizeInBytes -= file.sizeInBytes;
        } else {
            throw new FileNotFoundException(name);
        }
    }

    public final synchronized void renameFile(String from, String to) throws IOException {
        this.ensureOpen();
        RAMFile fromFile = (RAMFile)this.fileMap.get(from);
        if (fromFile == null) {
            throw new FileNotFoundException(from);
        }
        RAMFile toFile = (RAMFile)this.fileMap.get(to);
        if (toFile != null) {
            this.sizeInBytes -= toFile.sizeInBytes;
            toFile.directory = null;
        }
        this.fileMap.remove(from);
        this.fileMap.put(to, fromFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexOutput createOutput(String name) throws IOException {
        this.ensureOpen();
        RAMFile file = new RAMFile(this);
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            RAMFile existing = (RAMFile)this.fileMap.get(name);
            if (existing != null) {
                this.sizeInBytes -= existing.sizeInBytes;
                existing.directory = null;
            }
            this.fileMap.put(name, file);
        }
        return new RAMOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexInput openInput(String name) throws IOException {
        RAMFile file;
        this.ensureOpen();
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return new RAMInputStream(file);
    }

    public void close() {
        this.isOpen = false;
        this.fileMap = null;
    }
}

