/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.logging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.actf.util.logging.AbstractErrorLogger;

public class StreamErrorLogger
extends AbstractErrorLogger {
    private PrintWriter _writer;
    private String _filename;

    public StreamErrorLogger(OutputStream outputStream) {
        this._writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream), true);
    }

    public void logError(String string, Throwable throwable) {
        if (string != null) {
            this._writer.println(string);
        }
        if (throwable != null) {
            this._writer.println(String.valueOf(throwable.getClass().getName()) + " - " + throwable.toString());
            throwable.printStackTrace();
            while ((throwable = throwable.getCause()) != null) {
                this._writer.println(throwable.toString());
                throwable.printStackTrace();
            }
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String string) {
        this._filename = string;
    }

    protected void finalize() throws Throwable {
        this._writer.close();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + (this._filename == null ? "" : this._filename) + "]";
    }
}

