/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.Reader;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.ru.RussianCharsets;
import org.apache.lucene.util.AttributeSource;

public class RussianLetterTokenizer
extends CharTokenizer {
    private char[] charset;

    public RussianLetterTokenizer(Reader in, char[] charset) {
        super(in);
        this.charset = charset;
    }

    public RussianLetterTokenizer(Reader in) {
        this(in, RussianCharsets.UnicodeRussian);
    }

    public RussianLetterTokenizer(AttributeSource source, Reader in) {
        super(source, in);
        this.charset = RussianCharsets.UnicodeRussian;
    }

    public RussianLetterTokenizer(AttributeSource.AttributeFactory factory, Reader in) {
        super(factory, in);
        this.charset = RussianCharsets.UnicodeRussian;
    }

    protected boolean isTokenChar(char c) {
        if (Character.isLetter(c)) {
            return true;
        }
        for (int i = 0; i < this.charset.length; ++i) {
            if (c != this.charset[i]) continue;
            return true;
        }
        return false;
    }
}

