/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class BrowserFavoritesExtension {
    private static final String EXTENSION_NAME = "browserFavorites";
    private static final String FAVORITES = "favorites";
    private static final String ATTR_PREF_FILE = "prefFile";
    private static BrowserFavoritesExtension[] extensions;
    private static URL[] prefFileURLs;
    private URL prefFileUrl = null;

    static {
        prefFileURLs = null;
    }

    public static URL[] getBrowserFavoritesPrefFileURLs() {
        if (prefFileURLs != null) {
            return prefFileURLs;
        }
        BrowserFavoritesExtension[] tmpExtensions = BrowserFavoritesExtension.getExtensions();
        ArrayList<URL> tmpList = new ArrayList<URL>();
        if (tmpExtensions != null) {
            int i = 0;
            while (i < tmpExtensions.length) {
                URL tmpInfo = tmpExtensions[i].getPrefFileURL();
                if (tmpInfo != null) {
                    tmpList.add(tmpInfo);
                }
                ++i;
            }
        }
        prefFileURLs = new URL[tmpList.size()];
        tmpList.toArray(prefFileURLs);
        return prefFileURLs;
    }

    private static BrowserFavoritesExtension[] getExtensions() {
        if (extensions != null) {
            return extensions;
        }
        IExtension[] tmpExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.model.ui", EXTENSION_NAME).getExtensions();
        DebugPrintUtil.devOrDebugPrintln((Object)(String.valueOf(BrowserFavoritesExtension.class.getName()) + ":" + tmpExtensions.length));
        ArrayList<BrowserFavoritesExtension> l = new ArrayList<BrowserFavoritesExtension>();
        int i = 0;
        while (i < tmpExtensions.length) {
            IConfigurationElement[] configElements = tmpExtensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                BrowserFavoritesExtension ex = BrowserFavoritesExtension.parseExtension(configElements[j]);
                if (ex != null) {
                    l.add(ex);
                }
                ++j;
            }
            ++i;
        }
        extensions = l.toArray(new BrowserFavoritesExtension[l.size()]);
        return extensions;
    }

    private static BrowserFavoritesExtension parseExtension(IConfigurationElement configElement) {
        if (!configElement.getName().equals(FAVORITES)) {
            return null;
        }
        try {
            return new BrowserFavoritesExtension(configElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BrowserFavoritesExtension(IConfigurationElement configElement) {
        try {
            IContributor contributor = configElement.getContributor();
            String prefFile = configElement.getAttribute(ATTR_PREF_FILE);
            this.prefFileUrl = FileLocator.resolve((URL)Platform.getBundle((String)contributor.getName()).getEntry(prefFile));
        }
        catch (Exception e) {
            DebugPrintUtil.devOrDebugPrintStackTrace((Exception)e);
        }
    }

    private URL getPrefFileURL() {
        return this.prefFileUrl;
    }
}

