/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final String LINE_SEP = System.getProperty("line.separator");
    private static final int BUFFER_SIZE = 8192;
    private static Logger logger = Logger.getLogger("org.eclipse.actf.core");
    private static FilenameFilter dirFilter = new FilenameFilter(){

        public boolean accept(File path, String name) {
            return new File(path, name).isDirectory();
        }
    };

    private static FilenameFilter formFilter(String fileDesc) {
        StringBuffer descBuff = new StringBuffer(fileDesc);
        int c = 0;
        while (c < descBuff.length()) {
            if (descBuff.charAt(c) == '*') {
                descBuff.insert(c, '.');
                ++c;
            } else if (descBuff.charAt(c) == '?') {
                descBuff.insert(c, '.');
                ++c;
            } else if (".-%^$!~".indexOf(descBuff.charAt(c)) >= 0) {
                descBuff.insert(c, '\\');
                ++c;
            }
            ++c;
        }
        final Pattern descPatt = Pattern.compile(descBuff.toString());
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File parent, String name) {
                return descPatt.matcher(name).matches();
            }
        };
        return filter;
    }

    public static String replaceWhiteSpaceInUrl(String target) {
        return target.replaceAll(" ", "%20");
    }

    /*
     * Loose catch block
     */
    public static synchronized boolean copyFile(File source, String dest, boolean overWrite) {
        FilterOutputStream bos;
        BufferedInputStream bis;
        block29: {
            int size;
            byte[] buffer;
            block27: {
                block28: {
                    bis = null;
                    bos = null;
                    buffer = new byte[8192];
                    File file = new File(dest);
                    if (overWrite || !file.exists()) break block27;
                    if (bis == null) break block28;
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
            bis = new BufferedInputStream(new FileInputStream(source));
            bos = new BufferedOutputStream(new FileOutputStream(dest));
            while ((size = bis.read(buffer)) > 0) {
                ((BufferedOutputStream)bos).write(buffer, 0, size);
            }
            if (bis == null) break block29;
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        return true;
        catch (Exception e) {
            block30: {
                try {
                    e.printStackTrace();
                    if (bis == null) break block30;
                }
                catch (Throwable throwable) {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            return false;
        }
    }

    public static synchronized boolean copyFile(String source, String dest, boolean overWrite) {
        return FileUtils.copyFile(new File(source), dest, overWrite);
    }

    public static void copyFile(FileInputStream source, FileOutputStream dest) throws IOException {
        int b = -1;
        while ((b = source.read()) != -1) {
            dest.write(b);
        }
        source.close();
        dest.close();
    }

    public static void copyFiles(File baseDir, File newParent, String pattern) {
        FilenameFilter nameFilter = FileUtils.formFilter(pattern);
        File[] files = baseDir.listFiles(nameFilter);
        File[] directories = baseDir.listFiles(dirFilter);
        int f = 0;
        while (files != null && f < files.length) {
            try {
                FileInputStream fis = new FileInputStream(files[f]);
                FileOutputStream fos = new FileOutputStream(new File(newParent, files[f].getName()));
                FileUtils.copyFile(fis, fos);
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Could not copy file " + files[f].getName());
            }
            ++f;
        }
        int d = 0;
        while (directories != null && d < directories.length) {
            File newDir = new File(newParent, directories[d].getName());
            if (newDir.mkdir() || newDir.exists()) {
                FileUtils.copyFiles(directories[d], newDir, pattern);
            } else {
                logger.log(Level.WARNING, "Could not create directory " + newDir.getName());
            }
            ++d;
        }
    }

    public static synchronized boolean copyFile(Bundle bundle, IPath file, String savePath, boolean overWrite) {
        try {
            FileUtils.saveToFile(FileLocator.openStream((Bundle)bundle, (IPath)file, (boolean)false), savePath, overWrite);
            return true;
        }
        catch (IOException iOException) {
            try {
                FileUtils.saveToFile(FileLocator.find((Bundle)bundle, (IPath)file, null).openStream(), savePath, overWrite);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized boolean saveToFile(InputStream is, String savePath, boolean overWrite) {
        boolean flag;
        byte[] buffer;
        FilterOutputStream bos;
        BufferedInputStream bis;
        block25: {
            block26: {
                bis = null;
                bos = null;
                buffer = new byte[8192];
                flag = true;
                File file = new File(savePath);
                if (overWrite || !file.exists()) break block25;
                if (bis == null) break block26;
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (bos == null) return false;
            try {
                bos.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
        try {
            try {
                int size;
                bis = new BufferedInputStream(is);
                bos = new BufferedOutputStream(new FileOutputStream(savePath));
                while ((size = bis.read(buffer)) > 0) {
                    ((BufferedOutputStream)bos).write(buffer, 0, size);
                }
            }
            catch (Exception exception) {
                flag = false;
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bos == null) return flag;
                try {
                    bos.close();
                    return flag;
                }
                catch (IOException iOException) {}
                return flag;
            }
        }
        catch (Throwable throwable) {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (bos == null) throw throwable;
            try {
                bos.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
        if (bos == null) return flag;
        try {
            bos.close();
            return flag;
        }
        catch (IOException iOException) {}
        return flag;
    }

    public static void deleteFiles(File rootDir) {
        if (rootDir != null) {
            File[] fileList = rootDir.listFiles();
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].isDirectory()) {
                    FileUtils.deleteFiles(fileList[i]);
                }
                fileList[i].delete();
                ++i;
            }
        }
    }

    public static void deleteFiles(File baseDir, String pattern) {
        FilenameFilter nameFilter = FileUtils.formFilter(pattern);
        File[] files = baseDir.listFiles(nameFilter);
        File[] directories = baseDir.listFiles(dirFilter);
        int cf = 0;
        while (files != null && cf < files.length) {
            new File(baseDir, files[cf].getName()).delete();
            ++cf;
        }
        int d = 0;
        while (directories != null && d < directories.length) {
            File dir = new File(baseDir, directories[d].getName());
            FileUtils.deleteFiles(dir, pattern);
            if (!dir.delete()) {
                logger.log(Level.WARNING, "Could not delete directory " + dir);
            }
            ++d;
        }
    }

    public static File[] findFiles(String fileDesc, File baseDir) {
        LinkedList<File> fileList = new LinkedList<File>();
        FileUtils.findFiles(FileUtils.formFilter(fileDesc), baseDir, fileList);
        return fileList.toArray(new File[fileList.size()]);
    }

    public static void findFiles(FilenameFilter filter, File baseDir, List<File> fileList) {
        File[] directories = baseDir.listFiles(dirFilter);
        File[] files = baseDir.listFiles(filter);
        if (files != null && files.length > 0) {
            fileList.addAll(Arrays.asList(files));
        }
        int d = 0;
        while (directories != null && d < directories.length) {
            File dir = new File(baseDir, directories[d].getName());
            FileUtils.findFiles(filter, dir, fileList);
            ++d;
        }
    }

    public static boolean isAvailableDirectory(String path) {
        File testDir = new File(path);
        if (!(testDir.isDirectory() && testDir.canWrite() || testDir.mkdirs())) {
            DebugPrintUtil.devOrDebugPrintln(String.valueOf(path) + " is not available.");
            return false;
        }
        return true;
    }

    public static String getActfTempDir() {
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir != null) {
            if (!tempDir.endsWith(File.separator)) {
                tempDir = String.valueOf(tempDir) + File.separator;
            }
            tempDir = String.valueOf(tempDir) + "actf";
        }
        return tempDir;
    }
}

